<?php
if($tag != ''){
    $pdf->SetFillColor(240,240,240);
    $pdf->SetDrawColor(245,245,245);
    $pdf->SetXY(0,0);
    $pdf->SetFont('freesans','B',15);
    $pdf->SetTextColor(0);
    $pdf->SetLineWidth(0.75);
    $pdf->StartTransform();
    $pdf->Rotate(-35,109,235);
    $pdf->Cell(100,1,strtoupper($tag),'TB',0,'C','1');
    $pdf->StopTransform();
    $pdf->SetFont('freesans','',10);
    $pdf->setX(10);
    $pdf->setY(10);
}

// $html = '<br><br><br><br><span style="font-weight:bold;font-size:20px;">'._l('order_report_pdf_heading').'</span><br />';


//$pdf->Ln(6);
$custom_pdf_logo_image_url = get_option('custom_pdf_logo_image_url');
$pdf->setJPEGQuality(100);
if($custom_pdf_logo_image_url == ''){
     if(get_option('company_logo'))
    $pdf->writeHTMLCell(35, 0, 10, 7, '<a href="'.site_url().'"><img src="'.site_url('uploads/company/'.get_option('company_logo')).'"></a>', 0, 1, false, true, 'L', false);
} else {
    $pdf->writeHTMLCell(35, 0, 10, 7, '<a href="'.site_url().'"><img src="'.$custom_pdf_logo_image_url.'"></a>', 0, 1, false, true, 'L', false);
}
// Get Y position for the separation
$y            = $pdf->getY();
$order_info = '<br><br><br><b>' . get_option('invoice_company_name') . '</b><br />';
$order_info .= nl2br(get_option('invoice_company_address')) . '<br/>';
$order_info .= get_option('invoice_company_city') . ', ';
$order_info .= get_option('invoice_company_state') . ', ';
$order_info .= get_option('invoice_company_postal_code') . '<br/> ';
$order_info .= get_country_name(get_option('invoice_company_country_code')) . '<br/> ';
if(get_option('invoice_company_phonenumber') != ''){
    $order_info .='<abbr title="Phone">P:</abbr>'. get_option('invoice_company_phonenumber'); 
  } 
// check for company custom fields
$custom_company_fields = get_company_custom_fields();
if(count($custom_company_fields) > 0){
    $order_info .= '<br />';
}
foreach($custom_company_fields as $field){
    $order_info .= $field['label'] . ':' . $field['value'] . '<br />';
}
$pdf->writeHTMLCell(91, 200, '', $y, $order_info, 0, 0, false, true, 'J', true);

// Quote to
$client_details = "";
if(!get_option('company_logo'))
{

    $client_details .= '<br /><br />';
}
$client_details .= '<b>' ._l('quote_report') . '</b><br />';
$client_details .=  _l('run_date').':'. _d(date('Y-m-d')). '</b><br />';
if (!empty($from_date)) {
    $client_details .=  _l('quote_from_date').':'. _d($from_date). '</b><br />';
}
if (!empty($to_date)) {
    $client_details .=  _l('quote_to_date').':'. _d($from_date). '</b><br />';
}
if($quotes == "")
{
    $count_quotes = 0;
}
else
{
    $count_quotes = count($quotes);
}
$client_details .=  _l('quote_count').':'. $count_quotes. '</b><br />';

// Dates
// $pdf->Cell(0, 0, _l('run_date') . ': ' . _d(date('Y-m-d')), 0, 1, 'R', 0, '', 0);
// if (!empty($from_date)) {
//     $pdf->Cell(0, 0, _l('order_from_date') . ': ' . _d($from_date), 0, 1, 'R', 0, '', 0);
// }

// if (!empty($to_date)) {
//     $pdf->Cell(0, 0, _l('order_to_date') . ': ' . _d($to_date), 0, 1, 'R', 0, '', 0);
// }

// $html .= '<b style="color:#6a6c6f"># ' . count($orders) . '</b>';

$pdf->writeHTMLCell(80, '', 165, 15, $client_details, 0, 1, 0, true, 'J', true);
// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
// The Table
$pdf->Ln(5);
// Header
$tblhtml = '<br><br><br><br><table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="1" border="0">
<tr height="30" bgcolor="#3A4656" style="color:#fff;text-align:center;">
	<th width="15%">'._l('estimate_dt_table_heading_number').'</th>
	<th width="14%">'._l('estimate_dt_table_heading_date').'</th>
	<th width="35%">'._l('invoice_dt_table_heading_client').'</th>
	<th width="14%">'._l('estimate_dt_table_heading_amount').'</th>
	<th width="10%">'._l('estimate_dt_table_heading_duedate').'</th>
	<th width="12%">'._l('estimate_dt_table_heading_status').'</th>
</tr>';
// Items
$taxes   = array();
$i       = 1;
$tblhtml .= '<tbody>';
 $CI =& get_instance();
 if($quotes != "")
 {
    foreach ($quotes as $quote) {
        $tblhtml .= '<tr style="text-align:center;font-size:9px;padding:0px">';
        $tblhtml .= '<td>' . format_estimate_number($quote->number) . '</td>';
        $tblhtml .= '<td>' . date('d/m/Y',strtotime($quote->date)) . '</td>';
        $tblhtml .= '<td>' .  $quote->accountname .'</td>';
        $tblhtml .= '<td>'.format_money($quote->total,$quote->symbol).'</td>';
        $tblhtml .= '<td>' .date('d/m/Y',strtotime($quote->expirydate)) . '</td>';
          
        $tblhtml .= '<td>' . format_estimate_status($quote->status) . '</td>';
       
        $tblhtml .= '</tr>';
        
    }
}

$tblhtml .= '</tbody>';
$tblhtml .= '</table>';
$pdf->writeHTML($tblhtml, true, false, false, false, '');