<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
			<div class="col-md-5">
				<div class="panel_s">
					<div class="panel-heading">
						<?php echo $title; ?>
					</div>
					<div class="col-md-12 no-padding animated fadeIn">
						<div class="panel_s">
							<?php echo form_open($this->uri->uri_string()); ?>
							<div class="panel-body">
								<h4 class="bold"><?php echo _l('payment_edit_for_invoice'); ?> <a href="<?php echo admin_url('invoices/list_invoices/'.$payment->invoiceid); ?>"><?php echo format_invoice_number($invoice->number); ?></a></h4>
								<?php echo render_input('amount','payment_edit_amount_received',$payment->amount); ?>
								<?php echo render_date_input('date','payment_edit_date',_d($payment->date)); ?>

								<?php $value = (isset($payment->receipt_number) ? $payment->receipt_number : $receipt_number); ?>
                                <?php echo render_input('receipt_number', 'receipt_number', $value); ?>


                             <div class="form-group">
                         <label for="paymentmode" class="control-label"><?php echo _l('payment_mode'); ?></label>
                         <select class="selectpicker display-block paymentmode" name="paymentmode" data-width="100%" data-live-search="true">

                             <option <?php if ($payment->paymentmode == '1') echo 'selected="selected"' ?> value="1">Cash</option>
                             <option <?php if ($payment->paymentmode == '2') echo 'selected="selected"' ?> value="2">Cheque</option>
                         </select>
                     </div>
                             <div id="bakdetails" style="display:none">                              
                              
                                    <div class="form-group">
                                        <label for="bank" class="control-label">Bank</label>
                                        <select class="selectpicker bank display-block" name="bank" data-width="100%" data-live-search="true">
                                            <option value=""></option>
                                            <?php
                                            foreach ($banks as $value) {
                                                if ($payment->bank == $value->bankid) {
                                                    echo "<option selected='selected' value='$value->bankid'>" . $value->bank . "</option>";
                                                } else {
                                                    echo "<option  value='$value->bankid'>" . $value->bank . "</option>";
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <br/>
                                    <?php $value = (isset($payment->account_number) ? $payment->account_number : ''); ?>
                                    <?php echo render_input('account_number', 'client_account_number', $value); ?>
                                    <?php $value = (isset($payment->cheque_number) ? $payment->cheque_number : ''); ?>
                                    <?php echo render_input('cheque_number', 'Check Number', $value); ?>
                                    <div class="form-group">
                                        <label for="idenpresented" class="control-label">Identification Presented</label>
                                        <select class="selectpicker display-block idenpresented" name="idenpresented" data-width="100%" data-live-search="true">
                                            <option value=""></option>
                                            <option <?php if ($payment->idenpresented == '1') echo "selected='selected'" ?> value="1">National Registration Card</option>
                                            <option <?php if ($payment->idenpresented == '2') echo "selected='selected'" ?> value="2">Social Security Card</option>
                                            <option  <?php if ($payment->idenpresented == '3') echo "selected='selected'" ?> value="3">Drivers License</option>
                                            <option <?php if ($payment->idenpresented == '4') echo "selected='selected'" ?> value="4">Passport</option>
                                            <option <?php if ($payment->idenpresented == '2') echo "selected='selected'" ?> value="4">Government Issued Employee ID</option>
                                            <option <?php if ($payment->idenpresented == '6') echo "selected='selected'" ?> value="5">Store Issued Card</option>
                                        </select>
                                    </div>
                                    <br/>
                                
                                   <?php $value = (isset($payment->identification) ? $payment->identification : ''); ?>
                                    <?php echo render_input('identification', 'Identification Number',$value); ?>
                              
                            </div>
                                                                 <?php // echo render_select('paymentmode',$payment_modes,array('id','name'),'payment_mode',$payment->paymentmode); ?>
								
                                                        <div class="transactionids"><?php echo render_input('transactionid','payment_transaction_id',$payment->transactionid); ?>
                                                    </div>
                                                                          <?php echo render_textarea('note','payment_edit_lave_note',$payment->note,array('rows'=>7)); ?>
								<div class="pull-right">
									<button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
								</div>
							</div>
							<?php echo form_close(); ?>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-7">
				<div class="panel_s">
					<div class="panel-heading">
						<?php echo _l('payment_view_heading'); ?>
					</div>
					<div class="panel-body">
						<div class="text-right">
							<a href="<?php echo admin_url('payments/pdf/'.$payment->paymentid); ?>" class="btn btn-default" data-toggle="tooltip" title="View PDF" data-placement="bottom"><i class="fa fa-file-pdf-o"></i></a>
							<a href="<?php echo admin_url('payments/delete/'.$payment->paymentid); ?>" class="btn btn-danger"><i class="fa fa-remove"></i></a>
						</div>
						<hr />
						<div class="row">
							<div class="col-md-6">
								<address>
							<span class="bold"><?php echo get_option('invoice_company_name'); ?></span><br>
							<?php echo get_option('invoice_company_address'); ?><br>
							<?php echo get_option('invoice_company_city'); ?>, <?php echo get_option('invoice_company_state'); ?> , <?php echo get_option('invoice_company_postal_code'); ?><br>
							<?php echo get_country_name(get_option('invoice_company_country_code')); ?><br/>
                                                        <?php if(get_option('invoice_company_phonenumber') != ''){ ?>
							<abbr title="Phone">P:</abbr> <?php echo get_option('invoice_company_phonenumber'); ?>
							<?php } ?>
							<?php
							// check for company custom fields
							$custom_company_fields = get_company_custom_fields();
							foreach($custom_company_fields as $field){
								echo $field['label'] . ':' . $field['value'] . '<br />';
							}
							?>
						</address>
							</div>
							<div class="col-sm-6 text-right">
								<address>
									<span class="bold"><?php echo $invoice->client->accountname; ?></span><br>
										<?php echo $invoice->client->address; ?><br>
							<?php echo $invoice->client->city; ?>, <?php echo $invoice->client->state; ?> , <?php echo $invoice->client->zip; ?><br>
                                                        <?php echo get_country_name($invoice->client->country); ?><br/><?php if(!empty($invoice->client->vat)){ ?>
									<?php echo _l('invoice_vat'); ?>: <?php echo $invoice->client->vat; ?><br />
									<?php } ?>
									<?php
									// check for customer custom fields which is checked show on pdf
									$pdf_custom_fields = get_custom_fields('customers',array('show_on_pdf'=>1));
									foreach($pdf_custom_fields as $field){
										$value = get_custom_field_value($invoice->clientid,$field['id'],'customers');
										if($value == ''){continue;}
										echo $field['name'] . ': ' . $value . '<br />';
									}
									?>
								</address>
							</div>
						</div>
						<div class="col-md-12 text-center">
							<h3 class="text-uppercase"><?php echo _l('payment_receipt'); ?></h3>
						</div>
						<div class="col-md-12 mtop30">
							<div class="row">
								<div class="col-md-6">
									<p><?php echo _l('payment_date'); ?> <span class="pull-right bold"><?php echo _d($payment->date); ?></span></p>
									<hr />
									<p><?php echo _l('payment_view_mode'); ?> <span class="pull-right bold"><?php echo $payment->name; ?></span></p>
									<?php if(!empty($payment->transactionid)) { ?>
									<hr />
									<p><?php echo _l('payment_transaction_id'); ?>: <span class="pull-right bold"><?php echo $payment->transactionid; ?></span></p>
									<?php } ?>
								</div>
								<div class="clearfix"></div>
								<div class="col-md-6">
									<div class="payment-preview-wrapper">
										<?php echo _l('payment_total_amount'); ?><br />
										<?php echo format_money($payment->amount,$invoice->symbol); ?>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-12 mtop30">
							<h4><?php echo _l('payment_for_string'); ?></h4>
							<div class="table-responsive">
								<table class="table table-borderd table-hover">
									<thead>
										<tr>
											<th><?php echo _l('payment_table_invoice_number'); ?></th>
											<th><?php echo _l('payment_table_invoice_date'); ?></th>
											<th><?php echo _l('payment_table_invoice_amount_total'); ?></th>
											<th><?php echo _l('payment_table_payment_amount_total'); ?></th>
										</tr>
									</thead>
									<tbody>
										<tr>
											<td><?php echo format_invoice_number($invoice->number); ?></td>
											<td><?php echo _d($invoice->date); ?></td>
											<td><?php echo format_money($invoice->total,$invoice->symbol); ?></td>
											<td><?php echo format_money($payment->amount,$invoice->symbol); ?></td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php init_tail(); ?>
<script>
    $('#payment_amount').mask('000,000,000,000,000.00', {reverse: true});
    $(document).ready(function(){

    	$("#receipt_number").attr("readonly", true);
    	
      if($( ".paymentmode option:selected" ).val() != 1){
            $('#bakdetails').show();
            $('.transactionids').hide();
      }else{
           $('#bakdetails').hide();
            $('.transactionids').show();
      }
    });
     $('.paymentmode').change(function () {
        if ($(this).val() == '2') {
            $('#bakdetails').show();
            $('.transactionids').hide();
        } else {
            $('#bakdetails').hide();
            $('.transactionids').show();
        }

    });
    
    $('#amount').change(function(){
        if($(this).val()){
       var amount = parseFloat($(this).val());
     
        $(this).val(amount.toFixed(2)); 
    }
    })
//	_validate_form($('form'),{amount:'required',date:'required'});

  _validate_form($('form'), {amount: 'required', date: 'required'}, expenseSubmitHandler);
    function expenseSubmitHandler(form) {
        if ($('.paymentmode').val() == '2') {
            var flag = 1;
           
            if ($('.bank').val() == '') {
                $('.bank').parent().addClass('has-error');
                flag = 0;
            } else {
                $('.bank').parent().removeClass('has-error');
                flag = 1;
            }
            if ($('#account_number').val() == '') {
                $('#account_number').parent().addClass('has-error');
                flag = 0;
            } else {
                $('#account_number').parent().removeClass('has-error');
                flag = 1;
            }
            if ($('#cheque_number').val() == '') {
                $('#cheque_number').parent().addClass('has-error');
                flag = 0;
            } else {
                $('#cheque_number').parent().removeClass('has-error');
                flag = 1;
            }

            if (flag == 1) {

                if ($('.idenpresented').val()) {
                    
                    if ($('#identification').val() == '') {
                        $('#identification').parent().addClass('has-error');
                        return false;
                    } else {
                      form.submit();
                      return true;
                  }
                }else {
                    form.submit();
                    return true;
                }


            } else {
                return false;
            }
        } else {
           form.submit();
            return true;
        }
    };
</script>
</body>
</html>
