<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
			<div class="col-md-12">
                <h2>Discount</h2>
               <div class="panel_s">
                <div class="panel-body tableNoMTop">
					<div class="absoluteBtns">
						<a href="#" class="btn btn-info pull-left" data-toggle="modal" data-target="#tax_modal"><?php echo _l('new_discount'); ?></a>
					</div>

						<div class="clearfix"></div>
						<?php render_datatable(array(
							_l('discount_dt_name'),
							_l('discount_dt_rate'),
							_l('Ledger'),
							_l('options')
							),'discounts'); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal animated fadeIn" id="tax_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="myModalLabel">
						<span class="edit-title"><?php echo _l('discount_edit_title'); ?></span>
						<span class="add-title"><?php echo _l('discount_add_title'); ?></span>
					</h4>
				</div>
				<?php echo form_open('admin/discounts/manage',array('id'=>'tax_form')); ?>
				<?php echo form_hidden('discountid'); ?>

				<div class="modal-body">
					<div class="row">
                        <div class="col-md-12">
                            <?php echo render_input('name','discount_add_edit_name'); ?>
                            <?php echo render_input('discountrate','discount_add_edit_rate','','number'); ?>
                               <div class="form-group">
                                <label for="ledger" class="control-label">Ledgers</label>
                                <select name="ledger" class="form-control selectpicker" id="ledger" data-live-search="true">
                                    <option value=""></option>
                                    <?php
                                        $parent= '' ;
                                        display_tree($prev,0,$default_options['sales_discount']);
                                    ?>
                                </select>
                            </div>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
					<button type="button" class="btn btn-primary" data-dismiss="modal">Exit</button>
					<button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
					<button type="button" class="btn btn-primary addsaveandnew">Save & New</button>
					<?php echo form_close(); ?>
				</div>
			</div>
		</div>
	</div>
	<?php init_tail(); ?>
	<?php
	function display_tree($prevsubgroups,$ind,$parent)
	{
	    
	    $t=$ind*35+5;
	     $ind++;
	     foreach ($prevsubgroups as $value) {
	        /* if($value->type=="Ledger")
	         {*/
	         if($value->name!="Equity")
	         {
	            $str="";
	            $val=$value->id;
	            if($value->type=="Group")
	            {
	                $str="color:#0699E1";
	                $val="";
	            }
	             $style='style="padding-left:'.$t.'px;'.$str.'"';
	             
	             
	             if($parent == $value->id)
	                echo "<option $style selected='selected' value='$val'>$value->name</option>";
	               else 
	                  echo "<option $style value='$val'>$value->name</option>";
	             
	             
	        // }
	            display_tree($value->subgroups,$ind,$parent);
	         }
	         
	         }
	}
	?>
	<script>
		_validate_form($('form'),{name:'required',ledger:'required',rate:{number:true,required:true}},manage_discount);
		/* TAX MANAGE FUNCTIONS */
		function manage_discount(form) {
			var data = $(form).serialize();
			var url = form.action;
			$.post(url, data).success(function(response) {
				response = $.parseJSON(response);
				if (response.success == true) {
					$('.table-discounts').DataTable().ajax.reload();
					alert_float('success', response.message);
				}
				$('#tax_modal').modal('hide');
			});
			return false;
		}

		$('#tax_modal').on('show.bs.modal', function(event) {
			var button = $(event.relatedTarget)
			var id = button.data('id');
			$('#tax_modal input').val('');
			$('#tax_modal .add-title').removeClass('hide');
			$('#tax_modal .edit-title').addClass('hide');

			if (typeof(id) !== 'undefined') {
				$('input[name="discountid"]').val(id);
				var name = $(button).parents('tr').find('td').eq(0).text();
				var rate = $(button).parents('tr').find('td').eq(1).text();
			
                                
                                $.ajax({
                                    url: admin_url + 'discounts/get_details',
                                    data: {id: id},
                                    type: 'POST',
                                    dataType: 'json',
                                    success: function(response)
                                    {
                                  
                                     $('#tax_modal input[name="name"]').val(response.name);
                                     $('#tax_modal input[name="discountrate"]').val(response.discountrate);
                                     $('#ledger').selectpicker('val',response.ledger);
                                     $('#ledger').selectpicker('refresh');
                                    }
                                });
    
				$('#tax_modal .add-title').addClass('hide');
				$('#tax_modal .edit-title').removeClass('hide');
      				
			}
		});
		/* END TAX MANAGE FUNCTIONS */

		$(document).ready(function(){

	        $('.addsaveandnew').on('click', function (e) {
	            if($("form").valid() == true)
            	{
		            $.ajax({
		                type: "POST",
		                url: admin_url + 'discounts/manage',
		                // data: {data: $('#add_category_form').serializeArray()},
		                data: {
		                    name: $('#name').val(),
		                    discountrate: $('#discountrate').val(),
		                    ledger: $('#ledger').val(),
		                    discountid: $('input[name="discountid"').val(),
		                },
		                // dataType: 'json',
		                success: function (response) {
		                    // location.reload();
		                    if (response.success == true) {
		                        $('.table-customer-groups').DataTable().ajax.reload();
		                        alert_float('success', response.message);
		                    }
		                    $('#name').val('');
		                    $('#discountrate').val('');
		                    $('#ledger').selectpicker('deselectAll');
		                    $('input[name="id"').val('');
		                    $('#tax_modal').modal('show');
		                }
		                
		            });
		        }
	        });

	      
	    });
	</script>
</body>
</html>
