<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
			<div class="col-md-12">
			<div class="panel-heading">
					Currencies
						
					</div>
				<div class="panel_s">
					<div class="panel-body tableNoMTop">
					<a href="#" class="btn btn-info pull-left floatedBtn" data-toggle="modal" data-target="#currency_modal"><?php echo _l('new_currency'); ?></a>
					
						<?php render_datatable(array(
							_l('currency_list_name'),
							_l('currency_list_symbol'),
							_l('options'),
							),'currencies'); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal animated fadeIn" id="currency_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="myModalLabel">
						<span class="edit-title"><?php echo _l('currency_edit_heading'); ?></span>
						<span class="add-title"><?php echo _l('currency_add_heading'); ?></span>
					</h4>
				</div>
				<?php echo form_open('admin/currencies/manage',array('id'=>'currency_form')); ?>
				<input type="hidden" name="currencyid" id="currencyid">
				
				<div class="modal-body">
					<div class="row">
						<div class="col-md-12">
							<?php echo render_input('name','currency_add_edit_description'); ?>
							<?php echo render_input('symbol','currency_add_edit_rate'); ?>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
					<button type="button" class="btn btn-primary" data-dismiss="modal">Exit</button>
					<button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
					<button type="button" class="btn btn-primary addsaveandnew">Save & NEw</button>
					<?php echo form_close(); ?>
				</div>
			</div>
		</div>
	</div>
	<?php init_tail(); ?>
	<script>
		_validate_form($('form'),{name:'required',symbol:'required'},manage_currencies);

		/* CURRENCY MANAGE FUNCTIONS */
		function manage_currencies(form) {
			var data = $(form).serialize();
			var url = form.action;
			$.post(url, data).success(function(response) {
				response = $.parseJSON(response);
				if (response.success == true) {
					$('.table-currencies').DataTable().ajax.reload();
					alert_float('success', response.message);
				}
				$('#currency_modal').modal('hide');
			});
			return false;
		}

		$('#currency_modal').on('show.bs.modal', function(event) {
			var button = $(event.relatedTarget)
			var id = button.data('id');
			$('#currency_modal input').val('');
			$('#currency_modal .add-title').removeClass('hide');
			$('#currency_modal .edit-title').addClass('hide');

			if (typeof(id) !== 'undefined') {
				$('input[name="currencyid"]').val(id);
				var name = $(button).parents('tr').find('td').eq(0).find('span.name').text();
				var symbol = $(button).parents('tr').find('td').eq(1).text();
				$('#currency_modal .add-title').addClass('hide');
				$('#currency_modal .edit-title').removeClass('hide');
				$('#currency_modal input[name="name"]').val(name);
				$('#currency_modal input[name="symbol"]').val(symbol);
			}
		});
		/* END CURRENCY MANAGE FUNCTIONS */

	$(document).ready(function(){

        $('.addsaveandnew').on('click', function (e) {
            if($("form").valid() == true)
            {
	            $.ajax({
	                type: "POST",
	                url: admin_url + 'currencies/manage',
	                // data: {data: $('#add_category_form').serializeArray()},
	                data: {
	                    name: $('#name').val(),
	                    symbol: $('#symbol').val(),
	                    currencyid: $('#currencyid').val(),
	                },
	                // dataType: 'json',
	                success: function (response) {
	                    $('#name').val('');
	                    $('#symbol').val('');
	                    $('#currencyid').val('');
	                    $('#currency_modal').modal('show');  
	                }
	            });
	        }
        });

      
    });
	</script>
</body>
</html>
