// JS File used in events
$(document).ready(function() {
  if ($('body').hasClass('home')) {
    settings.customButtons.viewFullCalendar = {
      text: 'expand',
      click: function() {
        window.location.href = admin_url + 'utilities/calendar';
      }
    }
  }
  if (google_api != '') {
    //settings.googleCalendarApiKey = google_api;
  }
  $('#calendar').fullCalendar({
    // put your options and callbacks here
    //slotDuration: '00:05:00',
    eventLimit: true, // for all non-agenda views
    views: {
      month: {
        eventLimit: 10, // adjust to 6 only for agendaWeek/agendaDay
        //columnFormat: 'YYYY, MM, DD'
      },
      basic: {
        columnFormat: 'DD/MM',
        // options apply to basicWeek and basicDay views
      },
      agenda: {
        // options apply to agendaWeek and agendaDay views
      },
      week: {
        // options apply to basicWeek and agendaWeek views
      },
      day: {
        // options apply to basicDay and agendaDay views
      }
    },
    eventRender: function(event, element) {
      element.find('.fc-title').html(event.title);
      // element.find('.fc-title').append("<br/>" + event.description); 
    },
    customButtons: {
      addnewevent: {
        text: 'New Event',
        click: function() {
          //$('.fc-addnewevent-button').button('loading');
          $('.fc-addnewevent-button').addClass('calendar-add-event-btn');
          $('#ajax').modal({
            remote: '/events/edit'
          });
        }
      },
      deleteevent: {
        text: 'Delete Event',
        click: function() {
          $('.fc-addnewevent-button').addClass('calendar-add-event-btn');
          $('#ajax').modal({
            remote: '/events/edit'
          });
        }
      },
      refreshevents: {
        text: 'Retrieve New Events!',
        click: function() {
          $('.fc-refreshevents-button').button('loading');
          var events_reload_url = '/eventsrest/loadevents';
          $.get(events_reload_url, function(data) {
            if ('success' == data.status) {
              //generate('information', data.message);
              //generateAll();
            }
            $('.fc-refreshevents-button').button('reset');
            $('#calendar-events').fullCalendar('refetchEvents');
          });
          var events_customer_fix_url = '/eventsrest/refreshunknowncustomers';
          $.get(events_customer_fix_url, function(data) {
            //alert(data.message);
            if ('success' == data.status) {
              //generate('information', data.message);
              //generateAll();
            }
            $('.fc-refreshevents-button').button('reset');
            $('#calendar-events').fullCalendar('refetchEvents');
          });
        }
      },
      refreshcalendar: {
        text: 'Refresh Events!',
        click: function() {
          $('.fc-refreshcalendar-button').button('loading');
          $('#calendar').fullCalendar('refetchEvents');
          $('.fc-refreshcalendar-button').button('reset');
          //generate('information', 'Events Refreshed' );					
        }
      }
    },
    timeFormat: 'H:mm',
    weekends: true,
    defaultView: 'month',
    editable: true,
	eventOrder: 'appointment_date,event_date',

    header: {
      left: 'month,agendaWeek basicDay,basicWeek',
      center: 'title',
      right: 'addnewevent refreshcalendar prev,next today'
    },
    //dayClick: function(date, jsEvent, view) {
    //        		var day_clicked = date.format('YYYY-MM-DD HH:mm');
    //        		var new_event_url = '/events/edit/event_date/' + day_clicked;
    //        		$('#ajax').modal({
    //					remote: escape(new_event_url)
    //				});
    //
    //        		//alert( day_clicked );
    //		        //alert('Clicked on: ' + date.format());
    //		        //alert('Coordinates: ' + jsEvent.pageX + ',' + jsEvent.pageY);
    //		        //alert('Current view: ' + view.name);
    //		        // change the day's background color just for fun
    //		        //$(this).css('background-color', 'red');
    //
    //		    },
    events: {
      url: admin_url + 'jobcard/jobcard_data',
      type: 'GET',
      data: {
        custom_param1: 'something',
        custom_param2: 'somethingelse'
      },
      error: function() {
        //alert('there was an error while fetching events!');
      },
      //color: 'blue',   // a non-ajax option
      //textColor: 'white' // a non-ajax option
    },
    dayRightclick: function(date, jsEvent, view) {
      // Prevent browser context menu:
      return false;
    },
    eventMouseover: function(event, jsEvent, view) {
      //alert('an event has been rightclicked!');
      // Prevent browser context menu:
      $('.popovers').popover({
        html: true
      });
      return false;
    },
    eventRightclick: function(event, jsEvent, view) {
      // if( event.event_notes.length ) {
      // 	alert(event.event_notes);	
      // }wcwwwwc
      //alert('an event has been rightclicked!');
      // Prevent browser context menu:
      return false;
    },
	
    eventDrop: function(event, delta, revertFunc) {
      var event_start = event.start.format('YYYY-MM-DD HH:mm');
      if ('event' == event.event_type) {
        $.ajax({
          type: "POST",
          url: admin_url + 'events/update_event',
          data: {
            event_id: event.id,
            event_date: event_start
          },
          success: function(data) {}
        }).done(function(data) {
          //console.log(data);
        });
      } else if ('jobcard' == event.event_type) {
        $.ajax({
          type: "POST",
          url: admin_url + 'jobcard/update_jobcard_event',
          data: {
            jobcard_id: event.id,
            appointment_date: event_start
          },
          success: function(data) {}
        }).done(function(data) {
          //console.log(data);
        });
      }
      //return false;
      // if (!confirm("Are you sure about this change?")) {
      //     revertFunc();
      // }
    },
    eventClick: function(event, jsEvent, view) {
      //$('#modalTitle').html(event.title);
      //$('#modalBody').html(event.description);	            
      //$('#eventUrl').attr('href',event.url);
      //$('#fullCalModal').modal('show');	            
    }
  });
  // New event modal
  $('#newEventModal form').submit(function() {
    if ($(this).find('input[name="start"]').val() == '') {
      alert('Start date cannot be empty');
      return false;
    }
    $.post(this.action, $(this).serialize(), function(response) {
      response = $.parseJSON(response);
      if (response.success == true) {
        alert_float('success', response.message);
        $('#newEventModal').modal('hide');
        $('#calendar').fullCalendar('refetchEvents');
        $('#newEventModal input').val('');
      }
    });
    return false;
  });
  var refreshcalendar = setInterval(function(){
			//$('.fc-refreshevents-button').trigger('click');
			$('.fc-refreshcalendar-button').trigger('click');
			
		},30000);
  
});