<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12">
                <h2>Supplier Class</h2>
                <div class="panel_s">
                    <div class="panel-body tableNoMTop">
					<div class="absoluteBtns">
                        <a href="#" class="btn btn-info pull-left addform" data-toggle="modal" data-target="#supplier_group_modal"><?php echo _l('new_supplier_group'); ?></a>
                    </div>
                        <div class="clearfix"></div>
                        <?php
                        render_datatable(array(
                            _l('supplier_group_name'),
                            _l('is_active'),
                            _l('options'),
                                ), 'supplier-groups');
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal animated fadeIn" id="supplier_group_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button group="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                    <span class="edit-title"><?php echo _l('supplier_group_edit_heading'); ?></span>
                    <span class="add-title"><?php echo _l('supplier_group_add_heading'); ?></span>
                </h4>
            </div>
            <?php echo form_open('admin/suppliers/group'); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <?php echo render_input('name', 'supplier_group_name'); ?>
                        <?php echo render_input('discription', 'Discription'); ?>
                        <div class="form-group">
                            <label for="default_language" class="control-label"><?php echo _l('localization_default_language'); ?>
                            </label>
                            <select name="default_language" id="default_language" class="form-control selectpicker">
                                <option value=""><?php echo _l('system_default_string'); ?></option>
                                <?php
                                foreach (list_folders(APPPATH . 'language') as $language) {
                                   
                                    ?>
                                    <option value="<?php echo $language; ?>"><?php echo ucfirst($language); ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="ledger" class="control-label">Accounts Payable Ledger</label>
                            <select name="account_payable_ledger" class="form-control selectpicker" id="account_payable_ledger" data-live-search="true">
                                <option value=""></option>
                                <?php
                                    $parent= (isset($suppliers->ledger) ? $suppliers->ledger : '' );
                                    display_tree($liabilities_prev, 0, $parent);
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="ledger" class="control-label"><?php echo _l('expense_ledger'); ?></label>
                            <select name="expense_ledger" class="form-control selectpicker" id="expense_ledger" data-live-search="true">
                                <option value=""></option>
                                <?php
                                    $parent= (isset($suppliers->ledger) ? $suppliers->ledger : '' );
                                    display_tree($expenses_prev, 0, $parent);
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="payment_term" class="control-label"><?php echo _l('payment_modes'); ?></label>
                            <select id="payment_term" style="" class="form-control selectpicker" name="payment_term" data-live-search="true" data-width="100%">
                                <option value=""></option>
                                <?php
                                foreach (get_all_paymentterms()as $value) {

                                    if (isset($client)) {
                                        if ($suppliers->payment_term == $value->id)
                                            echo '<option data-days="' . $value->dueDays . '" selected="selected" value=' . $value->id . '>' . $value->name . "</option>";
                                        else
                                            echo '<option data-days="' . $value->dueDays . '" value=' . $value->id . '>' . $value->name . "</option>";
                                    }else {
                                        if ($value->id == '1')
                                            echo '<option data-days="' . $value->dueDays . '"  selected="selected" value=' . $value->id . '>' . $value->name . "</option>";
                                        else
                                            echo '<option data-days="' . $value->dueDays . '"  value=' . $value->id . '>' . $value->name . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>

                        <?php
                        $selected = '';
                        foreach ($currencies as $currency) {
                            if (isset($client)) {
                                if ($currency['id'] == $client->default_currency) {
                                    $selected = $currency['id'];
                                }
                            }
                        }
                        ?>
                        <?php echo render_select('default_currency', $currencies, array('id', 'symbol', 'name'), 'invoice_add_edit_currency', $selected, array('data-none-selected-text' => _l('system_default_string'))); ?>
                       

                        <div class='duedays'>
                            <?php echo render_input('creditlimit', 'Credit Limit'); ?>
                        </div>

                        <div class="checkbox checkbox-primary">
                            <input type="checkbox" value="1" name="class_is_active" id="class_is_active" >
                            <label>Is Active</label>
                        </div>

                        <input type="hidden" name="id" id="id">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" data-dismiss="modal">Exit</button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                <button type="button" class="btn btn-primary addsaveandnew">Save & New</button>
            <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<?php
function display_tree($prevsubgroups,$ind,$parent)
{

    
    $t=$ind*35+5;
     $ind++;
     foreach ($prevsubgroups as $value) {
        /* if($value->type=="Ledger")
         {*/
         if($value->name!="Equity")
         {
            $str="";
            $val=$value->id;
            if($value->type=="Group")
            {
                $str="color:#0699E1";
                $val="";
            }
             $style='style="padding-left:'.$t.'px;'.$str.'"';
             
             
             if($parent == $value->id)
                // echo $parent;
                echo "<option $style selected='selected' value='$val'>$value->name</option>";
               else 
                  echo "<option $style value='$val'>$value->name</option>";
             
             
        // }
            display_tree($value->subgroups,$ind,$parent);
         }
         
         }
}
?>
<script>

    $('.duedays').hide();
    $('#payment_term').change(function () {
        
     chckpt=($( "#payment_term option:selected" ).text());

      if(chckpt=="Cash" || chckpt==""){
               $('.duedays').hide();
      }
      else {
         $('.duedays').show();
          
      }
    
    });
//         $('#class_is_active').click(function(){
//            if($(this).is(':checked')){
//                alert($('#class_is_active').val())
//             $('#isactive').val($('#class_is_active').val());
//            }else{
//                 $('#isactive').val('0');
//            }
//        });
    _validate_form($('form'), {
        name: 'required'
    }, manage_supplier_groups);
    initDataTable('.table-supplier-groups', window.location.href, 'groups', [2], [2]);

    function manage_supplier_groups(form) {

        var data = $(form).serialize();

        var url = form.action;
        $.post(url, data).success(function (response) {
            response = $.parseJSON(response);
            if (response.success == true) {

                $('.table-supplier-groups').DataTable().ajax.reload();
                alert_float('success', response.message);
            }
            $('#ledger,#payment_term,#account_req').selectpicker('deselectAll');
            $('#supplier_group_modal').modal('hide');
            $('input[name="class_is_active"]').prop('checked', false);
        });

        return false;
    }
    $('.addform').click(function () {
        $('#ledger,#payment_term,#account_req,#default_language,#default_currency').selectpicker('deselectAll');
        $('#name,#discription,#creditlimit').val('');
        $('input[name="class_is_active"]').prop('checked', false);
         $('.duedays').hide();
         $('#supplier_group_modal input[name="id"]').val('');
        $('#supplier_group_modal .edit-title').addClass('hide');
        $('#supplier_group_modal .add-title').removeClass('hide');
    });
    $('#supplier_group_modal').on('show.bs.modal', function (e) {
        var invoker = $(e.relatedTarget);
        var group_id = $(invoker).data('id');
        var data = {id: group_id};
        if (group_id) {
            $('#supplier_group_modal .add-title').removeClass('hide');
            $('#supplier_group_modal .edit-title').addClass('hide');
            var url = '<?php echo base_url('admin/suppliers/getclass') ?>';
            $.post(url, data, function (response) {

                $('#name').val(response.name);
                $('#discription').val(response.discription);
                creditlmt= (response.creditlimit + "").replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
                $('#creditlimit').val(creditlmt);
                $('#account_payable_ledger').selectpicker('val', response.account_payable_ledger);
                $('#account_payable_ledger').selectpicker('refresh');
                $('#expense_ledger').selectpicker('val', response.expense_ledger);
                $('#expense_ledger').selectpicker('refresh');
                $('#default_currency').selectpicker('val', response.default_currency);
                $('#default_currency').selectpicker('refresh');
                $('#default_language').selectpicker('val', response.default_language);
                $('#default_language').selectpicker('refresh');
                $('#payment_term').selectpicker('val', response.payment_term);
                $('#payment_term').selectpicker('refresh');
                // $('#account_req').selectpicker('val', response.account_req);
                // $('#account_req').selectpicker('refresh');
                chckpt=($( "#payment_term option:selected" ).text());

      if(chckpt=="Cash" || chckpt==""){
               $('.duedays').hide();
      }
      else {
         $('.duedays').show();
          
      }

                if (response.class_is_active == 1) {
                    $('input[name="class_is_active"]').prop('checked', true);
                } else {
                    $('input[name="class_is_active"]').prop('checked', false);
                }

            }, 'json');

//            $('#customer_group_modal input').val('');
            // is from the edit button
            if (typeof (group_id) !== 'undefined') {
                console.log(group_id);
                $('#supplier_group_modal input[name="id"]').val(group_id);
                $('#supplier_group_modal .add-title').addClass('hide');
                $('#supplier_group_modal .edit-title').removeClass('hide');
                $('#supplier_group_modal input[name="name"]').val($(invoker).parents('tr').find('td').eq(0).text());
            }
        }
    });

    $(document).ready(function(){

        $('.addsaveandnew').on('click', function (e) {
            if($("form").valid() == true)
            {
                if($('#class_is_active').prop("checked") == true){
                    var class_is_active = 1;
                }
                else
                {
                    var class_is_active = 0;
                }

                // alert($('#id').val());
                $.ajax({
                    type: "POST",
                    url: admin_url + 'suppliers/add_update_group',
                    // data: {data: $('#add_category_form').serializeArray()},
                    data: {
                        name: $('#name').val(),
                        discription: $('#discription').val(),
                        default_language: $('#default_language').val(),
                        account_payable_ledger: $('#account_payable_ledger').val(),
                        expense_ledger: $('#expense_ledger').val(),
                        payment_term: $('#payment_term').val(),
                        default_currency: $('#default_currency').val(),
                        // account_req: $('#account_req').val(),
                        creditlimit: $('#creditlimit').val(),
                        id: $('#id').val(),
                        class_is_active: class_is_active,

                    },
                    // dataType: 'json',
                    success: function (response) {
                        // location.reload();
                        // if (response.success == true) {
                        //     $('.table-customer-groups').DataTable().ajax.reload();
                        //     alert_float('success', response.message);
                        // }

                        $('#name').val('');
                        $('#discription').val('');
                        // $('#default_language').val('');
                        // $('#ledger').val('');
                        // $('#payment_term').val('');
                        // $('#default_currency').val('');
                        // $('#account_req').val('');
                        $('#creditlimit').val('');
                        $('#id').val('');

                        $('#expense_ledger,#payment_term,#account_payable_ledger,#default_currency,#default_language').selectpicker('deselectAll');
                        // $('#customer_group_modal').modal('hide');
                        // $('input[name="class_is_active"]').prop('checked', false);

                        $('#class_is_active').prop('checked', false);

                        $('#supplier_group_modal').modal('show');
                       
                    }
                    
                });
            }
            
      
        });

      
    });

    $(document).on('click', '.ischeckbox', function () {
        var current = $(this);
        $.ajax({
            url: admin_url + "suppliers/changestatus",
            data: {id: $(this).data('rowid')},
            dataType: 'json',
            type: 'post',
            success: function (response)
            {

            }
        });
    });
</script>
</body>
</html>
