<div class="col-md-12 no-padding animated fadeIn">
    <div class="panel_s">
        <div class="panel-body padding-16">
         <ul class="nav nav-tabs no-margin" role="tablist">
            <li role="presentation" class="active">
                <a href="#tab_quote" aria-controls="tab_quote" role="tab" data-toggle="tab">
                    <?php echo _l('quote'); ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#tab_tasks" aria-controls="tab_tasks" role="tab" data-toggle="tab">
                    <?php echo _l('tasks'); ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#tab_activity" aria-controls="tab_activity" role="tab" data-toggle="tab">
                    <?php echo _l('quote_view_activity_tooltip'); ?>
                </a>
            </li>
        </ul>
    </div>
</div>
<div class="panel_s">
    <div class="panel-body">
        <div class="row">

            <div class="col-md-3">
                <?php echo format_quote_status($quote->status,'mtop10');  ?>
            </div>
            <div class="col-md-9">
                <div class="pull-right">
                    <a href="<?php echo admin_url('quotes/quote/'.$quote->clientid.'/'.$quote->id); ?>" class="btn btn-default mright5 pull-left" data-toggle="tooltip" title="<?php echo _l('edit_quote_tooltip'); ?>" data-placement="bottom"><i class="fa fa-pencil-square-o"></i></a>

                    <a href="<?php echo admin_url('quotes/pdf/'.$quote->id); ?>" class="btn btn-default pull-left mright5" data-toggle="tooltip" target="_blank" title="View PDF" data-placement="bottom"><i class="fa fa-file-pdf-o"></i></a>
                    <?php
                    $_tooltip = _l('quote_sent_to_email_tooltip');
                    if($quote->sent == 1){
                        $_tooltip = _l('quote_already_send_to_client_tooltip',time_ago($quote->datesend));
                    }
                    ?>
                    <a href="#" class="quote-send-to-client btn btn-default mright5 pull-left" data-toggle="tooltip" title="<?php echo $_tooltip; ?>" data-placement="bottom"><i class="fa fa-envelope"></i></a>

                    <div class="btn-group">
                        <button type="button" class="btn btn-default pull-left dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php echo _l('more'); ?> <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <li><a href="<?php echo site_url('viewquote/' . $quote->id . '/' .  $quote->hash) ?>" target="_blank"><?php echo _l('view_quote_as_client'); ?></a></li>

                           <?php if($quote->invoiceid == NULL){ ?>
                            <?php if($quote->status != '1'){ ?>
                            <li>
                              <a href="<?php echo admin_url() . 'quotes/mark_action_status/1/'.$quote->id; ?>">
                              <?php echo _l('quote_mark_as',_l('quote_status_draft')); ?></a>
                            </li>
                            <?php } ?>
                            <?php if($quote->status != '2'){ ?>
                            <li>
                              <a href="<?php echo admin_url() . 'quotes/mark_action_status/2/'.$quote->id; ?>">
                               <?php echo _l('quote_mark_as',_l('quote_status_sent')); ?></a>
                            </li>
                            <?php } ?>
                            <?php if($quote->status != '3'){ ?>
                            <li>
                              <a href="<?php echo admin_url() . 'quotes/mark_action_status/3/'.$quote->id; ?>">
                               <?php echo _l('quote_mark_as',_l('quote_status_declined')); ?></a>
                            </li>
                            <?php } ?>
                            <?php if($quote->status != '4'){ ?>
                            <li>
                              <a href="<?php echo admin_url() . 'quotes/mark_action_status/4/'.$quote->id; ?>">
                               <?php echo _l('quote_mark_as',_l('quote_status_accepted')); ?></a>
                            </li>
                            <?php } ?>
                                <?php if($quote->status != '5'){ ?>
                            <li>
                              <a href="<?php echo admin_url() . 'quotes/mark_action_status/5/'.$quote->id; ?>">
                               <?php echo _l('quote_mark_as',_l('quote_status_expired')); ?></a>
                            </li>
                            <?php } ?>
                            <?php } ?>
                                <?php
                            if((get_option('delete_only_on_last_quote') == 1 && is_last_quote($quote->id)) || (get_option('delete_only_on_last_quote') == 0)){ ?>
                            <li>
                            <a href="<?php echo admin_url('quotes/delete/'.$quote->id); ?>" data-placement="bottom"><?php echo _l('delete_quote_tooltip'); ?></a>
                            </li>
                            <?php
                        }
                        ?>
                    </ul>
                </div>
                <?php if($quote->invoiceid == NULL){ ?>
                <a href="<?php echo admin_url('quotes/convert_to_invoice/'.$quote->id); ?>" class="mleft10 btn btn-success"><?php echo _l('quote_convert_to_invoice'); ?></a>
                <?php } else { ?>
                <a href="<?php echo admin_url('invoices/list_invoices/'.$quote->invoice->id); ?>" data-placement="bottom" data-toggle="tooltip" title="<?php echo _l('quote_invoiced_date',_dt($quote->invoiced_date)); ?>"class="btn mleft10 btn-info"><?php echo format_invoice_number($quote->invoice->id); ?></a>
                <?php } ?>

            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    <hr />
    <div class="tab-content">
        <div role="tabpanel" class="tab-pane ptop10 active" id="tab_quote">
            <div id="quote-preview" class="mtop30">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <h4 class="bold"><a href="<?php echo admin_url('quotes/quote/'.$quote->id); ?>"><?php echo format_quote_number($quote->id); ?></a></h4>
                            <address>
                                <span class="bold"><a href="<?php echo admin_url('settings?tab_hash=company_info'); ?>" target="_blank"><?php echo get_option('invoice_company_name'); ?></span></a><br>
                                <?php echo get_option('invoice_company_address'); ?><br>
                                <?php echo get_option('invoice_company_city'); ?>, <?php echo get_option('invoice_company_country_code'); ?> <?php echo get_option('invoice_company_postal_code'); ?><br>
                                <?php if(get_option('invoice_company_phonenumber') != ''){ ?>
                                <abbr title="Phone">P:</abbr> <?php echo get_option('invoice_company_phonenumber'); ?><br />
                                <?php } ?>
                                <?php
                                // check for company custom fields
                                $custom_company_fields = get_company_custom_fields();
                                foreach($custom_company_fields as $field){
                                    echo $field['label'] . ':' . $field['value'] . '<br />';
                                }
                                ?>
                            </address>
                        </div>
                        <div class="col-sm-6 text-right">
                            <span class="bold"><?php echo _l('quote_to'); ?>:</span>
                            <address>
                                <span class="bold"><a href="<?php echo admin_url('clients/client/'.$quote->client->userid); ?>" target="_blank"><?php echo $quote->client->accountname; ?></span></a><br>
                                <?php echo $quote->billing_street; ?><br>
                                <?php echo $quote->billing_city; ?>, <?php echo $quote->billing_state; ?><br/><?php echo get_country_short_name($quote->billing_country); ?>,<?php echo $quote->billing_zip; ?><br>
                                <?php if(!empty($quote->client->vat)){ ?>
                                <?php echo _l('quote_vat'); ?>: <?php echo $quote->client->vat; ?><br />
                                <?php } ?>
                                <?php
                                // check for customer custom fields which is checked show on pdf
                                $pdf_custom_fields = get_custom_fields('customers',array('show_on_pdf'=>1));
                                foreach($pdf_custom_fields as $field){
                                    $value = get_custom_field_value($quote->clientid,$field['id'],'customers');
                                    if($value == ''){continue;}
                                    echo $field['name'] . ': ' . $value . '<br />';
                                }
                                ?>
                            </address>
                            <?php if($quote->include_shipping == 1 && $quote->show_shipping_on_quote == 1){ ?>
                            <span class="bold"><?php echo _l('ship_to'); ?>:</span>
                            <address>
                                <?php echo $quote->shipping_street; ?><br>
                                <?php echo $quote->shipping_city; ?>, <?php echo $quote->shipping_state; ?><br/>
                                <?php echo get_country_short_name($quote->shipping_country); ?>,<?php echo $quote->shipping_zip; ?>
                            </address>
                            <?php } ?>
                            <p>
                                <span><span class="text-muted"><?php echo _l('quote_data_date'); ?>:</span> <?php echo $quote->date; ?></span>
                                <?php if(!empty($quote->expirydate)){ ?>

                                <br /><span class="mtop20"><span class="text-muted"><?php echo _l('quote_data_expiry_date'); ?>:</span>
                                <?php echo $quote->expirydate; ?></span>
                                <?php } ?>
                                <?php if(!empty($quote->reference_no)){ ?>

                                <br /><span class="mtop20"><span class="text-muted"><?php echo _l('reference_no'); ?>:</span> <?php echo $quote->reference_no; ?></span>
                                <?php } ?>
                                <?php if($quote->sale_agent != 0){
                                    if(get_option('show_sale_agent_on_estimates') == 1){ ?>
                                    <br /><span class="mtop20">
                                    <span class="text-muted"><?php echo _l('sale_agent_string'); ?>:</span>
                                    <?php echo get_staff_full_name($quote->sale_agent); ?>
                                </span>
                                <?php }
                            }
                            ?>
                            <?php
                        // check for quote custom fields which is checked show on pdf
                            $pdf_custom_fields = get_custom_fields('quote',array('show_on_pdf'=>1));
                            foreach($pdf_custom_fields as $field){
                                $value = get_custom_field_value($quote->id,$field['id'],'quote');
                                if($value == ''){continue;} ?>
                                <br /><span class="mtop20">
                                <span class="text-muted"><?php echo $field['name']; ?>: </span>
                                <?php echo $value; ?>
                            </span>
                            <?php
                        }
                        ?>
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table items">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th class="description"><?php echo _l('quote_table_item_heading'); ?></th>
                                    <th><?php echo _l('quote_table_quantity_heading'); ?></th>
                                    <th><?php echo _l('quote_table_rate_heading'); ?></th>
                                    <th><?php echo _l('quote_table_tax_heading'); ?></th>
                                    <th><?php echo _l('quote_table_amount_heading'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($quote)){
                                    $_tax_tr = '';
                                    $taxes = array();
                                    $i = 1;
                                    foreach($quote->items as $item){
                                        $_item = '';
                                        $_item .= '<tr>';
                                        $_item .= '<td>' .$i. '</td>';
                                        $_item .= '<td class="bold description">'.$item['description'].'<br /><span class="text-muted">'.$item['long_description'].'</span></td>';
                                        $_item .= '<td>'.floatVal($item['qty']).'</td>';
                                        $_item .= '<td>'._format_number($item['rate']).'</td>';
                                        $taxrate = ($item['taxrate'] !== null ? $item['taxrate'] : 0);
                                        $_item .= '<td>'.$taxrate.'%</td>';
                                        $_item .= '<td class="amount">'._format_number(($item['qty'] * $item['rate'])).'</td>';
                                        $_item .= '</tr>';
                                        echo $_item;
                                        if($item['taxid']){
                                            if(!array_key_exists($item['taxid'],$taxes)) {
                                                if($item['taxrate'] != null){
                                                    $calculated_tax = (($item['qty'] * $item['rate']) / 100 * $item['taxrate']);
                                                    $taxes[$item['taxid']] = $calculated_tax;
                                                }
                                            } else {
                                                $taxes[$item['taxid']] += $calculated_tax = (($item['qty'] * $item['rate']) / 100 * $item['taxrate']);
                                            }
                                        }
                                        $i++;
                                    }
                                } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-4 col-md-offset-8">
                    <table class="table text-right">
                        <tbody>
                            <tr id="subtotal">
                                <td><span class="bold"><?php echo _l('quote_subtotal'); ?></span>
                                </td>
                                <td class="subtotal">
                                    <?php
                                    if(isset($quote)){
                                        echo _format_number($quote->subtotal,$quote->symbol);
                                        echo form_hidden('subtotal',$quote->subtotal);
                                    }
                                    ?>
                                </td>
                            </tr>
                            <?php if($quote->discount_percent != 0){ ?>
                            <tr>
                                <td>
                                    <span class="bold"><?php echo _l('quote_discount'); ?> (<?php echo $quote->discount_percent; ?>%)</span>
                                </td>
                                <td class="discount">
                                    <?php echo '-' . _format_number($quote->discount_total); ?>
                                </td>
                            </tr>
                            <?php } ?>
                            <?php
                            if(isset($quote)){
                                foreach($taxes as $taxid => $total){
                                    $_tax = get_tax_by_id($taxid);
                                    if($quote->discount_percent != 0 && $quote->discount_type == 'before_tax'){
                                        $total_tax_calculated = ($total * $quote->discount_percent) / 100;
                                        $total = ($total - $total_tax_calculated);
                                    }
                                    echo '<tr class="tax-area"><td>'.$_tax->name.'('.$_tax->taxrate.'%)</td><td>'._format_number($total,$quote->symbol).'</td></tr>';
                                }
                            }
                            ?>
                            <?php if($quote->adjustment != '0.00'){ ?>
                            <tr>
                                <td>
                                    <span class="bold"><?php echo _l('quote_adjustment'); ?></span>
                                </td>
                                <td class="adjustment">
                                    <?php echo _format_number($quote->adjustment); ?>
                                </td>
                            </tr>
                            <?php } ?>
                            <tr>
                                <td><span class="bold"><?php echo _l('quote_total'); ?></span>
                                </td>
                                <td class="total">
                                    <?php
                                    if(isset($quote)){
                                        echo format_money($quote->total,$quote->symbol);
                                        echo form_hidden('subtotal',$quote->total);
                                    }
                                    ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <?php if($quote->clientnote != ''){ ?>
                <div class="col-md-12 mtop15">
                    <p class="bold text-muted"><?php echo _l('quote_note'); ?></p>
                    <p><?php echo $quote->clientnote; ?></p>
                </div>
                <?php } ?>

                <?php if($quote->terms != ''){ ?>
                <div class="col-md-12 mtop15">
                    <p class="bold text-muted"><?php echo _l('terms_and_conditions'); ?></p>
                    <p><?php echo $quote->terms; ?></p>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<div role="tabpanel" class="tab-pane ptop10" id="tab_tasks">
    <?php init_relation_tasks_table(array('data-new-rel-id'=>$quote->id,'data-new-rel-type'=>'quote')); ?>
</div>
<div role="tabpanel" class="tab-pane ptop10" id="tab_activity">
    <div class="row">
        <div class="col-md-12">
            <?php foreach($activity as $activity){ ?>
            <div class="display-block">
                <?php if(is_numeric($activity['staffid'])){ ?>
                <a href="<?php echo admin_url('profile/'.$activity['staffid']); ?>"><?php echo staff_profile_image($activity['staffid'],array('staff-profile-image-small','pull-left mright10')); ?></a>
                <?php } ?>
                <div class="media-body">
                    <div class="display-block">
                        <?php
                            // Version 1.0.5 fix
                        if(is_numeric($activity['staffid'])
                            && strpos($activity['description'],get_staff_full_name($activity['staffid'])) !== false ){
                            echo $activity['description'];
                    } else {
                        if(is_numeric($activity['staffid'])){
                            echo get_staff_full_name($activity['staffid']) . ' ' . $activity['description'];
                        } else {
                            echo $activity['description'];
                        }
                    }
                    ?>
                </div>
                <small class="text-muted"><?php echo _dt($activity['date']); ?></small>
            </div>
            <hr />
        </div>
        <?php } ?>
    </div>
</div>
</div>
</div>

</div>
</div>
</div>
<script>
    initDataTable('.table-rel-tasks', admin_url +'tasks/init_relation_tasks/<?php echo $quote->id; ?>/quote', 'tasks');
</script>
<?php $this->load->view('admin/quotes/quote_send_to_client'); ?>

