<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Subcategories_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }


    public function get($value='')
    {
        $this->db->select('tblsubcategories.*,tblcategories.category_name');
        $this->db->from('tblsubcategories');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblsubcategories.catid');
        return $this->db->get()->result();

    }

    public function count_invoice_subcategory($id)
    {
       
        $this->db->select('*');
        $this->db->from('tblinvoiceitemslist');
        $this->db->where('subcategory',$id);
        $query = $this->db->get();
        return $num = $query->num_rows();
       
    }



    public function change_category_status($id, $status) {
        $this->db->where('subcategory_id', $id);
        $this->db->update('tblsubcategories', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Category Status Changed [CategoryID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }

    public function update($data, $id) {
        $data = $_data['data'];

        $this->db->where('subcategory_id', $id);
        $this->db->update('tblsubcategories', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            do_action('after_category_updated', $id);
            $_update_client_log = $data['firstname'] . ' ' . $data['lastname'];
            $_is_staff = NULL;

            if (is_staff_logged_in()) {
                $_update_client_log .= ' From Staff: ' . get_staff_user_id();
                $_is_staff = get_staff_user_id();
            }

            logActivity('Client Info Updated [' . $_update_client_log . ']', $_is_staff);
            return true;
        }

        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }

    public function delete($id) {
        $affectedRows = 0;
        do_action('before_category_deleted', $id);
       

        $this->db->select('tblsubcategories.*');
        $this->db->from('tblsubcategories');
        $this->db->where('subcategory_id', $id);
        $subcategories = $this->db->get()->row();

        if($subcategories->show_in_cart == 1)
        {

            $CI = &get_instance();
                        
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            // $db2->where('solomon_cat_id', $id);
            $db2->where('name', $subcategories->subcategory_name);
            $cart_categorytransaltion = $db2->get()->row();
            // print_r($cart_categorytransaltion);
            // die;

            $db2->select('cart_categories.*');
            $db2->from('cart_categories');
            $db2->where('cart_categories.id', $cart_categorytransaltion->category_id);
            $cart_category = $db2->get()->row();

            $db2->where('cart_categories.id', $cart_category->id);
            $db2->delete('cart_categories');


            // $db2->where('parent_id', $cart_category->id);
            // $db2->delete('cart_categories');

            $db2->where('id', $cart_categorytransaltion->id);
            $db2->delete('cart_category_translations');
        }

        $this->db->where('subcategory_id', $id);
        $affectedRows =$this->db->delete('tblsubcategories');

        if ($affectedRows > 0) {
            do_action('after_category_deleted');
            logActivity('Category Deleted [' . $id . ']');
            return true;
        }
       
    }

    public function get_category_details($id) {
        return $this->db->where('subcategory_id', $id)->get('tblsubcategories')->first_row();
    }

    public function update_category_details() {
        $id   = $this->input->post('cat_id');
    
        $active = $this->input->post('cat_is_active')?$this->input->post('cat_is_active'):0;
        $show_in_cart = $this->input->post('show_in_cart')?$this->input->post('show_in_cart'):0;
        $data = array(
            'catid' => $this->input->post('category'),
            'subcategory_name' => $this->input->post('categoryname'),
            'description'   => $this->input->post('description'),
            // 'sales'   => $this->input->post('sales'),
            // 'inventory'   => $this->input->post('inventory'),
            // 'cogs'   => $this->input->post('cogs'),
            'active'        => $active,
            'show_in_cart'        => $show_in_cart,
        );
   
        $this->db->where('subcategory_id', $id)->update('tblsubcategories',$data);

        $this->db->select('tblcategories.*');
        $this->db->from('tblcategories');
        $this->db->where('tblcategories.category_id',$this->input->post('category'));
        $category_details = $this->db->get()->row();

        if($category_details->show_in_cart == 1)
        {
            if($show_in_cart == 1)
            {
                $CI = &get_instance();
                    
                $db2 = $CI->load->database('proverbs_solomon', TRUE);

                $db2->select('cart_category_translations.*');
                $db2->from('cart_category_translations');
                $cart_category_translations = $db2->get()->result();

                // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

                $cart_category_id = "";
                $cart_subcategory_id = "";
                // $cart_subcategory_id = array();
                
                foreach ($cart_category_translations as $key => $cate_name) {
                    if($cate_name->name == $category_details->category_name)
                    {
                        // echo "sad";
                        $cart_category_id = $cate_name->category_id;
                    }
                    
                }

                foreach ($cart_category_translations as $key => $cate_name) {
                    // if($cate_name->solomon_cat_id == $id)
                    if($cate_name->name == $this->input->post('categoryname'))
                    {
                        // echo "sad";
                        $cart_subcategory_id = $cate_name->category_id;
                    }
                    
                }

                // echo $cart_subcategory_id;
                // die;
                $insert_cart_subcategory_id = "";
                $insert_cart_subcategory_translations_id = "";


                if($cart_subcategory_id == "")
                {
                    $db2->select_max('sort_order');
                    $cart_categories = $db2->get('cart_categories')->row();  
                    $sort_order = $cart_categories->sort_order + 1;

                    $insert_cart_subcategory = array(
                                    'parent_id' => $cart_category_id,
                                    'icon' => 'default.png',
                                    'icon_thumb' => 'default_thumb.png',
                                    'products_count_total' => 0,
                                    'products_count_active' => 0,
                                    'sort_order' => $sort_order,
                                );
                    $db2->insert('cart_categories', $insert_cart_subcategory);
                    $insert_cart_subcategory_id = $db2->insert_id();

                    $insert_cart_subcategory_translations = array(
                                    'category_id' => $insert_cart_subcategory_id,
                                    'language_code' => 'en',
                                    'name' => $this->input->post('categoryname'),
                                    'description' => $this->input->post('description'),
                                );

                    $db2->insert('cart_category_translations', $insert_cart_subcategory_translations);
                    $insert_cart_subcategory_translations_id = $db2->insert_id();
                }

                if(!empty($cart_subcategory_id))
                {

                    $update_cart_category_translations = array(
                                    'category_id' => $cart_subcategory_id,
                                    'language_code' => 'en',
                                    'name' => $this->input->post('categoryname'),
                                    'description' => $this->input->post('description'),
                                );
                    $db2->where('category_id', $cart_subcategory_id);
                    $db2->update('cart_category_translations',$update_cart_category_translations);

                }
                // if($cart_category_id != "")
                // {
                //     $update_cart_category_id = $cart_category_id;
                // }
            }

            if($show_in_cart != 1)
            {
                $CI = &get_instance();
                    
                $db2 = $CI->load->database('proverbs_solomon', TRUE);

                $db2->select('cart_category_translations.*');
                $db2->from('cart_category_translations');
                // $db2->where('solomon_cat_id', $id);
                $db2->where('name', $this->input->post('categoryname'));
                $cart_categorytransaltion = $db2->get()->row();
                // print_r($cart_categorytransaltion);
                // die;

                $db2->select('cart_categories.*');
                $db2->from('cart_categories');
                $db2->where('cart_categories.id', $cart_categorytransaltion->category_id);
                $cart_category = $db2->get()->row();

                $db2->where('cart_categories.id', $cart_category->id);
                $db2->delete('cart_categories');


                // $db2->where('parent_id', $cart_category->id);
                // $db2->delete('cart_categories');

                $db2->where('id', $cart_categorytransaltion->id);
                $db2->delete('cart_category_translations');
            }
        }

        return $id;
 
    }
    
    public function add_category_details(){
        $active = $this->input->post('cat_is_active')?$this->input->post('cat_is_active'):0;
        $show_in_cart = $this->input->post('show_in_cart')?$this->input->post('show_in_cart'):0;
        $data = array(
            'catid' => $this->input->post('category'),
            'subcategory_name' => $this->input->post('categoryname'),
            'description'   => $this->input->post('description'),
            // 'sales'   => $this->input->post('sales'),
            // 'inventory'   => $this->input->post('inventory'),
            // 'cogs'   => $this->input->post('cogs'),
            'active'        => $active,
            'show_in_cart'        => $show_in_cart,
        );

      
        $this->db->insert('tblsubcategories',$data);
        $solomon_cat_id = $this->db->insert_id();

        $this->db->select('tblcategories.*');
        $this->db->from('tblcategories');
        $this->db->where('tblcategories.category_id',$this->input->post('category'));
        $category_details = $this->db->get()->row();

        if($category_details->show_in_cart == 1)
        {
            if($show_in_cart == 1)
            {
                $CI = &get_instance();
                    
                $db2 = $CI->load->database('proverbs_solomon', TRUE);

                $db2->select('cart_category_translations.*');
                $db2->from('cart_category_translations');
                $cart_category_translations = $db2->get()->result();

                // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

                $cart_category_id = "";
                $cart_subcategory_id = "";
                // $cart_subcategory_id = array();
                
                foreach ($cart_category_translations as $key => $cate_name) {
                    if($cate_name->name == $category_details->category_name)
                    {
                        // echo "sad";
                        $cart_category_id = $cate_name->category_id;
                    }
                    
                }

                foreach ($cart_category_translations as $key => $cate_name) {
                    if($cate_name->name == $this->input->post('categoryname'))
                    {
                        // echo "sad";
                        $cart_subcategory_id = $cate_name->category_id;
                    }
                    
                }


                $insert_cart_subcategory_id = "";
                $insert_cart_subcategory_translations_id = "";


                if($cart_subcategory_id == "")
                {
                    $db2->select_max('sort_order');
                    $cart_categories = $db2->get('cart_categories')->row();  
                    $sort_order = $cart_categories->sort_order + 1;

                    $insert_cart_subcategory = array(
                                    'parent_id' => $cart_category_id,
                                    'icon' => 'default.png',
                                    'icon_thumb' => 'default_thumb.png',
                                    'products_count_total' => 0,
                                    'products_count_active' => 0,
                                    'sort_order' => $sort_order,
                                );
                    $db2->insert('cart_categories', $insert_cart_subcategory);
                    $insert_cart_subcategory_id = $db2->insert_id();

                    $insert_cart_subcategory_translations = array(
                                    'category_id' => $insert_cart_subcategory_id,
                                    'solomon_cat_id' => $solomon_cat_id,
                                    'language_code' => 'en',
                                    'name' => $this->input->post('categoryname'),
                                    'description' => $this->input->post('description'),
                                );

                    $db2->insert('cart_category_translations', $insert_cart_subcategory_translations);
                    $insert_cart_subcategory_translations_id = $db2->insert_id();
                }
                else
                {
                    $update_cart_category_translations = array(
                                // 'category_id' => $value->id,
                                // 'language_code' => 'en',
                                'name' => $this->input->post('categoryname'),
                                'description' => $this->input->post('description'),
                            );
                    $db2->where('name', $this->input->post('categoryname'));
                    $db2->update('cart_category_translations',$update_cart_category_translations);
                }

                // if($cart_category_id != "")
                // {
                //     $update_cart_category_id = $cart_category_id;
                // }
            }
        }

        return $solomon_cat_id;
    }
    public function get_cat_name($catid){
        $res = $this->db->where('category_id',$catid)->get('tblcategories')->row();
        if($res){
           return $res->category_name;
        }else{
            return '';
        }
    }
    public function changestatus(){
       
        $row = $this->db->where('subcategory_id',$this->input->post('id'))->get('tblsubcategories')->row();
        if($row->active == '0'){
            $data =array('active'=>1);
            $this->db->where('subcategory_id', $this->input->post('id'));
            $this->db->update('tblsubcategories', $data);
        }
        if($row->active == '1'){
            $data =array('active'=>0);
            $this->db->where('subcategory_id', $this->input->post('id'));
            $this->db->update('tblsubcategories', $data);
        }

    }

    public function changeeview(){
       
        $row = $this->db->where('subcategory_id',$this->input->post('id'))->get('tblsubcategories')->row();
        if($row->show_in_cart == '0'){

            $this->db->select('tblcategories.*');
            $this->db->from('tblcategories');
            $this->db->where('tblcategories.category_id',$row->catid);
            $category_details = $this->db->get()->row();

            if($category_details->show_in_cart == 1)
            {
                $CI = &get_instance();
                    
                $db2 = $CI->load->database('proverbs_solomon', TRUE);

                $db2->select('cart_category_translations.*');
                $db2->from('cart_category_translations');
                $cart_category_translations = $db2->get()->result();

                // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

                $cart_category_id = "";
                $cart_subcategory_id = "";
                // $cart_subcategory_id = array();
                
                foreach ($cart_category_translations as $key => $cate_name) {
                    if($cate_name->name == $category_details->category_name)
                    {
                        // echo "sad";
                        $cart_category_id = $cate_name->category_id;
                    }
                    
                }

                foreach ($cart_category_translations as $key => $cate_name) {
                    // if($cate_name->solomon_cat_id == $id)
                    if($cate_name->name == $row->subcategory_name)
                    {
                        // echo "sad";
                        $cart_subcategory_id = $cate_name->category_id;
                    }
                    
                }

                
                $insert_cart_subcategory_id = "";
                $insert_cart_subcategory_translations_id = "";


                if($cart_subcategory_id == "")
                {
                    $db2->select_max('sort_order');
                    $cart_categories = $db2->get('cart_categories')->row();  
                    $sort_order = $cart_categories->sort_order + 1;

                    $insert_cart_subcategory = array(
                                    'parent_id' => $cart_category_id,
                                    'icon' => 'default.png',
                                    'icon_thumb' => 'default_thumb.png',
                                    'products_count_total' => 0,
                                    'products_count_active' => 0,
                                    'sort_order' => $sort_order,
                                );
                    $db2->insert('cart_categories', $insert_cart_subcategory);
                    $insert_cart_subcategory_id = $db2->insert_id();

                    $insert_cart_subcategory_translations = array(
                                    'category_id' => $insert_cart_subcategory_id,
                                    'language_code' => 'en',
                                    'name' => $row->subcategory_name,
                                    'description' => $row->description,
                                );

                    $db2->insert('cart_category_translations', $insert_cart_subcategory_translations);
                    $insert_cart_subcategory_translations_id = $db2->insert_id();
                }
                    
                
            }


            $data =array('show_in_cart'=>1);
            $this->db->where('subcategory_id', $this->input->post('id'));
            $this->db->update('tblsubcategories', $data);
        }
        if($row->show_in_cart == '1'){

            $CI = &get_instance();
                        
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            // $db2->where('solomon_cat_id', $id);
            $db2->where('name', $row->subcategory_name);
            $cart_categorytransaltion = $db2->get()->row();
            // print_r($cart_categorytransaltion);
            // die;

            $db2->select('cart_categories.*');
            $db2->from('cart_categories');
            $db2->where('cart_categories.id', $cart_categorytransaltion->category_id);
            $cart_category = $db2->get()->row();

            $db2->where('cart_categories.id', $cart_category->id);
            $db2->delete('cart_categories');


            // $db2->where('parent_id', $cart_category->id);
            // $db2->delete('cart_categories');

            $db2->where('id', $cart_categorytransaltion->id);
            $db2->delete('cart_category_translations');
       

            $data =array('show_in_cart'=>0);
            $this->db->where('subcategory_id', $this->input->post('id'));
            $this->db->update('tblsubcategories', $data);
        }

    }

    public function get_ledgers(){
        return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }
}
