<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Rfqs_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * Get estimate by id
     * @param  mixed $id
     * @return array
     */

    public function get_poid($id)
    {
        $this->db->select('tblpurchaseorders.id, tblpurchaseorders.number');
        $this->db->from('tblrfqsqoutes');
        $this->db->join('tblpurchaseorders', "tblpurchaseorders.rfq_id = tblrfqsqoutes.id");
        $this->db->where('tblrfqsqoutes.id', $id);
        return $this->db->get()->row();
    }

    public function get_grn($id)
    {
        $this->db->select('tblgrns.number,tblgrns.grnid');
        $this->db->from('tblgrns');
        $this->db->join('tblpurchaseorders', 'tblpurchaseorders.id = tblgrns.po_id', 'left');
        $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id', 'left');
        $this->db->where('tblrfqsqoutes.id', $id);
        return $item = $this->db->get()->row();
    }

    public function get($id = '')
    {
        $this->db->select('*, tblrfqsqoutes.id as id');
        $this->db->from('tblrfqsqoutes');
        

        if (is_numeric($id)) {
            $this->db->where('tblrfqsqoutes.id', $id);
            $rfq = $this->db->get()->row();

            return $rfq;
        }

        return $this->db->get()->result_array();
    }
	public function change_rfq_status($status,$id)
	{
		$this->db->where('id', $id);
        return $this->db->update('tblrfqsqoutes', array('status' => $status));
	}
    public function get_items($id){
       return  $this->get_rfqs_items($id);
    }
    
    public function get_last_rfqno(){
        $this->db->order_by('id', 'DESC');      
        $this->db->limit(1);
        return $this->db->get('tblrfqsqoutes')->row()->rfqnumber;
    }
    
    public function get_supplier(){
        $this->db->order_by('supplier', 'ASC');      
        return $this->db->get('tblsuppliers')->result();
    }

    


    /**
     * Get all estimate items
     * @param  mixed $id estimateid
     * @return array
     */

    public function get_rfqs_items($id)
    {
        $this->db->select('*');
        $this->db->from('tblrfqsqouteitems');
       
        $this->db->where('tblrfqsqouteitems.orderid', $id);
        $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }
	 public function get_rfqs_items_unit($id)
    {
        $this->db->select('tblrfqsqouteitems.id as id,qty,suppliersku,tblrfqsqouteitems.description as description,oursku,tblunitsofmeasure.name as unit,manufacture,orderid,item_order');
        $this->db->from('tblrfqsqouteitems');
       $this->db->join('tblunitsofmeasure', 'tblunitsofmeasure.id = tblrfqsqouteitems.manufacture', 'left');
        $this->db->where('tblrfqsqouteitems.orderid', $id);
        $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }
	
	
	 public function get_all_items_ajax() {
		 //original	{"itemid":"1","descp":"Blue Gold Star Widget","catname":"4","taxname":"SDE678GD72","label":"C28836A5TY"}
		// new "itemid":"1","descp":"Blue Gold Star Widget","catname":"4","taxname":"SDE678GD72","label":"C28836A5TY"
        $this->db->select('id as itemid,description as descp,manufacture as catname, oursku as taxname,id as taxid,suppliersku as label');
        $this->db->from('tblrfqsqouteitems');
       
        return $this->db->get()->result_array();
    }
	public function get_all_our_items_ajax() {
		//[{"itemid":"1","descp":"Blue Gold Star Widget","catname":"4","taxname":"C28836A5TY","label":"SDE678GD72"

        $this->db->select('id as itemid,description as descp,manufacture as catname, suppliersku as taxname, oursku as label');
        $this->db->from('tblrfqsqouteitems');
       
        return $this->db->get()->result_array();
    }
    /**
     * Insert new estimate to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, estimate ID if succes
     */
    public function add($data)
    {
	
      unset($data['action']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);

        // $data['number'] = $data['_number'];
        $data['number'] = get_option('next_rfqsqoute_number');

        $unsetters = array(
            '_number',
            'currency_symbol',
            'price',
            'taxname',
            'sku',
            'description',
//            'long_description',
            'taxid',
            'rate',
			'discount_type',
            'quantity',
			 'createdby',
			 'createdby2',
			 'itemrecorid',
			 'suppliersku',
			 'oursku',
			 'itemorder_id',
			 'manufacture',
			 'items'
        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }

        
		
        $data['requisitiondate'] = to_sql_date($data['requisitiondate']);
       $data['requiredby'] = to_sql_date($data['requiredby']);

        $data['terms']       = nl2br($data['terms']);
        $data['datecreated'] = date('Y-m-d H:i:s');
//        $data['year']        = get_option('estimate_year');
        $data['addedfrom']   = get_staff_user_id();


        $items = array();
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }

        $_data = do_action('before_rfq_added', array(
            'data' => $data,
            'items' => $items
        ));

        $data  = $_data['data'];
        $items = $_data['items'];
        
        
             $data['hash'] = md5(rand() . microtime());
        // Check if the key exists
        $this->db->where('hash', $data['hash']);
        $exists = $this->db->get('tblrfqsqoutes')->row();

        if ($exists) {
            $data['hash'] = md5(rand() . microtime());
        }
        

        $this->db->insert('tblrfqsqoutes', $data);
        $insert_id = $this->db->insert_id();
 
        if ($insert_id) {

               if (isset($custom_fields)) {
                 handle_custom_fields_post($insert_id, $custom_fields);
             }

            // Update next estimate number in settings
            $this->db->where('name', 'next_rfqsqoute_number');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
            if (count($items) > 0) {
            foreach ($items as $key => $item) {
				//print_r($item);
                    $this->db->insert('tblrfqsqouteitems',array(                        					
						'orderid'=>$insert_id,
						'suppliersku'=>$item['sku'],
						'oursku'=>$item['oursku'],
                        'description'=>$item['description'],    
						'manufacture'=>$item['manufacture'],  
                        'qty'=>$item['qty'],  
                        'item_order'=>$item['order'],
                        ));
                }
            }

            $this->log_estimate_activity($insert_id, 'created the PR');
            do_action('after_rfq_added', $insert_id);
            return $insert_id;
        }

        return false;
    }

     public function get_estimate_item($id)
    {
		 $this->db->select('*');
        
		
        $this->db->where('id', $id);
        return $this->db->get('tblestimateitems')->row();
    }

    public function get_term($id){
       $this->db->select('payment_term');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row(); 
    }
    /**
     * Update estimate data
     * @param  array $data estimate data
     * @param  mixed $id   estimateid
     * @return boolean
     */
	 
	 
    public function update($data, $id)
    {
         unset($data['action']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);

       

        $unsetters = array(
            '_number',
            'currency_symbol',
            'price',
            'taxname',
            'sku',
            'description',
//            'long_description',
            'taxid',
            'rate',
			'discount_type',
            'quantity',
			 'createdby',
			 'createdby2',
			 'itemrecorid',
			 'suppliersku',
			 'oursku',
			 'isedit',
			 'itemorder_id',
			 'manufacture'
        );

      foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }
		
        $affectedRows = 0;
        $prefix       = "PR-";

        $data['number'] = substr($data['number'], strlen($prefix));
        $data['number']    = trim($data['number']);
		$data['requisitiondate'] = to_sql_date($data['requisitiondate']);
       $data['requiredby'] = to_sql_date($data['requiredby']);
        if(get_option('estimate_number_format') == 2){
             $_temp_number = explode('/',$data['number']);
             $data['number'] = $_temp_number[1];
        }

        $original_estimate = $this->get($id);
        $original_status   = $original_estimate->status;
        $original_number   = $original_estimate->number;

        


        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }

        $data['terms']      = nl2br($data['terms']);
        
        




        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );

        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data                 = do_action('before_estimate_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems              = $_data['newitems'];
        $items                 = $_data['items'];
        $data                  = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                	
                    $original_item = $this->get_estimate_item($remove_item_id);
                    $this->db->where('orderid', $id);
                    $this->db->where('id', $remove_item_id);
                    $this->db->delete('tblrfqsqouteitems');
                    if ($this->db->affected_rows() > 0) {
                        $this->log_estimate_activity($id,'removed item <b>' . $original_item->description . '</b>');
                        $affectedRows++;
                    }
               
            }
            
        }
		unset($data['removed_items']);
        $this->db->where('id', $id);
        $this->db->update('tblrfqsqoutes', $data);

        if ($this->db->affected_rows() > 0) {
            // Check for status change
            if ($original_status != $data['status']) {
                $this->log_estimate_activity($original_estimate->id, 'PR Status Updated: From: ' . format_rfq_status($original_status) . ' To: ' . format_rfq_status($data['status']));
            }

            if($original_number != $data['number']){
                  $this->log_estimate_activity($original_estimate->id, 'PR Number Changed: From: ' . format_rfqsquote_number($original_number) . ' To: ' . format_rfqsquote_number($data['number']));
            }

            $affectedRows++;

        }
        $this->load->model('taxes_model');
        if (count($items) > 0) {

            foreach ($items as $key => $item) {
				
                $estimate_item_id = $item['itemid'];

                $original_item = $this->get_estimate_item($estimate_item_id);

                $this->db->where('id',$estimate_item_id);
                $this->db->update('tblrfqsqouteitems', array(
                      'item_order'=>$item['order'],
                ));

                if ($this->db->affected_rows() > 0) {
                     $affectedRows++;
                }
                // Check for invoice item short description change
                $this->db->where('id', $estimate_item_id);
                $this->db->update('tblrfqsqouteitems', array(
                    'description'=>$item['description'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated item description from ' . $original_item->description . ' to ' . $item['description']);
                    $affectedRows++;
                }

                // Check for item long description change
                $this->db->where('id', $estimate_item_id);
                $this->db->update('tblrfqsqouteitems', array(
                    'suppliersku'=>nl2br($item['sku']),
                ));
//                $this->db->where('id', $estimate_item_id);
//                $this->db->update('tblestimateitems', array(
//                    'long_description'=>nl2br($item['long_description']),
//                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated item sku on item <b>' . $item['description'] . '</b> from  ' . $original_item->suppliersku . ' to ' . $item['sku']);
                    $affectedRows++;
                }
				$this->db->where('id', $estimate_item_id);
                $this->db->update('tblrfqsqouteitems', array(
                    'oursku'=>nl2br($item['oursku']),
                ));               
                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated item oursku on item <b>' . $item['description'] . '</b> from  ' . $original_item->oursku . ' to ' . $item['oursku']);
                    $affectedRows++;
                }
               
                
              

                
                // CHeck for invoice quantity change
                $this->db->where('id', $estimate_item_id);
                $this->db->update('tblrfqsqouteitems', array(
                    'qty' => $item['qty']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated quantity on item <b>' . $item['description'] . '</b> from ' . $original_item->qty . ' to ' . $item['qty']);
                    $affectedRows++;
                }
				
				 $this->db->where('id', $estimate_item_id);
                $this->db->update('tblrfqsqouteitems', array(
                    'manufacture' => $item['manufacture']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_estimate_activity($id,'updated manufacture on item <b>' . $item['description'] . '</b> from ' . $original_item->manufacture . ' to ' . $item['manufacture']);
                    $affectedRows++;
                }
            }
        }

        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                
                if($item['itemorder_id'] != $id)
                {
                    $this->db->insert('tblrfqsqouteitems',array(
                    'orderid'=>$id,
                    'suppliersku'=>$item['sku'],
                    'oursku'=>$item['oursku'],
                    'description'=>$item['description'],    
                    'manufacture'=>$item['manufacture'],  
                    'qty'=>$item['qty'],  
                    'item_order'=>$item['order'],                                      
                    
                    ));

                    $new_item_added = $this->db->insert_id();
                    if ($new_item_added) {
                        $this->log_estimate_activity($id,'added new item <b>' . $item['description'] . '</b>');
                        $affectedRows++;
                    }
                }
                else
                {
                    $this->db->where('id', $item['itemid']);
                    $this->db->update('tblrfqsqouteitems', array(
                    'orderid'=>$id,
                    'suppliersku'=>$item['sku'],
                    'oursku'=>$item['oursku'],
                    'description'=>$item['description'],    
                    'manufacture'=>$item['manufacture'],  
                    'qty'=>$item['qty'],  
                    'item_order'=>$item['order'],           
                    ));
                }

                
            }
        }

        if ($affectedRows > 0) {
            $this->log_estimate_activity($id,' updated');
            return true;
        }

        return false;
    }

    public function client_estimate_action($action, $id)
    {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {
            $this->load->model('staff_model');
            $staff    = $this->staff_model->get('', 1);
            $estimate = $this->get($id);
            $invoiceid = false;
            $invoiced = false;
            if ($action == 4) {
                if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                    $invoiceid = $this->convert_to_invoice($id, true);
                    $this->load->model('invoices_model');
                    if ($invoiceid) {
                        $invoiced = true;
                        $invoice = $this->invoices_model->get($invoiceid);
                        $this->log_estimate_activity($id, 'Client accepted this estimate. Estimate is converted to invoice with number <a href="' . admin_url('invoices/list_invoices/' . $invoiceid) . '">' . format_invoice_number($invoice->number) . '</a>', false, true);
                    }

                } else {
                    $this->log_estimate_activity($id, 'Client accepted this estimate.', false, true);
                }

                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffid'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Congratiolations! Client accepted estimate with number ' . format_estimate_number($estimate->number),
                            'link'=>'estimates/list_estimates/'.$id
                        ));
                    }
                }

                 return array(
                            'invoiced' => $invoiced,
                            'invoiceid' => $invoiceid
                        );

            } else if ($action == 3) {
                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffod'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Client declined estimate with number ' . format_estimate_number($estimate->number),
                            'link'=>'estimates/list_estimates/'.$id
                        ));
                    }
                }
                $this->log_estimate_activity($id, 'Client declined this estimate.', false, true);
                return true;
            }

        }

        return false;
    }
	
	 public function get_rfq_activity($id)
    {
        $this->db->where('orderid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblrfqsqouteactivity')->result_array();
    }
    /**
     * Log estimate activity to database
     * @param  mixed $id   estimateid
     * @param  string $description activity description
     */
    public function log_estimate_activity($id, $description = '', $cron = false, $client = false)
    {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblrfqsqouteactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'orderid' => $id,
            'staffid' => $staffid
        ));
    }
	function get_rfqs_by_status($status=3)
	{
		$this->db->where('status', $status);
        $this->db->order_by('requiredby', 'desc');
        return $this->db->get('tblrfqsqoutes')->result_array();
	}
    /**
     * Delete estimate items and all connections
     * @param  mixed $id estimateid
     * @return boolean
     */
    public function delete($id)
    {

        if (get_option('delete_only_on_last_estimate') == 1) {
            if (!is_last_estimate($id)) {
                return false;
            }
        }

         $this->db->where('orderid', $id);
         $this->db->delete('tblrfqsqouteactivity');
		 $this->db->where('orderid', $id);
         $this->db->delete('tblrfqsqouteitems');
		 $this->db->where('id', $id);
         $this->db->delete('tblrfqsqoutes');
		return true;
    }
    /**
     * Set estimate to sent when email is successfuly sended to client
     * @param mixed $id estimateid
     */
    public function set_estimate_sent($id)
    {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $description = 'sent estimate to client';
        $this->log_estimate_activity($id, $description);

        // Update estimate status to sent
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => 2
        ));
    }

    /**
     * Sent estimate to client
     * @param  mixed  $id        estimateid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach estimate pdf or not
     * @return boolean
     */
    public function sent_estimate_to_client($id, $template = '', $attachpdf = true)
    {

        $this->load->model('emails_model');
        $estimate = $this->get($id);
        if ($template == '') {
            if ($estimate->sent == 0) {
                $template = 'estimate-send-to-client';
            } else {
                $template = 'estimate-already-send';
            }
        }

        $estimate_number = format_estimate_number($estimate->number);
        $pdf             = estimate_pdf($estimate);

        if ($attachpdf) {
            $attach = $pdf->Output($estimate_number . '.pdf', 'S');
            $this->emails_model->add_attachment($attach, $estimate_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $estimate->client->email, $estimate->clientid, false,false,false,$id);
        if ($send) {
            $this->set_estimate_sent($id);
            return true;
        }

        return false;
    }
    /**
     * All estimate activity
     * @param  mixed $id estimateid
     * @return array
     */
   
 function get_prev($id){
   return $this->db->query("select id,clientid from tblestimates where id = (select max(id) from tblestimates where id < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select id,clientid from tblestimates where id = (select min(id) from tblestimates where id > $id)")->row();
}
    public function mark_action_status($action, $id, $client = false)
    {
        $this->db->where('id', $id);
        $this->db->update('tblquotes', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {

            $quote  = $this->get($id);

            if($client == true){
                $this->db->where('staffid',$quote->addedfrom);
                $this->db->or_where('staffid',$quote->sale_agent);
                $staff_quote = $this->db->get('tblstaff')->result_array();

               
                $orderid = false;
                $orderd  = false;
                if ($action == 4) {
                    if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                        $orderid = $this->convert_to_order($id, true);
                        $this->load->model('orders_model');
                        if ($orderid) {
                            $orderd = true;
                            $invoice  = $this->orders_model->get($orderid);
                            $this->log_estimate_activity($id, 'Client accepted this quote. Quote is converted to order with number <a href="' . admin_url('orders/list_orders/' . $orderid) . '">' . format_order_number($orderid->id) . '</a>', false, true);
                        }
                    } else {
                        $this->log_estimate_activity($id, 'Client accepted this quote.', false, true);
                    }

                    // Send thank you email
                    $this->emails_model->send_email_template('quote-thank-you-to-customer', $quote->client->email, $quote->clientid, false, false, false, $id);

                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {
                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Congratiolations! Client accepted quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));
                          // Send staff email notification that customer accepted quote
                          $this->emails_model->send_email_template('quote-accepted-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }

                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );

                } else if ($action == 3) {
                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {

                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Client declined quote with number ' . format_quote_number($quote->id),
                                'link' => 'quotes/list_quotes/' . $id
                            ));

                            // Send staff email notification that customer declined quote
                            $this->emails_model->send_email_template('quote-declined-to-staff', $member['email'], $quote->clientid, false, false, false, $id);

                        }
                    }
                    $this->log_estimate_activity($id, 'Client declined this quote.', false, true);
                    return array(
                        'invoiced' => $invoiced,
                        'invoiceid' => $invoiceid
                    );
                }
            } else {
                // Admin marked quote
                $this->log_estimate_activity($id,'marked quote as '.format_quote_status($status,'',false));
                return true;
            }
        }
        return false;
    }
        public function mark_action_status_order($action, $id, $client = false)
    {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {

            $quote  = $this->get($id);

            if($client == true){
                $this->db->where('staffid',$quote->addedfrom);
                $this->db->or_where('staffid',$quote->sale_agent);
                $staff_quote = $this->db->get('tblstaff')->result_array();

                $orderid = false;
                $orderd  = false;
                if ($action == 4) {
                    if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                        $orderid = $this->convert_to_order($id, true);
                        $this->load->model('orders_model');
                        if ($orderid) {
                            $orderd = true;
                            $invoice  = $this->orders_model->get($orderid);
                            $this->log_estimate_activity($id, 'Client accepted this quote. Quote is converted to order with number <a href="' . admin_url('orders/list_orders/' . $orderid) . '">' . format_order_number($orderid->id) . '</a>', false, true);
                        }
                    } else {
                        $this->log_estimate_activity($id, 'Client accepted this quote.', false, true);
                    }

                    // Send thank you email
                    $this->emails_model->send_email_template('quote-thank-you-to-customer', $quote->client->email, $quote->clientid, false, false, false, $id);

                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {
                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Congratiolations! Client accepted quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));
                          // Send staff email notification that customer accepted quote
                          $this->emails_model->send_email_template('quote-accepted-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }

                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );

                } else if ($action == 3) {
                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {

                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Client declined quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));

                            // Send staff email notification that customer declined quote
                            $this->emails_model->send_email_template('quote-declined-to-staff', $member['email'], $quote->clientid, false, false, false, $id);

                        }
                    }
                    $this->log_estimate_activity($id, 'Client declined this quote.', false, true);
                     return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );
                }
            } else {
                // Admin marked quote
                $this->log_estimate_activity($id,'marked quote as '.format_quote_status($status,'',false));
                return true;
            }
        }
        return false;
    }
}

