<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Periods_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  mixed $id client id (optional)
     * @param  integer $active (optional) get all active or inactive
     * @return mixed
     * Get client object based on passed clientid if not passed clientid return array of all clients
     */
    public function get($id = false, $active = '')
    {
        if (is_int($active)) {
            $this->db->where('status', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $period = $this->db->get('tblperiod')->row();
             if ($period) {
                $period->items  = $this->get_modules($id);
                
            }
            return $period;
        }


        return $this->db->get('tblperiod')->result_array();
    }


    public function get_period($status)
    {
        $this->db->select('*');
        $this->db->from('tblperiod');
        $this->db->where('status',$status);
        return $this->db->get()->row();
    }

    
   public function get_modules($id)
    {
        $this->db->select('*');
        $this->db->from('tblperiodmodules');
        $this->db->where('tblperiodmodules.periodid', $id);
        $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }

    function get_all_groups() {
        $this->db->where('parent', '0');
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblaccountgroups')->result();
    }
    function get_subgroups($id) {
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblaccountgroups')->result();
    }
    function get_prev_ledgers(){
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblledgergroups')->result();   
    }
    function get_parent($id){
        $this->db->where('id', $id);
        return $this->db->get('tblledgergroups')->row()->name;
    }
    function getSingleRecord($table, $where) {
        return $this->db->get_where($table, $where)->row();
    }
      
    
    function get_last_accountno() {
        $this->db->where('type', 'Ledger');
        $this->db->order_by('id', 'DESC');      
        $this->db->limit(1);
        return $this->db->get('tblledgergroups')->row();
    }
    
    
 function getDataByOrder($table, $where ) {
        $this->db->order_by('sort_order', 'asc');
        return $this->db->get_where($table, $where)->result_array();
 }


public function getRecords($tbl)
{
  return $this->db->get($tbl)->result_array();  
}
public function get_where_record($tbl,$id)
{
    
  return $this->db->where('id', $id)->get($tbl)->row();  
}



    /**
     * @param array $_POST data
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['snew']);
        unset($data['sexit']);
        
       $data['fromdate'] = to_sql_date($data['fromdate']);
       $data['todate'] = to_sql_date($data['todate']);
        $data = do_action('before_period_added', $data);
        $this->db->insert('tblperiod', $data);
        $periodid= $this->db->insert_id();
        return $periodid;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
      public function update($data, $id)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
      
        $affectedRows = 0;


        unset($data['module']);
        unset($data['access']);
        unset($data['note']);
        unset($data['isedit']);
 
      

        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }

        if ($data['adjustment'] == 'NaN') {
            $data['adjustment'] = 0;
        }

        $data['fromdate']       = to_sql_date($data['fromdate']);
        $data['todate'] = to_sql_date($data['todate']);


     


        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );

        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data                 = do_action('before_period_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems              = $_data['newitems'];
        $items                 = $_data['items'];
        $data                  = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                foreach ($data['removed_items'] as $remove_item_id) {
                    $original_item = $this->get_period_item($remove_item_id);
                    $this->db->where('periodid', $id);
                    $this->db->where('id', $remove_item_id);
                    $this->db->delete('tblperiodmodules');
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
                }
            }
            unset($data['removed_items']);
        }

        $this->db->where('id', $id);
        $this->db->update('tblperiod', $data);

     
        $this->load->model('taxes_model');
        if (count($items) > 0) {

            foreach ($items as $key => $item) {
                $period_item_id = $item['itemid'];

                $original_item = $this->get_period_item($period_item_id);

                $this->db->where('id',$period_item_id);
                $this->db->update('tblperiodmodules', array(
                      'module'=>$item['module'],
                      'access'=>$item['access'],
                      'note'=>$item['note'],
                      'item_order'=>$item['order'],
                ));

               
            }
        }

        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblperiodmodules',array(
                      'periodid'=>$id,
                      'module'=>$item['module'],
                      'access'=>$item['access'],
                      'note'=>$item['note'],
                      'item_order'=>$item['order'],
                    ));

                $new_item_added = $this->db->insert_id();
            
            }
        }

        if ($affectedRows > 0) {
            do_action('after_period_updated', $id);
            return true;
        }

        return false;
    }
     public function get_period_item($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('tblperiodmodules')->row();
    }

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function delete($id)
    {

        do_action('before_periods_deleted', $id);

        $this->db->where('id', $id);
        $this->db->delete('tblperiod');
         return true;
    }


}