<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Payments_model extends CRM_Model {

    function __construct() {
        parent::__construct();
        $this->load->model('invoices_model');
    }

    /**
     * Get payment by ID
     * @param  mixed $id payment id
     * @return object
     */
    public function get($id) {
        $this->db->select('*,tblinvoicepaymentrecords.id as paymentid');
        $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tblinvoicepaymentrecords.paymentmode', 'left');
        $this->db->order_by('tblinvoicepaymentrecords.id', 'asc');
        $this->db->where('tblinvoicepaymentrecords.id', $id);
        $payment = $this->db->get('tblinvoicepaymentrecords')->row();
        if (!$payment) {
            return false;
        }
        // Since version 1.0.1
        $this->load->model('payment_modes_model');
        $online_modes = $this->payment_modes_model->get_online_payment_modes();
        if (is_null($payment->id)) {
            foreach ($online_modes as $online_mode) {
                if ($payment->paymentmode == $online_mode['id']) {
                    $payment->name = $online_mode['name'];
                }
            }
        }
        return $payment;
    }

    /**
     * Get all invoice payments
     * @param  mixed $invoiceid invoiceid
     * @return array
     */
    public function get_invoice_payments($invoiceid) {
        $this->db->select('*,tblinvoicepaymentrecords.id as paymentid');
        $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tblinvoicepaymentrecords.paymentmode', 'left');
        $this->db->order_by('tblinvoicepaymentrecords.id', 'asc');
        $this->db->where('invoiceid', $invoiceid);

        $payments = $this->db->get('tblinvoicepaymentrecords')->result_array();

        // Since version 1.0.1
        $this->load->model('payment_modes_model');
        $online_modes = $this->payment_modes_model->get_online_payment_modes(true);

        $i = 0;
        foreach ($payments as $payment) {
            if (is_null($payment['id'])) {
                foreach ($online_modes as $online_mode) {
                    if ($payment['paymentmode'] == $online_mode['id']) {
                        $payments[$i]['id'] = $online_mode['id'];
                        $payments[$i]['name'] = $online_mode['name'];
                    }
                }
            }
            $i++;
        }
        return $payments;
    }

    /**
     * Process invoice payment offline or online
     * @since  Version 1.0.1
     * @param  array $data $_POST data
     * @return boolean
     */
    public function process_payment($data, $invoiceid = '') {

        // echo "<pre>";
        // print_r($data);
        // die;

        if ($data['paymentmode'] == '1') {
            unset($data['bank']);
            unset($data['account_number']);
            unset($data['cheque_number']);
            unset($data['idenpresented']);
            unset($data['identification']);
        }

        // Offline payment mode from the admin side
        if (is_numeric($data['paymentmode'])) {
            if (is_staff_logged_in()) {
                $id = $this->add($data);
                return $id;
            } else {
                return false;
            }
            // Is online payment mode request by client or staff
        } else if (!is_numeric($data['paymentmode']) && !empty($data['paymentmode'])) {

            // This request will come from admin area only
            // If admin clicked the button that dont want to pay the invoice from the getaways only want
            if (is_staff_logged_in() && has_permission('manageSales')) {
                if (isset($data['do_not_redirect'])) {
                    $id = $this->add($data);
                    return $id;
                }
            }
            if (!is_numeric($invoiceid)) {
                if (!isset($data['invoiceid'])) {
                    die('No invoice specified');
                } else {
                    $invoiceid = $data['invoiceid'];
                }
            }

            $invoice = $this->invoices_model->get($invoiceid);
            // Check if request coming from admin area and the user added note so we can insert the note also when the payment is recorded
            if (isset($data['note']) && $data['note'] != '') {
                $this->session->set_userdata(array(
                    'payment_admin_note' => $data['note']
                ));
            }
            if (get_option('allow_payment_amount_to_be_modified') == 0) {
                $data['amount'] = get_invoice_total_left_to_pay($invoiceid, $invoice->total);
            }

            if ($data['paymentmode'] == 'paypal') {
                $data['returnUrl'] = site_url('getaways/paypal/complete_purchase?hash=' . $invoice->hash . '&invoiceid=' . $invoiceid);
                $data['cancelUrl'] = site_url('viewinvoice/' . $invoiceid . '/' . $invoice->hash);
                $data['currency'] = $invoice->currency_name;
                $data['description'] = 'Payment for invoice ' . format_invoice_number($invoice->id);
                $data['invoiceid'] = $invoiceid;

                $this->load->library('getaways/paypal_getaway');
                $this->paypal_getaway->make_purchase($data);
            } else if ($data['paymentmode'] == 'stripe') {
                redirect(site_url('getaways/stripe/make_payment?invoiceid=' . $invoiceid . '&total=' . $data['amount'] . '&hash=' . $invoice->hash));
            }
        }
        return false;
    }

    /**
     * Record new payment
     * @param array $data payment data
     * @return boolean
     */
    public function add($data) 
    {
        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();


        // $this->db->select('voucher');
        // $this->db->where('vchtype', '3');
        // $this->db->order_by("tblvoucher.vchid", "DESC");
        // $voucher = $this->db->get('tblvoucher')->row();

        // // print_r($this->db->last_query());
        // // die;
        // if($voucher){
        //     $voc = str_replace('PMT', '', $voucher->voucher);

        //     $voucher = ++$voc;
        //     // print_r($vouchers);
        //     $voucher ='PMT'.$voucher;
            
        // }else{
        //  $voucher ='PMT1';
        // }
       
        
        // // Check if field do not redirect to payment processor is set so we can unset from the database
        if (isset($data['do_not_redirect'])) {
            unset($data['do_not_redirect']);
        }
        $clientaccount_name = $data['clientaccount_name'];
        unset($data['clientaccount_name']);

        if (is_staff_logged_in()) {
            $data['addedfrom'] = get_staff_user_id();
            if (isset($data['date'])) {
                $data['date'] = to_sql_date($data['date']);
            } else {
                $data['date'] = date('Y-m-d H:i:s');
            }
            if (isset($data['note'])) {
                $data['note'] = nl2br($data['note']);
            } else if ($this->session->has_userdata('payment_admin_note')) {
                $data['note'] = nl2br($this->session->userdata('payment_admin_note'));
                $this->session->unset_userdata('payment_admin_note');
            }
        } else {
            $data['date'] = date('Y-m-d H:i:s');
        }

        $data['daterecorded'] = date('Y-m-d H:i:s');
       // $data['number'] = get_option('next_payment_number');

       


        $this->db->select('voucher');
        $this->db->where('vchtype', '3');
        $this->db->order_by("tblvoucher.vchid", "DESC");
        $voucher = $this->db->get('tblvoucher')->row();

        // print_r($this->db->last_query());
        // die;
        if($voucher){
            $voc = str_replace('PMT', '', $voucher->voucher);

            $voucher = ++$voc;
            // print_r($vouchers);
            $voucher ='PMT'.$voucher;
            
        }else{
         $voucher ='PMT1';
        }


        $voucherdate =  $data['date'];

        $this->db->insert('tblvoucher',array(
             
                    'voucher'=>$voucher,
                    'vchtype'=>'3',
                    'invoiceid'=>$data['invoiceid'],
                    'docdate'=>$voucherdate,
                    'trxdate'=>$voucherdate,
                    'created_by'=> get_staff_user_id(),
                    'currency'=>'3',
               
                    ));
        $voucherid = $this->db->insert_id();

        $account_receivable_amount = $data['amount'];
                        

        $this->db->select('tblinvoices.*');
        $this->db->from('tblinvoices');
        $this->db->where('tblinvoices.id',$data['invoiceid']);
        $invoice = $this->db->get()->row();
        
        // $voucher_records = $this->db->get()->row();

        $invoicenumber = format_invoice_number($invoice->number) ;


         
        // print_r($default_options);
        // die;

        $customer_discounts_ledger =  array(
                  'ledger'=>$default_options['customer_discounts_ledger'],
                  'vchid'=>$voucherid,
                  'amount'=>$account_receivable_amount,
                  'description'=>$clientaccount_name,
                  'refrence'=>$voucher,
                 'invoiceid'=>$invoicenumber,
                 'poid'=>'',
                  'item_order'=> 0,
                  'amount_type'=>0
                  );
        $this->db->insert('tblvoucherlines',$customer_discounts_ledger);
        $customer_discounts_ledger_id = $this->db->insert_id();

        $data['voucherlines_id'] = $customer_discounts_ledger_id;
 		$data = do_action('before_payment_recorded', $data);
        $this->db->insert('tblinvoicepaymentrecords', $data);
        $insert_id = $this->db->insert_id();
          // $this->load->model('settings_model');
          //           $default_options = $this->settings_model->getOptions();

        $account_receivable =  array(
                              'ledger'=>$default_options['account_receivable'],
                              'vchid'=>$voucherid,
                              'amount'=>$account_receivable_amount,
                              'description'=>'Account Receivable ',
                              'refrence'=>$voucher,
                             'invoiceid'=>$invoicenumber,
                             'poid'=>'',
                              'item_order'=> 0,
                              'amount_type'=>1
                              );
        $this->db->insert('tblvoucherlines',$account_receivable);




        $res = explode('-',$data['receipt_number']);
        $receipt_startnumber = array('value' => $res[1]);
        
        $this->db->where('name', 'receipt_startnumber');
        $this->db->update('tbloptions', $receipt_startnumber);

        $nextreceipt = $res[1] + 1;
        $next_receipt = array('value' => $nextreceipt);
                
        $this->db->where('name', 'next_receipt');
        $this->db->update('tbloptions', $next_receipt);

        if ($insert_id) {
             // $this->db->where('name', 'next_payment_number');
              // $this->db->set('value', 'value+1', FALSE);
              // $this->db->update('tbloptions');
               
            $invoice = $this->invoices_model->get($data['invoiceid']);
            update_invoice_status($data['invoiceid']);
            if (is_staff_logged_in()) {
                $this->invoices_model->log_invoice_activity($data['invoiceid'], get_staff_full_name() . ' recorded payment from total <b>' . format_money($data['amount'], $invoice->symbol) . '</b> - <a href="' . admin_url('payments/payment/' . $insert_id) . '" target="_blank">#' . $insert_id . '</a>');
            } else {
                $this->invoices_model->log_invoice_activity($data['invoiceid'], 'Client made payment for the invoice from total <b>' . format_money($data['amount'], $invoice->symbol) . '</b> - <a href="' . admin_url('payments/payment/' . $insert_id) . '" target="_blank">#' . $insert_id . '</a>', false, true);
            }

            logActivity('Payment Recorded [ID:' . $insert_id . ', Invoice Number: ' . format_invoice_number($invoice->id) . ', Total: ' . format_money($data['amount'], $invoice->symbol) . ']');


            // Send email to the client that the payment is recorded
            $this->load->model('emails_model');
            $payment = $this->get($insert_id);
            $payment->invoice_data = $this->invoices_model->get($payment->invoiceid);
            $paymentpdf = payment_pdf($payment);
            $attach = $paymentpdf->Output(_l('payment') . '-' . $payment->paymentid . '.pdf', 'S');

            $this->emails_model->add_attachment(array(
                'attachment' => $attach,
                'filename' => _l('payment') . '-' . $payment->paymentid . '.pdf',
                'type' => 'application/pdf'
            ));

            $this->emails_model->send_email_template('invoice-payment-recorded', $invoice->client->email, $invoice->clientid, $invoice->id);


            return $insert_id;
        }

        return false;
    }

    /**
     * Update payment
     * @param  array $data payment data
     * @param  mixed $id   paymentid
     * @return boolean
     */
    public function update($data, $id) 
    {
        // echo "<pre>";
        // print_r($data);
        // die;

        $data['date'] = to_sql_date($data['date']);
        $data['note'] = nl2br($data['note']);
        if($data['paymentmode'] = 1){
            $data['bank']='';
            $data['account_number']='';
            $data['cheque_number']='';
            $data['idenpresented']='';
            $data['identification']='';
            $data['note']='';
        }else{
            $data['transactionid']='';
        }
        $_data = do_action('before_payment_updated', array(
            'data' => $data,
            'id' => $id
        ));

        $data = $_data['data'];
        
        $this->db->where('id', $id);
        $this->db->update('tblinvoicepaymentrecords', $data);
        
        $this->db->select('*');
        $this->db->from('tblinvoicepaymentrecords');
        $this->db->where('id', $id);
        $invoice_payment = $this->db->get()->row();

        $this->db->select('*');
        $this->db->from('tblvoucherlines');
        $this->db->where('id', $invoice_payment->voucherlines_id);
        $voucherlines_id = $this->db->get()->row();

        $this->db->select('*');
        $this->db->from('tblvoucherlines');
        $this->db->where('vchid', $voucherlines_id->vchid);
        $voucherlines = $this->db->get()->result();

        foreach ($voucherlines as $key => $voucherline) {
            $data = array(
                    'amount' => $data['amount'],
                );

            $this->db->where('id', $voucherline->id);
            $this->db->update('tblvoucherlines', $data);
        }


        if ($this->db->affected_rows() > 0) {
            logActivity('Payment Updated [ID:' . $id . ']');
            return true;
        }


        return false;
    }

    /**
     * Delete payment from database
     * @param  mixed $id paymentid
     * @return boolean
     */
    public function delete($id) {
        $current = $this->get($id);
        $current_invoice = $this->invoices_model->get($current->invoiceid);
        $invoiceid = $current->invoiceid;

        do_action('before_payment_deleted', array(
            'paymentid' => $id,
            'invoiceid' => $invoiceid
        ));
        $this->db->where('id', $id);
        $this->db->delete('tblinvoicepaymentrecords');

        if ($this->db->affected_rows() > 0) {
            update_invoice_status($invoiceid);
            $this->invoices_model->log_invoice_activity($invoiceid, get_staff_full_name() . ' deleted payment for the invoice. Payment #' . $current->paymentid . ', total amount: ' . format_money($current->amount, $current_invoice->symbol));
            logActivity('Payment Deleted [ID:' . $id . ', Invoice Number: ' . format_invoice_number($current->id) . ']');

            return true;
        }

        return false;
    }

    public function get_userinvoice($id) {
        return $this->db->where('clientid', $id)->get('tblinvoices')->result();
    }   

    public function get_last_payment($value='')
    {
        return $this->db->order_by('id','DESC')->get('tblinvoicepaymentrecords')->row();
    }

    public function makepayments($data = '') {
        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        $data['payment_amount'] = str_replace(',', '', $data['payment_amount']);
        $data['amount'] = str_replace(',', '', $data['amount']);
        $data['credit_to_apply'] = str_replace(',', '', $data['credit_to_apply']);
        $data['receipt_number'] = get_option('receipt_prefix').get_option('receipt_separator').get_option('next_receipt');
        
        
        $applamiount = $data['applyamounts'];
		
		// apply paymnet has nothing to do with voucher creation
		$applamiount = '1';

        if ($applamiount == '1') {

            // echo "<pre>";
            // print_r($applamiount);
            // die;
            $result = $this->db->select('id,status,total,number')->where('clientid', $data['clientid'])->where('status !=2')->order_by('status', 'DESC')->get('tblinvoices')->result();

            $client_name = $this->db->select('userid,accountname')->where('userid', $data['clientid'])->get('tblclients')->row();

            $sum = $this->db->select_sum('total')->where('clientid', $data['clientid'])->where('status !=2')->order_by('status', 'DESC')->get('tblinvoices')->row();

            if ($data['payment_amount'] > $sum->total) {
                $credit = $data['payment_amount'] - $sum->total;
                $this->db->query("UPDATE tblclients SET credit = credit + $credit WHERE userid =".$data['clientid']);

            }
      

            $paymentamount = $data['payment_amount'];


            
                    if (is_staff_logged_in()) {
                        $data['addedfrom'] = get_staff_user_id();
                        if (isset($data['date'])) {

                            $d = DateTime::createFromFormat(get_current_date_format(), $data['date']);
                            $data['date']  = $d->format('Y-m-d');
                        
                        } else {
                            $data['date'] = date('Y-m-d H:i:s');
                        }
                        if (isset($data['note'])) {
                            $data['note'] = nl2br($data['note']);
                        } else if ($this->session->has_userdata('payment_admin_note')) {
                            $data['note'] = nl2br($this->session->userdata('payment_admin_note'));
                            $this->session->unset_userdata('payment_admin_note');
                        }
                    } else {
                        $data['date'] = date('Y-m-d H:i:s');
                    }

                    $data['daterecorded'] = date('Y-m-d H:i:s');

            foreach ($result as $key => $value) {

                if ($paymentamount > 0) {
                    if ($paymentamount < $value->total)
                        $data['amount'] = $paymentamount;
                    else
                        $data['amount'] = $value->total;

                    $data['invoiceid'] = $value->id;


                    // $this->db->select_max('voucher');
                    // $this->db->where('vchtype', '3');
                    // $voucher = $this->db->get('tblvoucher')->row()->voucher;

                    

                    // if($voucher){
                    //     $voc = str_replace('PMT-', '', $voucher);

                    //     $voucher = ++$voc;
                    //     $voucher ='PMT-'.$voucher;
                        
                    // }else{
                    //  $voucher ='PMT-1';
                    // }

                    $this->db->select('voucher');
                    $this->db->where('vchtype', '3');
                    $this->db->order_by("tblvoucher.vchid", "DESC");
                    $voucher = $this->db->get('tblvoucher')->row();

                    // print_r($this->db->last_query());
                    // die;
                    if($voucher){
                        $voc = str_replace('PMT', '', $voucher->voucher);

                        $voucher = ++$voc;
                        // print_r($vouchers);
                        $voucher ='PMT'.$voucher;
                        
                    }else{
                     $voucher ='PMT1';
                    }


                     

                    $voucherdate = $data['date'];

                    $this->db->insert('tblvoucher',array(
                         
                                'voucher'=>$voucher,
                                'vchtype'=>'3',
                                'invoiceid'=>$data['invoiceid'],
                                'docdate'=>$voucherdate,
                                'trxdate'=>$voucherdate,
                                'created_by'=> get_staff_user_id(),
                                'currency'=>'3',
                           
                                ));
                    $voucherid = $this->db->insert_id();





                        $account_receivable_amount = $paymentamount;
                        

                        // $this->db->select('tblvoucher.*');
                        // $this->db->from('tblvoucher');
                        // $this->db->where('tblvoucher.invoiceid', $data['invoiceid']);
                        
                        // $voucher_records = $this->db->get()->row();

                        $invoicenumber = format_invoice_number($value->number) ;


                    $this->load->model('settings_model');
                    $default_options = $this->settings_model->getOptions();


                    $customer_discounts_ledger =  array(
                              'ledger'=>$default_options['customer_discounts_ledger'],
                              'vchid'=>$voucherid,
                              'amount'=>$account_receivable_amount,
                              'description'=>$client_name->accountname,
                              'refrence'=>$voucher,
                             'invoiceid'=>$invoicenumber,
                             'poid'=>'',
                              'item_order'=> 0,
                              'amount_type'=>0
                              );
                    $this->db->insert('tblvoucherlines',$customer_discounts_ledger);
                    $customer_discounts_ledger_id = $this->db->insert_id();

                    $data['voucherlines_id'] = $customer_discounts_ledger_id;





                    unset($data['clientid']);
                    unset($data['do_not_redirect']);
                    unset($data['amount_due']);
                    unset($data['credit_to_apply']);
                    unset($data['invoiceids']);
                    unset($data['applyamount']);
                    unset($data['applyamounts']);
                    unset($data['payment_amount']);
                    $data['invoiceid'] = $value->id;

                  //  $data = do_action('before_payment_recorded', $data);
                    $this->db->insert('tblinvoicepaymentrecords', $data);
                

                    $insert_id = $this->db->insert_id();

                    $res = explode('-',$data['receipt_number']);
                    $receipt_startnumber = array('value' => $res[1]);
                    
                    $this->db->where('name', 'receipt_startnumber');
                    $this->db->update('tbloptions', $receipt_startnumber);

                    $nextreceipt = $res[1] + 1;
                    $next_receipt = array('value' => $nextreceipt);
                            
                    $this->db->where('name', 'next_receipt');
                    $this->db->update('tbloptions', $next_receipt);
                    

                    $paymentamount = ($paymentamount - $value->total);

                    if ($insert_id) {
                        $invoice = $this->invoices_model->get($data['invoiceid']);

                        



                        
                        $account_receivable =  array(
                              'ledger'=>$default_options['account_receivable'],
                              'vchid'=>$voucherid,
                              'amount'=>$account_receivable_amount,
                              'description'=>'Account Receivable ',
                              'refrence'=>$voucher,
                             'invoiceid'=>$invoicenumber,
                             'poid'=>'',
                              'item_order'=> 0,
                              'amount_type'=>1
                              );
                        $this->db->insert('tblvoucherlines',$account_receivable);

                        // $customer_discounts_ledger =  array(
                        //       'ledger'=>$default_options['customer_discounts_ledger'],
                        //       'vchid'=>$voucher_records->vchid,
                        //       'amount'=>$account_receivable_amount,
                        //       'description'=>$client_name->accountname,
                        //       'refrence'=>'',
                        //      'invoiceid'=>$invoicenumber,
                        //      'poid'=>'',
                        //       'item_order'=> 0,
                        //       'amount_type'=>0
                        //       );
                        // $this->db->insert('tblvoucherlines',$customer_discounts_ledger);

                        update_invoice_status($data['invoiceid']);
                        if (is_staff_logged_in()) {
                            $this->invoices_model->log_invoice_activity($data['invoiceid'], get_staff_full_name() . ' recorded payment from total <b>' . format_money($data['amount'], $invoice->symbol) . '</b> - <a href="' . admin_url('payments/payment/' . $insert_id) . '" target="_blank">#' . $insert_id . '</a>');
                        } else {
                            $this->invoices_model->log_invoice_activity($data['invoiceid'], 'Client made payment for the invoice from total <b>' . format_money($data['amount'], $invoice->symbol) . '</b> - <a href="' . admin_url('payments/payment/' . $insert_id) . '" target="_blank">#' . $insert_id . '</a>', false, true);
                        }

                        logActivity('Payment Recorded [ID:' . $insert_id . ', Invoice Number: ' . format_invoice_number($invoice->id) . ', Total: ' . format_money($data['amount'], $invoice->symbol) . ']');


                        // Send email to the client that the payment is recorded
                        $this->load->model('emails_model');
                        $payment = $this->get($insert_id);
                        $payment->invoice_data = $this->invoices_model->get($payment->invoiceid);
                        $paymentpdf = payment_pdf($payment);
                        $attach = $paymentpdf->Output(_l('payment') . '-' . $payment->paymentid . '.pdf', 'S');

                        $this->emails_model->add_attachment(array(
                            'attachment' => $attach,
                            'filename' => _l('payment') . '-' . $payment->paymentid . '.pdf',
                            'type' => 'application/pdf'
                        ));

                        $this->emails_model->send_email_template('invoice-payment-recorded', $invoice->client->email, $invoice->clientid, $invoice->id);
                    }
                } else {
                    return $insert_id;
                }
            }
             return $insert_id;
        } else {

                // echo "jfhsadui";
                // die;
                if (is_staff_logged_in()) {
                    $data['addedfrom'] = get_staff_user_id();
                    if (isset($data['date'])) {
                       $d = DateTime::createFromFormat(get_current_date_format(), $data['date']);
                        $data['date']  = $d->format('Y-m-d');
                      
  
                    } else {
                        $data['date'] = date('Y-m-d H:i:s');
                    }
                    if (isset($data['note'])) {
                        $data['note'] = nl2br($data['note']);
                    } else if ($this->session->has_userdata('payment_admin_note')) {
                        $data['note'] = nl2br($this->session->userdata('payment_admin_note'));
                        $this->session->unset_userdata('payment_admin_note');
                    }
                } else {
                    $data['date'] = date('Y-m-d H:i:s');
                }
                $applyamount =$data['applyamount'];
  
               $totalsum =  array_sum($applyamount);
               
                 if ($applyamount > $totalsum) {
                    $credit = $data['payment_amount'] - $totalsum;
                     $this->db->query("UPDATE tblclients SET credit = credit + $credit WHERE userid =".$data['clientid']);
                }
          
                 $paymentamount = $data['payment_amount'];
                 
              foreach ($data['invoiceids'] as $key => $value) {
                $data['invoiceid'] = $value;
          
                if ($paymentamount > 0) {
                    
                
                   if ($paymentamount < $applyamount[$key])
                       $data['amount'] = $paymentamount;
                    else
                        $data['amount'] =  $applyamount[$key];

                
                $data['daterecorded'] = date('Y-m-d H:i:s');
         
                unset($data['clientid']);
                unset($data['do_not_redirect']);
                unset($data['amount_due']);
                unset($data['credit_to_apply']);
                unset($data['invoiceids']);
                unset($data['applyamount']);
                unset($data['applyamounts']);
                unset($data['payment_amount']);


                $data = do_action('before_payment_recorded', $data);
                $this->db->insert('tblinvoicepaymentrecords', $data);
                $insert_id = $this->db->insert_id();

                $res = explode('-',$data['receipt_number']);
                $receipt_startnumber = array('value' => $res[1]);
                
                $this->db->where('name', 'receipt_startnumber');
                $this->db->update('tbloptions', $receipt_startnumber);

                $nextreceipt = $res[1] + 1;
                $next_receipt = array('value' => $nextreceipt);
                        
                $this->db->where('name', 'next_receipt');
                $this->db->update('tbloptions', $next_receipt);
            

                if ($insert_id) {
                    $invoice = $this->invoices_model->get($data['invoiceid']);
//                   update_invoice_status($data['invoiceid']);
                    if (is_staff_logged_in()) {
                        $this->invoices_model->log_invoice_activity($data['invoiceid'], get_staff_full_name() . ' recorded payment from total <b>' . format_money($data['amount'], $invoice->symbol) . '</b> - <a href="' . admin_url('payments/payment/' . $insert_id) . '" target="_blank">#' . $insert_id . '</a>');
                    } else {
                        $this->invoices_model->log_invoice_activity($data['invoiceid'], 'Client made payment for the invoice from total <b>' . format_money($data['amount'], $invoice->symbol) . '</b> - <a href="' . admin_url('payments/payment/' . $insert_id) . '" target="_blank">#' . $insert_id . '</a>', false, true);
                    }

                    logActivity('Payment Recorded [ID:' . $insert_id . ', Invoice Number: ' . format_invoice_number($invoice->id) . ', Total: ' . format_money($data['amount'], $invoice->symbol) . ']');


                    // Send email to the client that the payment is recorded
                    $this->load->model('emails_model');
                    $payment = $this->get($insert_id);
                    $payment->invoice_data = $this->invoices_model->get($payment->invoiceid);
                    $paymentpdf = payment_pdf($payment);
                    $attach = $paymentpdf->Output(_l('payment') . '-' . $payment->paymentid . '.pdf', 'S');

                    $this->emails_model->add_attachment(array(
                        'attachment' => $attach,
                        'filename' => _l('payment') . '-' . $payment->paymentid . '.pdf',
                        'type' => 'application/pdf'
                    ));

                    $this->emails_model->send_email_template('invoice-payment-recorded', $invoice->client->email, $invoice->clientid, $invoice->id);
                }
//              
            }else{
                  return true;
            }
       
              }
              return true;
        }
    }

}
