<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ledgers_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  mixed $id client id (optional)
     * @param  integer $active (optional) get all active or inactive
     * @return mixed
     * Get client object based on passed clientid if not passed clientid return array of all clients
     */
    public function get_all_ledgers($value='')
    {
      $this->db->select('*');
      $this->db->from('tblledgergroups');
      $this->db->where('type','Ledger');
      return $this->db->get()->result();
    }
    public function get($id = false, $active = '')
    {
        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $client = $this->db->get('tblledgergroups')->row();
            // echo($client);

            return $client;
        }


        return $this->get_ledgers();
    }

    public function get_ledgers() {
        return $this->db->where('type', 'Ledger')->order_by('name', 'ASC')->get('tblledgergroups')->result();
    }


    function get_all_groups() {
        $this->db->where('parent', '0');
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblaccountgroups')->result();
    }
    function get_subgroups($id) {
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblaccountgroups')->result();
    }
    function get_prev_ledgers(){
        return $this->get_prev_groups(0);
		$this->db->order_by('name', 'ASC');
        return $this->db->get('tblledgergroups')->result();   
    }
	function get_prev_groups($id=0) {
      $this->db->where('type', 'Group');
		$this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
		$subgoups=array();
		foreach($tabl as $ta)
		{			
			
        	$ta->subgroups= $this->get_prev_groups($ta->id);
			$subgoups[]=$ta;
			
		}
		
		return $subgoups;
    }
    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }
    function get_parent($id){
        $this->db->where('id', $id);
        return $this->db->get('tblledgergroups')->row()->name;
    }

    function get_parent_id($id){
      
        $this->db->where('id', $id);
        return $this->db->get('tblledgergroups')->row()->parent;        
    }

    function getSingleRecord($table, $where) {
        return $this->db->get_where($table, $where)->row();
    }
      
    
    function get_last_accountno() {
        $this->db->where('type', 'Ledger');
        $this->db->order_by('id', 'DESC');      
        $this->db->limit(1);
        return $this->db->get('tblledgergroups')->row();
    }
    
    
 function getDataByOrder($table, $where ) {
        $this->db->order_by('sort_order', 'asc');
        return $this->db->get_where($table, $where)->result_array();
 }


public function getRecords($tbl)
{
  return $this->db->get($tbl)->result_array();  
}
public function get_where_record($tbl,$id)
{
    
  return $this->db->where('id', $id)->get($tbl)->row();  
}



    /**
     * @param array $_POST data
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data)
    {
     

      unset($data['action']);
      unset($data['save']);
      unset($data['snew']);
      unset($data['sexit']);

      $this->db->select('*');
      $this->db->from('tblledgergroups');
      $this->db->where('id', $data['parent']);
      $parent_name =  $this->db->get()->row();

      $data['path'] = $parent_name->name."/".$data['name'];

      // echo "<pre>";print_r($data);echo "</pre>";exit;

      $this->db->where('name', $data['name']);
      $this->db->where('type', 'Ledger');
      $this->db->where('accountid', $data['accountid']);
      $res = $this->db->get('tblledgergroups')->row();

      if ($res) {
        set_alert('warning', 'Ledger already exists');
        redirect(admin_url('ledgers/ledger'));
      }
      // $data['accountid']=str_replace('-','',$data['accountid']);
      $data['description']= strip_tags($data['description']);
      $data['name']= strip_tags($data['name']);
      //$data = do_action('before_ledger_added', $data);
      $parentID = $this->find_parentIdFromPath($data['parent']);
      
      // echo $parentID;	 echo "<pre>";print_r($data);echo "</pre>";exit;
      $data['parent']	= $parentID;
      $this->db->insert('tblledgergroups', $data);
      $ledgerid = $this->db->insert_id();


      return $ledgerid;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
    public function update($data, $id)
    {
		    // $this->db->where('path', $data['parent']);
      //   $ParentID = $this->db->get('tblledgergroups')->row()->id;
		
		  // echo "<pre>";
    //   print_r($data);
    //   die;

      $this->db->select('*');
      $this->db->from('tblledgergroups');
      $this->db->where('id', $data['parent']);
      $parent_name =  $this->db->get()->row();

      $data['path'] = $parent_name->name."/".$data['name'];

        unset($data['action']);
        unset($data['save']);
        unset($data['snew']);
        unset($data['sexit']);

        $this->db->where('name', $data['name']);
             $this->db->where('type', 'Ledger');
        $this->db->where('id !=', $id);
        $res = $this->db->get('tblledgergroups')->row();
        if ($res) {
          set_alert('warning', 'Ledger already exists');
            redirect(admin_url('ledgers/ledger'));
        }


      // $data['path'] = $data['parent'];
      // $data['parent'] = $ParentID;
	    
	    $data['description']= strip_tags($data['description']);
      $data['name']= strip_tags($data['name']);
      $this->db->where('id', $id);
      $this->db->update('tblledgergroups', $data);

      return true;
    }

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function delete($id)
    {

        do_action('before_ledger_deleted', $id);

        $this->db->where('id', $id);
        $this->db->delete('tblledgergroups');
         return true;
    }


	///FUNCTION FOR GETTING ALL THE LEDGERS AND ITS SUB LEDGERS IN MUTLI
	///MULTI DIMENSIONAL ARRAY.
	public function getLedgersTree(){
		$this->db->select('id,name,parent');
		$this->db->from('tblledgergroups');
		$this->db->where('parent',0);
		$q = $this->db->get();
		if ($q->num_rows() > 0){
			foreach($q->result() as $row){
				$data[] = $row;
				 
			}
			return $data;
		}
	}
	
	public function find_parentIdFromPath($value)
  {
    // echo $value;
    // die;
		$this->db->select('id');
		$this->db->from('tblledgergroups');	
    // $this->db->where('path',$value);
		$this->db->where('id',$value);
		$q = $this->db->get();

		if ($q->num_rows() > 0){
			foreach($q->result() as $row){
				$data = $row->id;	
			}
			return $data;
		}else{
			return 0;	
		}
	}
}