<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Jobcard_model extends CRM_Model {
    function __construct() {
        parent::__construct();
    }
    /**
     * Get invoice by id
     * @param  mixed $id
     * @return array
     */
    public function get_invoices_list() {
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        // $this->db->join('tblinvoicepaymentrecords', 'tblinvoicepaymentrecords.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        return $item = $this->db->get()->result();
    }
    public function get_jobcard($id) {
        $this->db->select('jobcards.id as jobcard_id,jobcards.*,jobcards.date_entered as date_enter,jobcards.private_notes as private_not,vehicles.*,engines.*,vehiclemodelyear.make,vehiclemodelyear.model,vehiclemodelyear.year,sanetz_users.*');
        $this->db->from('jobcards');
        $this->db->join('vehicles', 'vehicles.id = jobcards.vehicles_id', 'left');
        $this->db->join('engines', 'engines.id = vehicles.engines_id', 'left');
        $this->db->join('vehiclemodelyear', 'vehiclemodelyear.id = engines.vehiclemodelyear', 'left');
        $this->db->join('sanetz_users', 'sanetz_users.id = jobcards.users_id', 'left');
        $this->db->where('jobcards.id', $id);
        $jobcard = $this->db->get()->row();
        if ($jobcard) {
            $jobcard->items = $this->get_jobcard_items($id);
            return $jobcard;
        }
    }
    public function get_jobcard_excel($userid, $orderby, $sortby) {
        //print_r($orderby);
        //exit;
        $this->db->select('jobcards.id as jobcard_id,jobcards.*,jobcards.date_entered as date_enter,date(appointment_date) as apt_date,vehicles.*,engines.*,vehiclemodelyear.make as maker,vehiclemodelyear.model as modler,vehiclemodelyear.year as yar,sanetz_users.*');
        $this->db->from('jobcards');
        $this->db->join('vehicles', 'vehicles.id = jobcards.vehicles_id', 'left');
        $this->db->join('engines', 'engines.id = vehicles.engines_id', 'left');
        $this->db->join('vehiclemodelyear', 'vehiclemodelyear.id = engines.vehiclemodelyear', 'left');
        $this->db->join('sanetz_users', 'sanetz_users.id = jobcards.users_id', 'left');
        $this->db->where('jobcards.users_id', $userid);
        if ($sortby == 'paid') {
            $this->db->where('jobcards.jc_status', '100');
        } elseif ($sortby == 'unpaid') {
            $ignore = '100';
            $this->db->where_not_in('jobcards.jc_status', $ignore);
        }
        if ($orderby == 'date') {
            $this->db->order_by('appointment_date', 'DESC');
        } elseif ($orderby == 'vehicle') {
            $this->db->order_by('maker', 'ASC', 'modler', 'ASC', 'yar', 'ASC');
        }
        $jobcard = $this->db->get()->result();
        if ($jobcard) {
            return $jobcard;
        }
    }
    public function sum_of_payment($id) {
        $this->db->select('sum(tblinvoicepaymentrecords.amount) as sum_of_payment');
        $this->db->from('tblinvoicepaymentrecords');
        $this->db->where('invoiceid', $id);
        return $item = $this->db->get()->row();
    }
    public function get_list($clientid, $status, $from, $to) {
        // echo $from;
        // die;
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        if ($clientid != "") {
            $this->db->where('tblinvoices.clientid', $clientid);
        }
        if ($status != "") {
            $this->db->where('tblinvoices.status', $status);
        }
        if ($from != "") {
            $this->db->where('tblinvoices.date >=', $from);
        }
        if ($to != "") {
            $this->db->where('tblinvoices.date <=', $to);
        }
        return $item = $this->db->get()->result();
    }
    public function get_invoicepdf($from, $to) {
        // echo $from;
        // die;
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        if ($from != "") {
            $this->db->where('tblinvoices.date >=', $from);
        }
        if ($to != "") {
            $this->db->where('tblinvoices.date <=', $to);
        }
        return $item = $this->db->get()->result();
    }
    public function get_sale_item_list($category_id, $date, $today_date, $from, $to) {
        $this->db->select('tblinvoiceitems.*,tblinvoices.number,tblcategories.category_name,tblsubcategories.subcategory_name,tblinvoiceitemslist.id as itemid');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoiceitems.invoiceid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.sku = tblinvoiceitems.sku', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        $this->db->join('tblsubcategories', 'tblsubcategories.subcategory_id = tblinvoiceitemslist.subcategory', 'left');
        if ($category_id != "") {
            $this->db->where('tblinvoiceitemslist.category', $category_id);
        }
        if ($date != "") {
            $this->db->where('tblinvoices.date BETWEEN "' . $date . '" AND "' . date('Y-m-d') . '"');
            // $this->db->where('tblinvoices.date >=',$date);
            // $this->db->where('tblinvoices.date',date('Y-m-d'));
            
        }
        if ($today_date != "") {
            // $this->db->where('tblinvoices.date >=',$date);
            $this->db->where('tblinvoices.date', $today_date);
        }
        if ($from != "" && $to != "") {
            $this->db->where('tblinvoices.date BETWEEN "' . $from . '" AND "' . $to . '"');
            // $this->db->where('tblinvoices.date >=',$from);
            
        }
        // if($to != "")
        // {
        //     $this->db->where('tblinvoices.date <=',$to);
        // }
        return $item = $this->db->get()->result();
        // print_r($this->db->last_query());
        // die;
        
    }
    public function get_sale_item_pdf($category_id, $date, $today_date, $from, $to) {
        // echo $today_date;die;
        $this->db->select('tblinvoiceitems.invoiceid,tblinvoiceitems.sku,tblinvoiceitems.description,sum(tblinvoiceitems.qty) as quantity,tblinvoices.number,tblcategories.category_name,tblsubcategories.subcategory_name,tblinvoiceitemslist.id as itemid');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoiceitems.invoiceid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.sku = tblinvoiceitems.sku', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        $this->db->join('tblsubcategories', 'tblsubcategories.subcategory_id = tblinvoiceitemslist.subcategory', 'left');
        $this->db->group_by('tblinvoiceitems.sku');
        if ($category_id != "null") {
            $this->db->where('tblinvoiceitemslist.category', $category_id);
        }
        if ($date != 'custom') {
            if ($date != "") {
                $this->db->where('tblinvoices.date BETWEEN "' . $date . '" AND "' . date('Y-m-d') . '"');
                // $this->db->where('tblinvoices.date >=',$date);
                // $this->db->where('tblinvoices.date',date('Y-m-d'));
                
            }
        }
        if ($today_date != "") {
            // $this->db->where('tblinvoices.date >=',$date);
            $this->db->where('tblinvoices.date', $today_date);
        }
        if ($from != "") {
            $this->db->where('tblinvoices.date >=', $from);
        }
        if ($to != "") {
            $this->db->where('tblinvoices.date <=', $to);
        }
        return $item = $this->db->get()->result();
        // echo "<pre>";
        // print_r($item);
        // die;
        
    }
    public function jobcard_data() {
        $data = array();
        $this->db->select('jobcards.id as jobcard_id,date(jobcards.appointment_date) as start,date(jobcards.appointment_date) as end,jobcards.*,vehicles.*,engines.*,vehiclemodelyear.make as title,vehiclemodelyear.model,vehiclemodelyear.year,sanetz_users.*');
        $this->db->from('jobcards');
        $this->db->join('vehicles', 'vehicles.id = jobcards.vehicles_id', 'left');
        $this->db->join('engines', 'engines.id = vehicles.engines_id', 'left');
        $this->db->join('vehiclemodelyear', 'vehiclemodelyear.id = engines.vehiclemodelyear', 'left');
        $this->db->join('sanetz_users', 'sanetz_users.id = jobcards.users_id', 'left');
        $this->db->where('(date(appointment_date) BETWEEN "' . $this->input->get('start') . '" AND "' . $this->input->get('end') . '")');
        $jobcards = $this->db->get()->result_array();
        foreach ($jobcards as $jobcard) {
            $jobcard['_tooltip'] = ('Jobcard');
            if ($jobcard['jc_status'] == '5') {
                $status = 'Unconfirmed';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '10') {
                $status = 'Vehicle in shop';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '20') {
                $status = 'Inspection in progress';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '30') {
                $status = 'Waiting for confirmation';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '40') {
                $status = 'Waiting for parts';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '50') {
                $status = 'Repair and installation';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '60') {
                $status = 'Vehicle ready';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '99') {
                $status = 'Vehicle delivered - outstanding payment';
                $jc_color = '#0087E0';
            } elseif ($jobcard['jc_status'] == '100') {
                $jc_color = 'green';
                $status = 'Vehicle delivered and paid';
            }
            $jobcard['title'] = '<a class="popovers" data-container="body" data-trigger="hover" data-placement="top" 
				data-content=" ' . $jobcard['type'] . ' <br> ' . $jobcard['cc'] . 'CC | ' . $jobcard['kw'] . 'KW | ' . $jobcard['ps'] . 'PS | ' . $jobcard['hp'] . 'HP | ' . $jobcard['nm'] . 'NM | ' . $jobcard['cylinders'] . 'CYL' . ' ' . $jobcard['fuel'] . ' <br> ' . $jobcard['engine_code'] . '" data-original-title="Engine Details" target="_blank" href="../clients/view/' . $jobcard['users_id'] . '"><i class="fa fa-car fa-inverse"></i></a>&nbsp;<a href="../jobcard/jobcard/' . $jobcard['users_id'] . '/' . $jobcard['jobcard_id'] . '" class="" target="_blank"><i class="fa fa-pencil-square-o fa-inverse"></i></a>&nbsp;<a href="../clients/view/' . $jobcard['users_id'] . '" class="" target="_blank"><i class="fa fa-user fa-inverse"></i></a>&nbsp;<a href="../jobcard/show_invoice/' . $jobcard['jobcard_id'] . '" class="pull-right" target="_blank"><i class="fa fa-print fa-inverse"></i></a></br>' . '<strong style="font-size: 12px;">' . $jobcard['first_name'] . '&nbsp;' . $jobcard['last_name'] . '</strong>' . '</br>' . '<strong style="font-size: 12px;">' . $jobcard['title'] . '&nbsp;' . $jobcard['model'] . '</strong>' . '</br>' . '<strong style="font-size: 12px;" class="popovers" data-container="body" data-trigger="hover" data-placement="top" data-content="' . $status . '" data-original-title="Jobcard Status">' . substr($status, 0, 30) . '</strong>' . '';
            /*if($jobcard['jc_status'] == '100'){
            
            $color='#2ea8e5';
            
            }else{
            
            $color='#FF0000';
            
            }*/
            $jobcard['color'] = $jc_color;
            $jobcard['id'] = $jobcard['jobcard_id'];
            $jobcard['event_type'] = 'jobcard';
            //$jobcard['url']      = admin_url('jobcard/jobcard/' . $jobcard['jobcard_id']);
            array_push($data, $jobcard);
        }
        $this->db->select('date(events.event_date) as start,date(events.event_date) as end,events.*');
        $this->db->from('events');
        $this->db->where('(date(event_date) BETWEEN "' . $this->input->get('start') . '" AND "' . $this->input->get('end') . '")');
        $this->db->where('((events.status != 99) OR ((events.ignore_list != 0) AND (events.ignore_list != 1)))');
		$this->db->order_by('events.event_date', 'ASC');
        $events = $this->db->get()->result_array();
      //  echo $this->db->last_query();
        foreach ($events as $event) {
            $event['_tooltip'] = ('Event');
            if ($event['from_name'] != '(Unknown)') {
                $html = '<a href="../clients/view/' . $event['users_id'] . '" class="" target="_blank"><i class="fa fa-user fa-inverse"></i></a>';
            } else {
                $html = '<a href="../clients/client/' . $event['users_id'] . '" class="" target="_blank"><i class="fa fa-user-plus fa-inverse"></i></a>';
            }
            $event['title'] = '<span class="fc-time"></span><a href="../events/show_calls/' . $event['id'] . '" class="" data-toggle="modal" data-target="#sanet-add-calls"><i class="fa fa-pencil-square-o fa-inverse"></i></a> ' . $html . '<a style="font-size:11px;" href="javascript:;" class="pull-right"  onclick="deleteevent(\'' . $event['id'] . '\')"><i class="fa fa-trash fa-inverse"></i></a>' . '</br>' . $event['from_name'] . '</br>' . $event['from_number'] . '';
            $event['color'] = '#FF0000';
            $event['event_type'] = 'event';
            // $event['url']      = admin_url('events/loadeventsAction/' . $event['id']);
            array_push($data, $event);
        }
        //echo'<pre>';
        //print_r($data);
        //print_r($data);
        return $data;
    }
    public function getvehicles() {
        if ($id) {
            $this->db->where('id', $id);
            $vehicle_char = $this->db->get('vehicles')->row();
            //echo $this->db->last_query();
            return $vehicle_char;
        }
        //$this->db->order_by('name', 'ASC');
        return $this->db->get('vehicles')->result_array();
    }
    public function getuserid($phone, $lastname) {
        $this->db->select('sanetz_users.phone_mobile', 'sanetz_users.last_name', 'sanetz_users.*')->from('sanetz_users')->where('phone_mobile =', $phone)->where('last_name =', $lastname);
        $userid = $this->db->get('sanetz_users')->row();
        //echo $this->db->last_query();
        return $userid;
        //$this->db->order_by('name', 'ASC');
        //return $this->db->get('vehicles')->result_array();
        
    }
    public function get_where_single_tbl($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->row();
    }
    public function get_sale_item_print($category_id, $date, $today_date, $from, $to) {
        $this->db->select('tblinvoiceitems.invoiceid,tblinvoiceitems.sku,tblinvoiceitems.description,sum(tblinvoiceitems.qty) as quantity,tblinvoices.number,tblcategories.category_name,tblsubcategories.subcategory_name,tblinvoiceitemslist.id as itemid');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoiceitems.invoiceid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.sku = tblinvoiceitems.sku', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        $this->db->join('tblsubcategories', 'tblsubcategories.subcategory_id = tblinvoiceitemslist.subcategory', 'left');
        $this->db->group_by('tblinvoiceitems.sku');
        if ($category_id != "null") {
            $this->db->where('tblinvoiceitemslist.category', $category_id);
        }
        if ($date != 'custom') {
            if ($date != "") {
                $this->db->where('tblinvoices.date BETWEEN "' . $date . '" AND "' . date('Y-m-d') . '"');
                // $this->db->where('tblinvoices.date >=',$date);
                // $this->db->where('tblinvoices.date',date('Y-m-d'));
                
            }
        }
        if ($today_date != "") {
            // $this->db->where('tblinvoices.date >=',$date);
            $this->db->where('tblinvoices.date', $today_date);
        }
        if ($from != "null") {
            $this->db->where('tblinvoices.date >=', $from);
        }
        if ($to != "null") {
            $this->db->where('tblinvoices.date <=', $to);
        }
        return $item = $this->db->get()->result();
        // echo "<pre>";
        // print_r($item);
        // die;
        
    }
    public function get_salesmanlist($sale_agent, $status, $from, $to) {
        // echo $from;
        // die;
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol,tblstaff.firstname,tblstaff.lastname');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        $this->db->join('tblstaff', 'tblstaff.staffid = tblinvoices.sale_agent', 'left');
        if ($sale_agent != "") {
            $this->db->where('tblinvoices.sale_agent', $sale_agent);
        }
        if ($status != "") {
            $this->db->where('tblinvoices.status', $status);
        }
        if ($from != "") {
            $this->db->where('tblinvoices.date >=', $from);
        }
        if ($to != "") {
            $this->db->where('tblinvoices.date <=', $to);
        }
        $this->db->where('tblstaff.active', 1);
        return $item = $this->db->get()->result();
    }
    public function get_staff() {
        $this->db->select('tblstaff.*');
        $this->db->from('tblstaff');
        $this->db->where('active', 1);
        return $this->db->get()->result();
    }
    public function getjobcardserviceinfo($itemid) {
        $this->db->select('jobcard_items.*');
        $this->db->from('jobcard_items');
       // $this->db->where('jobcards_id', $jobcardid);
        $this->db->where('id', $itemid);
        return $this->db->get()->row();
    }
    public function saveserviceinfo($data,$itemid) {
        //print_r($data);
        //exit;
        $technician = $data['technician'];
        $estimate_cost = $data['estimate_cost'];
        $other_cost = $data['other_cost'];
        $baynumber = $data['baynumber'];
        //$description=$data['description'] ;
        $private_notes = $data['private_notes'];
       // $this->db->where('jobcards_id', $jobcardid);
        $this->db->where('id', $itemid);
       // $this->db->where('product', $product);
        //$this->db->set('service',$service);
        $this->db->set('technician', $technician);
        $this->db->set('estimate_cost', $estimate_cost);
        $this->db->set('other_cost', $other_cost);
        $this->db->set('baynumber', $baynumber);
        $this->db->set('private_notes', $private_notes);
        $this->db->update('jobcard_items');
        //echo $this->db->last_query();
        //exit;
        return true;
    }
    public function get_estimates($id) {
        $this->db->select('tblestimates.number,tblestimates.id');
        $this->db->from('tblinvoices');
        $this->db->join('tblorders', 'tblorders.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblestimates', 'tblestimates.orderid = tblorders.id', 'left');
        $this->db->where('tblinvoices.id', $id);
        return $item = $this->db->get()->row();
    }
    public function get_order($id) {
        $this->db->select('tblorders.number,tblorders.id');
        $this->db->from('tblorders');
        // $this->db->join('tblorders', 'tblorders.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblorders.invoiceid', 'left');
        $this->db->where('tblinvoices.id', $id);
        return $item = $this->db->get()->row();
    }
    public function get($id = '') {
        $this->db->select('*, tblcurrencies.id as currencyid, tblinvoices.id as id, tblcurrencies.name as currency_name');
        $this->db->from('tblinvoices');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        if (is_numeric($id)) {
            $this->db->where('tblinvoices' . '.id', $id);
            $invoice = $this->db->get()->row();
            if ($invoice) {
                $invoice->items = $this->get_invoice_items($id);
                $i = 0;
                $this->load->model('payments_model');
                $this->load->model('clients_model');
                $invoice->client = $this->clients_model->get($invoice->clientid);
                if ($invoice->client->company == '') {
                    $invoice->client->company = $invoice->client->firstname . ' ' . $invoice->client->lastname;
                }
                $invoice->payments = $this->payments_model->get_invoice_payments($id);
            }
            return $invoice;
        }
        return $this->db->get()->result_array();
    }
    public function get_items($id) {
        return $this->get_invoice_items($id);
    }
    public function get_bank() {
        return $this->db->order_by('bank', 'ASC')->get('tblbanks')->result();
    }
    /**
     * Get all invoice items
     * @param  mixed $id invoiceid
     * @return array
     */
    public function get_jobcard_items($id) {
        $this->db->select('jobcard_items.id,qty,estimate_cost,jobcard_items.description,jobcard_items.private_notes,service,product,products.name,product_services.name as service_name');
        $this->db->from('jobcard_items');
        $this->db->join('products', 'products.id = jobcard_items.product', 'left');
        $this->db->join('product_services', 'product_services.id = jobcard_items.service', 'left');
        $this->db->where('jobcard_items.jobcards_id', $id);
        return $this->db->get()->result_array();
        //print_r($this->db->get()->result_array());
        //exit;
        
    }
    public function get_jobcard_items_amount($id) {
        $this->db->select('jobcard_items.id,qty,estimate_cost,other_cost,jobcard_items.description,jobcard_items.private_notes,service,product,products.name,product_services.name as service_name');
        $this->db->from('jobcard_items');
        $this->db->join('products', 'products.id = jobcard_items.product', 'left');
        $this->db->join('product_services', 'product_services.id = jobcard_items.service', 'left');
        $this->db->where('jobcard_items.jobcards_id', $id);
        return $this->db->get()->result();
        //print_r($this->db->get()->result_array());
        //exit;
        
    }
    public function get_invoice_item($id) {
        $this->db->where('id', $id);
        return $this->db->get('tblinvoiceitems')->row();
    }
    public function getbalance($id) {
        $this->db->select_sum('amount');
        $this->db->where('invoiceid', $id);
        return $this->db->get('tblinvoicepaymentrecords')->row();
    }
    /**
     * Get this invoice generated recuring invoices
     * @since  Version 1.0.1
     * @param  mixed $id main invoice id
     * @return array
     */
    public function get_invoice_recuring_invoices($id) {
        $this->db->where('is_recurring_from', $id);
        $invoices = $this->db->get('tblinvoices')->result_array();
        $recuring_invoices = array();
        foreach ($invoices as $invoice) {
            $recuring_invoices[] = $this->get($invoice['id']);
        }
        return $recuring_invoices;
    }
    /**
     * Get invoice total from all statuses
     * @since  Version 1.0.2
     * @param  mixed $data $_POST data
     * @return array
     */
    public function get_invoices_total($data) {
        $statuses = array(1, 2, 3, 4);
        $this->load->model('currencies_model');
        if ((is_using_multiple_currencies() && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }
        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql = 'SELECT';
        foreach ($statuses as $invoice_status) {
            $sql.= '(SELECT SUM(total) FROM tblinvoices WHERE status=' . $invoice_status;
            $sql.= ' AND currency =' . $currencyid;
            $sql.= ') as "' . $invoice_status . '",';
        }
        $sql = substr($sql, 0, -1);
        $result = $this->db->query($sql)->result_array();
        $_result = array();
        $i = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total'] = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }
        // print_r($_result);
        // die;
        return $_result;
    }
    /**
     * Insert new invoice to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, invoice ID if succes
     */
    function get_ledgerdetails($id) {
        $this->db->select('ldg.*');
        $this->db->from('tblledgergroups as ldg');
        $this->db->join('tblinvoiceitemslist as inl', 'inl.ledger = ldg.id');
        $this->db->where('inl.id', $id);
        return $ldgres = $this->db->get()->row();
    }
    function get_client($id) {
        $this->db->select('*');
        $this->db->from('tblclients');
        $this->db->where('userid', $id);
        return $this->db->get()->row();
    }
    function get_client_class($id) {
        $this->db->select('*');
        $this->db->from('tblcustomergroups_in');
        $this->db->where('customer_id', $id);
        return $this->db->get()->row();
    }
    function get_taxrate($id) {
        $this->db->where('id', $id);
        return $this->db->get('tbltaxes')->row();
    }
    function add_ledger_AR($userid, $data) {
        // print_r($data);
        //       die;
        if ($data['groups_in'] == 1) {
            $this->db->select_max('accountid');
            $this->db->where('accountid', $userid);
            $accountid = $this->db->get('tblledgergroups')->row()->accountid;
            $this->load->model('ledgers_model');
            $ledgerdata = array('name' => ucfirst($data['accountname']), 'description' => $data['accountname'], 'type' => 'Ledger', 'parent' => 129, 'accountid' => $userid,);
            if ($accountid) {
                $this->db->where('accountid', $userid);
                $this->db->update('tblledgergroups', $ledgerdata);
            } else {
                $ledgerid = $this->ledgers_model->add($ledgerdata);
            }
            /* if($ledgerid){
            
            $this->db->where('userid', $userid);
            
            $this->db->update('tblclients', array('ledger'=>$ledgerid));
            
            $this->createpath();
            
            } */
        }
    }
    public function add($data, $cron = false, $expense = false) {
        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);
        unset($data['costprice']);
        $data['date_entered'] = date("Y-m-d H:i:s", strtotime($data['date_entered']));
        $data['appointment_date'] = date("Y-m-d H:i:s", strtotime($data['appointment_date']));
        $unsetters = array('service', 'product', 'description', 'qty', 'estimate_cost',);
        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }
        //$data['date']      = to_sql_date($data['date']);
        //$data['date_entered'] = date('Y-m-d H:i:s');
        $items = array();
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }
        //$data  = $_data['data'];
        //$items = $_data['items'];
        foreach ($items as $key => $item) { /*
            
            $this->db->select('tblclients.warehouse,tblwarehousestock.*');
            
            $this->db->from('tblclients');
            
            $this->db->join('tbllocations', 'tbllocations.ware_id = tblclients.warehouse');
            
            $this->db->join('tblwarehousestock', 'tblwarehousestock.location_id = tbllocations.location_id');
            
            $this->db->where('tblclients.userid', $clientid);
            
            $this->db->where('tbllocations.default_location', 2);
            
            $this->db->where('tblwarehousestock.suppliersku',$item['sku']);
            
            $warehouseitem = $this->db->get()->row();
            
            // print_r($warehouseitem);
            
            
            
            $invoiceqty = $warehouseitem->qty - $item['qty'];
            
            // echo $invoiceqty;
            
            
            
            $warehousestockdata =array('qty'=> $invoiceqty);
            
            $this->db->where('id', $warehouseitem->id);
            
            $this->db->update('tblwarehousestock', $warehousestockdata);
            
            */
        }
        // die;
        //print_r($data);
        $this->db->select('UUID() AS id');
        $idrow = $this->db->get('jobcards')->row();
        $data['id'] = $idrow->id;
        $this->db->insert('jobcards', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            $total = '';
            //print_r($item);
            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    //print_r($item['product']);
                    $this->db->insert(' jobcard_items', array('service' => $item['service'], 'product' => $item['product'], 'description' => $item['description'], 'qty' => $item['qty'], 'jobcards_id' => $data['id'], 'estimate_cost' => $item['estimate_cost']));
                    //echo $this->db->last_query();
                    //exit;
                    $i++;
                }
            }
            $cost = 0;
            foreach ($items as $key => $value) {
                $cost = $cost + $value['costprice'];
            }
            do_action('after_invoice_added', $insert_id);
            return $idrow->id;
        }
        return false;
    }
    public function get_term($id) {
        $this->db->select('payment_term');
        $this->db->where('userid', $id);
        return $this->db->get('tblclients')->row();
    }
    public function get_sales_agent($id) {
        $this->db->select('account_req');
        $this->db->where('userid', $id);
        return $this->db->get('tblclients')->row()->account_req;
    }
    public function due_days($id) {
        $this->db->select('dueDays');
        $this->db->where('id', $id);
        return $this->db->get('tblinvoicepaymentsmodes')->row();
    }
    /**
     * Update invoice data
     * @param  array $data invoice data
     * @param  mixed $id   invoiceid
     * @return boolean
     */
    public function update($data, $id) {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);
        unset($data['itemorder_id']);
        $affectedRows = 0;
        unset($data['service']);
        unset($data['product']);
        unset($data['description']);
        unset($data['qty']);
        unset($data['isedit']);
        unset($data['estimate_cost']);
        unset($data['description']);
        $data['date_entered'] = date("Y-m-d H:i:s", strtotime($data['date_entered']));
        $data['appointment_date'] = date("Y-m-d H:i:s", strtotime($data['appointment_date']));
        $itemid = $data['items'];
      /*  foreach ($itemid as $item_id) {
            $this->db->select('*');
            $this->db->from('jobcard_items');
            $this->db->where('jobcards_id', $id);
            $required_fields = $this->db->get()->row();
        }*/
        //print_r($data['items']);
        //exit;
        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }
        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }
        $this->db->where('jobcards_id', $id);
        $this->db->set('field_status', '3');
        $this->db->update('jobcard_items');
        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }
        $this->db->where('id', $id);
        $this->db->update('jobcards', $data);
        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
				$estimate_cost=0;
                $this->db->select('*');
                $this->db->from('jobcard_items');
                $this->db->where('jobcards_id', $id);
                $this->db->where('id', $item['itemid']);
				//echo $item['itemid'];
				//echo '<pre>';
			   // print_r($item);
				//echo '</pre>';
				//echo $this->db->last_query();
        		//exit;
                $required_fields = $this->db->get()->row();
                $baynumber = $required_fields->baynumber;
                $other_cost = $required_fields->other_cost;
                $estimate_cost = $required_fields->estimate_cost;
                $technician = $required_fields->technician;
                $private_notes = $required_fields->private_notes;
				//echo 'i <br>'. $item['estimate_cost'];
				//echo 'e <br>'.$estimate_cost;
				if($estimate_cost!=''){
					$estimate_cost=$estimate_cost;
				//	echo 'a';
				}else{
					$estimate_cost=$item['estimate_cost'];
					//echo 'b';
				}
				
				//echo $estimate_cost;
                $this->db->insert('jobcard_items', array(
				'service' => $item['service'],
				'product' => $item['product'],
				'description' => $item['description'],
				'qty' => $item['qty'],
				'jobcards_id' => $id,
				'baynumber' => $baynumber,
				'other_cost' => $other_cost,
				'estimate_cost' => $estimate_cost,
				'technician' => $technician,
				'private_notes' => $private_notes,));
        
		 // echo  '<br>'.$this->db->last_query();
		    }
        }
		
        $this->db->where('jobcards_id', $id);
        $this->db->where('field_status', '3');
        $this->db->delete('jobcard_items');
        //echo $this->db->last_query();
        //exit;
        return false;
    }
    public function update_jobcard_event($jobcard_eventid, $jobcard_eventdate) {
        $this->db->where('id', $jobcard_eventid);
        $this->db->set('appointment_date', $jobcard_eventdate);
        $res = $this->db->update('jobcards');
        //echo $this->db->last_query();
        //exit;
        return $res;
    }
    public function get_attachments($invoiceid, $id = '') {
        // If is passed id get return only 1 attachment
        if (is_numeric($id)) {
            $this->db->where('id', $id);
        } else {
            $this->db->where('invoiceid', $invoiceid);
        }
        $result = $this->db->get('tblinvoiceattachments');
        if (is_numeric($id)) {
            return $result->row();
        } else {
            return $result->result_array();
        }
    }
    /**
     *  Delete invoice attachment
     * @since  Version 1.0.4
     * @param   mixed $id  attachmentid
     * @return  boolean
     */
    public function delete_attachment($id) {
        $attachment = $this->get_attachments('', $id);
        if ($attachment) {
            if (unlink(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid . '/' . $attachment->file_name)) {
                $this->db->where('id', $id);
                $this->db->delete('tblinvoiceattachments');
                $other_attachments = list_files(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid);
                if (count($other_attachments) == 0) {
                    // delete the dir if no other attachments found
                    delete_dir(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid);
                }
            }
            return true;
        }
        return false;
    }
    /**
     * Delete invoice items and all connections
     * @param  mixed $id invoiceid
     * @return boolean
     */
    public function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('jobcards');
        $this->db->where('jobcards_id', $id);
        $this->db->delete('jobcard_items');
        return true;
    }
    /**
     * Set invoice to sent when email is successfuly sended to client
     * @param mixed $id invoiceid
     * @param  mixed $cron is request coming from cron
     * @param  mixed $manually is staff manualy marking this invoice as sent
     * @return  boolean
     */
    public function set_invoice_sent($id, $cron = false, $manually = false) {
        $this->db->where('id', $id);
        $this->db->update('tblinvoices', array('sent' => 1, 'datesend' => date('Y-m-d H:i:s')));
        $marked = false;
        if ($this->db->affected_rows() > 0) {
            $marked = true;
        }
        if ($cron == true) {
            $description = 'Invoice sent to client by CRON';
        } else {
            if ($manually == false) {
                $description = get_staff_full_name() . ' sent invoice to client';
            } else {
                $description = get_staff_full_name() . ' marked invoice as sent';
            }
        }
        $this->log_invoice_activity($id, $description, $cron);
        return $marked;
    }
    /**
     * Sent overdue notice to client for this invoice
     * @since  Since Version 1.0.1
     * @param  mxied  $id   invoiceid
     * @param  boolean $cron is request from cron
     * @return boolean
     */
    public function send_invoice_overdue_notice($id, $cron = false) {
        $this->load->model('emails_model');
        $invoice = $this->get($id);
        $invoice_number = format_invoice_number($invoice->number);
        $pdf = invoice_pdf($invoice);
        $attach = $pdf->Output($invoice_number . '.pdf', 'S');
        $this->emails_model->add_attachment($attach, $invoice_number . '.pdf', 'application/pdf');
        $send = $this->emails_model->send_email_template('invoice-overdue-notice', $invoice->client->email, $invoice->clientid, $id);
        if ($send) {
            if ($cron == true) {
                $_from = '[CRON]';
            } else {
                $_from = get_staff_full_name();
            }
            $this->db->where('id', $id);
            $this->db->update('tblinvoices', array('last_overdue_reminder' => date('Y-m-d')));
            $this->log_invoice_activity($id, _l('user_sent_overdue_reminder', $_from), $cron);
            return true;
        }
        return false;
    }
    /**
     * Sent invoice to client
     * @param  mixed  $id        invoiceid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach invoice pdf or not
     * @param  boolean $cron      is request coming from cron
     * @return boolean
     */
    public function sent_invoice_to_client($id, $template = '', $attachpdf = true, $cron = false) {
        $this->load->model('emails_model');
        $invoice = $this->get($id);
        if ($template == '') {
            if ($invoice->sent == 0) {
                $template = 'invoice-send-to-client';
            } else {
                $template = 'invoice-already-send';
            }
        }
        $invoice_number = format_invoice_number($invoice->number);
        $pdf = invoice_pdf($invoice);
        if ($attachpdf) {
            $attach = $pdf->Output(APPPATH . 'PDF/' . $invoice_number . '.pdf', 'F');
            $attachmentfile = APPPATH . 'PDF/' . $invoice_number . '.pdf';
            $this->emails_model->add_attachment($attachmentfile, $invoice_number . '.pdf', 'application/pdf');
        }
        $send = $this->emails_model->send_email_template($template, $invoice->client->email, $invoice->clientid, $id);
        if ($send) {
            $this->set_invoice_sent($id, $cron);
            return true;
        }
        return false;
    }
    /**
     * All invoice activity
     * @param  mixed $id invoiceid
     * @return array
     */
    public function get_invoice_activity($id) {
        $this->db->where('invoiceid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblinvoiceactivity')->result_array();
    }
    /**
     * Log invoice activity to database
     * @param  mixed $id   invoiceid
     * @param  string $description activity description
     */
    public function log_invoice_activity($id, $description = '', $cron = false, $client = false) {
        $staffid = get_staff_user_id();
        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }
        $this->db->insert('tblinvoiceactivity', array('description' => $description, 'date' => date('Y-m-d H:i:s'), 'invoiceid' => $id, 'staffid' => $staffid));
    }
    function get_prev($id) {
        return $this->db->query("select id,clientid from tblinvoices where id = (select max(id) from tblinvoices where id < $id)")->row();
    }
    function get_next($id) {
        return $this->db->query("select id,clientid from tblinvoices where id = (select min(id) from tblinvoices where id > $id)")->row();
    }
    function change_invoice_status($status, $id) {
        // $this->load->model('settings_model');
        // $default_options = $this->settings_model->getOptions();
        // $invoice_id = $this->db->query("select id,number from tblinvoices where id =  $id")->row();
        // $this->db->select('tblvoucherlines.*');
        // $this->db->from('tblvoucherlines');
        // $this->db->join('tblvoucher', 'tblvoucher.vchid = tblvoucherlines.vchid');
        // $this->db->join('tblinvoices', 'tblinvoices.id = tblvoucher.invoiceid');
        // $this->db->where('tblvoucher.invoiceid', $invoice_id->id);
        // $this->db->where('tblvoucherlines.ledger', $default_options['cost_of_goods_sold']);
        // $invoice_number = $this->db->get()->result();
        // // $invoice_number = $this->db->query("select * from tblvoucherlines where invoiceid = 'INV-0".$invoice_id->number."' AND ledger = 69 ")->result();
        //     if($status == 2)
        //     {
        //         $cost = array();
        //             foreach ($invoice_number as $key => $value) {
        //                        $cost[] =  array(
        //                               'ledger'=>$default_options['inventory_ledger'],
        //                               'vchid'=>$value->vchid,
        //                               'amount'=>$value->amount,
        //                               'description'=>'Inventory',
        //                               'refrence'=>$value->refrence,
        //                              'invoiceid'=>$value->invoiceid,
        //                              'poid'=>$value->poid,
        //                               'item_order'=> $value->item_order,
        //                               'amount_type'=>1
        //                               );
        //             }
        //             $this->db->insert_batch('tblvoucherlines',$cost);
        //     }
        $this->db->where('id', $id);
        return $this->db->update('tblinvoices', array('status' => $status));
    }
    public function update_credit($amount, $id) {
        $amount = str_replace(',', '', $amount);
        $this->db->query("UPDATE tblclients SET credit_limit = credit_limit + $amount WHERE userid =" . $id);
    }
    public function getinvoices($id) {
        return $this->db->select_sum('total')->where('status !=', '2')->where('clientid', $id)->get('tblinvoices')->row();
    }
    public function getorders($id) {
        return $this->db->select_sum('total')->where('clientid', $id)->get('tblorders')->row();
    }
    public function getcredit($id) {
        return $this->db->where('userid', $id)->get('tblclients')->row();
    }
    public function get_discount($id) {
        return $this->db->where('id', $id)->get('tbldiscounts')->row()->discountrate;
    }
}
