<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Invoices_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * Get invoice by id
     * @param  mixed $id
     * @return array
     */

    public function get_invoices_list()
    {
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        // $this->db->join('tblinvoicepaymentrecords', 'tblinvoicepaymentrecords.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        return $item = $this->db->get()->result();
    }

    public function sum_of_payment($id)
    {

        $this->db->select('sum(tblinvoicepaymentrecords.amount) as sum_of_payment');
        $this->db->from('tblinvoicepaymentrecords');
        $this->db->where('invoiceid',$id);
        return $item = $this->db->get()->row();
    }

    public function get_list($clientid,$status,$from,$to)
    {
        // echo $from;
        // die;
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        if($clientid != "")
        {
            $this->db->where('tblinvoices.clientid',$clientid);
        }

        if($status != "")
        {
            $this->db->where('tblinvoices.status',$status);
        }

        if($from != "")
        {
            $this->db->where('tblinvoices.date >=',$from);
        }

        if($to != "")
        {
            $this->db->where('tblinvoices.date <=',$to);
        }
        return $item = $this->db->get()->result();
    }

    public function get_invoicepdf($from,$to)
    {
        // echo $from;
        // die;
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        
        if($from != "")
        {
            $this->db->where('tblinvoices.date >=',$from);
        }

        if($to != "")
        {
            $this->db->where('tblinvoices.date <=',$to);
        }
        return $item = $this->db->get()->result();
    }

    public function get_sale_item_list($category_id,$date,$today_date,$from,$to)
    {
        $this->db->select('tblinvoiceitems.*,tblinvoices.number,tblcategories.category_name,tblsubcategories.subcategory_name,tblinvoiceitemslist.id as itemid');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoiceitems.invoiceid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.sku = tblinvoiceitems.sku', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        $this->db->join('tblsubcategories', 'tblsubcategories.subcategory_id = tblinvoiceitemslist.subcategory', 'left');
        if($category_id != "")
        {
            $this->db->where('tblinvoiceitemslist.category',$category_id);
        }

        if($date != "")
        {
            $this->db->where('tblinvoices.date BETWEEN "'. $date . '" AND "' . date('Y-m-d').'"');
            // $this->db->where('tblinvoices.date >=',$date);
            // $this->db->where('tblinvoices.date',date('Y-m-d'));
        }

        if($today_date != "")
        {
            // $this->db->where('tblinvoices.date >=',$date);
            $this->db->where('tblinvoices.date',$today_date);
        }

        if($from != "" && $to != "")
        {
            $this->db->where('tblinvoices.date BETWEEN "'. $from . '" AND "' . $to.'"');

            // $this->db->where('tblinvoices.date >=',$from);
        }

        // if($to != "")
        // {
        //     $this->db->where('tblinvoices.date <=',$to);
        // }
         return $item = $this->db->get()->result();
         // print_r($this->db->last_query());
         // die;

    }

    public function get_sale_item_pdf($category_id,$date,$today_date,$from,$to)
    {   
        // echo $today_date;die;
        $this->db->select('tblinvoiceitems.invoiceid,tblinvoiceitems.sku,tblinvoiceitems.description,sum(tblinvoiceitems.qty) as quantity,tblinvoices.number,tblcategories.category_name,tblsubcategories.subcategory_name,tblinvoiceitemslist.id as itemid');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoiceitems.invoiceid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.sku = tblinvoiceitems.sku', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        $this->db->join('tblsubcategories', 'tblsubcategories.subcategory_id = tblinvoiceitemslist.subcategory', 'left');
        $this->db->group_by('tblinvoiceitems.sku'); 
        if($category_id != "null")
        {
            $this->db->where('tblinvoiceitemslist.category',$category_id);
        }

        if($date != 'custom')
        {
            if($date != "")
            {
                $this->db->where('tblinvoices.date BETWEEN "'. $date . '" AND "' . date('Y-m-d').'"');
                // $this->db->where('tblinvoices.date >=',$date);
                // $this->db->where('tblinvoices.date',date('Y-m-d'));
            }
        }

        if($today_date != "")
        {
            // $this->db->where('tblinvoices.date >=',$date);
            $this->db->where('tblinvoices.date',$today_date);
        }

        if($from != "")
        {
            $this->db->where('tblinvoices.date >=',$from);
        }

        if($to != "")
        {
            $this->db->where('tblinvoices.date <=',$to);
        }
        return $item = $this->db->get()->result();
        // echo "<pre>";
        // print_r($item);
        // die;
    }

     public function get_sale_item_print($category_id,$date,$today_date,$from,$to)
    {   
        
        $this->db->select('tblinvoiceitems.invoiceid,tblinvoiceitems.sku,tblinvoiceitems.description,sum(tblinvoiceitems.qty) as quantity,tblinvoices.number,tblcategories.category_name,tblsubcategories.subcategory_name,tblinvoiceitemslist.id as itemid');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblinvoiceitems.invoiceid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.sku = tblinvoiceitems.sku', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        $this->db->join('tblsubcategories', 'tblsubcategories.subcategory_id = tblinvoiceitemslist.subcategory', 'left');
        $this->db->group_by('tblinvoiceitems.sku'); 
        if($category_id != "null")
        {
            $this->db->where('tblinvoiceitemslist.category',$category_id);
        }

        if($date != 'custom')
        {
            if($date != "")
            {
                $this->db->where('tblinvoices.date BETWEEN "'. $date . '" AND "' . date('Y-m-d').'"');
                // $this->db->where('tblinvoices.date >=',$date);
                // $this->db->where('tblinvoices.date',date('Y-m-d'));
            }
        }

        if($today_date != "")
        {
            // $this->db->where('tblinvoices.date >=',$date);
            $this->db->where('tblinvoices.date',$today_date);
        }
        
        if($from != "null")
        {
            $this->db->where('tblinvoices.date >=',$from);
        }

        if($to != "null")
        {
            $this->db->where('tblinvoices.date <=',$to);
        }
        return $item = $this->db->get()->result();
        // echo "<pre>";
        // print_r($item);
        // die;
    }

    public function get_salesmanlist($sale_agent,$status,$from,$to)
    {
        // echo $from;
        // die;
        $this->db->select('tblinvoices.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol,tblstaff.firstname,tblstaff.lastname');
        $this->db->from('tblinvoices');
        $this->db->join('tblclients', 'tblclients.userid = tblinvoices.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');
        $this->db->join('tblstaff', 'tblstaff.staffid = tblinvoices.sale_agent', 'left');
        if($sale_agent != "")
        {
            $this->db->where('tblinvoices.sale_agent',$sale_agent);
        }

        if($status != "")
        {
            $this->db->where('tblinvoices.status',$status);
        }

        if($from != "")
        {
            $this->db->where('tblinvoices.date >=',$from);
        }

        if($to != "")
        {
            $this->db->where('tblinvoices.date <=',$to);
        }
        $this->db->where('tblstaff.active', 1);
        return $item = $this->db->get()->result();
    }

    public function get_staff()
    {    
        $this->db->select('tblstaff.*');
        $this->db->from('tblstaff');
        $this->db->where('active', 1);
            
        return $this->db->get()->result();
       
    }
    
    public function get_estimates($id)
    {
        $this->db->select('tblestimates.number,tblestimates.id');
        $this->db->from('tblinvoices');
        $this->db->join('tblorders', 'tblorders.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblestimates', 'tblestimates.orderid = tblorders.id', 'left');
        $this->db->where('tblinvoices.id',$id);
        return $item = $this->db->get()->row();
    }

    public function get_order($id)
    {
        $this->db->select('tblorders.number,tblorders.id');
        $this->db->from('tblorders');
        // $this->db->join('tblorders', 'tblorders.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblinvoices', 'tblinvoices.id = tblorders.invoiceid', 'left');
        $this->db->where('tblinvoices.id',$id);
        return $item = $this->db->get()->row();
    }

    public function get($id = '')
    {
        $this->db->select('*, tblcurrencies.id as currencyid, tblinvoices.id as id, tblcurrencies.name as currency_name');
        $this->db->from('tblinvoices');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblinvoices.currency', 'left');

        if (is_numeric($id)) {
            $this->db->where('tblinvoices' . '.id', $id);

            $invoice = $this->db->get()->row();
            
            if ($invoice) {
       
                $invoice->items = $this->get_invoice_items($id);
                $i = 0;
                $this->load->model('payments_model');
                $this->load->model('clients_model');
                $invoice->client   = $this->clients_model->get($invoice->clientid);
                if($invoice->client->company == ''){
                    $invoice->client->company = $invoice->client->firstname . ' ' . $invoice->client->lastname;
                }
                $invoice->payments = $this->payments_model->get_invoice_payments($id);
            }

            return $invoice;
        }
        return $this->db->get()->result_array();
    }
     public function get_items($id){
       return  $this->get_invoice_items($id);
    }
    public function get_bank(){
        return $this->db->order_by('bank','ASC')->get('tblbanks')->result();
    }
    /**
     * Get all invoice items
     * @param  mixed $id invoiceid
     * @return array
     */
    public function get_invoice_items($id)
    {
        $this->db->select('tblinvoiceitems.id,qty,rate,taxrate,itemorder_id,disc,itemid,tbltaxes.id as taxid,tbltaxes.name as taxname,description as description,long_description,item_order,sku');
        $this->db->from('tblinvoiceitems');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitems.taxid', 'left');
        $this->db->where('tblinvoiceitems.invoiceid', $id);
        $this->db->order_by('tblinvoiceitems.item_order', 'asc');
        return $this->db->get()->result_array();
  
    }

    public function get_invoice_item($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('tblinvoiceitems')->row();
    }
    public function getbalance($id){
        $this->db->select_sum('amount');
        $this->db->where('invoiceid', $id);
        return $this->db->get('tblinvoicepaymentrecords')->row();
    }

    /**
     * Get this invoice generated recuring invoices
     * @since  Version 1.0.1
     * @param  mixed $id main invoice id
     * @return array
     */
    public function get_invoice_recuring_invoices($id)
    {
        $this->db->where('is_recurring_from', $id);
        $invoices          = $this->db->get('tblinvoices')->result_array();
        $recuring_invoices = array();
        foreach ($invoices as $invoice) {
            $recuring_invoices[] = $this->get($invoice['id']);
        }
        return $recuring_invoices;
    }

    /**
     * Get invoice total from all statuses
     * @since  Version 1.0.2
     * @param  mixed $data $_POST data
     * @return array
     */
    public function get_invoices_total($data)
    {

        $statuses = array(
            1,
            2,
            3,
            4
        );
        $this->load->model('currencies_model');

        if ((is_using_multiple_currencies() && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }


        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql    = 'SELECT';
        foreach ($statuses as $invoice_status) {
            $sql .= '(SELECT SUM(total) FROM tblinvoices WHERE status=' . $invoice_status;
            $sql .= ' AND currency =' . $currencyid;
            $sql .= ') as "' . $invoice_status . '",';
        }

        $sql     = substr($sql, 0, -1);
        $result  = $this->db->query($sql)->result_array();
        $_result = array();
        $i       = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total']  = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }
        // print_r($_result);
        // die;
        return $_result;
    }

    /**
     * Insert new invoice to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, invoice ID if succes
     */
    
    function get_ledgerdetails($id){
       $this->db->select('ldg.*');
        $this->db->from('tblledgergroups as ldg');
        $this->db->join('tblinvoiceitemslist as inl','inl.ledger = ldg.id');
        $this->db->where('inl.id',$id);
       return $ldgres = $this->db->get()->row();
    }
	function get_client($id)
	{
		$this->db->select('*');
        $this->db->from('tblclients');
       
        $this->db->where('userid',$id);
       return $this->db->get()->row();
	}
	function get_client_class($id)
	{
		$this->db->select('*');
        $this->db->from('tblcustomergroups_in');
       
        $this->db->where('customer_id',$id);
       return $this->db->get()->row();
	}
    function get_taxrate($id){
       
        $this->db->where('id',$id);
       return  $this->db->get('tbltaxes')->row();
    }
	function add_ledger_AR($userid,$data)
	{
		// print_r($data);
  //       die;
		if($data['groups_in']==1)
		{
			$this->db->select_max('accountid');
			$this->db->where('accountid', $userid);
			$accountid = $this->db->get('tblledgergroups')->row()->accountid;	
			$this->load->model('ledgers_model');
			$ledgerdata=array(
			  'name'=>ucfirst($data['accountname']),
			  'description'=>$data['accountname'],
			  'type'=>'Ledger',
			  'parent'=>129,
			  'accountid'=>$userid,
			);
			
			if($accountid){
				$this->db->where('accountid',$userid);
				$this->db->update('tblledgergroups',$ledgerdata);
			}
			else
			{
			  
			  $ledgerid = $this->ledgers_model->add($ledgerdata);
			}
	   
		  /* if($ledgerid){
				$this->db->where('userid', $userid);
				$this->db->update('tblclients', array('ledger'=>$ledgerid));
				$this->createpath();
		   } */ 
		}
	}
    public function add($data, $cron = false, $expense = false)
    {
        // echo "<pre>";
        // print_r($data);
        // die;
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);
        unset($data['costprice']);

      
        $data['number'] = $data['_number'];
		
		
        $unsetters = array(
            '_number',
            'currency_symbol',
            'price',
            'taxname',
            'itemorder_id',
            'itemrecorid',
            'sku',
            'description',
            'disc',
            'taxid',
            'rate',
            'quantity',
            'costprice',
        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }


        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            unset($data['custom_fields']);
        }

        $data['hash'] = md5(rand() . microtime());
        // Check if the key exists
        $this->db->where('hash', $data['hash']);
        $exists = $this->db->get('tblinvoices')->row();

        if ($exists) {
            $data['hash'] = md5(rand() . microtime());
        }
               
        $data['adminnote'] = nl2br($data['adminnote']);
       
        if(isset($data['terms'])){
          $data['terms']     = nl2br($data['terms']);
        }

        $data['date']      = to_sql_date($data['date']);
   
        if (!empty($data['duedate'])) {
      
            $data['duedate'] = to_sql_date($data['duedate']);
              
        } else {
            
            unset($data['duedate']);
        }
  

        // uncheck sales agent if is not set so the dafault value in base will be NULL
        if($data['sale_agent'] == ''){
            unset($data['sale_agent']);
        }
        // Since version 1.0.1
        if (isset($data['allowed_payment_modes'])) {
            $data['allowed_payment_modes'] = serialize($data['allowed_payment_modes']);
        } else {
            $data['allowed_payment_modes'] = serialize(array());
        }
     
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['year']        = get_option('invoice_year');
        if ($cron == false) {
            $data['addedfrom'] = get_staff_user_id();
        }
        $items = array();
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }

        
        $clientid= $data['clientid'];
        $voucherdate = $data['date'] ;
      
        $this->db->select('*');
        $this->db->from('tbloptions');
        $this->db->where('name', 'next_invoice_number');
        $next_number = $this->db->get()->row();

        $data['number'] = $next_number->value;
        $invoicenumber = format_invoice_number($data['number']);
       

        $_data = do_action('before_invoice_added', array(
            'data' => $data,
            'items' => $items
        ));
       
        $data  = $_data['data'];
        
       
        $items = $_data['items'];

        foreach ($items as $key => $item) 
        {
            $this->db->select('tblclients.warehouse,tblwarehousestock.*');
            $this->db->from('tblclients');
            $this->db->join('tbllocations', 'tbllocations.ware_id = tblclients.warehouse');
            $this->db->join('tblwarehousestock', 'tblwarehousestock.location_id = tbllocations.location_id');
            $this->db->where('tblclients.userid', $clientid);
            $this->db->where('tbllocations.default_location', 2);
            $this->db->where('tblwarehousestock.suppliersku',$item['sku']);
            $warehouseitem = $this->db->get()->row();
            // print_r($warehouseitem);

            $invoiceqty = $warehouseitem->qty - $item['qty'];
            // echo $invoiceqty;

            $warehousestockdata =array('qty'=> $invoiceqty);
            $this->db->where('id', $warehouseitem->id);
            $this->db->update('tblwarehousestock', $warehousestockdata);
        }
        // die;


         $data['vatpaid'] = str_replace(",", "",$data['vatpaid']);

        $this->db->insert('tblinvoices', $data);
        $insert_id = $this->db->insert_id();
    
     
        if ($insert_id) 
        {
            
            /*get customer ledger*/
            $this->db->select('ldg.*');
            $this->db->from('tblledgergroups as ldg');
            $this->db->join('tblclients as cl','cl.ledger = ldg.id');
            $this->db->where('cl.userid',$clientid);
            $ldgres = $this->db->get()->row();
            $cusledgrid = $ldgres->id;
            
            /*crerate voucher id*/
            $this->db->select_max('voucher');
            $this->db->where('vchtype', '8');
            $voucher = $this->db->get('tblvoucher')->row()->voucher;

            if($voucher){
                $voucher = ++$voucher;
            }else{
             $voucher ='INV0001';
            }
         
           /*calculate total*/
        
     
            $total = '';
            foreach ($items as $key => $item) {
               $total = ($total+($item['qty']*$item['rate']));
            }

  
            /*create voucer*/
            $this->db->insert('tblvoucher',array(
                 
                        'voucher'=>$voucher,
                        'vchtype'=>'8',
                        'invoiceid'=>$insert_id,
                        'docdate'=>$voucherdate,
                        'trxdate'=>$voucherdate,
                        'created_by'=> get_staff_user_id(),
                        'currency'=>'3',
                   
            ));

            $voucherid = $this->db->insert_id();
            $voucehrdata=array('vchid'=>$voucherid);
            $this->db->where('id',$insert_id);
          
           $this->db->update('tblinvoices', $voucehrdata);
           /*create top voucherline*/
		   $client=$this->get_client($data['clientid']);
		   $class=$this->get_client_class($data['clientid']);



            $this->load->model('settings_model');
            $default_options = $this->settings_model->getOptions();
		   
    		if($class->groupid==1) // 1 credit client , 2 master resseler , 3 General Retail 'debit)	
    		{
    			$this->db->select('id');
    			$this->db->where('accountid', $data['clientid']);
    			$ledger_id = $this->db->get('tblledgergroups')->row()->id;	
    			
    			// if(!$ledger_id){
    			// 	$data22["accountname"]=$client->accountname;
    			// 	$data22["groups_in"]=1;
    			// 	$ledger_id=$this->add_ledger_AR($data['clientid'],$data22);
    				
    				
    			// }

                $this->load->model('settings_model');
                $default_options = $this->settings_model->getOptions();
                // echo $default_options['sales_ledger'];
                // die;
                // $data['default_options'] = $default_options;
                
                // print_r($default_options['account_receivable']);
                // die;
                // print_r($ledger_id);
                // die;
    			
    		 	 $this->db->insert('tblvoucherlines',array(
                            // 'ledger'=>$ledger_id, //22
                            'ledger'=>$default_options['account_receivable'], 
                            'vchid'=>$voucherid,
                            'amount'=>$data['total'],
                            'description'=> $client->accountname,
                            'refrence'=>'',
                            'invoiceid'=>$invoicenumber,
                            'poid'=>'',
                            'item_order'=>'0',
    						'amount_type'=>0 // 0 debit ; 1 credit
                            ));
        		  if(($cusledgrid!=129)&&($ledger_id!=$cusledgrid))
                 $this->db->insert('tblvoucherlines',array(
                            // 'ledger'=>$cusledgrid,
                            'ledger'=>$default_options['sales_ledger'],
                            'vchid'=>$voucherid,
                            'amount'=>$data['subtotal'],
                            'description'=>'Automatic invoice journal',
                            'refrence'=>'',
                            'invoiceid'=>$invoicenumber,
                            'poid'=>'',
                            'item_order'=>'0',
    						'amount_type'=>1
                            ));
    		}
    		else
            {
                $this->db->insert('tblvoucherlines',array(
                        // 'ledger'=>$cusledgrid,
                        'ledger'=>$default_options['sales_ledger'],
                        'vchid'=>$voucherid,
                        'amount'=>$data['subtotal'],
                        'description'=>'Automatic invoice journal',
                        'refrence'=>'',
                        'invoiceid'=>$invoicenumber,
                        'poid'=>'',
                        'item_order'=>'0',
                        'amount_type'=>0
                        ));
            }
			
            //$mainvoucherlineid = $this->db->insert_id();
         
            if (isset($custom_fields)) {
                handle_custom_fields_post($insert_id, $custom_fields);
            }

            // Update next invoice number in settings
            $this->db->where('name', 'next_invoice_number');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
            update_invoice_status($insert_id);
          
            if (count($items) > 0) 
            {
                $i=1;
               // $taxtotal=$itemtotal=0;
                $discounts_ledger=array();
				$taxes_ledger=array();
                foreach ($items as $key => $item) 
                {
                    
                    $this->db->insert('tblinvoiceitems',array(
                        'sku'=>$item['sku'],
                        'description'=>$item['description'],
                        'disc'=>$item['disc'],
                        'qty'=>$item['qty'],
                        'itemorder_id'=>$item['itemorder_id'],
                        'rate'=>$item['rate'],
                        'taxid'=>$item['taxid'],
                        'invoiceid'=>$insert_id,
                        'item_order'=>$item['order'],
                        'itemid'=>$item['itemorder_id'],
                        ));
					 
					/* $this->db->where('id', $item['taxid']);
           			 $tax_table=$this->db->get('tbltaxes')->row();					 
                		if(!isset($tax_amount[$item['taxid']]))
							$tax_amount[$item['taxid']]=0;
						$sum=$item['qty']*$item['rate'];
						
   						$tax_amount[$item['taxid']]+=($sum/$tax_table["taxrate"] ) /100;*/
                     // $itemsledgrs =  $this->get_ledgerdetails($item['itemorder_id']);
                     // $itemtotal += '-'.($item['qty']*$item['rate']);
                     //   $this->db->insert('tblvoucherlines',array(
                     //       'ledger'=>$itemsledgrs->id,
                     //       'vchid'=>$voucherid,
                     //       'amount'=>'-'.($item['qty']*$item['rate']),
                     //       'description'=>'Automatic invoice journal',
                     //       'refrence'=>'',
                     //       'invoiceid'=>$invoicenumber,
                     //       'poid'=>'',
                     //       'item_order'=> $i,
                     //       ));
                     $i++; 
                     if($item['disc'] !='0'){
                      $this->db->where('id',$item['disc']);
                        $ledgerid = $this->db->get('tbldiscounts')->row();
                        $discamount = ($ledgerid->discountrate/100) * ($item['qty']*$item['rate']);
                        
                     }else{
                          $discamount = 0;
                     }
                        if($ledgerid && $discamount != '0'){
							if(!isset($discounts_ledger[$ledgerid->ledger]))
								$discounts_ledger[$ledgerid->ledger]=0;
							$discounts_ledger[$ledgerid->ledger]+=$discamount;
							
                            }
                     
                   if($item['taxid'] > '0'){
                      
                         $taxrate = $this->get_taxrate($item['taxid']);

                        if($taxrate){
                             $amount =  ($item['qty']*$item['rate']) - $discamount;
                            
                             $taxtotal += '-'.(($amount/100)*$taxrate->taxrate); 
                      	
							if($taxrate->ledger>0)
							{
								if(!isset($taxes_ledger[$taxrate->ledger]))
								$taxes_ledger[$taxrate->ledger]=0;
								$taxes_ledger[$taxrate->ledger]+=(($amount/100)*$taxrate->taxrate);
							
                           
							}
                            $i++; 
                        }
                   }
                }
            }
			foreach($discounts_ledger as $key=>$val)
			{
				   $this->db->insert('tblvoucherlines',array(
                                           'ledger'=>$key,
                                           'vchid'=>$voucherid,
                                           'amount'=>$val,
                                           'description'=>'Automatic invoice journal For Discount',
                                           'refrence'=>'',
                                           'invoiceid'=>$invoicenumber,
                                           'poid'=>'',
                                           'item_order'=> $i,
										   'amount_type'=>0
                                           ));
			}
			foreach($taxes_ledger as $key=>$val)
			{
				  $this->db->insert('tblvoucherlines',array(
                              'ledger'=>$key,
                              'vchid'=>$voucherid,
                              'amount'=>$val,
                              'description'=>'Automatic invoice journal For Tax',
                              'refrence'=>'',
                             'invoiceid'=>$invoicenumber,
                             'poid'=>'',
                              'item_order'=> $i,
							  'amount_type'=>1
                              ));
			}

            $cost = 0;
            // print_r($items);
            // die;
            foreach ($items as $key => $value) {
                $cost = $cost + $value['costprice'];
                      
            }
            // echo $cost;
            // die;
            $costprice =  array(
                              'ledger'=>$default_options['cost_of_goods_sold'],
                              'vchid'=>$voucherid,
                              'amount'=>$cost,
                              'description'=>'Cost of Goods Sold ',
                              'refrence'=>'',
                             'invoiceid'=>$invoicenumber,
                             'poid'=>'',
                              'item_order'=> $i,
                              'amount_type'=>0
                              );
            $this->db->insert('tblvoucherlines',$costprice);

            $inventoryprice =  array(
                            'ledger'=>$default_options['inventory_ledger'],
                            'vchid'=>$voucherid,
                            'amount'=>$cost,
                            'description'=>'Inventory',
                            'refrence'=>'',
                            'invoiceid'=>$invoicenumber,
                            'poid'=>'',
                            'item_order'=> $i,
                            'amount_type'=>1
                              );
            $this->db->insert('tblvoucherlines',$inventoryprice);

            // $this->db->insert_batch('tblvoucherlines',$cost);


            
			          
          //    if($data['discount_total'] > 0){

          //      $this->db->where('id',$data['discount_percent']);
          //      $ledgerid = $this->db->get('tbldiscounts')->row()->ledger;
          //      if($ledgerid){
          //          $this->db->insert('tblvoucherlines',array(
          //                         'ledger'=>$ledgerid,
          //                         'vchid'=>$voucherid,
          //                         'amount'=>$data['discount_total'],
          //                         'description'=>'Automatic invoice journal For Discount',
          //                         'refrence'=>'',
          //                         'invoiceid'=>$invoicenumber,
          //                         'poid'=>'',
          //                         'item_order'=> $i,
          //                         ));
          //          }
          //       }
                 
          //  $taxdiscountamount = abs(($taxtotal+$itemtotal+$data['discount_total']));
           
          // $this->db->query("UPDATE tblvoucherlines SET amount = $taxdiscountamount WHERE id =".$mainvoucherlineid);          
         

            if ($cron == false && $expense == false) {
                $this->log_invoice_activity($insert_id, 'created the invoice');
            } else if($cron == false && $expense == true){
                $this->log_invoice_activity($insert_id, 'converted to invoice from expense');
            } else if($cron == true && $expense == false) {
                $this->log_invoice_activity($insert_id, '[Recurring] Invoice created by CRON', true);
            } else {
                $this->log_invoice_activity($insert_id, '[Invoice From Expense] Invoice created by CRON', true);
            }

            do_action('after_invoice_added', $insert_id);
            return $insert_id;
        }

        return false;
    }

     public function get_term($id){
       $this->db->select('payment_term');
       $this->db->where('userid', $id);
      return  $this->db->get('tblclients')->row(); 


    }
       public function get_sales_agent($id){
       $this->db->select('account_req');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row()->account_req; 
    }
     public function due_days($id){
       $this->db->select('dueDays');
       $this->db->where('id', $id);
     return $this->db->get('tblinvoicepaymentsmodes')->row(); 

    }
    /**
     * Update invoice data
     * @param  array $data invoice data
     * @param  mixed $id   invoiceid
     * @return boolean
     */
    public function update($data, $id)
    {
          unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
          unset($data['creditlimit']);
          unset($data['itemrecorid']);
        $affectedRows = 0;
        $prefix       = get_option('invoice_prefix');

        $data['number'] = substr($data['number'], strlen($prefix));
        $data['number'] = trim($data['number']);

        if(get_option('invoice_number_format') == 2){
             $_temp_number = explode('/',$data['number']);
             $data['number'] = $_temp_number[1];
        }
        

        $original_invoice = $this->get($id);
        $original_number = $original_invoice->number;
$invoicenumber = format_invoice_number($original_number) ;
        unset($data['currency_symbol']);
        unset($data['price']);
        unset($data['taxname']);
        unset($data['taxid']);
        unset($data['isedit']);
        unset($data['sku']);
        unset($data['description']);
        unset($data['long_description']);
        unset($data['disc']);
        unset($data['tax']);
        unset($data['rate']);
        unset($data['quantity']);

        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }
 $clientid= $data['clientid'];
        if ($data['adjustment'] == 'NaN') {
            $data['adjustment'] = 0;
        }


        // uncheck sales agent if is not set so the dafault value in base will be NULL
        if($data['sale_agent'] == ''){
            $data['sale_agent'] = NULL;
        }

        // Since version 1.0.1
        if (isset($data['allowed_payment_modes'])) {
            $data['allowed_payment_modes'] = serialize($data['allowed_payment_modes']);
        } else {
            $data['allowed_payment_modes'] = serialize(array());
        }

         if(isset($data['terms'])){
          $data['terms']     = nl2br($data['terms']);
        }

        $data['date']    = to_sql_date($data['date']);
        $data['duedate'] = to_sql_date($data['duedate']);

        if(isset($data['custom_fields'])){
            $custom_fields = $data['custom_fields'];
            if(handle_custom_fields_post($id,$custom_fields)){
                $affectedRows++;
            }

            unset($data['custom_fields']);
        }

        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );
        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data                 = do_action('before_invoice_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems              = $_data['newitems'];
        $items                 = $_data['items'];
        $data                  = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                $original_item = $this->get_invoice_item($remove_item_id);
                $this->db->where('invoiceid', $id);
                $this->db->where('id', $remove_item_id);
                $this->db->delete('tblinvoiceitems');
                if ($this->db->affected_rows() > 0) {
                    $this->log_invoice_activity($id,'removed item <b>' . $original_item->description . '</b>');
                    $affectedRows++;
                }
            }
            unset($data['removed_items']);
        }

        $this->db->where('id', $id);
        $this->db->update('tblinvoices', $data);
   

        if ($this->db->affected_rows() > 0) {
            update_invoice_status($id);
            $affectedRows++;

              if($original_number != $data['number']){
                  $this->log_invoice_activity($original_invoice->id, 'Invoice Number Changed: From: ' . format_invoice_number($original_number) . ' To: ' . format_invoice_number($data['number']));
            }

        }
      
         $this->load->model('taxes_model');
        if (count($items) > 0) {
            foreach ($items as $key => $item) {
                $invoice_item_id = $item['itemid'];

                $original_item = $this->get_invoice_item($invoice_item_id);

                $this->db->where('id',$invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                      'item_order'=>$item['order'],
                ));
                if ($this->db->affected_rows() > 0) {
                     $affectedRows++;
                }
                // Check for invoice item short description change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                    'description'=>$item['description'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_invoice_activity($id,'updated item short description from ' . $original_item->description . ' to ' . $item['description']);
                    $affectedRows++;
                }

                // Check for item sku change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                    'sku'=> $item['sku']
                ));
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                    'disc'=>$item['disc']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_invoice_activity($id,'updated item Discount from ' . $original_item->sku . ' to ' . $item['disc']);
                    $affectedRows++;
                }
                // Check for tax id change
                $original_tax = $this->taxes_model->get($original_item->taxid);

                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                    'taxid'=>$item['taxid'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $tax_now = $this->taxes_model->get($item['taxid']);
                    if($original_tax){
                        if($tax_now){
                         $this->log_invoice_activity($id,'updated tax ('.$original_tax->name.') from ' . $original_tax->taxrate . '% to ('.$tax_now->name.') ' . $tax_now->taxrate.'%');
                     } else {
                         $this->log_invoice_activity($id,'removed tax ('.$original_tax->name.') ' . $original_tax->taxrate . '%');
                     }
                 } else {
                  $this->log_invoice_activity($id,'added tax ('.$tax_now->name.') '.$tax_now->taxrate . '%');
              }
              $affectedRows++;
          }

                // Check for item rate change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                    'rate'=>$item['rate'],
                ));
                if ($this->db->affected_rows() > 0) {
                    $this->log_invoice_activity($id,'updated item rate from ' . $original_item->rate . ' to ' . $item['rate']);
                    $affectedRows++;
                }
                // CHeck for invoice quantity change
                $this->db->where('id', $invoice_item_id);
                $this->db->update('tblinvoiceitems', array(
                    'qty' => $item['qty']
                ));

                if ($this->db->affected_rows() > 0) {
                    $this->log_invoice_activity($id,'updated quantity on item <b>' . $item['description'] . '</b> from ' . $original_item->qty . ' to ' . $item['qty']);
                    $affectedRows++;
                }
            }
        }
        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblinvoiceitems',array(
                    'sku'=>$item['sku'],
                    'description'=>$item['description'],
                    'disc'=>$item['disc'],
                    'qty'=>$item['qty'],
                    'itemorder_id'=>$item['itemorder_id'],
                    'rate'=>$item['rate'],
                    'taxid'=>$item['taxid'],
                    'invoiceid'=>$id,
                    'item_order'=>$item['order'],
                    'itemid'=>$item['itemorder_id'],
                    ));
                $new_item_added = $this->db->insert_id();
                if ($new_item_added) {
                    $this->log_invoice_activity($id,'added new item <b>' . $item['description'] . '</b>');
                    $affectedRows++;
                }
            }
        }
        /*voucher lines*/
        
        $temesarray = array_merge($items,$newitems);
     
        $vchid = $this->db->where('id',$id)->get('tblinvoices')->row()->vchid;
        $this->db->where('vchid',$vchid)->delete('tblvoucherlines');
    
           $this->db->select('ldg.*');
        $this->db->from('tblledgergroups as ldg');
        $this->db->join('tblclients as cl','cl.ledger = ldg.id');
        $this->db->where('cl.userid',$clientid);
        $ldgres = $this->db->get()->row();
        $cusledgrid = $ldgres->id;
       
         $this->db->insert('tblvoucherlines',array(
                        'ledger'=>$cusledgrid,
                        'vchid'=>$vchid,
                        'amount'=>$data['total'],
                        'description'=>'Automatic invoice journal',
                        'refrence'=>'',
                        'invoiceid'=>$invoicenumber,
                        'poid'=>'',
                        'item_order'=>'0',
                        ));
         
         $this->db->insert('tblvoucherlines',array(
                        'ledger'=>'22',
                        'vchid'=>$vchid,
                        'amount'=>$data['total'],
                        'description'=>'Automatic invoice journal',
                        'refrence'=>'',
                        'invoiceid'=>$invoicenumber,
                        'poid'=>'',
                        'item_order'=>'0',
                        ));
        
             if (count($temesarray) > 0) {
                $i=1;
//                $taxtotal=$itemtotal=0;
                
                foreach ($temesarray as $key => $item) {
            
                  $itemsledgrs =  $this->get_ledgerdetails($item['itemorder_id']);
          
//                  $itemtotal += '-'.($item['qty']*$item['rate']);
//                    $this->db->insert('tblvoucherlines',array(
//                        'ledger'=>$itemsledgrs->id,
//                        'vchid'=>$vchid,
//                        'amount'=>'-'.($item['qty']*$item['rate']),
//                        'description'=>'Automatic invoice journal',
//                        'refrence'=>'',
//                        'invoiceid'=>$invoicenumber,
//                        'poid'=>'',
//                        'item_order'=> $i,
//                        ));
        
                     $i++; 
                     if($item['disc'] !='0'){
                      $this->db->where('id',$item['disc']);
                        $ledgerid = $this->db->get('tbldiscounts')->row();
                        $discamount = ($ledgerid->discountrate/100) * ($item['qty']*$item['rate']);
                        
                     }else{
                          $discamount = 0;
                     }
                        if($ledgerid && $discamount != '0'){
//                            $this->db->insert('tblvoucherlines',array(
//                                           'ledger'=>$ledgerid->ledger,
//                                           'vchid'=>$vchid,
//                                           'amount'=>$discamount,
//                                           'description'=>'Automatic invoice journal For Discount',
//                                           'refrence'=>'',
//                                           'invoiceid'=>$invoicenumber,
//                                           'poid'=>'',
//                                           'item_order'=> $i,
//                                           ));
                            }
                     
                   if($item['taxid'] > '0'){
                      
                         $taxrate = $this->get_taxrate($item['taxid']);

                        if($taxrate){
                             $amount =  ($item['qty']*$item['rate']) - $discamount;
                            
//                             $taxtotal += '-'.(($amount/100)*$taxrate->taxrate); 
                         
//                             $this->db->insert('tblvoucherlines',array(
//                              'ledger'=>$taxrate->ledger,
//                              'vchid'=>$vchid,
//                              'amount'=>'-'.(($amount/100)*$taxrate->taxrate),
//                              'description'=>'Automatic invoice journal For Tax',
//                              'refrence'=>'',
//                              'invoiceid'=>$invoicenumber,
//                              'poid'=>'',
//                              'item_order'=> $i,
//                              ));

                            $i++; 
                        }
                   }
                }
            }
            
        if ($affectedRows > 0) {
            do_action('after_invoice_updated', $id);
            return true;
        }

        return false;
    }

    public function get_attachments($invoiceid, $id = ''){

        // If is passed id get return only 1 attachment
        if(is_numeric($id)){
            $this->db->where('id',$id);
        } else {
            $this->db->where('invoiceid',$invoiceid);
        }

        $result = $this->db->get('tblinvoiceattachments');
        if(is_numeric($id)){
            return $result->row();
        } else {
            return $result->result_array();
        }
    }
    /**
     *  Delete invoice attachment
     * @since  Version 1.0.4
     * @param   mixed $id  attachmentid
     * @return  boolean
     */
    public function delete_attachment($id){
        $attachment = $this->get_attachments('',$id);
        if($attachment){
            if(unlink(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid . '/' . $attachment->file_name)){
                $this->db->where('id',$id);
                $this->db->delete('tblinvoiceattachments');
                $other_attachments = list_files(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid);
                if(count($other_attachments) == 0){
                // delete the dir if no other attachments found
                    delete_dir(INVOICE_ATTACHMENTS_FOLDER . $attachment->invoiceid);
                }
            }

            return true;

        }
        return false;
    }
    /**
     * Delete invoice items and all connections
     * @param  mixed $id invoiceid
     * @return boolean
     */
    public function delete($id)
    {

        if (get_option('delete_only_on_last_invoice') == 1) {
            if (!is_last_invoice($id)) {
                return false;
            }
        }

        do_action('before_invoice_deleted', $id);
        $this->db->where('id', $id);
        $this->db->delete('tblinvoices');

        if ($this->db->affected_rows() > 0) {
            // Check if is invoice from expense
            $this->db->where('invoiceid',$id);
            $is_expense_invoice = $this->db->get('tblexpenses')->row();
            if($is_expense_invoice){
                $this->db->where('id',$is_expense_invoice->id);
                $this->db->update('tblexpenses',array('invoiceid'=>NULL));
            }
            if (get_option('invoice_number_decrement_on_delete') == 1) {
                $current_next_invoice_number = get_option('next_invoice_number');
                if ($current_next_invoice_number > 1) {
                    // Decrement next invoice number to
                    $this->db->where('name', 'next_invoice_number');
                    $this->db->set('value', 'value-1', FALSE);
                    $this->db->update('tbloptions');
                }
            }
            $this->db->where('invoiceid', $id);
            $this->db->delete('tblinvoiceitems');

            $this->db->where('invoiceid', $id);
            $this->db->delete('tblinvoicepaymentrecords');

            $this->db->where('invoiceid', $id);
            $this->db->delete('tblinvoiceactivity');

            // Delete the custom field values
            $this->db->where('relid',$id);
            $this->db->where('fieldto','invoice');
            $this->db->delete('tblcustomfieldsvalues');

            return true;
        }
        return false;
    }
    /**
     * Set invoice to sent when email is successfuly sended to client
     * @param mixed $id invoiceid
     * @param  mixed $cron is request coming from cron
     * @param  mixed $manually is staff manualy marking this invoice as sent
     * @return  boolean
     */
    public function set_invoice_sent($id, $cron = false,$manually = false)
    {
        $this->db->where('id', $id);
        $this->db->update('tblinvoices', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $marked = false;
        if($this->db->affected_rows() > 0){
            $marked = true;
        }
        if ($cron == true) {
            $description = 'Invoice sent to client by CRON';
        } else {
            if($manually == false){
               $description = get_staff_full_name() . ' sent invoice to client';
            } else {
              $description = get_staff_full_name() . ' marked invoice as sent';
            }
        }
        $this->log_invoice_activity($id, $description, $cron);

        return $marked;
    }
    /**
     * Sent overdue notice to client for this invoice
     * @since  Since Version 1.0.1
     * @param  mxied  $id   invoiceid
     * @param  boolean $cron is request from cron
     * @return boolean
     */
    public function send_invoice_overdue_notice($id, $cron = false)
    {

        $this->load->model('emails_model');
        $invoice = $this->get($id);

        $invoice_number = format_invoice_number($invoice->number);
        $pdf            = invoice_pdf($invoice);
        $attach         = $pdf->Output($invoice_number . '.pdf', 'S');
        $this->emails_model->add_attachment($attach, $invoice_number . '.pdf', 'application/pdf');
        $send = $this->emails_model->send_email_template('invoice-overdue-notice', $invoice->client->email, $invoice->clientid, $id);

        if ($send) {
            if ($cron == true) {
                $_from = '[CRON]';
            } else {
                $_from = get_staff_full_name();
            }
            $this->db->where('id', $id);
            $this->db->update('tblinvoices', array(
                'last_overdue_reminder' => date('Y-m-d')
            ));

            $this->log_invoice_activity($id, _l('user_sent_overdue_reminder', $_from), $cron);
            return true;
        }

        return false;
    }

    /**
     * Sent invoice to client
     * @param  mixed  $id        invoiceid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach invoice pdf or not
     * @param  boolean $cron      is request coming from cron
     * @return boolean
     */
    public function sent_invoice_to_client($id, $template = '', $attachpdf = true, $cron = false)
    {

        $this->load->model('emails_model');
        $invoice = $this->get($id);
        if ($template == '') {
            if ($invoice->sent == 0) {
                $template = 'invoice-send-to-client';
            } else {
                $template = 'invoice-already-send';
            }
        }

        $invoice_number = format_invoice_number($invoice->number);
        $pdf            = invoice_pdf($invoice);

        if ($attachpdf) {
            $attach = $pdf->Output(APPPATH.'PDF/'.$invoice_number . '.pdf', 'F');
            $attachmentfile = APPPATH.'PDF/'.$invoice_number . '.pdf';
            $this->emails_model->add_attachment($attachmentfile, $invoice_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $invoice->client->email, $invoice->clientid, $id);
        if ($send) {
            $this->set_invoice_sent($id, $cron);
            return true;
        }

        return false;
    }
    /**
     * All invoice activity
     * @param  mixed $id invoiceid
     * @return array
     */
    public function get_invoice_activity($id)
    {
        $this->db->where('invoiceid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblinvoiceactivity')->result_array();
    }
    /**
     * Log invoice activity to database
     * @param  mixed $id   invoiceid
     * @param  string $description activity description
     */
    public function log_invoice_activity($id, $description = '', $cron = false, $client = false)
    {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblinvoiceactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'invoiceid' => $id,
            'staffid' => $staffid
        ));
    }
    
function get_prev($id){
   return $this->db->query("select id,clientid from tblinvoices where id = (select max(id) from tblinvoices where id < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select id,clientid from tblinvoices where id = (select min(id) from tblinvoices where id > $id)")->row();
}
function change_invoice_status($status,$id){

    // $this->load->model('settings_model');
    // $default_options = $this->settings_model->getOptions();

    // $invoice_id = $this->db->query("select id,number from tblinvoices where id =  $id")->row();


    // $this->db->select('tblvoucherlines.*');
    // $this->db->from('tblvoucherlines');
    // $this->db->join('tblvoucher', 'tblvoucher.vchid = tblvoucherlines.vchid');
    // $this->db->join('tblinvoices', 'tblinvoices.id = tblvoucher.invoiceid');
    // $this->db->where('tblvoucher.invoiceid', $invoice_id->id);
    // $this->db->where('tblvoucherlines.ledger', $default_options['cost_of_goods_sold']);
    // $invoice_number = $this->db->get()->result();

    // // $invoice_number = $this->db->query("select * from tblvoucherlines where invoiceid = 'INV-0".$invoice_id->number."' AND ledger = 69 ")->result();

    //     if($status == 2)
    //     {

    //         $cost = array();
    //             foreach ($invoice_number as $key => $value) {
    //                        $cost[] =  array(
    //                               'ledger'=>$default_options['inventory_ledger'],
    //                               'vchid'=>$value->vchid,
    //                               'amount'=>$value->amount,
    //                               'description'=>'Inventory',
    //                               'refrence'=>$value->refrence,
    //                              'invoiceid'=>$value->invoiceid,
    //                              'poid'=>$value->poid,
    //                               'item_order'=> $value->item_order,
    //                               'amount_type'=>1
    //                               );
    //             }
    //             $this->db->insert_batch('tblvoucherlines',$cost);
    //     }

       $this->db->where('id', $id);
        return $this->db->update('tblinvoices', array('status' => $status));

    }
    public function update_credit($amount,$id){
        $amount = str_replace(',','',$amount);
       $this->db->query("UPDATE tblclients SET credit_limit = credit_limit + $amount WHERE userid =".$id);
    }

    public function getinvoices($id) {
       return   $this->db->select_sum('total')->where('status !=','2')->where('clientid',$id)->get('tblinvoices')->row();
    }
    public function getorders($id) {
       return   $this->db->select_sum('total')->where('clientid',$id)->get('tblorders')->row();
    }
    public function getcredit($id) {
       return   $this->db->where('userid',$id)->get('tblclients')->row();
    }
    public function get_discount($id){
         return   $this->db->where('id',$id)->get('tbldiscounts')->row()->discountrate;  
    }
}