<?php
ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Invoice_items_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get invoice item by ID
     * @param  mixed $id
     * @return mixed - array if not passed id, object if id passed
     */

    public function items($value='')
    {
        $this->db->select('tblinvoiceitemslist.id,tblinvoiceitemslist.description,tblinvoiceitemslist.sku,tblinvoiceitemslist.manufacturersku,tblinvoiceitemslist.salesprice,tblinvoiceitemslist.costprice,tblinvoiceitemslist.purchase_tax_id');
        $this->db->from('tblinvoiceitemslist');
       // $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.tax', 'left outer');
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        // $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblrfqsqouteitems.orderid');
        
        // $this->db->where('tblrfqsqoutes.status',3);
        // $this->db->group_by('tblrfqsqouteitems.oursku'); 
		$items0 = $this->db->get()->result();
	
		foreach($items0 as $item)
        {
			 $this->db->select("tbltaxes.taxrate");
			$this->db->from('tbltaxes');
			$this->db->where('tbltaxes.id',$item->purchase_tax_id);
			$items2 = $this->db->get()->row();
			if(isset($items2->taxrate))
			$item->purchase_taxe=$items2->taxrate;
			else
			$item->purchase_taxe=0;
			$items[]=$item;
			
		}
		if(isset($items))
        	return $items;
		else
			return $items0;
        // echo "<pre>";
        // print_r($items);
        // die;
    }
    public function warehouse_items($value='')
    {
        $this->db->select('tblwarehouse.*');
        $this->db->from('tblwarehouse');
        // $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.ware_id = tblwarehouse.ware_id');
        
        // $this->db->where('tblwarehouse.status',3);
        // $this->db->group_by('tblwarehouse.ware_id'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function on_hold($value='')
    {
        $this->db->select('tblrfqsqoutes.status,tblrfqsqouteitems.suppliersku,tblrfqsqouteitems.oursku,sum(tblrfqsqouteitems.qty)as total_qty');
        $this->db->from('tblrfqsqoutes');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.orderid = tblrfqsqoutes.id');
        
        $this->db->where('tblrfqsqoutes.status',3);
        $this->db->group_by('tblrfqsqouteitems.oursku'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function warehouse_on_hold($oursku)
    {
        $this->db->select('tblrfqsqoutes.status,tblrfqsqouteitems.suppliersku,tblrfqsqouteitems.oursku,sum(tblrfqsqouteitems.qty)as total_qty,tblrfqsqoutes.warehouse');
        $this->db->from('tblrfqsqoutes');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.orderid = tblrfqsqoutes.id');
        // $this->db->join('tblwarehouse', 'tblwarehouse.ware_id = tblrfqsqoutes.warehouse');
        
        $this->db->where('tblrfqsqoutes.status',3);
        $this->db->where('tblrfqsqouteitems.oursku',$oursku);
        $this->db->group_by('tblrfqsqoutes.warehouse'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function on_order($value='')
    {
        $this->db->select('tblpurchaseorders.status,tblpurchaseorderitems.sku,tblpurchaseorderitems.oursku,sum(tblpurchaseorderitems.qty)as total_qty');
        $this->db->from('tblpurchaseorders');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        // $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id');
        $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        $this->db->where('tblpurchaseorders.status',3);
        $this->db->group_by('tblpurchaseorderitems.oursku'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }


    public function warehouse_on_order($oursku)
    {
        $this->db->select('tblpurchaseorders.status,tblpurchaseorderitems.sku,tblpurchaseorderitems.oursku,sum(tblpurchaseorderitems.qty)as total_qty,tblrfqsqoutes.warehouse');
        $this->db->from('tblpurchaseorders');
        
        $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id','Left');
        $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        $this->db->where('tblpurchaseorders.status',3);
        $this->db->where('tblpurchaseorderitems.oursku',$oursku);
        $this->db->group_by('tblrfqsqoutes.warehouse');  
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function warehouse_in_transit($oursku)
    {
        $this->db->select('tblpurchaseorders.status,tblpurchaseorderitems.sku,tblpurchaseorderitems.oursku,sum(tblpurchaseorderitems.qty)as total_qty,tblrfqsqoutes.warehouse');
        $this->db->from('tblpurchaseorders');

        $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id','Left');
        $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        $this->db->where('tblpurchaseorders.status',4);
        $this->db->where('tblpurchaseorderitems.oursku',$oursku);
        $this->db->group_by('tblrfqsqoutes.warehouse');
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function in_transit($value='')
    {
        $this->db->select('tblpurchaseorders.status,tblpurchaseorderitems.sku,tblpurchaseorderitems.oursku,sum(tblpurchaseorderitems.qty)as total_qty');
        $this->db->from('tblpurchaseorders');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        // $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id','Left');
        $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        $this->db->where('tblpurchaseorders.status',4);
        $this->db->group_by('tblpurchaseorderitems.oursku'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }


    public function warehouse_received($oursku)
    {
        // $this->db->select('tblpurchaseorders.status,tblpurchaseorderitems.sku,tblpurchaseorderitems.oursku,sum(tblpurchaseorderitems.qty)as total_qty,tblrfqsqoutes.warehouse');
        // $this->db->from('tblpurchaseorders');
        
        // $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id','Left');
        // $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        // $this->db->where('tblpurchaseorders.status',5);
        // $this->db->where('tblpurchaseorderitems.oursku',$oursku);
        // $this->db->group_by('tblrfqsqoutes.warehouse');
        // return $items = $this->db->get()->result();


        $this->db->select('tblwarehousestock.oursku,tblwarehousestock.suppliersku,sum(tblwarehousestock.qty)as total_qty,tblwarehousestock.warehouse_id as warehouse');
        $this->db->from('tblwarehousestock');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        
        $this->db->where('tbllocations.default_location',1);
        $this->db->where('tblwarehousestock.oursku',$oursku);
        $this->db->group_by('tblwarehousestock.warehouse_id'); 

        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function received($value='')
    {
        // $this->db->select('tblpurchaseorders.status,tblpurchaseorderitems.sku,tblpurchaseorderitems.oursku,sum(tblpurchaseorderitems.qty)as total_qty');
        // $this->db->from('tblpurchaseorders');
        
        // // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku');
        // // $this->db->join('tblrfqsqoutes', 'tblrfqsqoutes.id = tblpurchaseorders.rfq_id');
        // $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        // $this->db->where('tblpurchaseorders.status',5);
        // $this->db->group_by('tblpurchaseorderitems.oursku'); 
        // return $items = $this->db->get()->result();

        $this->db->select('tblwarehousestock.oursku,tblwarehousestock.suppliersku,sum(tblwarehousestock.qty)as total_qty');
        $this->db->from('tblwarehousestock');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        
        $this->db->where('tbllocations.default_location',1);
        $this->db->group_by('tblwarehousestock.oursku'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function warehouse_available($oursku)
    {
        $this->db->select('tblwarehousestock.oursku,tblwarehousestock.suppliersku,sum(tblwarehousestock.qty)as total_qty,tblwarehousestock.warehouse_id as warehouse');
        $this->db->from('tblwarehousestock');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        
        $this->db->where('tbllocations.default_location',2);
        $this->db->where('tblwarehousestock.oursku',$oursku);
        $this->db->group_by('tblwarehousestock.warehouse_id'); 

        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function get_all_item($id) {
        $this->db->select('tblinvoiceitemslist.*');
        $this->db->from('tblinvoiceitemslist');
        $this->db->where('tblinvoiceitemslist.id !=', $id);
        $this->db->where('tblinvoiceitemslist.show_in_eview', 1);
        return $this->db->get()->result();
    }

    public function available($value='')
    {
        $this->db->select('tblwarehousestock.oursku,tblwarehousestock.suppliersku,sum(tblwarehousestock.qty)as total_qty');
        $this->db->from('tblwarehousestock');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        
        $this->db->where('tbllocations.default_location',2);
        $this->db->group_by('tblwarehousestock.oursku'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }   

    public function on_hold_item($suppliersku)
    {
	    $this->db->select('sum(tblrfqsqouteitems.qty)as total_qty');
        $this->db->from('tblrfqsqoutes');
        $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.orderid = tblrfqsqoutes.id');
        $this->db->where('tblrfqsqoutes.status',3);
        $this->db->group_by('tblrfqsqouteitems.suppliersku'); 
        $this->db->where('tblrfqsqouteitems.suppliersku',$suppliersku); 
     //  $this->db->last_query();
	
	    return $items = $this->db->get()->row();
              // die;
        // echo "<pre>";
        // print_r($items);
        // die;
    }
	public function on_hold_item_sku($sku)
    {
        $this->db->select('sum(tblrfqsqouteitems.qty)as total_qty');
        $this->db->from('tblrfqsqoutes');
        $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.orderid = tblrfqsqoutes.id');
        $this->db->where('tblrfqsqoutes.status',3);
        $this->db->group_by('tblrfqsqouteitems.suppliersku'); 
        $this->db->where('tblrfqsqouteitems.oursku',$sku); 
        return $items = $this->db->get()->row();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }
    public function received_item($suppliersku)
    {
        $this->db->select('sum(tblwarehousestock.qty)as total_qty');
        $this->db->from('tblwarehousestock');
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        $this->db->where('tbllocations.default_location',1);
        $this->db->group_by('tblwarehousestock.oursku'); 
        $this->db->where('tblwarehousestock.suppliersku',$suppliersku);
        return $items = $this->db->get()->row();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }
	public function received_item_sku($sku)
    {
        $this->db->select('sum(tblwarehousestock.qty)as total_qty');
        $this->db->from('tblwarehousestock');
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        $this->db->where('tbllocations.default_location',1);
        $this->db->group_by('tblwarehousestock.oursku'); 
        $this->db->where('tblwarehousestock.oursku',$sku);
        return $items = $this->db->get()->row();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }


    public function available_item($suppliersku)
    {
        $this->db->select('sum(tblwarehousestock.qty)as total_qty');
        $this->db->from('tblwarehousestock');
		
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        $this->db->where('tbllocations.default_location',2);
        $this->db->group_by('tblwarehousestock.oursku'); 
        $this->db->where('tblwarehousestock.suppliersku',$suppliersku);
        return $items = $this->db->get()->row();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    } 
	public function available_item_sku($oursku)
    {
        $this->db->select('sum(tblwarehousestock.qty)as total_qty');
        $this->db->from('tblwarehousestock');
		
        $this->db->join('tbllocations', 'tbllocations.location_id = tblwarehousestock.location_id');
        $this->db->where('tbllocations.default_location',2);
        $this->db->group_by('tblwarehousestock.oursku'); 
        $this->db->where('tblwarehousestock.oursku',$oursku);
        return $items = $this->db->get()->row();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    } 
    public function get_rfq_count($oursku)
    {
        $this->db->select('tblrfqsqouteitems.id');
        $this->db->from('tblrfqsqouteitems');
        $this->db->where('tblrfqsqouteitems.oursku',$oursku);
        $items = $this->db->get();
        return $items->num_rows();        
    }

    public function get_po_count($oursku)
    {
        $this->db->select('tblpurchaseorderitems.id');
        $this->db->from('tblpurchaseorderitems');
        $this->db->where('tblpurchaseorderitems.oursku',$oursku);
        $items = $this->db->get();
        return $items->num_rows();        
    }

    public function get_invoice_count($sku)
    {
        $this->db->select('tblinvoiceitems.id');
        $this->db->from('tblinvoiceitems');
        $this->db->where('tblinvoiceitems.sku',$sku);
        $items = $this->db->get();
        return $items->num_rows();        
    }

    public function item_supplier($oursku)
    {
        $this->db->select('tblsuppliers.supplier,tblcountries.short_name,tblsuppliers.phonenumber,tblsuppliers.email,tblsuppliers.active,tblsuppliers.userid');
        $this->db->from('tblsuppliers');
        
        // $this->db->join('tblrfqsqouteitems', 'tblrfqsqouteitems.oursku = tblinvoiceitemslist.manufacturersku','Left');
        $this->db->join('tblcountries', 'tblcountries.country_id = tblsuppliers.country');
        $this->db->join('tblpurchaseorders', 'tblpurchaseorders.supplierid = tblsuppliers.userid');
        $this->db->join('tblpurchaseorderitems', 'tblpurchaseorderitems.orderid = tblpurchaseorders.id');
        
        $this->db->where('tblpurchaseorderitems.oursku',$oursku);
        $this->db->group_by('tblsuppliers.userid'); 
        return $items = $this->db->get()->result();
        
        // echo "<pre>";
        // print_r($items);
        // die;
    }

    public function get($id = '') {
        $this->db->select('tblinvoiceitemslist.id as itemid ,tblinvoiceitemslist.allow_discount,tblinvoiceitemslist.discounts,salesprice,tblinvoiceitemslist.costprice,taxrate,tbltaxes.id as taxid,tbltaxes.name as taxname,tblinvoiceitemslist.description,long_description,sku,manufacturersku,unitofmeasure');
        $this->db->from('tblinvoiceitemslist');
        // $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.tax', 'left');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.purchase_tax_id', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        if (is_numeric($id)) {
            $this->db->where('tblinvoiceitemslist.id', $id);
            return $this->db->get()->row();
        }
        return $this->db->get()->result_array();
    }

    public function get_sale($id = '') {
        $this->db->select('tblinvoiceitemslist.id as itemid ,tblinvoiceitemslist.itemtype,tblinvoiceitemslist.allow_discount,tblinvoiceitemslist.discounts,salesprice,tblinvoiceitemslist.costprice,taxrate,tbltaxes.id as taxid,tbltaxes.name as taxname,tblinvoiceitemslist.description,long_description,sku,manufacturersku,unitofmeasure');
        $this->db->from('tblinvoiceitemslist');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.tax', 'left');
        // $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.purchase_tax_id', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        if (is_numeric($id)) {
            $this->db->where('tblinvoiceitemslist.id', $id);
            return $this->db->get()->row();
        }
        return $this->db->get()->result_array();
    }

	public function get_sku($sku = '') {


        // $this->db->select('tblinvoiceitemslist.*');

        $this->db->select('tblinvoiceitemslist.id as itemid ,tblinvoiceitemslist.allow_discount,tblinvoiceitemslist.discounts,salesprice,taxrate,tbltaxes.id as taxid,tbltaxes.name as taxname,tblinvoiceitemslist.description,long_description,sku,manufacturersku,unitofmeasure');
        $this->db->from('tblinvoiceitemslist');
        // $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.tax', 'left');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.purchase_tax_id', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        if ($sku) {
            // $this->db->where('tblinvoiceitemslist.sku', $sku);
            $this->db->where('tblinvoiceitemslist.manufacturersku', $sku);
            return $this->db->get()->row();
            // echo "<pre>";
            // print_r($result);
        }
            // die;
        // print_r($this->db->last_query());
        // die;
        return $this->db->get()->result_array();
    }
	function get_prev_groups2($id=0) {
       
		//$this->db->where('type', 'Ledger');
		$this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
		$subgoups=array();
		foreach($tabl as $ta)
		{			
			
        	$ta->subgroups= $this->get_prev_groups2($ta->id);
			$ta->exists=false;
			foreach($ta->subgroups as $gr )			
			if(($gr->type!="Group")||($gr->exists))
			{
				$ta->exists=true;
				break;
				
			}
			if(($ta->type!="Group")||($ta->exists))
			{
				$ta->exists=true;
				$subgoups[]=$ta;
				
			}
			
			
		}
		
		return $subgoups;
    }
    public function get_ledgers() {
        return $this->db->where('type', 'Ledger')->order_by('name', 'ASC')->get('tblledgergroups')->result();
    }
    // public function get_ledgers($id = false, $active = '')
    // {
    //     if (is_int($active)) {
    //         $this->db->where('active', $active);
    //     }

    //     if (is_numeric($id)) {
    //         $this->db->where('id', $id);
    //         $client = $this->db->get('tblledgergroups')->row();
    //         echo($client);

    //         return $client;
    //     }


    //     return $this->db->get('tblledgergroups')->result_array();
    // }

    function get_prev_ledgers(){
        return $this->get_prev_groups(0);
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblledgergroups')->result();   
    }

    function get_prev_groups($id=0) {
     //  $this->db->where('type', 'Group');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups($ta->id);
            $subgoups[]=$ta;
            
        }
        
        return $subgoups;
    }
    public function get_item_componant($id){
          return $this->db->where('id', $id)->order_by('id', 'ASC')->get('tblinvoiceitemslist')->row();
    }

    /**
     * Add new invoice item
     * @param array $data Invoice item data
     * @return boolean
     */

    public function get_location($ware_id)
    {
        return $this->db->where('ware_id',$ware_id)->order_by('location_id','ASC')->get('tbllocations')->result(); 
    }

    public function add($data) {
     //  echo "<pre>";
       // print_r($data);
       //  die;

        unset($data['itemid']);
      //  unset($data['sales']);
      //  unset($data['inventory']);
      //  unset($data['cogs']);
        unset($data['action']);
        unset($data['isedit']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
       // unset($data['allow_discount']);

        if ($data['tax'] == '') {
            unset($data['tax']);
        }

        if ($data['purchase_tax_id'] == '') {
            unset($data['purchase_tax_id']);
        }

        if (!isset($data['show_in_eview'])) {
            $data['show_in_eview'] = 0;
        }
		//print_r($data);
        $data['discounts'] = serialize($data['discounts']);

        $this->db->query("SET FOREIGN_KEY_CHECKS = 0");
        $this->db->insert('tblinvoiceitemslist', $data);
        $insert_id = $this->db->insert_id();
        $this->db->query("SET FOREIGN_KEY_CHECKS = 1");
        if ($insert_id) {
              $invoiceitem = $this->get_where_single_tbl('tblinvoiceitemslist','id',$insert_id);
           // if($invoiceitem->subcategory < 1){
                $led =$this->get_category_ledgers('tblcategories',$invoiceitem->category);
            /* }  else{
                 $led =$this->get_category_ledgers('tblsubcategories',$invoiceitem->subcategory);
             }*/
			
		/*
			 $this->db->where('id', $insert_id);
				$this->db->update('tblinvoiceitemslist', array(
					'ledger' =>$led->sales,
					'sales' =>$led->sales,
					'inventory' =>$led->inventory,
					'cogs' =>$led->cogs
				)); */ 
	
              
           //   $this->update_item_cat($data['category'], $insert_id);
           //sales, inventory, cogs
            $this->load->helper('polaris_upload');
            handle_item_upload($insert_id);
            // handle_eviewitemupload($insert_id);
            
        }
       
           
        if ($insert_id) {
            logActivity('New Invoice Item Added [ID:' . $insert_id . ', ' . $data['description'] . ']');
            return $insert_id;
        }

        return false;
    }

    /**
     * Update invoiec item
     * @param  array $data Invoice data to update
     * @return boolean
     */
    public function edit($data) {

        $itemid = $data['itemid'];
        unset($data['itemid']);
        $this->db->where('id', $itemid);
        $this->db->update('tblinvoiceitemslist', $data);


        if ($this->db->affected_rows() > 0) {
            logActivity('Invoice Item Updated [ID: ' . $itemid . ', ' . $data['description'] . ']');
            return true;
        }

        return false;
    }

    public function change_discount_status($id, $status) {

        $this->db->where('id', $id);
        $this->db->update('tblinvoiceitemslist', array(
            'allow_discount' => $status
        ));
    }
    public function update_item($ledger,$id){
      $this->db->where('id', $id);
        $this->db->update('tblinvoiceitemslist', array(
            'ledger' => $ledger
        ));  
    }

    public function update_item_cat($cat, $id){
        $category = $this->db->get_where("tblcategories", array("id", $cat))->row_array();
        $this->db->where('id', $id);
        $this->db->update('tblinvoiceitemslist', array(
            'sales' => $category['sales'],
            'inventory' => $category['inventory'],
            'cogs' => $category['cogs'],
        ));  
    }

    public function get_category_ledgers($table, $id) {
        if ($table == 'tblcategories') {
            return $this->db->where_in('category_id', $id)->get('tblcategories')->row();
        } else {
            return $this->db->where_in('subcategory_id', $id)->get('tblsubcategories')->row();
        }
    }

    public function changestatus() {

//            $row = $this->db->where('id',$this->input->post('id'))->get('tbldiscounts')->row();
//           if($row->allow == '0'){
//                $data =array('allow'=>1);
//                $this->db->where('id', $this->input->post('id'));
//                $this->db->update('tbldiscounts', $data);
//           }
//           if($row->allow == '1'){
//                $data =array('allow'=>0);
//                $this->db->where('id', $this->input->post('id'));
//                $this->db->update('tbldiscounts', $data);
//           }
        $data = array('discounts' => serialize($this->input->post('discounts')));
        $this->db->where('id', $this->input->post('itemid'));
        $this->db->update('tblinvoiceitemslist', $data);
    }
       public function addcomponants() {
         // echo "<pre>";
        // print_r($data);
        // die;
        
        foreach ($this->input->post('components') as $key => $value) {
			$pos=$this->input->post('quantity');
            $update_qty = array('quantity' => $pos[$key] );

            $this->db->where('id', $value);
            $this->db->update('tblinvoiceitemslist', $update_qty);
        }
        
        $data = array(
                'components' => serialize($this->input->post('components')),
                'qtycomponent' => serialize($this->input->post('quantity')),
                );
       
        $this->db->where('id', $this->input->post('itemid'));
        $this->db->update('tblinvoiceitemslist', $data);
        return true;
    }
	 public function addcomponantsinstruction() {
        
        $data = array(
                'assembly_description' => $this->input->post('assembly_description'),
                );
       
        $this->db->where('id', $this->input->post('itemid'));
        $this->db->update('tblinvoiceitemslist', $data);
        return true;
    }
    public function get_unitofmeasure($id){
         return $this->db->where('id', $id)->get('tblunitsofmeasure')->row()->name;
    }

    function get_discount($data, $allow) {

        if ($allow > 0) {
            if ($data) {
                $res = $this->db->where_in('id', $data)->get('tbldiscounts')->result();
            } else {
                $res = array();
            }
            $options = '<option value="0" data-text="0">0%</option>';
            foreach ($res as $value) {
                $options .= '<option value="' . $value->id . '" data-text="' . $value->discountrate . '">' . $value->discountrate . '%</option>';
            }
        } else {
            $options = '<option value="0" data-text="0">0%</option>';
        }
        return $options;
    }
    function getunitofmeasure($id){
             $res = $this->db->get('tblunitsofmeasure')->result();
               $options = '<option value="0" data-text="0"></option>';
             foreach ($res as $value) {
                     $selected='';
                 if($id == $value->id){
                     $selected="selected";
                 }
                $options .= '<option '.$selected.' value="' . $value->id . '" data-text="' . $value->name . '">' . $value->name . '</option>';
             } 
             return $options;
    }

    /**
     * Delete invoice item
     * @param  mixed $id
     * @return boolean
     */
    public function delete($id) {

        $this->db->select('tblinvoiceitems_eview.*');
        $this->db->from('tblinvoiceitems_eview');
        $this->db->where('tblinvoiceitems_eview.invoiceitems_id', $id);
        $eview = $this->db->get()->row();

        if($eview != "")
        {
            $this->db->where('eview_id', $eview->id);
            $this->db->delete('tbleview_item');

            if($eview->main_image != "")
            {
                $main_image = unlink(EVIEW_FOLDER . '/' . $eview->main_image);
            }

            if($eview->image1 != "")
            {
                $image1 = unlink(EVIEW_FOLDER . '/' . $eview->image1);
            }

            if($eview->image2 != "")
            {
                $image2 = unlink(EVIEW_FOLDER . '/' . $eview->image2);
            }

            if($eview->image3 != "")
            {
                $image3 = unlink(EVIEW_FOLDER . '/' . $eview->image3);
            }

            if($eview->image4 != "")
            {
                $image4 = unlink(EVIEW_FOLDER . '/' . $eview->image4);
            }

            if($eview->image5 != "")
            {
                $image5 = unlink(EVIEW_FOLDER . '/' . $eview->image5);
            }

            $this->db->where('id', $eview->id);
            $this->db->delete('tblinvoiceitems_eview');
        }


        $this->db->where('id', $id);
        $this->db->delete('tblinvoiceitemslist');

        if ($this->db->affected_rows() > 0) {
            logActivity('Invoice Item Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }

    /**
     * Get invoice items - ajax call for autocomplete when adding invoicei tems
     * @param  mixed $data query
     * @return array
     */
    public function get_all_items_ajax() {
        $this->db->select('tblinvoiceitemslist.id as itemid,rate,taxrate,tbltaxes.id as taxid,tbltaxes.name as taxname,tblinvoiceitemslist.description as descp,long_description,tblcategories.category_name as catname,sku as label');
        $this->db->from('tblinvoiceitemslist');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.tax', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        return $this->db->get()->result_array();
    }
    public function get_all_manufactur_items_ajax() {
        $this->db->select('tblinvoiceitemslist.id as itemid,rate,taxrate,tbltaxes.id as taxid,tbltaxes.name as taxname,tblinvoiceitemslist.description as descp,long_description,tblcategories.category_name as catname,manufacturersku as label');
        $this->db->from('tblinvoiceitemslist');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblinvoiceitemslist.tax', 'left');
        $this->db->join('tblcategories', 'tblcategories.category_id = tblinvoiceitemslist.category', 'left');
        return $this->db->get()->result_array();
    }

    public function get_items() {
        return $this->db->get('tblitemtypes')->result();
    }

    public function get_where_tbl($tbl, $col) {
        return $this->db->where($col, 1)->get($tbl)->result();
    }

    public function get_where_single_tbl($tbl, $col, $val) {
		
        return $this->db->where($col, $val)->get($tbl)->row();
    }

    public function get_eview($id)
    {
        $this->db->select('tblinvoiceitems_eview.*');
        $this->db->from('tblinvoiceitems_eview');
        $this->db->where('tblinvoiceitems_eview.invoiceitems_id',$id);
        return $this->db->get()->row();
    }

    public function get_eview_item($eview_id)
    {
        $this->db->select('tbleview_item.*');
        $this->db->from('tbleview_item');
        $this->db->where('tbleview_item.eview_id',$eview_id);
        return $this->db->get()->result();
    }

    public function get_eview_itemlist($eview_id)
    {
        $this->db->select('tblinvoiceitemslist.sku,tblinvoiceitemslist.description');
        $this->db->from('tblinvoiceitemslist');
        $this->db->join('tblinvoiceitems_eview', 'tblinvoiceitems_eview.invoiceitems_id = tblinvoiceitemslist.id', 'left');
        $this->db->join('tbleview_item', 'tbleview_item.item_id = tblinvoiceitemslist.id', 'left');
        $this->db->where('tbleview_item.eview_id',$eview_id);
        return $item = $this->db->get()->result();
        // echo "<pre>";
        // print_r($item);
        // die;
    }

    public function update1($data, $id) {

        // echo "<pre>";
        // print_r($_FILES['image']['name']);
        // die;
        // unset($data['sales']);
        // unset($data['inventory']);
        // unset($data['cogs']);
        unset($data['action']);
        unset($data['isedit']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['allow_discount']);



        $this->db->select('tblinvoiceitems_eview.*');
        $this->db->from('tblinvoiceitems_eview');
        $this->db->where('tblinvoiceitems_eview.invoiceitems_id',$id);
        $tblinvoiceitems_eview = $this->db->get()->row();

        if(isset($tblinvoiceitems_eview) && $tblinvoiceitems_eview != "")
        {
            if ($_FILES['image']['name']) {
                $this->load->helper('polaris_upload');
                handle_item_upload($id,$tblinvoiceitems_eview->id);
            }
        }
        else
        {
            if ($_FILES['image']['name']) {
                $this->load->helper('polaris_upload');
                $eview_id = handle_item_upload($id);
                $data['eview_id'] = $eview_id;
            }
        }
        


       
        // print_r($itemrow);
        // die;

        $data['costprice'] = str_replace(",", "", $data['costprice']);
        $data['suggested_price'] = str_replace(",", "", $data['suggested_price']);
        $data['salesprice'] = str_replace(",", "", $data['salesprice']);

        if($data['eview_id'] == "")
        {
            $this->db->select('tblcategories.*');
            $this->db->from('tblcategories');
            $this->db->where('tblcategories.category_id',$data['category']);
            $category_details = $this->db->get()->row();

            $this->db->select('tblsubcategories.*');
            $this->db->from('tblsubcategories');
            $this->db->where('tblsubcategories.catid',$data['category']);
            $subcategory_details = $this->db->get()->result();

            $subcategory_name = array();
            foreach ($subcategory_details as $key => $subcategory) {
                $subcategory_name[] = $subcategory->subcategory_name;
            }

            $CI = &get_instance();
            
            $db2 = $CI->load->database('proverbs_solomon', TRUE);

            $db2->select('cart_category_translations.*');
            $db2->from('cart_category_translations');
            $cart_category_translations = $db2->get()->result();

            // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

            $cart_category_id = "";
            $cart_subcategory_id = array();
            
            foreach ($cart_category_translations as $key => $cate_name) {
                if($cate_name->name == $category_details->category_name)
                {
                    // echo "sad";
                    $cart_category_id = $cate_name->category_id;
                }
                
            }

            foreach ($cart_category_translations as $key => $cate_name) {
                // if($cate_name->name == $subcategory_details->subcategory_name)
                if(in_array($cate_name->name,$subcategory_name))
                {
                    
                    $cart_subcategory_id[] = $cate_name->category_id;
                }
                
            }

            foreach ($cart_category_translations as $key => $cate_name) {
                if($cate_name->name == $subcategory_details->subcategory_name)
                {
                    // echo "sad";
                    $cart_subcategory_id = $cate_name->category_id;
                }
                
            }
            // echo $cart_category_id;
            // die;
            $insert_cart_category_id = "";
            $insert_cart_category_translations_id = "";

            if($cart_category_id == "")
            {
                $db2->select_max('sort_order');
                $cart_categories = $db2->get('cart_categories')->row();  
                $sort_order = $cart_categories->sort_order + 1;

                $insert_cart_category = array(
                                'parent_id' => 0,
                                'icon' => 'default.png',
                                'icon_thumb' => 'default_thumb.png',
                                'products_count_total' => 0,
                                'products_count_active' => 0,
                                'sort_order' => $sort_order,
                            );
                $db2->insert('cart_categories', $insert_cart_category);
                $insert_cart_category_id = $db2->insert_id();

                $insert_cart_category_translations = array(
                                'category_id' => $insert_cart_category_id,
                                'language_code' => 'en',
                                'name' => $subcategory_details->subcategory_name,
                                'description' => $subcategory_details->description,
                            );

                $db2->insert('cart_category_translations', $insert_cart_category_translations);
                $insert_cart_category_translations_id = $db2->insert_id();
            }
                
            if($cart_category_id != "")
            {
                $insert_cart_category_id = $cart_category_id;
            }
            // echo $insert_cart_category_id;
            // die;

            $update_cart_subcategory_id = "";
            $update_cart_subcategory_translations_id = "";

            if($cart_subcategory_id == "")
            {
                foreach ($subcategory_details as $key => $subcategory) 
                {
                    $db2->select_max('sort_order');
                    $cart_categories = $db2->get('cart_categories')->row();  
                    $sort_order = $cart_categories->sort_order + 1;

                    $insert_cart_subcategory = array(
                                    'parent_id' => $update_cart_category_id,
                                    'icon' => 'default.png',
                                    'icon_thumb' => 'default_thumb.png',
                                    'products_count_total' => 0,
                                    'products_count_active' => 0,
                                    'sort_order' => $sort_order,
                                );
                    $db2->insert('cart_categories', $insert_cart_subcategory);
                    $update_cart_subcategory_id = $db2->insert_id();

                    $insert_cart_category_translations = array(
                                    'category_id' => $update_cart_subcategory_id,
                                    'language_code' => 'en',
                                    'name' => $subcategory->category_name,
                                    'description' => $subcategory->description,
                                );

                    $db2->insert('cart_category_translations', $insert_cart_category_translations);
                    $update_cart_subcategory_translations_id = $db2->insert_id();
                }
            }

            if($cart_subcategory_id != "")
            {
                $update_cart_subcategory_id = $cart_subcategory_id;
            }

            /*-------------------------- end category --------------------------*/

            $this->db->select('tblmanufacturers.*');
            $this->db->from('tblmanufacturers');
            $this->db->where('tblmanufacturers.mfid',$data['manufacturer']);
            $manufacturers_details = $this->db->get()->row();


            $db2->select('cart_manufacturer_translations.*');
            $db2->from('cart_manufacturer_translations');
            $cart_manufacturer_translations = $db2->get()->result();

            // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

            $cart_manufacturer_id = "";
            
            foreach ($cart_manufacturer_translations as $key => $manufacturer_name) {
                if($manufacturer_name->name == $manufacturers_details->name)
                {
                    // echo "sad";
                    $cart_manufacturer_id = $manufacturer_name->manufacturer_id;
                }
                
            }
            // echo $cart_category_id;
            // die;
            $insert_cart_manufacturer_id = "";
            $insert_cart_manufacturer_translations_id = "";

            if($cart_manufacturer_id == "")
            {
                // $db2->select_max('sort_order');
                // $cart_categories = $db2->get('cart_categories')->row();  
                // $sort_order = $cart_categories->sort_order + 1;

                $insert_cart_manufacturers = array(
                                            'logo_file' =>'default.png',
                                            'logo_file_thumb' =>'default.png',
                            );
                $db2->insert('cart_manufacturers', $insert_cart_manufacturers);
                $insert_cart_manufacturer_id = $db2->insert_id();

                $insert_cart_manufacturer_translations = array(
                                'manufacturer_id' => $insert_cart_manufacturer_id,
                                'language_code' => 'en',
                                'name' => $manufacturers_details->name,
                                // 'description' => $manufacturers_details->description,
                                'description' => "",
                            );

                $db2->insert('cart_manufacturer_translations', $insert_cart_manufacturer_translations);
                $insert_cart_manufacturer_translations_id = $db2->insert_id();
            }
                
            if($cart_manufacturer_id != "")
            {
                $insert_cart_manufacturer_id = $cart_manufacturer_id;
            }
            // echo $insert_cart_category_id;
            // die;



            /*-------------------------- end manufact --------------------------*/




            $is_featured = $data['is_featured']?$data['is_featured']:0;
            $insert_eview = array(
                                'invoiceitems_id' => $id,
                                'details' => $data['details'],
                                'is_featured' => $is_featured,
                            );
            $this->db->insert('tblinvoiceitems_eview', $insert_eview);
            $insert_eview_id = $this->db->insert_id();
            

            $db2->select_max('sort_order');
            $product_order = $db2->get('cart_products')->row();  
            $sort_order = $product_order->sort_order + 1;

            $insert_product = array(
                                'item_id' => $id,
                                'category_id' => $insert_cart_category_id,
                                'manufacturer_id' => $insert_cart_manufacturer_id,
                                'sku' => $data['sku'],
                                'price' => $data['salesprice'],
                                // 'list_price' => $data['costprice'],
                                'list_price' => $data['suggested_price'],
                                'is_featured' => $is_featured,
                                'is_taxable' => 0,
                                'is_active' => 1,
                                'created_at' => date('Y-m-d'),
                                'sort_order' => $sort_order,
                            );
            $db2->insert('cart_products', $insert_product);
            $insert_product_id = $db2->insert_id();


            $insert_product_translation = array(
                                'product_id' => $insert_product_id,
                                'language_code' => 'en',
                                'name' => $data['description'],
                                'description' => $data['details'],
                            );

            $db2->insert('cart_product_translations', $insert_product_translation);


            $db2->select('cart_categories.*');
            $db2->from('cart_categories');
            $db2->where('cart_categories.id',$insert_cart_category_id);
            $category_product = $db2->get()->row();

            $products_count_total = $category_product->products_count_total + 1;
            $products_count_active = $category_product->products_count_active + 1;

            $update_cart_category = array(
                                        'products_count_total' => $products_count_total,
                                        'products_count_active' => $products_count_active,
                                    );
            $db2->where('id', $insert_cart_category_id);
            $db2->update('cart_categories', $update_cart_category);


            if ($_FILES['main_image']['name']) {
                $this->load->helper('polaris_upload');
                handle_main_image_upload($insert_eview_id,$insert_product_id);
                handle_product_main_image_upload($insert_product_id);
                // handle_main_image_upload(10,$insert_product_id);
            }

            if ($_FILES['image1']['name']) {
                $this->load->helper('polaris_upload');
                handle_image1_upload($insert_eview_id,$insert_product_id);
                handle_product_image1_upload($insert_product_id);
            }

            if ($_FILES['image2']['name']) {
                $this->load->helper('polaris_upload');
                handle_image2_upload($insert_eview_id,$insert_product_id);
                handle_product_image2_upload($insert_product_id);
            }

            if ($_FILES['image3']['name']) {
                $this->load->helper('polaris_upload');
                handle_image3_upload($insert_eview_id,$insert_product_id);
                handle_product_image3_upload($insert_product_id);
            }

            if ($_FILES['image4']['name']) {
                $this->load->helper('polaris_upload');
                handle_image4_upload($insert_eview_id,$insert_product_id);
                handle_product_image4_upload($insert_product_id);
            }

            if ($_FILES['image5']['name']) {
                $this->load->helper('polaris_upload');
                handle_image5_upload($insert_eview_id,$insert_product_id);
                handle_product_image5_upload($insert_product_id);
            }

            if (isset($data['items'])) {
                foreach ($data['items'] as $item) {
                    $this->db->insert('tbleview_item', array(
                        'eview_id' => $insert_eview_id,
                        'item_id' => $item,
                    ));
                }
            }
        }



        if($data['eview_id'] != "")
        {
            $this->db->select('tblcategories.*');
            $this->db->from('tblcategories');
            $this->db->where('tblcategories.category_id',$data['category']);
            $category_details = $this->db->get()->row();

            if($category_details->show_in_cart == 1)
            {
                $this->db->select('tblsubcategories.*');
                $this->db->from('tblsubcategories');
                $this->db->where('tblsubcategories.catid',$data['category']);
                $subcategory_details = $this->db->get()->result();
                // echo "<pre>";
                
                $subcategory_name = array();
                foreach ($subcategory_details as $key => $subcategory) {
                    $subcategory_name[] = $subcategory->subcategory_name;
                }
                // print_r($subcategory_name);
                // die;

                $CI = &get_instance();
                
                $db2 = $CI->load->database('proverbs_solomon', TRUE);

                $db2->select('cart_category_translations.*');
                $db2->from('cart_category_translations');
                $cart_category_translations = $db2->get()->result();

                // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

                $cart_category_id = "";
                $cart_subcategory_id = array();
                
                foreach ($cart_category_translations as $key => $cate_name) {
                    if($cate_name->name == $category_details->category_name)
                    {
                        // echo "sad";
                        $cart_category_id = $cate_name->category_id;
                    }
                    
                }

                foreach ($cart_category_translations as $key => $cate_name) {
                    // if($cate_name->name == $subcategory_details->subcategory_name)
                    if(in_array($cate_name->name,$subcategory_name))
                    {
                        
                        $cart_subcategory_id[] = $cate_name->category_id;
                    }
                    
                }
                // echo $cart_subcategory_id;
                // die;
                $update_cart_category_id = "";
                $update_cart_category_translations_id = "";


                if($cart_category_id == "")
                {
                    $db2->select_max('sort_order');
                    $cart_categories = $db2->get('cart_categories')->row();  
                    $sort_order = $cart_categories->sort_order + 1;

                    $insert_cart_category = array(
                                    'parent_id' => 0,
                                    'icon' => 'default.png',
                                    'icon_thumb' => 'default_thumb.png',
                                    'products_count_total' => 0,
                                    'products_count_active' => 0,
                                    'sort_order' => $sort_order,
                                );
                    $db2->insert('cart_categories', $insert_cart_category);
                    $update_cart_category_id = $db2->insert_id();

                    $insert_cart_category_translations = array(
                                    'category_id' => $update_cart_category_id,
                                    'language_code' => 'en',
                                    'name' => $category_details->category_name,
                                    'description' => $category_details->description,
                                );

                    $db2->insert('cart_category_translations', $insert_cart_category_translations);
                    $update_cart_category_translations_id = $db2->insert_id();
                }

                if($cart_category_id != "")
                {
                    $update_cart_category_id = $cart_category_id;
                }


                $update_cart_subcategory_id = "";
                $update_cart_subcategory_translations_id = "";

                if(empty($cart_subcategory_id))
                {
                    foreach ($subcategory_details as $key => $subcategory) 
                    {
                        $db2->select_max('sort_order');
                        $cart_categories = $db2->get('cart_categories')->row();  
                        $sort_order = $cart_categories->sort_order + 1;

                        $insert_cart_subcategory = array(
                                    'parent_id' => $update_cart_category_id,
                                    'icon' => 'default.png',
                                    'icon_thumb' => 'default_thumb.png',
                                    'products_count_total' => 0,
                                    'products_count_active' => 0,
                                    'sort_order' => $sort_order,
                                );
                        $db2->insert('cart_categories', $insert_cart_subcategory);
                        $update_cart_subcategory_id = $db2->insert_id();

                        $insert_cart_category_translations = array(
                                    'category_id' => $update_cart_subcategory_id,
                                    'language_code' => 'en',
                                    'name' => $subcategory->subcategory_name,
                                    'description' => $subcategory->description,
                                );

                        $db2->insert('cart_category_translations', $insert_cart_category_translations);
                        $update_cart_subcategory_translations_id = $db2->insert_id();


                    }                
                }

                // if($cart_subcategory_id != "")
                // {
                //     $update_cart_subcategory_id = $cart_subcategory_id;
                // }
                    
                
                // echo $insert_cart_category_id;
                // die;


                /*-------------------------- end category --------------------------*/

                $this->db->select('tblmanufacturers.*');
                $this->db->from('tblmanufacturers');
                $this->db->where('tblmanufacturers.mfid',$data['manufacturer']);
                $manufacturers_details = $this->db->get()->row();


                $db2->select('cart_manufacturer_translations.*');
                $db2->from('cart_manufacturer_translations');
                $cart_manufacturer_translations = $db2->get()->result();

                // $cart_category_translations = $db2->query("SELECT * FROM cart_category_translations");

                $cart_manufacturer_id = "";
                
                foreach ($cart_manufacturer_translations as $key => $manufacturer_name) {
                    if($manufacturer_name->name == $manufacturers_details->name)
                    {
                        // echo "sad";
                        $cart_manufacturer_id = $manufacturer_name->manufacturer_id;
                    }
                    
                }
                // echo $cart_category_id;
                // die;
                $update_cart_manufacturer_id = "";
                $update_cart_manufacturer_translations_id = "";

                if($cart_manufacturer_id == "")
                {
                    // $db2->select_max('sort_order');
                    // $cart_categories = $db2->get('cart_categories')->row();  
                    // $sort_order = $cart_categories->sort_order + 1;

                    $insert_cart_manufacturers = array(
                                                'logo_file' =>'default.png',
                                                'logo_file_thumb' =>'default.png',
                                );
                    $db2->insert('cart_manufacturers', $insert_cart_manufacturers);
                    $update_cart_manufacturer_id = $db2->insert_id();

                    

                    $insert_cart_manufacturer_translations = array(
                                    'manufacturer_id' => $update_cart_manufacturer_id,
                                    'language_code' => 'en',
                                    'name' => $manufacturers_details->name,
                                    // 'description' => $manufacturers_details->description,
                                    'description' => "",
                                );

                    $db2->insert('cart_manufacturer_translations', $insert_cart_manufacturer_translations);
                    $update_cart_manufacturer_translations_id = $db2->insert_id();
                }
                    
                if($cart_manufacturer_id != "")
                {
                    $update_cart_manufacturer_id = $cart_manufacturer_id;
                }
                // echo $insert_cart_category_id;
                // die;



                /*-------------------------- end manufact --------------------------*/




                $is_featured = $data['is_featured']?$data['is_featured']:0;
                // $insert_eview = array(
                //                     'invoiceitems_id' => $id,
                //                     'details' => $data['details'],
                //                     'is_featured' => $is_featured,
                //                 );
                // $this->db->insert('tblinvoiceitems_eview', $insert_eview);
                // $insert_eview_id = $this->db->insert_id();
                
                $image_item_id = "";

                $db2->select('cart_products.*');
                $db2->where('item_id', $id);
                $item_product = $db2->get('cart_products')->row();  
                // $sort_order = $product_order->sort_order + 1;
                if($item_product != "")
                {
                    $update_product = array(
                                        'item_id' => $id,
                                        'category_id' => $update_cart_category_id,
                                        'manufacturer_id' => $update_cart_manufacturer_id,
                                        'sku' => $data['sku'],
                                        'price' => $data['salesprice'],
                                        // 'list_price' => $data['costprice'],
                                        'list_price' => $data['suggested_price'],
                                        'is_featured' => $is_featured,
                                        'is_taxable' => 0,
                                        'is_active' => 1,
                                        'created_at' => date('Y-m-d'),
                                        // 'sort_order' => $sort_order,
                                    );
                    $db2->where('item_id', $id);
                    $db2->update('cart_products', $update_product);
                    // $insert_product_id = $db2->insert_id();

                    $db2->select('cart_products.*');
                    $db2->from('cart_products');
                    $db2->where('cart_products.item_id',$id);
                    $cart_products_update_id = $db2->get()->row();

                    $image_item_id = $cart_products_update_id->id;

                    $update_product_translation = array(
                                        'product_id' => $cart_products_update_id->id,
                                        'language_code' => 'en',
                                        'name' => $data['description'],
                                        'description' => $data['details'],
                                    );
                    $db2->where('product_id', $cart_products_update_id->id);
                    $db2->update('cart_product_translations', $update_product_translation);
                }
                else
                {

                    $db2->select_max('sort_order');
                    $product_order = $db2->get('cart_products')->row();  
                    $sort_order = $product_order->sort_order + 1;

                    $insert_product = array(
                                    'item_id' => $id,
                                    'category_id' => $update_cart_category_id,
                                    'manufacturer_id' => $update_cart_manufacturer_id,
                                    'sku' => $data['sku'],
                                    'price' => $data['salesprice'],
                                    // 'list_price' => $data['costprice'],
                                    'list_price' => $data['suggested_price'],
                                    'is_featured' => $is_featured,
                                    'is_taxable' => 0,
                                    'is_active' => 1,
                                    'created_at' => date('Y-m-d'),
                                    'sort_order' => $sort_order,
                                );
                    $db2->insert('cart_products', $insert_product);
                    $insert_product_id = $db2->insert_id();

                    $image_item_id = $insert_product_id;

                    $insert_product_translation = array(
                                        'product_id' => $insert_product_id,
                                        'language_code' => 'en',
                                        'name' => $data['description'],
                                        'description' => $data['details'],
                                    );

                    $db2->insert('cart_product_translations', $insert_product_translation);
                }

                $db2->select('cart_categories.*');
                $db2->from('cart_categories');
                $db2->where('cart_categories.id',$insert_cart_category_id);
                $category_product = $db2->get()->row();

                if($category_product->products_count_total == 0) 
                {
                    $products_count_total = $category_product->products_count_total + 1;
                    $products_count_active = $category_product->products_count_active + 1;

                    $update_cart_category = array(
                                                'products_count_total' => $products_count_total,
                                                'products_count_active' => $products_count_active,
                                            );
                    $db2->where('id', $insert_cart_category_id);
                    $db2->update('cart_categories', $update_cart_category);
                }
            }



            // $is_featured = $data['is_featured']?$data['is_featured']:0;
            $update_eview = array(
                                'invoiceitems_id' => $id,
                                'details' => $data['details'],
                                'is_featured' => $is_featured,
                            );
             $this->db->where('id', $data['eview_id'])
                 ->update('tblinvoiceitems_eview', $update_eview);
            // $this->db->insert('tblinvoiceitems_eview', $insert_eview);
            // $insert_eview_id = $this->db->insert_id();

            // if ($_FILES['image']['name']) {
            //     $this->load->helper('polaris_upload');
            //     // handle_main_image_upload($data['eview_id']);
            //     $main_image_product = $_FILES['image']['name'];
            //     handle_product_main_image_upload($image_item_id,$main_image_product);
            // }

            $this->db->select('tblinvoiceitemslist.*');
            $this->db->from('tblinvoiceitemslist');
            $this->db->where('tblinvoiceitemslist.id',$id);
            $itemrow = $this->db->get()->row();


            if ($itemrow->image != "") {
                $this->load->helper('polaris_upload');
                // handle_main_image_upload($data['eview_id']);
                handle_product_main_image_upload($image_item_id,$itemrow->image);
            }

            if ($_FILES['image1']['name']) {
                $this->load->helper('polaris_upload');
                handle_image1_upload($data['eview_id']);
                handle_product_image1_upload($image_item_id);
            }

            if ($_FILES['image2']['name']) {
                $this->load->helper('polaris_upload');
                handle_image2_upload($data['eview_id']);
                handle_product_image2_upload($image_item_id);
            }

            if ($_FILES['image3']['name']) {
                $this->load->helper('polaris_upload');
                handle_image3_upload($data['eview_id']);
                handle_product_image3_upload($image_item_id);
            }

            if ($_FILES['image4']['name']) {
                $this->load->helper('polaris_upload');
                handle_image4_upload($data['eview_id']);
                handle_product_image4_upload($image_item_id);
            }

            if ($_FILES['image5']['name']) {
                $this->load->helper('polaris_upload');
                handle_image5_upload($data['eview_id']);
                handle_product_image5_upload($image_item_id);
            }

            $this->db->where('eview_id', $data['eview_id']);
            $this->db->delete('tbleview_item');

            if (isset($data['items'])) {
                foreach ($data['items'] as $item) {
                    $this->db->insert('tbleview_item', array(
                        'eview_id' => $data['eview_id'],
                        'item_id' => $item,
                    ));
                }
            }
        }


        unset($data['details']);
        unset($data['is_featured']);
        unset($data['items']);
        unset($data['eview_id']);
        unset($data['item_id']);


        

        // $update_invoiceitem = array(
        //                         'description' => $data['description'];
        //                         'long_description' => $data['description'];
        //                         'rate' => $data['description'];
        //                         'tax' => $data['description'];
        //                         'sku' => $data['description'];
        //                         'manufacturersku' => $data['description'];
        //                         'itemtype' => $data['description'];
        //                         );


        
        $this->db->query("SET FOREIGN_KEY_CHECKS = 0");
        $this->db->where('id', $id)
                 ->update('tblinvoiceitemslist', $data);
        $this->db->query("SET FOREIGN_KEY_CHECKS = 1");


        // $this->db->select('tblinvoiceitems_eview.*');
        // $this->db->from('tblinvoiceitems_eview');
        // $this->db->where('tblinvoiceitems_eview.invoiceitems_id',$id);
        // $tblinvoiceitems_eview = $this->db->get()->row();

        // if ($_FILES['image']['name']) {
        //     $this->load->helper('polaris_upload');
        //     handle_item_upload($id,$tblinvoiceitems_eview->id);
        // }

    
        return true;
    }

    public function update($data, $id) {

        // echo "<pre>";
        // print_r($data);
        // die;
        // unset($data['sales']);
        // unset($data['inventory']);
        // unset($data['cogs']);
        unset($data['action']);
        unset($data['isedit']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['allow_discount']);



        $this->db->select('tblinvoiceitems_eview.*');
        $this->db->from('tblinvoiceitems_eview');
        $this->db->where('tblinvoiceitems_eview.invoiceitems_id',$id);
        $tblinvoiceitems_eview = $this->db->get()->row();

        if(isset($tblinvoiceitems_eview) && $tblinvoiceitems_eview != "")
        {
            if ($_FILES['image']['name']) {
                $this->load->helper('polaris_upload');
                handle_item_upload($id,$tblinvoiceitems_eview->id);
            }
        }
        else
        {
            if ($_FILES['image']['name']) {
                $this->load->helper('polaris_upload');
                $eview_id = handle_item_upload($id);
                $data['eview_id'] = $eview_id;
            }
        }
        


       
        // print_r($data['eview_id']);
        // die;

        $data['costprice'] = str_replace(",", "", $data['costprice']);
        $data['suggested_price'] = str_replace(",", "", $data['suggested_price']);
        $data['salesprice'] = str_replace(",", "", $data['salesprice']);
        $data['landed_cost'] = str_replace(",", "", $data['landed_cost']);
        // $data['pricing_method'] = str_replace(",", "", $data['pricing_method']);
        $data['amount'] = str_replace(",", "", $data['amount']);
        $data['margin_percent'] = str_replace(",", "", $data['margin_percent']);
        $data['markup_percent'] = str_replace(",", "", $data['markup_percent']);
        $data['suggested_retail_price'] = str_replace(",", "", $data['suggested_retail_price']);
        $data['retail_price'] = str_replace(",", "", $data['retail_price']);

        $is_featured = $data['is_featured']?$data['is_featured']:0;
        $data['show_in_eview'] = $data['show_in_eview']?$data['show_in_eview']:0;

        if($data['eview_id'] == "")
        {
            $this->db->select('tblcategories.*');
            $this->db->from('tblcategories');
            $this->db->where('tblcategories.category_id',$data['category']);
            $category_details = $this->db->get()->row();

           
            $this->db->select('tblsubcategories.*');
            $this->db->from('tblsubcategories');
            $this->db->where('tblsubcategories.subcategory_id',$data['subcategory']);
            $subcategory_details = $this->db->get()->row();
            //  echo $subcategory_details->show_in_cart;
            // die;
            if(get_option('show_in_cart') == 1)
            {
                if($data['show_in_eview'] == 1)
                {
                    if($category_details->show_in_cart == 1)
                    {

                        if($subcategory_details->show_in_cart == 1)
                        {

                            $this->db->select('tblmanufacturers.*');
                            $this->db->from('tblmanufacturers');
                            $this->db->where('tblmanufacturers.mfid',$data['manufacturer']);
                            $manufacturers_details = $this->db->get()->row();

                            $CI = &get_instance();
                    
                            $db2 = $CI->load->database('proverbs_solomon', TRUE);

                            

                            $cart_category_id = "";
                            $update_cart_category_id = "";
                            
                            $db2->select('cart_category_translations.*');
                            $db2->from('cart_category_translations');
                            $cart_category_translations = $db2->get()->result();
                            
                            foreach ($cart_category_translations as $key => $cate_name) {
                                if($cate_name->name == $category_details->category_name)
                                {
                                    // echo "sad";
                                    $cart_category_id = $cate_name->category_id;
                                }
                                
                            }

                            // echo $cart_category_id;
                            // die;

                            $update_cart_category_id = $cart_category_id;

                            $db2->select('cart_manufacturer_translations.*');
                            $db2->from('cart_manufacturer_translations');
                            $cart_manufacturer_translations = $db2->get()->result();

                            $cart_manufacturer_id = "";
                            
                            foreach ($cart_manufacturer_translations as $key => $manufacturer_name)
                            {
                                if($manufacturer_name->name == $manufacturers_details->name)
                                {
                                    // echo "sad";
                                    $cart_manufacturer_id = $manufacturer_name->manufacturer_id;
                                }
                                
                            }
                           
                            $update_cart_manufacturer_id = "";
                            $update_cart_manufacturer_translations_id = "";

                            if($cart_manufacturer_id == "")
                            {
                                // $db2->select_max('sort_order');
                                // $cart_categories = $db2->get('cart_categories')->row();  
                                // $sort_order = $cart_categories->sort_order + 1;

                                $insert_cart_manufacturers = array(
                                                            'logo_file' =>'default.png',
                                                            'logo_file_thumb' =>'default.png',
                                            );
                                $db2->insert('cart_manufacturers', $insert_cart_manufacturers);
                                $update_cart_manufacturer_id = $db2->insert_id();

                                

                                $insert_cart_manufacturer_translations = array(
                                                'manufacturer_id' => $update_cart_manufacturer_id,
                                                'language_code' => 'en',
                                                'name' => $manufacturers_details->name,
                                                // 'description' => $manufacturers_details->description,
                                                'description' => "",
                                            );

                                $db2->insert('cart_manufacturer_translations', $insert_cart_manufacturer_translations);
                                $update_cart_manufacturer_translations_id = $db2->insert_id();
                            }
                                
                            if($cart_manufacturer_id != "")
                            {
                                $update_cart_manufacturer_id = $cart_manufacturer_id;
                            }

                            // $is_featured = $data['is_featured']?$data['is_featured']:0;
                        
                        
                            $image_item_id = "";

                            $db2->select('cart_products.*');
                            $db2->where('item_id', $id);
                            $item_product = $db2->get('cart_products')->row();  
                            // $sort_order = $product_order->sort_order + 1;
                            if($item_product != "")
                            {
                                $update_product = array(
                                                    'item_id' => $id,
                                                    'category_id' => $update_cart_category_id,
                                                    'manufacturer_id' => $update_cart_manufacturer_id,
                                                    'sku' => $data['sku'],
                                                    'price' => $data['salesprice'],
                                                    // 'list_price' => $data['costprice'],
                                                    'list_price' => $data['suggested_price'],
                                                    'is_featured' => $is_featured,
                                                    'is_taxable' => 0,
                                                    'is_active' => 1,
                                                    'created_at' => date('Y-m-d'),
                                                    // 'sort_order' => $sort_order,
                                                );
                                $db2->where('item_id', $id);
                                $db2->update('cart_products', $update_product);
                                // $insert_product_id = $db2->insert_id();

                                $db2->select('cart_products.*');
                                $db2->from('cart_products');
                                $db2->where('cart_products.item_id',$id);
                                $cart_products_update_id = $db2->get()->row();

                                $image_item_id = $cart_products_update_id->id;

                                $update_product_translation = array(
                                                    'product_id' => $cart_products_update_id->id,
                                                    'language_code' => 'en',
                                                    'name' => $data['description'],
                                                    'description' => $data['details'],
                                                );
                                $db2->where('product_id', $cart_products_update_id->id);
                                $db2->update('cart_product_translations', $update_product_translation);
                            }
                            else
                            {

                                $db2->select_max('sort_order');
                                $product_order = $db2->get('cart_products')->row();  
                                $sort_order = $product_order->sort_order + 1;

                                $insert_product = array(
                                                'item_id' => $id,
                                                'category_id' => $update_cart_category_id,
                                                'manufacturer_id' => $update_cart_manufacturer_id,
                                                'sku' => $data['sku'],
                                                'price' => $data['salesprice'],
                                                // 'list_price' => $data['costprice'],
                                                'list_price' => $data['suggested_price'],
                                                'is_featured' => $is_featured,
                                                'is_taxable' => 0,
                                                'is_active' => 1,
                                                'created_at' => date('Y-m-d'),
                                                'sort_order' => $sort_order,
                                            );
                                $db2->insert('cart_products', $insert_product);
                                $insert_product_id = $db2->insert_id();

                                $image_item_id = $insert_product_id;

                                $insert_product_translation = array(
                                                    'product_id' => $insert_product_id,
                                                    'language_code' => 'en',
                                                    'name' => $data['description'],
                                                    'description' => $data['details'],
                                                );

                                $db2->insert('cart_product_translations', $insert_product_translation);

                                $db2->select('cart_categories.*');
                                $db2->from('cart_categories');
                                $db2->where('cart_categories.id',$update_cart_category_id);
                                $category_product = $db2->get()->row();

                                $products_count_total = $category_product->products_count_total + 1;
                                $products_count_active = $category_product->products_count_active + 1;

                                $update_cart_category = array(
                                                            'products_count_total' => $products_count_total,
                                                            'products_count_active' => $products_count_active,
                                                        );
                                $db2->where('id', $update_cart_category_id);
                                $db2->update('cart_categories', $update_cart_category);
                            }

                            // $db2->select('cart_categories.*');
                            // $db2->from('cart_categories');
                            // $db2->where('cart_categories.id',$insert_cart_category_id);
                            // $category_product = $db2->get()->row();

                            // if($category_product->products_count_total == 0) 
                            // {
                            //     $products_count_total = $category_product->products_count_total + 1;
                            //     $products_count_active = $category_product->products_count_active + 1;

                            //     $update_cart_category = array(
                            //                                 'products_count_total' => $products_count_total,
                            //                                 'products_count_active' => $products_count_active,
                            //                             );
                            //     $db2->where('id', $insert_cart_category_id);
                            //     $db2->update('cart_categories', $update_cart_category);
                            // }

                            $this->db->select('tblinvoiceitemslist.*');
                            $this->db->from('tblinvoiceitemslist');
                            $this->db->where('tblinvoiceitemslist.id',$id);
                            $itemrow = $this->db->get()->row();


                            if ($itemrow->image != "") {
                                $this->load->helper('polaris_upload');
                                // handle_main_image_upload($data['eview_id']);
                                handle_product_main_image_upload($image_item_id,$itemrow->image);
                            }

                            if ($_FILES['image1']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image1_upload($data['eview_id']);
                                handle_product_image1_upload($image_item_id);
                            }

                            if ($_FILES['image2']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image2_upload($data['eview_id']);
                                handle_product_image2_upload($image_item_id);
                            }

                            if ($_FILES['image3']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image3_upload($data['eview_id']);
                                handle_product_image3_upload($image_item_id);
                            }

                            if ($_FILES['image4']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image4_upload($data['eview_id']);
                                handle_product_image4_upload($image_item_id);
                            }

                            if ($_FILES['image5']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image5_upload($data['eview_id']);
                                handle_product_image5_upload($image_item_id);
                            }
                        }
                        
                    }
                }
            }
        }


        if($data['eview_id'] != "")
        {

            if ($_FILES['image1']['name']) {
                $this->load->helper('polaris_upload');
                handle_image1_upload($data['eview_id']);
                // handle_product_image1_upload($image_item_id);
            }

            if ($_FILES['image2']['name']) {
                $this->load->helper('polaris_upload');
                handle_image2_upload($data['eview_id']);
                // handle_product_image2_upload($image_item_id);
            }

            if ($_FILES['image3']['name']) {
                $this->load->helper('polaris_upload');
                handle_image3_upload($data['eview_id']);
                // handle_product_image3_upload($image_item_id);
            }

            if ($_FILES['image4']['name']) {
                $this->load->helper('polaris_upload');
                handle_image4_upload($data['eview_id']);
                // handle_product_image4_upload($image_item_id);
            }

            if ($_FILES['image5']['name']) {
                $this->load->helper('polaris_upload');
                handle_image5_upload($data['eview_id']);
                // handle_product_image5_upload($image_item_id);
            }   



            // echo "<pre>";
            $this->db->select('tblcategories.*');
            $this->db->from('tblcategories');
            $this->db->where('tblcategories.category_id',$data['category']);
            $category_details = $this->db->get()->row();

           
            $this->db->select('tblsubcategories.*');
            $this->db->from('tblsubcategories');
            $this->db->where('tblsubcategories.subcategory_id',$data['subcategory']);
            $subcategory_details = $this->db->get()->row();
            //  echo $category_details->show_in_cart;
            // die;
            if(get_option('show_in_cart') == 1)
            {
                if($data['show_in_eview'] == 1)
                {
                    if($category_details->show_in_cart == 1)
                    {

                        if($subcategory_details->show_in_cart == 1)
                        {

                            $this->db->select('tblmanufacturers.*');
                            $this->db->from('tblmanufacturers');
                            $this->db->where('tblmanufacturers.mfid',$data['manufacturer']);
                            $manufacturers_details = $this->db->get()->row();

                            $CI = &get_instance();
                    
                            $db2 = $CI->load->database('proverbs_solomon', TRUE);

                            

                            $cart_category_id = "";
                            $update_cart_category_id = "";
                            
                            $db2->select('cart_category_translations.*');
                            $db2->from('cart_category_translations');
                            $cart_category_translations = $db2->get()->result();
                            
                            foreach ($cart_category_translations as $key => $cate_name) {
                                // if($cate_name->name == $category_details->category_name)
                                if($cate_name->name == $subcategory_details->subcategory_name)
                                {
                                    // echo "sad";
                                    $cart_category_id = $cate_name->category_id;
                                }
                                
                            }

                            // echo $cart_category_id;
                            // die;

                            $update_cart_category_id = $cart_category_id;

                            $db2->select('cart_manufacturer_translations.*');
                            $db2->from('cart_manufacturer_translations');
                            $cart_manufacturer_translations = $db2->get()->result();

                            $cart_manufacturer_id = "";
                            
                            foreach ($cart_manufacturer_translations as $key => $manufacturer_name) {
                                if($manufacturer_name->name == $manufacturers_details->name)
                                {
                                    // echo "sad";
                                    $cart_manufacturer_id = $manufacturer_name->manufacturer_id;
                                }
                                
                            }
                           
                            $update_cart_manufacturer_id = "";
                            $update_cart_manufacturer_translations_id = "";

                            if($cart_manufacturer_id == "")
                            {
                                // $db2->select_max('sort_order');
                                // $cart_categories = $db2->get('cart_categories')->row();  
                                // $sort_order = $cart_categories->sort_order + 1;

                                $insert_cart_manufacturers = array(
                                                            'logo_file' =>'default.png',
                                                            'logo_file_thumb' =>'default.png',
                                            );
                                $db2->insert('cart_manufacturers', $insert_cart_manufacturers);
                                $update_cart_manufacturer_id = $db2->insert_id();

                                

                                $insert_cart_manufacturer_translations = array(
                                                'manufacturer_id' => $update_cart_manufacturer_id,
                                                'language_code' => 'en',
                                                'name' => $manufacturers_details->name,
                                                // 'description' => $manufacturers_details->description,
                                                'description' => "",
                                            );

                                $db2->insert('cart_manufacturer_translations', $insert_cart_manufacturer_translations);
                                $update_cart_manufacturer_translations_id = $db2->insert_id();
                            }
                                
                            if($cart_manufacturer_id != "")
                            {
                                $update_cart_manufacturer_id = $cart_manufacturer_id;
                            }

                            // $is_featured = $data['is_featured']?$data['is_featured']:0;
                        
                        
                            $image_item_id = "";

                            $db2->select('cart_products.*');
                            $db2->where('item_id', $id);
                            $item_product = $db2->get('cart_products')->row();  
                            // $sort_order = $product_order->sort_order + 1;
                            if($item_product != "")
                            {
                                $update_product = array(
                                                    'item_id' => $id,
                                                    'category_id' => $update_cart_category_id,
                                                    'manufacturer_id' => $update_cart_manufacturer_id,
                                                    'sku' => $data['sku'],
                                                    'price' => $data['salesprice'],
                                                    // 'list_price' => $data['costprice'],
                                                    'list_price' => $data['suggested_price'],
                                                    'is_featured' => $is_featured,
                                                    'is_taxable' => 0,
                                                    'is_active' => 1,
                                                    'created_at' => date('Y-m-d'),
                                                    // 'sort_order' => $sort_order,
                                                );
                                $db2->where('item_id', $id);
                                $db2->update('cart_products', $update_product);
                                // $insert_product_id = $db2->insert_id();

                                $db2->select('cart_products.*');
                                $db2->from('cart_products');
                                $db2->where('cart_products.item_id',$id);
                                $cart_products_update_id = $db2->get()->row();

                                $image_item_id = $cart_products_update_id->id;

                                $update_product_translation = array(
                                                    'product_id' => $cart_products_update_id->id,
                                                    'language_code' => 'en',
                                                    'name' => $data['description'],
                                                    'description' => $data['details'],
                                                );
                                $db2->where('product_id', $cart_products_update_id->id);
                                $db2->update('cart_product_translations', $update_product_translation);
                            }
                            else
                            {

                                $db2->select_max('sort_order');
                                $product_order = $db2->get('cart_products')->row();  
                                $sort_order = $product_order->sort_order + 1;

                                $insert_product = array(
                                                'item_id' => $id,
                                                'category_id' => $update_cart_category_id,
                                                'manufacturer_id' => $update_cart_manufacturer_id,
                                                'sku' => $data['sku'],
                                                'price' => $data['salesprice'],
                                                // 'list_price' => $data['costprice'],
                                                'list_price' => $data['suggested_price'],
                                                'is_featured' => $is_featured,
                                                'is_taxable' => 0,
                                                'is_active' => 1,
                                                'created_at' => date('Y-m-d'),
                                                'sort_order' => $sort_order,
                                            );
                                $db2->insert('cart_products', $insert_product);
                                $insert_product_id = $db2->insert_id();

                                $image_item_id = $insert_product_id;

                                $insert_product_translation = array(
                                                    'product_id' => $insert_product_id,
                                                    'language_code' => 'en',
                                                    'name' => $data['description'],
                                                    'description' => $data['details'],
                                                );

                                $db2->insert('cart_product_translations', $insert_product_translation);

                                $db2->select('cart_categories.*');
                                $db2->from('cart_categories');
                                $db2->where('cart_categories.id',$update_cart_category_id);
                                $category_product = $db2->get()->row();

                                $products_count_total = $category_product->products_count_total + 1;
                                $products_count_active = $category_product->products_count_active + 1;

                                $update_cart_category = array(
                                                            'products_count_total' => $products_count_total,
                                                            'products_count_active' => $products_count_active,
                                                        );
                                $db2->where('id', $update_cart_category_id);
                                $db2->update('cart_categories', $update_cart_category);
                            }

                            // $db2->select('cart_categories.*');
                            // $db2->from('cart_categories');
                            // $db2->where('cart_categories.id',$insert_cart_category_id);
                            // $category_product = $db2->get()->row();

                            // if($category_product->products_count_total == 0) 
                            // {
                            //     $products_count_total = $category_product->products_count_total + 1;
                            //     $products_count_active = $category_product->products_count_active + 1;

                            //     $update_cart_category = array(
                            //                                 'products_count_total' => $products_count_total,
                            //                                 'products_count_active' => $products_count_active,
                            //                             );
                            //     $db2->where('id', $insert_cart_category_id);
                            //     $db2->update('cart_categories', $update_cart_category);
                            // }

                            $this->db->select('tblinvoiceitemslist.*');
                            $this->db->from('tblinvoiceitemslist');
                            $this->db->where('tblinvoiceitemslist.id',$id);
                            $itemrow = $this->db->get()->row();


                            if ($itemrow->image != "") {
                                $this->load->helper('polaris_upload');
                                // handle_main_image_upload($data['eview_id']);
                                handle_product_main_image_upload($image_item_id,$itemrow->image);
                            }

                            if ($_FILES['image1']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image1_upload($data['eview_id']);
                                handle_product_image1_upload($image_item_id);
                            }

                            if ($_FILES['image2']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image2_upload($data['eview_id']);
                                handle_product_image2_upload($image_item_id);
                            }

                            if ($_FILES['image3']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image3_upload($data['eview_id']);
                                handle_product_image3_upload($image_item_id);
                            }

                            if ($_FILES['image4']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image4_upload($data['eview_id']);
                                handle_product_image4_upload($image_item_id);
                            }

                            if ($_FILES['image5']['name']) {
                                $this->load->helper('polaris_upload');
                                // handle_image5_upload($data['eview_id']);
                                handle_product_image5_upload($image_item_id);
                            }
                        }
                        
                    }
                }
            }
			$data['show_in_eview']=1;
            if($data['show_in_eview'] != 1)
            {   
                $CI = &get_instance();
                
                $db2 = $CI->load->database('proverbs_solomon', TRUE);
                
                $db2->select('cart_products.*');
                $db2->from('cart_products');
                $db2->where('cart_products.item_id',$id);
                $product = $db2->get()->row();

                $db2->where('product_id', $product->id);
                $db2->delete('cart_product_translations');

               

                $db2->select('cart_categories.*');
                $db2->from('cart_categories');
                $db2->where('cart_categories.id',$product->category_id);
                $category_product = $db2->get()->row();

                $products_count_total = $category_product->products_count_total - 1;
                $products_count_active = $category_product->products_count_active - 1;

                $update_cart_category = array(
                                            'products_count_total' => $products_count_total,
                                            'products_count_active' => $products_count_active,
                                        );
                $db2->where('id', $category_product->id);
                $db2->update('cart_categories', $update_cart_category);

                $this->load->library('ftp');
                $this->load->helper("file");

                $ftp_config['hostname'] = "skyway.redplanethost.com"; 
                $ftp_config['hostname'] = "ftp.proverbs.ekomplete.com"; 
                $ftp_config['username'] = "jay@proverbs.ekomplete.com";
                $ftp_config['password'] = "dtMo;rB@VITU";
                $ftp_config['debug']    = TRUE;

                $this->ftp->connect($ftp_config);

               
                if($product->main_image != "")
                {
                    $main_image = '/public_html/images/modules/shoppingcart/products/'.$product->main_image;
                    $this->ftp->delete_file($main_image);
                }
                

                if($product->main_image_thumb != "")
                {
                    $main_image_thumb = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product->main_image_thumb;
                    $this->ftp->delete_file($main_image_thumb);
                }

                 if($product->image1 != "")
                {
                    $image1 = '/public_html/images/modules/shoppingcart/products/'.$product->image1;
                    $this->ftp->delete_file($image1);
                }


                if($product->image1_thumb != "")
                {
                    $image1_thumb = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product->image1_thumb;
                    $this->ftp->delete_file($image1_thumb);
                }

                if($product->image2 != "")
                {
                    $image2 = '/public_html/images/modules/shoppingcart/products/'.$product->image2;
                    $this->ftp->delete_file($image2);
                }

                if($product->image2_thumb != "")
                {
                    $image2_thumb = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product->image2_thumb;
                    $this->ftp->delete_file($image2_thumb);
                }

                if($product->image3 != "")
                {
                    $image3 = '/public_html/images/modules/shoppingcart/products/'.$product->image3;
                    $this->ftp->delete_file($image3);
                }

                if($product->image3_thumb != "")
                {
                    $image3_thumb = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product->image3_thumb;
                    $this->ftp->delete_file($image3_thumb);
                }

                if($product->image4 != "")
                {
                    $image4 = '/public_html/images/modules/shoppingcart/products/'.$product->image4;
                    $this->ftp->delete_file($image4);
                }

                if($product->image4_thumb != "")
                {
                    $image4_thumb = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product->image4_thumb;
                    $this->ftp->delete_file($image4_thumb);
                }

                if($product->image5 != "")
                {
                    $image5 = '/public_html/images/modules/shoppingcart/products/'.$product->image5;
                    $this->ftp->delete_file($image5);
                }

                if($product->image5_thumb != "")
                {
                    $image5_thumb = '/public_html/images/modules/shoppingcart/products/thumbs/'.$product->image5_thumb;
                    $this->ftp->delete_file($image5_thumb);
                }




                $db2->where('item_id', $id);
                $db2->delete('cart_products');
            }

            $update_eview = array(
                                'invoiceitems_id' => $id,
                                'details' => $data['details'],
                                'is_featured' => $is_featured,
                            );
             $this->db->where('id', $data['eview_id'])
                 ->update('tblinvoiceitems_eview', $update_eview);
            // $this->db->insert('tblinvoiceitems_eview', $insert_eview);
            // $insert_eview_id = $this->db->insert_id();

            // if ($_FILES['image']['name']) {
            //     $this->load->helper('polaris_upload');
            //     // handle_main_image_upload($data['eview_id']);
            //     $main_image_product = $_FILES['image']['name'];
            //     handle_product_main_image_upload($image_item_id,$main_image_product);
            // }

            

            if ($_FILES['image1']['name']) {
                $this->load->helper('polaris_upload');
                handle_image1_upload($data['eview_id']);
                // handle_product_image1_upload($image_item_id);
            }

            if ($_FILES['image2']['name']) {
                $this->load->helper('polaris_upload');
                handle_image2_upload($data['eview_id']);
                // handle_product_image2_upload($image_item_id);
            }

            if ($_FILES['image3']['name']) {
                $this->load->helper('polaris_upload');
                handle_image3_upload($data['eview_id']);
                // handle_product_image3_upload($image_item_id);
            }

            if ($_FILES['image4']['name']) {
                $this->load->helper('polaris_upload');
                handle_image4_upload($data['eview_id']);
                // handle_product_image4_upload($image_item_id);
            }

            if ($_FILES['image5']['name']) {
                $this->load->helper('polaris_upload');
                handle_image5_upload($data['eview_id']);
                // handle_product_image5_upload($image_item_id);
            }

            $this->db->where('eview_id', $data['eview_id']);
            $this->db->delete('tbleview_item');

            if (isset($data['items'])) {
                foreach ($data['items'] as $item) {
                    $this->db->insert('tbleview_item', array(
                        'eview_id' => $data['eview_id'],
                        'item_id' => $item,
                    ));
                }
            }
        }

		
        $data['discounts'] = serialize($data['discounts']);


        unset($data['details']);
        unset($data['is_featured']);
        unset($data['items']);
        unset($data['eview_id']);
        unset($data['item_id']);


        

        // $update_invoiceitem = array(
        //                         'description' => $data['description'];
        //                         'long_description' => $data['description'];
        //                         'rate' => $data['description'];
        //                         'tax' => $data['description'];
        //                         'sku' => $data['description'];
        //                         'manufacturersku' => $data['description'];
        //                         'itemtype' => $data['description'];
        //                         );


        
        $this->db->query("SET FOREIGN_KEY_CHECKS = 0");
        $this->db->where('id', $id)
                 ->update('tblinvoiceitemslist', $data);
        $this->db->query("SET FOREIGN_KEY_CHECKS = 1");


        // $this->db->select('tblinvoiceitems_eview.*');
        // $this->db->from('tblinvoiceitems_eview');
        // $this->db->where('tblinvoiceitems_eview.invoiceitems_id',$id);
        // $tblinvoiceitems_eview = $this->db->get()->row();

        // if ($_FILES['image']['name']) {
        //     $this->load->helper('polaris_upload');
        //     handle_item_upload($id,$tblinvoiceitems_eview->id);
        // }

    
        return true;
    }

    public function get_subcategory() {
        return $this->db->where('catid', $this->input->post('id'))->get('tblsubcategories')->result();
    }

    public function get_selecte_dsubcategory() {
        return $this->db->where('catid', $this->input->post('id'))->get('tblsubcategories')->result();
    }

    function get_prev($id) {
        return $this->db->query("select id from tblinvoiceitemslist where id = (select max(id) from tblinvoiceitemslist where id < $id)")->row();
    }

    function get_next($id) {
        return $this->db->query("select id from tblinvoiceitemslist where id = (select min(id) from tblinvoiceitemslist where id > $id)")->row();
    }
   function get_warehouse_location($ware_id,$location_name) {
            $this->db->select('tbllocations.location_id');
            $this->db->from('tbllocations');
            $this->db->where('tbllocations.ware_id', $ware_id);
            $this->db->where('tbllocations.location_name', $location_name);
            $location_id = $this->db->get()->row();
		//	$this->db->last_query();
			return $location_id;
}
}