<?php

ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Fullfillments_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get estimate by id
     * @param  mixed $id
     * @return array
     */

    public function get_list($clientid,$status,$from,$to)
    {
        // echo $from;
        // die;
        $this->db->select('tblorders.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblorders');
        $this->db->join('tblclients', 'tblclients.userid = tblorders.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblorders.currency', 'left');
        if($clientid != "")
        {
            $this->db->where('tblorders.clientid',$clientid);
        }

        if($status != "")
        {
            $this->db->where('tblorders.status',$status);
        }

        if($from != "")
        {
            $this->db->where('tblorders.date >=',$from);
        }

        if($to != "")
        {
            $this->db->where('tblorders.date <=',$to);
        }
        return $item = $this->db->get()->result();
    }

     public function get_orderpdf($from,$to)
    {
        // echo $from;
        // die;
        $this->db->select('tblorders.*,tblclients.accountname,tblclients.userid,tblcurrencies.symbol');
        $this->db->from('tblorders');
        $this->db->join('tblclients', 'tblclients.userid = tblorders.clientid', 'left');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblorders.currency', 'left');
       

        if($from != "")
        {
            $this->db->where('tblorders.date >=',$from);
        }

        if($to != "")
        {
            $this->db->where('tblorders.date <=',$to);
        }
        return $item = $this->db->get()->result();
    }

    public function get_estimates($id)
    {
        $this->db->select('tblestimates.number,tblestimates.id');
        $this->db->from('tblorders');
        $this->db->join('tblestimates', 'tblestimates.orderid = tblorders.id');
        $this->db->where('tblorders.id',$id);
        return $item = $this->db->get()->row();
    }

    public function get_invoice($id)
    {
        $this->db->select('tblinvoices.number,tblinvoices.id');
        $this->db->from('tblinvoices');
        // $this->db->join('tblorders', 'tblorders.invoiceid = tblinvoices.id', 'left');
        $this->db->join('tblorders', 'tblorders.invoiceid = tblinvoices.id', 'left');
        $this->db->where('tblorders.id',$id);
        return $item = $this->db->get()->row();
    }

    public function get($id = '') {
        $this->db->select('*,tblcurrencies.id as currencyid, tblorderfulfillments.id as id, tblcurrencies.name as currency_name');
        $this->db->from('tblorderfulfillments');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblorderfulfillments.currency', 'left');

        if (is_numeric($id)) {
            $this->db->where('tblorderfulfillments.id', $id);
            $order = $this->db->get()->row();

            if ($order) {
                $this->load->model('clients_model');
                $order->items = $this->get_order_items($id);
                $order->client = $this->clients_model->get($order->clientid);
                if ($order->client->company == '') {
                    $order->client->company = $order->client->firstname . ' ' . $order->client->lastname;
                }
            }
            return $order;
        }

        return $this->db->get()->result_array();
    }

    public function get_items($id) {
        return $this->get_order_items($id);
    }

    /**
     * Convert estimate to invoice
     * @param  mixed $id estimate id
     * @return mixed     New invoice ID
     */
    public function convert_to_invoice($id, $client = false) {
        // Recurring invoice date is okey lets convert it to new invoice
        $_order = $this->get($id);

        $new_invoice_data = array();
        $new_invoice_data['clientid'] = $_order->clientid;
        $new_invoice_data['_number'] = get_option('next_invoice_number');
        $new_invoice_data['date'] = _d(date('Y-m-d'));
        $new_invoice_data['duedate'] = _d(date('Y-m-d'));

        if ($_order->expirydate < date('Y-m-d')) {
            $new_invoice_data['duedate'] = _d($_order->expirydate);
        }

        $new_invoice_data['currency'] = $_order->currency;
        $new_invoice_data['subtotal'] = $_order->subtotal;
        $new_invoice_data['total'] = $_order->total;
        $new_invoice_data['adjustment'] = $_order->adjustment;
        $new_invoice_data['discount_percent'] = $_order->discount_percent;
        $new_invoice_data['discount_total'] = $_order->discount_total;
        $new_invoice_data['discount_type'] = $_order->discount_type;
        $new_invoice_data['sale_agent'] = $_order->sale_agent;

        $new_invoice_data['terms'] = get_option('predefined_terms_invoice');
        $new_invoice_data['clientnote'] = get_option('predefined_clientnote_invoice');

        // Set to unpaid status automatically
        $new_invoice_data['status'] = 1;
        $new_invoice_data['clientnote'] = '';
        $new_invoice_data['adminnote'] = 'Converted from order #' . format_order_number($_order->number);
        $this->load->model('payment_modes_model');

        $modes = $this->payment_modes_model->get();
        $temp_modes = array();

        foreach ($modes as $mode) {
            $temp_modes[] = $mode['id'];
        }

        $new_invoice_data['allowed_payment_modes'] = $temp_modes;
        $new_invoice_data['newitems'] = array();

        $key = 1;
        foreach ($_order->items as $item) {
            $new_invoice_data['newitems'][$key]['sku'] = $item['sku'];
            $new_invoice_data['newitems'][$key]['description'] = $item['description'];
//            $new_invoice_data['newitems'][$key]['long_description'] = $item['long_description'];
            $new_invoice_data['newitems'][$key]['qty'] = $item['qty'];
            $new_invoice_data['newitems'][$key]['itemorder_id'] = $item['itemorder_id'];
            $new_invoice_data['newitems'][$key]['taxid'] = $item['taxid'];
            $new_invoice_data['newitems'][$key]['disc'] = $item['disc'];
            $new_invoice_data['newitems'][$key]['rate'] = $item['rate'];
            $new_invoice_data['newitems'][$key]['order'] = $item['item_order'];
            $key++;
        }

        $this->load->model('invoices_model');
      

        $id = $this->invoices_model->add($new_invoice_data);

        if ($id) {
            // Update estimate with the new invoice data and set to status accepted
            $this->db->where('id', $_order->id);
            $this->db->update('tblorders', array(
                'invoiced_date' => date('Y-m-d H:i:s'),
                'invoiceid' => $id,
                'status' => 5
            ));
            if ($client == false) {
                $this->log_order_activity($_order->id, 'converted this order to invoice.<br /><a href="' . admin_url('invoices/list_invoices/' . $id) . '">' . format_invoice_number($new_invoice_data['_number']) . '</a>');
            }
        }

        return $id;
    }

    public function get_orders_total($data) {

        $statuses = array(
            1,
            2,
            3,
            4,
            5
        );
        $this->load->model('currencies_model');

        if ((is_using_multiple_currencies('tblorders') && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }

        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql = 'SELECT';
        foreach ($statuses as $order_status) {
            $sql .= '(SELECT SUM(total) FROM tblorders WHERE status=' . $order_status;
            $sql .= ' AND currency =' . $currencyid;
            $sql .= ') as "' . $order_status . '",';
        }

        $sql = substr($sql, 0, -1);
        $result = $this->db->query($sql)->result_array();
        $_result = array();
        $i = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total'] = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }

        return $_result;
    }

    /**
     * Get all estimate items
     * @param  mixed $id orderid
     * @return array
     */
    public function get_order_items($id) {
        $this->db->select('tblorderfulfillmentsitems.id,tblorderfulfillmentsitems.qty,taxrate,tblorderfulfillmentsitems.disc,tblorderfulfillmentsitems.itemorder_id,tbltaxes.id as taxid,tbltaxes.name as taxname,tblorderfulfillmentsitems.description as description,tblorderitems.item_order,tblorderfulfillmentsitems.sku,tblwarehouse.warehouse_name,tbllocations.location_name,tblorderitems.qty as qty1, tblorderfulfillmentsitems.orderid, tbllocations.location_id ,tblorderfulfillmentsitems.bin_id,tblbins.aisle,tblbins.row,tblbins.level,,tblbins.bin_name');
        $this->db->from('tblorderfulfillmentsitems');
        $this->db->join('tbltaxes', 'tbltaxes.id = tblorderfulfillmentsitems.taxid', 'left');
        $this->db->join('tblinvoiceitemslist', 'tblinvoiceitemslist.id = tblorderfulfillmentsitems.itemorder_id', 'left'); 
		$this->db->join('tblwarehouse', 'tblwarehouse.ware_id = tblinvoiceitemslist.ware_id', 'left');
		$this->db->join('tbllocations', 'tbllocations.location_id =  tblinvoiceitemslist.location_id', 'left');
		$this->db->join('tblorderfulfillments', 'tblorderfulfillments.id =  tblorderfulfillmentsitems.orderid', 'left');
		$this->db->join('tblbins', 'tblbins.bin_id =  tblorderfulfillmentsitems.bin_id', 'left');
		
		$this->db->join('tblorderitems', 'tblorderitems.itemorder_id = tblorderfulfillmentsitems.itemorder_id AND tblorderitems.orderid = tblorderfulfillments.order_id', 'left');
        $this->db->where('tblorderfulfillmentsitems.orderid', $id);
        $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }

    /**
     * Insert new estimate to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, estimate ID if succes
     */
    public function add($data) {

        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        unset($data['creditlimit']);

       
        $data['number'] = $data['_number'];

        $unsetters = array(
            '_number',
            'currency_symbol',
            'price',
            'taxname',
            'sku',
            'description',
            'itemrecorid',
            'disc',
            'taxid',
            'rate',
            'quantity'
        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }

        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            unset($data['custom_fields']);
        }

        $data['date'] = to_sql_date($data['date']);
        if (!empty($data['expirydate'])) {
            $data['expirydate'] = to_sql_date($data['expirydate']);
        } else {
            unset($data['expirydate']);
        }

        $data['terms'] = nl2br($data['terms']);
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['year'] = get_option('order_year');
        $data['addedfrom'] = get_staff_user_id();

        $items = array();
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }
            

        $_data = do_action('before_order_added', array(
            'data' => $data,
            'items' => $items
        ));

        $data = $_data['data'];
        $items = $_data['items'];


        $data['hash'] = md5(rand() . microtime());

        $data['number'] = get_option('next_pickticket_number');

        $data['vatpaid'] = str_replace(",", "",$data['vatpaid']);
        // Check if the key exists
        $this->db->where('hash', $data['hash']);
        $exists = $this->db->get('tblorderfulfillments')->row();

        $this->db->insert('tblorderfulfillments', $data);

        $insert_id = $this->db->insert_id();

        if ($insert_id) {

            if (isset($custom_fields)) {
                handle_custom_fields_post($insert_id, $custom_fields);
            }

            // Update next pickticket number in settings
            $this->db->where('name', 'next_pickticket_number');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
          

            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $this->db->insert('tblorderfulfillmentsitems', array(
                        'sku' => $item['sku'],
                        'description' => $item['description'],
                        'disc'=>$item['disc'],
                        'qty' => $item['qty'],
                           'itemorder_id'=>$item['itemorder_id'],
                        'rate' => $item['rate'],
                        'taxid' => $item['taxid'],
                        'orderid' => $insert_id,
                        'item_order' => $item['order'],
                    ));
                }
            }

            $this->log_order_activity($insert_id, 'created the order fulfillment');
            do_action('after_order_added', $insert_id);
            return $insert_id;
        }

        return false;
    }

    public function get_order_item($id) {
        $this->db->where('id', $id);
        return $this->db->get('tblorderitems')->row();
    }

   
    public function get_term($id){
       $this->db->select('payment_term');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row()->payment_term; 
    }
    public function get_sales_agent($id){
       $this->db->select('account_req');
       $this->db->where('userid', $id);
       return $this->db->get('tblclients')->row()->account_req; 
    }

    /**
     * Update estimate data
     * @param  array $data estimate data
     * @param  mixed $id   orderid
     * @return boolean
     */
    public function update($data, $id) {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
         unset($data['creditlimit']);

        $affectedRows = 0;
        $prefix = get_option('pickticket_prefix').get_option('pickticket_separator');
		
        $data['number'] = substr($data['number'], strlen($prefix));
        $data['number'] = trim($data['number']);

       /* if (get_option('order_number_format') == 2) {
            $_temp_number = explode('/', $data['number']);
            $data['number'] = $_temp_number[1];
        }*/

        $original_estimate = $this->get($id);
        $original_status = $original_order->status;
        $original_number = $original_order->number;

        unset($data['currency_symbol']);
        unset($data['price']);
        unset($data['taxname']);
        unset($data['taxid']);
        unset($data['isedit']);
        unset($data['sku']);
        unset($data['description']);
        unset($data['itemrecorid']);
        unset($data['disc']);
        unset($data['tax']);
        unset($data['rate']);
        unset($data['quantity']);


        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }

        if ($data['adjustment'] == 'NaN') {
            $data['adjustment'] = 0;
        }

        $data['terms'] = nl2br($data['terms']);
     //   $data['date'] = to_sql_date($data['date']);
      //  $data['expirydate'] = to_sql_date($data['expirydate']);
      //  $data['bin'] = $data['bin'];
      //  $data['warehouse'] = $data['ware_id'];
      //  $data['location'] = $data['location'];


        if (isset($data['custom_fields'])) {
            $custom_fields = $data['custom_fields'];
            if (handle_custom_fields_post($id, $custom_fields)) {
                $affectedRows++;
            }

            unset($data['custom_fields']);
        }


        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );

        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data = do_action('before_order_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems = $_data['newitems'];
        $items = $_data['items'];
        $data = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                foreach ($data['removed_items'] as $remove_item_id) {
                    $original_item = $this->get_order_item($remove_item_id);
                    $this->db->where('orderid', $id);
                    $this->db->where('id', $remove_item_id);
                    $this->db->delete('tblorderfulfillmentsitems');
                    if ($this->db->affected_rows() > 0) {
                    //    $this->log_order_activity($id, 'removed item <b>' . $original_item->description . '</b>');
                        $affectedRows++;
                    }
                }
            }
            unset($data['removed_items']);
        }

        $this->db->where('id', $id);
        $this->db->update('tblorderfulfillments', $data);

        if ($this->db->affected_rows() > 0) {
            // Check for status change
            if ($original_status != $data['status']) {
              //  $this->log_order_activity($original_order->id, 'Estimate Status Updated: From: ' . format_order_status($original_status) . ' To: ' . format_order_status($data['status']));
            }

            if ($original_number != $data['number']) {
             //   $this->log_order_activity($original_order->id, 'Estimate Number Changed: From: ' . format_order_number($original_number) . ' To: ' . format_order_number($data['number']));
            }

            $affectedRows++;
        }
        $this->load->model('taxes_model');
        if (count($items) > 0) {

            foreach ($items as $key => $item) {
                $order_item_id = $item['itemid'];

                $original_item = $this->get_order_item($order_item_id);

                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'item_order' => $item['order'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }
                // Check for invoice item short description change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'description' => $item['description'],
                ));

                if ($this->db->affected_rows() > 0) {
                   // $this->log_order_activity($id, 'updated item short description from ' . $original_item->description . ' to ' . $item['description']);
                    $affectedRows++;
                }

                // Check for item long description change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'sku' => nl2br($item['sku']),
                ));
                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'disc'=>$item['disc'],
                ));

                if ($this->db->affected_rows() > 0) {
                 //   $this->log_order_activity($id, 'updated item sku from ' . $original_item->sku . ' to ' . $item['sku']);
                    $affectedRows++;
                }
                // Check for tax id change
                $original_tax = $this->taxes_model->get($original_item->taxid);

                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'taxid' => $item['taxid'],
                ));

                if ($this->db->affected_rows() > 0) {
                    $tax_now = $this->taxes_model->get($item['taxid']);
                    if ($original_tax) {
                        if ($tax_now) {
                        //    $this->log_order_activity($id, 'updated tax (' . $original_tax->name . ') from ' . $original_tax->taxrate . '% to (' . $tax_now->name . ') ' . $tax_now->taxrate . '%');
                        } else {
                         //   $this->log_order_activity($id, 'removed tax (' . $original_tax->name . ') ' . $original_tax->taxrate . '%');
                        }
                    } else {
                     //   $this->log_order_activity($id, 'added tax (' . $tax_now->name . ') ' . $tax_now->taxrate . '%');
                    }
                    $affectedRows++;
                }

                // Check for item rate change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'rate' => $item['rate'],
                ));
                if ($this->db->affected_rows() > 0) {
                 //   $this->log_order_activity($id, 'updated item rate from ' . $original_item->rate . ' to ' . $item['rate']);
                    $affectedRows++;
                }
                // CHeck for invoice quantity change
                $this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'qty' => $item['qty']
                ));
				
				$this->db->where('id', $order_item_id);
                $this->db->update('tblorderfulfillmentsitems', array(
                    'bin_id' => $item['to_bin']
                ));

                if ($this->db->affected_rows() > 0) {
                 //   $this->log_order_activity($id, 'updated quantity on item <b>' . $item['description'] . '</b> from ' . $original_item->qty . ' to ' . $item['qty']);
                    $affectedRows++;
                }
            }
        }

        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblorderfulfillmentsitems', array(
                    'sku' => $item['sku'],
                    'description' => $item['description'],
                    'disc'=>$item['disc'],
                    'qty' => $item['qty'],
                    'itemorder_id'=>$item['itemorder_id'],
                    'rate' => $item['rate'],
                    'taxid' => $item['taxid'],
                    'orderid' => $id,
                    'item_order' => $item['order'],
                ));

                $new_item_added = $this->db->insert_id();
                if ($new_item_added) {
                   // $this->log_order_activity($id, 'added new item <b>' . $item['description'] . '</b>');
                    $affectedRows++;
                }
            }
        }

        if ($affectedRows > 0) {
            do_action('after_order_updated', $id);
            return true;
        }

        return false;
    }

    public function client_order_action($action, $id) {
        $this->db->where('id', $id);
        $this->db->update('tblorders', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {
            $this->load->model('staff_model');
            $staff = $this->staff_model->get('', 1);
            $estimate = $this->get($id);
            $invoiceid = false;
            $invoiced = false;
            if ($action == 4) {
//                if (get_option('order_auto_convert_to_invoice_on_client_accept') == 1) {
//                    $invoiceid = $this->convert_to_invoice($id, true);
//                    $this->load->model('invoices_model');
//                    if ($invoiceid) {
//                        $invoiced = true;
//                        $invoice = $this->invoices_model->get($invoiceid);
//                        $this->log_order_activity($id, 'Client accepted this estimate. Estimate is converted to invoice with number <a href="' . admin_url('invoices/list_invoices/' . $invoiceid) . '">' . format_invoice_number($invoice->number) . '</a>', false, true);
//                    }
//
//                } else {
//                    $this->log_order_activity($id, 'Client accepted this estimate.', false, true);
//                }
                $this->log_order_activity($id, 'Client accepted this estimate.', false, true);

                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffid'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Congratiolations! Client accepted estimate with number ' . format_order_number($order->number),
                            'link' => 'orders/list_orders/' . $id
                        ));
                    }
                }

                return array(
                    'invoiced' => $invoiced,
                    'invoiceid' => $invoiceid
                );
            } else if ($action == 3) {
                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffod'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Client declined estimate with number ' . format_order_number($order->number),
                            'link' => 'orders/list_orders/' . $id
                        ));
                    }
                }
                $this->log_order_activity($id, 'Client declined this estimate.', false, true);
                return true;
            }
        }

        return false;
    }

    /**
     * Delete estimate items and all connections
     * @param  mixed $id orderid
     * @return boolean
     */
    public function delete($id) {

        if (get_option('delete_only_on_last_estimate') == 1) {
            if (!is_last_estimate($id)) {
                return false;
            }
        }

        do_action('before_order_deleted', $id);
        $this->db->where('id', $id);
        $this->db->delete('tblorders');

        if ($this->db->affected_rows() > 0) {
            if (get_option('order_number_decrement_on_delete') == 1) {
                $current_next_order_number = get_option('next_order_number');
                if ($current_next_order_number > 1) {
                    // Decrement next estimate number to
                    $this->db->where('name', 'next_order_number');
                    $this->db->set('value', 'value-1', FALSE);
                    $this->db->update('tbloptions');
                }
            }
            $this->db->where('orderid', $id);
            $this->db->delete('tblorderitems');

            $this->db->where('orderid', $id);
            $this->db->delete('tblorderactivity');

            // Delete the custom field values
            $this->db->where('relid', $id);
            $this->db->where('fieldto', 'invoice');
            $this->db->delete('tblcustomfieldsvalues');

            return true;
        }
        return false;
    }

    /**
     * Set estimate to sent when email is successfuly sended to client
     * @param mixed $id orderid
     */
    public function set_order_sent($id) {
        $this->db->where('id', $id);
        $this->db->update('tblorders', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $description = 'sent order to client';
        $this->log_order_activity($id, $description);

        // Update estimate status to sent
        $this->db->where('id', $id);
        $this->db->update('tblorders', array(
            'status' => 2
        ));
    }

    /**
     * Sent estimate to client
     * @param  mixed  $id        orderid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach estimate pdf or not
     * @return boolean
     */
    public function sent_order_to_client($id, $template = '', $attachpdf = true) {

        $this->load->model('emails_model');
        $order = $this->get($id);
        if ($template == '') {
            if ($order->sent == 0) {
                $template = 'order-send-to-client';
            } else {
                $template = 'order-already-send';
            }
        }

        $order_number = format_order_number($order->number);
        $pdf = order_pdf($order);

        if ($attachpdf) {
            // $attach = $pdf->Output($order_number . '.pdf', 'S');
            $attach = $pdf->Output(APPPATH.'PDF/orderPDF/'.$order_number . '.pdf', 'F');
            $attachmentfile = APPPATH.'PDF/orderPDF/'.$order_number . '.pdf';
            $this->emails_model->add_attachment($attachmentfile, $order_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $order->client->email, $order->clientid, false, false, false, $id);
        if ($send) {
            $this->set_order_sent($id);
            return true;
        }

        return false;
    }

    /**
     * All estimate activity
     * @param  mixed $id orderid
     * @return array
     */
    public function get_order_activity($id) {
        $this->db->where('orderid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblorderactivity')->result_array();
    }

    /**
     * Log estimate activity to database
     * @param  mixed $id   orderid
     * @param  string $description activity description
     */
    public function log_order_activity($id, $description = '', $cron = false, $client = false) {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblorderactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'orderid' => $id,
            'staffid' => $staffid
        ));
    }

    function get_prev($id) {
        return $this->db->query("select id,clientid from tblorders where id = (select max(id) from tblorders where id < $id)")->row();
    }

    function get_next($id) {
        return $this->db->query("select id,clientid from tblorders where id = (select min(id) from tblorders where id > $id)")->row();
    }

    function change_order_status($status, $id) {
        $this->db->where('id', $id);
        return $this->db->update('tblorders', array('status' => $status));
    }
    public function update_credit($amount,$id){
       $amount = str_replace(',','',$amount);
       $this->db->query("UPDATE tblclients SET credit_limit = credit_limit + $amount WHERE userid =".$id);
    }

    public function getinvoices($id) {
       return   $this->db->select_sum('total')->where('status !=','2')->where('clientid',$id)->get('tblinvoices')->row();
    }
    public function getorders($id) {
       return   $this->db->select_sum('total')->where('clientid',$id)->get('tblorders')->row();
    }
    public function getcredit($id) {
       return   $this->db->where('userid',$id)->get('tblclients')->row();
    }
     public function get_discount($id){
         return   $this->db->where('id',$id)->get('tbldiscounts')->row()->discountrate;  
    }

}
