<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departments_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

     /**
     * @param  integer ID (optional)
     * @param  boolean (optional)
     * @return mixed
     * Get department object based on passed id if not passed id return array of all departments
     * Second parameter is to check if the request is coming from clientarea, so if any departments are hidden from client to exclude
     */
    public function get($id = false, $clientarea = false)
    {

        if ($clientarea == true) {
            $this->db->where('hidefromclient', 0);
        }

        if (is_numeric($id)) {
            $this->db->where('departmentid', $id);
            return $this->db->get('tbldepartments')->row();
        }

        return $this->db->get('tbldepartments')->result_array();
    }

    /**
     * @param array $_POST data
     * @return integer
     * Add new department
     */
    public function add($data)
    {
        if (isset($data['hidefromclient'])) {
            $data['hidefromclient'] = 1;
        } else {
            $data['hidefromclient'] = 0;
        }

        $data = do_action('before_department_added', $data);
        $this->db->insert('tbldepartments', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            do_action('after_department_added',$insert_id);
            logActivity('New Department Added [' . $data['name'] . ', ID: '.$insert_id.']');
        }

        return $insert_id;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update department to database
     */
    public function update($data, $id)
    {

        if ($data['email'] == '') {
            $data['email'] = NULL;
        }

        if (isset($data['hidefromclient'])) {
            $data['hidefromclient'] = 1;
        } else {
            $data['hidefromclient'] = 0;
        }

        $this->db->where('departmentid', $id);
        $this->db->update('tbldepartments', $data);

        if ($this->db->affected_rows() > 0) {
            logActivity('Department Updated [Name: '.$data['name'].', ID: ' . $id . ']');
            return true;
        }

        return false;
    }

    /**
     * @param  integer ID
     * @return mixed
     * Delete department from database, if used return array with key referenced
     */
    public function delete($id)
    {

        $current = $this->get($id);

        if (is_reference_in_table('department', 'tbltickets', $id)) {
            return array(
                'referenced' => true
            );
        }
        do_action('before_department_deleted', $id);
        $this->db->where('departmentid', $id);
        $this->db->delete('tbldepartments');

        if ($this->db->affected_rows() > 0) {
            logActivity('Department Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }


    /**
     * @param  integer ID (option)
     * @param  boolean (optional)
     * @return mixed
     * Get departments where staff belongs
     * If $onlyids passed return only departmentsID (simple array) if not returns array of all departments
     */
    function get_staff_departments($userid = false, $onlyids = false)
    {

        if ($userid == false) {
            $userid = get_staff_user_id();
        }

        if ($onlyids == false) {
            $this->db->select();
        } else {
            $this->db->select('tblstaffdepartments.departmentid');
        }
        $this->db->from('tblstaffdepartments');
        $this->db->join('tbldepartments', 'tblstaffdepartments.departmentid = tbldepartments.departmentid', 'left');
        $this->db->where('staffid', $userid);

        $departments = $this->db->get()->result_array();

        if ($onlyids == true) {
            $departmentsid = array();

            foreach ($departments as $department) {
                array_push($departmentsid, $department['departmentid']);
            }

            return $departmentsid;
        }

        return $departments;
    }
    public function adddepartment(){
        if($this->input->post('hidefromclient')){
            $hide = $this->input->post('hidefromclient');
        }else{
            $hide = 0;  
        }
        if($this->input->post('dep_is_active')){
            $active = $this->input->post('dep_is_active');
        }else{
            $active = 0;  
        }
        $data = array(
            'name' => $this->input->post('name'),
            'email' => $this->input->post('email'),
            'departmentemail' => $this->input->post('departmentemail'),
            'hidefromclient' => $hide,
            'is_active' => $active,
            'sort_order' => $this->input->post('sal_order') 
        );
        $cnt = $this->db->insert('tbldepartments', $data);
        $id = $this->db->insert_id();
        return $id;
    }

    public function addsalutation(){
        if($this->input->post('sal_is_active')){
            $active = $this->input->post('sal_is_active');
        }else{
            $active = 0;  
        }
        $data = array(
            'description' => $this->input->post('sal_name'),
            'is_active' => $active,
            'sort_order' => $this->input->post('sal_order') 
        );
        $this->db->insert('tblsalutation', $data);
        $id = $this->db->insert_id();
        return $id;
    }

    public function addposition(){
        if($this->input->post('pos_is_active')){
            $active = $this->input->post('pos_is_active');
        }else{
            $active = 0;  
        }
        $data = array(
            'description' => $this->input->post('pos_name'),
            'is_active' => $active,
            'sort_order' => $this->input->post('post_order')
        );
        $cnt = $this->db->insert('tblposition', $data);
        $id = $this->db->insert_id();
        return $id;
    }

    public function editdepartment(){
        if($this->input->post('hidefromclient')){
            $hide = $this->input->post('hidefromclient');
        }else{
            $hide = 0;  
        }
        if($this->input->post('dep_is_active')){
            $active = $this->input->post('dep_is_active');
        }else{
            $active = 0;  
        }
        $data = array(
            'name' => $this->input->post('name'),
            'departmentemail' => $this->input->post('departmentemail'),
            'email' => $this->input->post('email'),
            'hidefromclient' => $hide,
            'is_active' => $active,
            'sort_order' => $this->input->post('sal_order') 
        );
        $this->db->where('departmentid', $this->input->post('recordid'));
        $this->db->update('tbldepartments', $data);
       
        return $this->input->post('recordid');
    }

    public function editsalutation(){
        if($this->input->post('sal_is_active')){
            $active = $this->input->post('sal_is_active');
        }else{
            $active = 0;  
        }
        $data = array(
            'description' => $this->input->post('sal_name'),
            'is_active' => $active,
            'sort_order' => $this->input->post('sal_order')
        );
        $this->db->where('id', $this->input->post('recordid'));
        $cnt= $this->db->update('tblsalutation', $data);
         
        return $cnt;
    }
    public function editposition(){
        if($this->input->post('pos_is_active')){
            $active = $this->input->post('pos_is_active');
        }else{
            $active = 0;  
        }
        $data = array(
            'description' => $this->input->post('pos_name'),
            'is_active' => $active,
            'sort_order' => $this->input->post('post_order')
        );
        $this->db->where('id', $this->input->post('recordid'));
        $cnt= $this->db->update('tblposition', $data);

        return $cnt;
    }
    
        public function changestatus(){
            if($this->input->post('rowtype')== 'salutation'){
            $row = $this->db->where('id',$this->input->post('id'))->get('tblsalutation')->row();
           if($row->is_active == '0'){
                $data =array('is_active'=>1);
                $this->db->where('id', $this->input->post('id'));
                $this->db->update('tblsalutation', $data);
           }
           if($row->is_active == '1'){
                $data =array('is_active'=>0);
                $this->db->where('id', $this->input->post('id'));
                $this->db->update('tblsalutation', $data);
           }

            }
            if($this->input->post('rowtype')== 'position'){
            $row = $this->db->where('id',$this->input->post('id'))->get('tblsalutation')->row();
           if($row->is_active == '0'){
                $data =array('is_active'=>1);
                $this->db->where('id', $this->input->post('id'));
                $this->db->update('tblsalutation', $data);
           }
           if($row->is_active == '1'){
                $data =array('is_active'=>0);
                $this->db->where('id', $this->input->post('id'));
                $this->db->update('tblsalutation', $data);
           }

            }else{
            $row = $this->db->where('departmentid',$this->input->post('id'))->get('tbldepartments')->row();
           if($row->is_active == '0'){
                $data =array('is_active'=>1);
                $this->db->where('departmentid', $this->input->post('id'));
                $this->db->update('tbldepartments', $data);
           }
           if($row->is_active == '1'){
                $data =array('is_active'=>0);
                $this->db->where('departmentid', $this->input->post('id'));
                $this->db->update('tbldepartments', $data);
           }
 
            }
        }
        function getdatadapartment(){
            $row = $this->db->where('departmentid',$this->input->post('id'))->get('tbldepartments')->row();
            echo json_encode($row);
        }
        function getdatasalutation(){
            $row = $this->db->where('id',$this->input->post('id'))->get('tblsalutation')->row();
            echo json_encode($row);
        }
        function getdataposition(){
            $row = $this->db->where('id',$this->input->post('id'))->get('tblposition')->row();
            echo json_encode($row);
        }
   


}
