<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Companies_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    public function get($id = false, $active = '')
    {
        //$this->db->join('tblcountries','tblcountries.country_id = tblclients.country', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $client = $this->db->get('tblcompanies')->row();

            return $client;
        }
 
        $this->db->order_by('created', 'asc');
        return $this->db->get('tblcompanies')->result_array();
    }

    public function add($data) {
        unset($data['action']);
         unset($data['radio']);
         
        $this->db->insert('tblcompanies', $data);
        $insert_id = $this->db->insert_id();
       
       logActivity('New Company Added [ID:' . $insert_id . ', ' . $data['name'] . ']');
        return $insert_id;
       
    }

    public function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('tblcompanies');

        if ($this->db->affected_rows() > 0) {
            logActivity('Company Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
    
   public function get_countries() {
        return $this->db->get('tblcountries')->result();
    }
    
   

    public function get_where_tbl($tbl, $col) {
        return $this->db->where($col, 1)->get($tbl)->result();
    }
   

    public function update($data, $id) {
       
         unset($data['action']);
         unset($data['isedit']);
		 unset($data['radio']);
        $this->db->where('id', $id)->update('tblcompanies', $data);
		logActivity('Company Edited [ID:' . $id . ', ' . $data['name'] . ']');
        return true;

    }
     public function change_company_status($id, $status)
    {
        $this->db->where('id', $id);
        $this->db->update('tblcompanies', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Company Status Changed [Company: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }
   
    
}
