<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Categories_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    public function change_category_status($id, $status) {
        $this->db->where('category_id', $id);
        $this->db->update('tblcategories', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Category Status Changed [CategoryID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }

    public function update($data, $id) {
        $data = $_data['data'];

        $this->db->where('category_id', $id);
        $this->db->update('tblcategories', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            do_action('after_category_updated', $id);
            $_update_client_log = $data['firstname'] . ' ' . $data['lastname'];
            $_is_staff = NULL;

            if (is_staff_logged_in()) {
                $_update_client_log .= ' From Staff: ' . get_staff_user_id();
                $_is_staff = get_staff_user_id();
            }

            logActivity('Client Info Updated [' . $_update_client_log . ']', $_is_staff);
            return true;
        }

        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }

    public function delete($id) {
        $affectedRows = 0;
        do_action('before_category_deleted', $id);
        $this->db->where('category_id', $id);
        $affectedRows =$this->db->delete('tblcategories');

        if ($affectedRows > 0) {
            do_action('after_category_deleted');
            logActivity('Category Deleted [' . $id . ']');
            return true;
        }
       
    }

    public function get_category_details($id) {
        return $this->db->where('category_id', $id)->get('tblcategories')->first_row();
    }

    public function update_category_details() {
        $id   = $this->input->post('cat_id');
        $active = $this->input->post('cat_is_active')?$this->input->post('cat_is_active'):0;
        $data = array(
            'category_name' => $this->input->post('categoryname'),
            'description'   => $this->input->post('description'),
            'sales'   => $this->input->post('sales'),
            'inventory'   => $this->input->post('inventory'),
            'cogs'   => $this->input->post('cogs'),
            'active'        => $active
        );
        $this->db->where('category_id', $id)->update('tblcategories',$data);
    }
    
    public function add_category_details(){
        $active = $this->input->post('cat_is_active')?$this->input->post('cat_is_active'):0;
        $data = array(
            'category_name' => $this->input->post('categoryname'),
            'description'   => $this->input->post('description'),
            'sales'   => $this->input->post('sales'),
            'inventory'   => $this->input->post('inventory'),
            'cogs'   => $this->input->post('cogs'),
            'active'        => $active
        );
        
        $this->db->insert('tblcategories',$data);

    }
     public function changestatus(){
       
            $row = $this->db->where('category_id',$this->input->post('id'))->get('tblcategories')->row();
           if($row->active == '0'){
                $data =array('active'=>1);
                $this->db->where('category_id', $this->input->post('id'));
                $this->db->update('tblcategories', $data);
           }
           if($row->active == '1'){
                $data =array('active'=>0);
                $this->db->where('category_id', $this->input->post('id'));
                $this->db->update('tblcategories', $data);
           }

            }
}
