<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Bins_model extends CRM_Model {

    function __construct() {
        parent::__construct();
         $this->load->model('bins_model');
    }

    public function change_category_status($id, $status) {
        $this->db->where('category_id', $id);
        $this->db->update('tblcategories', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Category Status Changed [CategoryID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }

    public function update($data, $id) {
        $data = $_data['data'];

        $this->db->where('category_id', $id);
        $this->db->update('tblcategories', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            do_action('after_category_updated', $id);
            $_update_client_log = $data['firstname'] . ' ' . $data['lastname'];
            $_is_staff = NULL;

            if (is_staff_logged_in()) {
                $_update_client_log .= ' From Staff: ' . get_staff_user_id();
                $_is_staff = get_staff_user_id();
            }

            logActivity('Client Info Updated [' . $_update_client_log . ']', $_is_staff);
            return true;
        }

        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }

    public function delete($id) {
        $affectedRows = 0;
        do_action('before_bin_deleted', $id);
        $this->db->where('bin_id', $id);
        $affectedRows =$this->db->delete('tblbins');

        if ($affectedRows > 0) {
            do_action('after_bin_deleted');
            logActivity('Bin Deleted [' . $id . ']');
            return true;
        }
       
    }

    public function get_bins_details($id) {
        return $this->db->where('bin_id', $id)->get('tblbins')->first_row();
    }
    
    public function get_warehouse() {
        return $this->db->get('tblwarehouse')->result();
    }

     public function get_locations_warehouse() {
        return $this->db->where('ware_id', $this->input->post('id'))->get('tbllocations')->result();
    }
    
    public function get_location() {
        return $this->db->get('tbllocations')->result();
    }

    public function update_bin_details() {
        $id   = $this->input->post('bin_id');
        $active = $this->input->post('bin_is_active')?$this->input->post('bin_is_active'):0;
        $active = $this->input->post('allow_picking')?$this->input->post('allow_picking'):0;
        $data = array(
            'bin_name' => $this->input->post('bin_name'),
            'ware_id' => $this->input->post('ware_id'),
            'location_id' => $this->input->post('location_id'),
            'aisle' => $this->input->post('aisle'),
            'row' => $this->input->post('row'),
            'level' => $this->input->post('level'),
            'label' => $this->input->post('label'),
            'allow_picking' => $this->input->post('allow_picking'),
            'active' => $active
        );
        $this->db->where('bin_id', $id)->update('tblbins',$data);
        return $id;
    }
    
    public function add_bin_details(){
        $active = $this->input->post('bin_is_active')?$this->input->post('bin_is_active'):0;
        $active = $this->input->post('allow_picking')?$this->input->post('allow_picking'):0;
        $data = array(
            'bin_name' => $this->input->post('bin_name'),
            'ware_id' => $this->input->post('ware_id'),
            'location_id' => $this->input->post('location_id'),
            'aisle' => $this->input->post('aisle'),
            'row' => $this->input->post('row'),
            'level' => $this->input->post('level'),
            'label' => $this->input->post('label'),
            'allow_picking' => $this->input->post('allow_picking'),
            'active' => $active
        );
        
        $this->db->insert('tblbins',$data);
        $id = $this->db->insert_id();
        return $id;
    }
    
    public function changestatus(){
       
            $row = $this->db->where('location_id',$this->input->post('id'))->get('tbllocations')->row();
           if($row->active == '0'){
                $data =array('active'=>1);
                $this->db->where('location_id', $this->input->post('id'));
                $this->db->update('tbllocations', $data);
           }
           if($row->active == '1'){
                $data =array('active'=>0);
                $this->db->where('location_id', $this->input->post('id'));
                $this->db->update('tbllocations', $data);
           }

            }
   
}
