<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Bin_transfer_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }
   public function get_list()
    {
        $this->db->select('tblbintransfer.*,tblbintransfer_item.oursku,tblbintransfer_item.qty,tblbintransfer_item.uom');
        $this->db->from('tblbintransfer');
        $this->db->join('tblbintransfer_item','tblbintransfer_item.bintransfer_id = tblbintransfer.id');   
		$this->db->group_by('tblbintransfer.id');
        $this->db->order_by('tblbintransfer.date','DESC');
        return $this->db->get()->result(); 
    }
    public function get_warehouse()
    {
        return $this->db->get('tblwarehouse')->result();
    }

    public function get_location($ware_id)
    {
        return $this->db->where('ware_id',$ware_id)->order_by('location_id','ASC')->get('tbllocations')->result(); 
    }

    public function get_bin($location_id)
    {
        return $this->db->where('location_id',$location_id)->order_by('bin_id','ASC')->get('tblbins')->result(); 
    }


    public function get_tobin($bin_id)
    {
        return $this->db->where('bin_id !=',$bin_id)->order_by('bin_id','ASC')->get('tblbins')->result(); 
    }

    public function get_item($warehouse_id)
    {
        // $this->db->select('tblwarehousestock.*');
        // $this->db->from('tblwarehousestock');
        // $this->db->where('tblwarehousestock.location_id',$location_id);
        // $this->db->where('tblwarehousestock.warehouse_id',$warehouse_id);
        // $this->db->order_by('id','ASC');
        // return $this->db->get()->result(); 

        $this->db->select('tblwarehousestock.*,tblunitsofmeasure.name,tbllocations.location_name,tblbins.bin_name,tblbins.bin_id,tblunitsofmeasure.id as uomid');
        $this->db->from('tblwarehousestock');
        $this->db->join('tblinvoiceitemslist','tblinvoiceitemslist.sku = tblwarehousestock.suppliersku');
        $this->db->join('tblunitsofmeasure','tblunitsofmeasure.id = tblinvoiceitemslist.unitofmeasure');
        $this->db->join('tbllocations','tbllocations.location_id = tblwarehousestock.location_id');
        $this->db->join('tblinternaltransfer_item','tblinternaltransfer_item.to_location = tblwarehousestock.location_id AND tblinternaltransfer_item.suppliersku = tblwarehousestock.suppliersku');
        $this->db->join('tblbins','tblbins.bin_id = tblinternaltransfer_item.to_bin');
        // $this->db->join('tblstaff','tblstaff.staffid = tbladminwarehousereminders.staff');
        $this->db->where('tblwarehousestock.warehouse_id',$warehouse_id);
        $this->db->order_by('tblwarehousestock.suppliersku','ASC');
        return $this->db->get()->result(); 
    }
public function transfer_bin($data)
    {
        // echo "<pre>";
        // print_r($this->input->post());
        // die;
        $var = $data['date'];
        $date = str_replace('/', '-', $var);


        $this->db->insert('tblbintransfer', array(
                    'transfer_id' => $data['number'],
                    'date' => date('Y-m-d', strtotime($date)),
                    'from_warehouse' => $data['from_warehouse'],
                
                ));
        $internaltransfer_id = $this->db->insert_id();

        foreach ($data['warehouse_transfer_id'] as $key => $wh_id) 
        {
            // print_r($data['qty'][$key]);
            if($data['qty'][$key] == "")
            {
                $data['qty'][$key] = 0;
            }
            // echo $data['qty'][$key];

            $this->db->select('tblwarehousestock.*');
            $this->db->from('tblwarehousestock');
            $this->db->where('tblwarehousestock.suppliersku', $data['suppliersku'][$key]);
            // $this->db->where('tblwarehousestock.warehouse_id', $data['to_warehouse']);
            $this->db->where('tblwarehousestock.location_id', $data['to_location'][$key]);
            $warehouse_stock = $this->db->get()->row();

            $this->db->select('tblwarehousestock.*');
            $this->db->from('tblwarehousestock');
            $this->db->where('tblwarehousestock.id', $wh_id);
            $warehousefrom = $this->db->get()->row();

            $from_warehouse_qty = $warehousefrom->qty - $data['qty'][$key];
            $this->db->where('id', $wh_id);
            $this->db->set('qty', $from_warehouse_qty, FALSE);
            $this->db->update('tblwarehousestock');
            
            if($warehouse_stock)
            {

                $to_warehouse_qty = $warehouse_stock->qty + $data['qty'][$key];

                $this->db->where('id', $warehouse_stock->id);
                // $this->db->set('qty', 'qty+'.$data['qty'][$key], FALSE);
                $this->db->set('qty', $to_warehouse_qty, FALSE);
                $this->db->update('tblwarehousestock');

                
            }
            else
            {
                $this->db->insert('tblwarehousestock', array(
                    'suppliersku' => $data['suppliersku'][$key],
                    'oursku' => $data['oursku'][$key],
                    'description' => $data['description'][$key],
                    'qty' => $data['qty'][$key],
                    'warehouse_id' => $data['from_warehouse'],
                    'location_id' => $data['to_location'][$key],
                    'date' => date('Y-m-d', strtotime($date)),
                    // 'grnid' => $insert_id,
                    
                ));
            }

            if($data['qty'][$key] != 0)
            {
                $this->db->insert('tblbintransfer_item', array(
                        'bintransfer_id' => $internaltransfer_id,
                        'suppliersku' => $data['suppliersku'][$key],
                        'oursku' => $data['oursku'][$key],
                        'description' => $data['description'][$key],
                        'qty' => $data['qty'][$key],
                        'uom' => $data['uom'][$key],
                        'from_location' => $data['from_location'][$key],
                        'from_bin' => $data['from_bin'][$key],
                        'to_location' => $data['to_location'][$key],
                        'to_bin' => $data['to_bin'][$key],
                    ));
            }

        }
		    // Update next internal transfer number in settings
            $this->db->where('name', 'next_bin_transfer');
            $this->db->set('value', 'value+1', FALSE);
            $this->db->update('tbloptions');
          
          
        // die;
        return true; 
    }
	 public function get_internaltransfer($id)
    {
        $this->db->select('tblbintransfer.*');
        $this->db->from('tblbintransfer');
        $this->db->where('tblbintransfer.id',$id);
        return $this->db->get()->row(); 
    }

    public function get_internaltransfer_item($id)
    {
        $this->db->select('tblbintransfer_item.*');
        $this->db->from('tblbintransfer_item');
        $this->db->where('tblbintransfer_item.bintransfer_id',$id);
        return $this->db->get()->result(); 
    }
}