<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Banksaccounts_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get invoice item by ID
     * @param  mixed $id
     * @return mixed - array if not passed id, object if id passed
     */
    public function get($id = false, $active = '')
    {
        //$this->db->join('tblcountries','tblcountries.country_id = tblclients.country', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('ware_id', $id);
            $client = $this->db->get('tblwarehouse')->row();

            return $client;
        }

        //$this->db->order_by('datecreated', 'desc');
        return $this->db->get('tblwarehouse')->result_array();
    }



public function get_where_record($tbl,$id)
{
    
  return $this->db->where('contact_id', $id)->get($tbl)->row();  
}

public function get_client($id){
      return $this->db->where('ware_id', $id)->get('tblwarehouse')->row(); 
}
public function branches_by_bank($id){
       return $this->db->where('bankid', $id)->get('tblbankbranches')->result();

}
public function get_ledgers(){
        return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }
public function get_banks(){
     return $this->db->order_by('bank', 'ASC')->get('tblbanks')->result();  
}
public function get_departments(){
   return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
}

    /**
     * Add new invoice item
     * @param array $data Invoice item data
     * @return boolean
     */
    public function add($data) {
	
      unset($data['action']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);
        $data['dateOpened'] = to_sql_date($data['dateOpened']);
        $data['balance']= str_replace(',','', $data['balance']);
        $data['overdraft']= str_replace(',','', $data['overdraft']);
        $data['available']= str_replace(',','', $data['available']);
        
        if($data['balance'] &&  $data['overdraft'] ==''){
           $data['available']= $data['balance']; 
        }else{
             $data['available']= $data['balance']+$data['overdraft']; 
        }
      
        $this->db->insert('tblbanksaccount', $data);
        $insert_id = $this->db->insert_id();
		
		if($data['balance'] != '0' || $data['balance'] != '0.00'){
			
        
          $this->db->select_max('voucher');
          $this->db->where('vchtype', '9');
          $voucher = $this->db->get('tblvoucher')->row()->voucher;

          if($voucher){
              $voucher = ++$voucher;
          }else{
           $voucher ='OB-0001';
          }

          $voucherdate = date('Y-m-d H:i:s');

          $this->db->insert('tblvoucher',array(
                         
                    'voucher'=>$voucher,
                    'vchtype'=>'9',
                    'invoiceid'=>0,
                    'docdate'=>$voucherdate,
                    'trxdate'=>$voucherdate,
                    'created_by'=> get_staff_user_id(),
                    'currency'=>'3',
               
                    ));
          $voucherid = $this->db->insert_id();

          $this->load->model('settings_model');
          $default_options = $this->settings_model->getOptions();

          

            $opening_balance_ledger =  array(
                                'ledger'=>$default_options['opening_balance'],
                                'vchid'=>$voucherid,
                                'amount'=>$data['balance'],
                                'description'=>'Account Balance',
                                'refrence'=>$voucher,
                               // 'invoiceid'=>$invoicenumber,
                               'poid'=>'',
                                'item_order'=> 0,
                                'amount_type'=>1
                                );
            $this->db->insert('tblvoucherlines',$opening_balance_ledger);

            $account_receivable_ledger =  array(
                                'ledger'=>$data['ledger'],
                                'vchid'=>$voucherid,
                                'amount'=>$data['balance'],
                                'description'=>'Opening Balance Equity',
                                'refrence'=>$voucher,
                               // 'invoiceid'=>$invoicenumber,
                               'poid'=>'',
                                'item_order'=> 0,
                                'amount_type'=>0
                                );
            $this->db->insert('tblvoucherlines',$account_receivable_ledger);       
		
		
		
		}

        if ($insert_id) {
            logActivity('New Bank Account Added [ID:' . $insert_id . ', ' . $data['warehouse_name'] . ']');
            return $insert_id;
        }
        return false;
    }

    /**
     * Delete invoice item
     * @param  mixed $id
     * @return boolean
     */
    public function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('tblbanksaccount');

        if ($this->db->affected_rows() > 0) {
            logActivity('Bank Account Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
  

        public function get_countries() {
        return $this->db->get('tblcountries')->result();
    }
    
   

    public function get_where_tbl($tbl, $col) {
        return $this->db->where($col, 1)->get($tbl)->result();
    }

    public function get_where_single_tbl($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->row();
    }
    
    public function get_where_single_tbl_result($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->result();
    }
        public function get_branches() {
        return $this->db->where('bankid', $this->input->post('id'))->get('tblbankbranches')->result();
    }

    public function update($data, $id) {
         unset($data['action']);
      unset($data['save']);
      unset($data['cancel']);
      unset($data['snew']);
      unset($data['slist']);
       $data['dateOpened'] = to_sql_date($data['dateOpened']);
       
        $data['balance']= str_replace(',','', $data['balance']);
        $data['overdraft']= str_replace(',','', $data['overdraft']);
        $data['available']= str_replace(',','', $data['available']);
   
        if($data['balance'] &&  $data['overdraft'] ==''){
           $data['available']= $data['balance']; 
        }else{
             $data['available']= $data['balance']+$data['overdraft']; 
        }
        $this->db->where('id', $id)->update('tblbanksaccount', $data);
        return true;

    }

    public function get_bank_name($id)
    {
      $this->db->select('*');
      $this->db->from('tblbanks');
      $this->db->where('bankid',$id);
      return $this->db->get()->row();
    }
    
 
    
}
