<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bankbranches_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  mixed $id client id (optional)
     * @param  integer $active (optional) get all active or inactive
     * @return mixed
     * Get client object based on passed clientid if not passed clientid return array of all clients
     */
    public function get($id = false, $active = '')
    {


        $this->db->join('tblcountries','tblcountries.country_id = tblbankbranches.country', 'left');
        $this->db->join('tblbanks','tblbanks.bankid = tblbankbranches.bankid', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('bankbranchid', $id);
            $client = $this->db->get('tblbankbranches')->row();

            return $client;
        }

        $this->db->order_by('tblbankbranches.datecreated', 'desc');
        return $this->db->get('tblbankbranches')->result_array();

    }

   /*get last client account number*/
public function get_departments(){
   return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
}

public function get_last_user(){
 return $this->db->order_by('bankbranchid','DESC')->get('tblclients')->row();
}

public function get_country($id){
   return $this->db->where('country_id',$id)->get('tblcountries')->row();  
}
public function get_pai_balance($id){
   $result = $this->db->select_sum('amount')->where('invoiceid',$id)->get('tblinvoicepaymentrecords')->row();
   if($result){
       return $result->amount;
   }else{
       return 0;
   }
}
public function get_balance($id){
    $result = $this->db->where('clientid',$id)->get('tblinvoices')->result();

    if(!empty($result)){
        $total=$paidamount=0;
        foreach ($result as $value) {
            $paidamount +=$this->get_pai_balance($value->id);
            $total +=$value->total;
        }
        
        return $total-$paidamount;
    }
}

public function get_contact($id){
 return $this->db->where('bankbranchid',$id)->get('tblclientcontacts')->result();
}

 
 function getSingleRecord($table, $where) {
        return $this->db->get_where($table, $where)->row();
    }
    
 function getDataByOrder($table, $where ) {
        $this->db->order_by('sort_order', 'asc');
        return $this->db->get_where($table, $where)->result_array();
 }

public function addcontact(){
    $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
        'bankbranchid'   => $this->input->post('bankbranchid'));
    $res=$this->db->insert('tblbankbranchecontacts', $data);  
    return $this->db->insert_id();
    
}
public function updateContacts($contactid)
{
     $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
      );
        $this->db->where('id', $this->input->post('contactid'));
        $res=$this->db->update('tblbankbranchecontacts',$data);
        return $res;
}


public function getRecords($tbl)
{
  return $this->db->get($tbl)->result_array();  
}
public function get_where_record($tbl,$id)
{
    
  return $this->db->where('id', $id)->get($tbl)->row();  
}
public function getcontact($id)
{    
  return $this->db->where('id', $id)->get('tblbankbranchecontacts')->row();  
}
public function get_bank($id)
{
   
  return  $this->db->where('bankid', $id)->get('tblbanks')->row()->bank;  
  
}

public function DeleteContacts($id)
{
        $this->db->where('id', $id);
        $res=$this->db->delete('tblbankbranchecontacts');
        return $res;
}
public function delete_reminder($id)
{
        $this->db->where('id', $id);
        $res=$this->db->delete('tblbankbranchesreminders');
        return $res;
}
public function get_client($id){
      return $this->db->where('bankbranchid', $id)->get('tblbankbranches')->row(); 
}


    /**
     * @param array $_POST data
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

       $this->db->where('email', $data['email']);
        $email = $this->db->get('tblbankbranches')->row();
        if ($email) {
            die('Email already exists');
        }

        $data['datecreated'] = date('Y-m-d H:i:s');
        $data = do_action('before_client_added', $data);
        $this->db->insert('tblbankbranches', $data);
        $bankbranchid = $this->db->insert_id();
        return $bankbranchid;
    }

    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
    public function update($data, $id)
    {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
       
        $this->db->where('bankbranchid', $id);
        $this->db->update('tblbankbranches', $data);
      
        return true;
    }

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function delete($id)
    {

        do_action('before_client_deleted', $id);

        $this->db->where('bankbranchid', $id);
        $this->db->delete('tblbankbranches');
         return true;
    }


    /**
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     * Update client status Active/Inactive
     */
    public function change_bank_status($id, $status)
    {
        $this->db->where('bankbranchid', $id);
        $this->db->update('tblbankbranches', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Bank Status Changed [ClientID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }
    
function get_prev($id){
   return $this->db->query("select bankbranchid from tblbankbranches where bankbranchid = (select max(bankbranchid) from tblbankbranches where bankbranchid < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select bankbranchid from tblbankbranches where bankbranchid = (select min(bankbranchid) from tblbankbranches where bankbranchid > $id)")->row();
}
   public function add_reminder($data,$id){

        if(isset($data['notify_by_email'])){
            $data['notify_by_email'] = 1;
        } else {
             $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tblbankbranchesreminders',$data);

        $insert_id = $this->db->insert_id();
        if($insert_id){
            logActivity('New Bank Branch Reminder Added [Bank Branch ID: ' . $data['bankbranchid'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }
    public function add_user_note($data, $userid, $staff) {
        $data['dateadded'] = date('Y-m-d H:i:s');
        $data['addedfrom'] = get_staff_user_id();
        $data['staff'] = $staff;
        $data['description'] = nl2br($data['description']);
        $data['branchid'] = $userid;

        $this->db->insert('tblbankbranchesnotes', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            logActivity('Branch Note Added [Branch ID: ' . $userid . ' Staff: ' . $staff . ']');
        }

        return $insert_id;
    }
     public function delete_user_note($noteid) {
        $this->db->where('usernoteid', $noteid);
        $this->db->delete('tblbankbranchesnotes');

        if ($this->db->affected_rows() > 0) {
            logActivity('Branch Note Deleted [NoteID: ' . $noteid . ']');
            return true;
        }

        return false;
    }
      public function get_user_notes($userid, $staff = true) {
        $this->db->select('tblbankbranchesnotes.dateadded,description,usernoteid,tblstaff.firstname,tblstaff.lastname,addedfrom');
        $this->db->from('tblbankbranchesnotes');
        $this->db->join('tblstaff', 'tblbankbranchesnotes.addedfrom = tblstaff.staffid', 'left');
        $this->db->where('staff', $staff);
        $this->db->where('tblbankbranchesnotes.branchid', $userid);
        $this->db->order_by('tblbankbranchesnotes.dateadded', 'ASC');
        return $this->db->get()->result_array();
    }

    function get_all_customer_attachments($id){
       $attachments = array();
        $attachments['client'] = array();
        $this->db->where('clientid',$id);
        $client_main_attachments = $this->db->get('tblbankbrancheattachments')->result_array();
        $attachments['client'] = $client_main_attachments;
        return $attachments;
  }
  public function delete_attachment($id){
    $this->db->where('id',$id);
    $attachment = $this->db->get('tblbankbrancheattachments')->row();
    if($attachment){
        if(unlink(BRANCH_ATTACHMENTS_FOLDER . $attachment->clientid . '/' . $attachment->file_name)){
            $this->db->where('id',$id);
            $this->db->delete('tblbankbrancheattachments');

            return true;
        }

          // Check if no attachments left, so we can delete the folder also
        $other_attachments = list_files(BRANCH_ATTACHMENTS_FOLDER . $attachment->clientid);
        if(count($other_attachments) == 0){
            delete_dir(BRANCH_ATTACHMENTS_FOLDER . $attachment->clientid);
        }
    }

    return false;
}

}
