<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Warehouse_transfer extends Admin_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('warehouse_transfer_model');
        // $this->load->helper('warehouse_transfer');
    }

    public function index($id = '')
    {
      
      $data['warehouse_transfers'] = $this->warehouse_transfer_model->get_list();

      $title = _l('warehouse_transfer');
      
      $data['title'] = $title;
      $this->load->view('admin/warehouse_transfer/manage',$data);
    }

    public function warehouse_transfer($id = '')
    {
      if($this->input->post() && !$this->input->is_ajax_request()){
			  if(!has_permission('managePayments')){
				  access_denied('managePayments');
			  }

  			if($id == ''){
                  
  				$id = $this->warehouse_transfer_model->transfer_warehouse($this->input->post());
          if ($id) {
               set_alert('success', _l('warehouse_transfer'));
               redirect(admin_url('warehouse_transfer/warehouse_transfer'));
          }else {
            set_alert('danger', _l('warehouse_transfer'));
            redirect(admin_url('warehouse_transfer/warehouse_transfer'));
          }                     
  			}
		  }

  		if($id == ''){
  			$title = _l('add_new',_l('warehouse_transfer'));
  		} 

	    $title = _l('warehouse_transfer');
      $data['from_warehouse'] = $this->warehouse_transfer_model->get_warehouse();
      $data['to_warehouse'] = $this->warehouse_transfer_model->get_warehouse();

      $this->load->model('taxes_model');
      $data['taxes'] = $this->taxes_model->get();
      $this->load->model('discount_model');
      $data['discount'] = $this->discount_model->get_discounts();
               
                
      $data['title'] = $title;
	  
		  $this->load->view('admin/warehouse_transfer/warehouse_transfer',$data);
    }

    public function get_location()
    {
    	$ware_id =  $this->input->post('ware_id');
       
        $location = $this->warehouse_transfer_model->get_location($ware_id);
        $options ='<option value=""></option>';
          if(isset($location)){
              foreach ($location as $value) {
               $options .='<option value="'.$value->location_id.'">'.$value->location_name.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
    }

    public function get_tolocation()
    {
      $ware_id =  $this->input->post('ware_id');
       
        $location = $this->warehouse_transfer_model->get_location($ware_id);
        $options ='<option value=""></option>';
          if(isset($location)){
              foreach ($location as $value) {
                 $selected = '';
                if ($ware_id == $value->ware_id && $value->default_location == 1):
                        $selected = "selected=selected";
                endif;

               $options .='<option value="'.$value->location_id.'"'.$selected.'>'.$value->location_name.'</option>';   
              }
          } 
          echo json_encode(array('options'=>$options));
    }

    public function unsel_ware()
    {
      $ware_id =  $this->input->post('ware_id');
       
        $location = $this->warehouse_transfer_model->unsel_ware($ware_id);
        $options ='<option value=""></option>';
          if(isset($location)){
              foreach ($location as $value) {
               $options .='<option value="'.$value->ware_id.'">'.$value->warehouse_name.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
    }

    public function get_item($value='')
    {
        $location_id =  $this->input->post('location_id');
    	  $warehouse_id =  $this->input->post('warehouse_id');
       
        $location = $this->warehouse_transfer_model->get_item($location_id,$warehouse_id);

        // $options ='<option value=""></option>';
        //   if(isset($location)){
        //       foreach ($location as $value) {
        //        $options .='<option value="'.$value->location_id.'">'.$value->location_name.'</option>';   
        //       }
        //   }
         echo json_encode($location);
    }

    public function get_warehouse_transfer_data_ajax($id)
    {
      // $id = $this->input->post('id');
      // echo $id;
      // die;
      $data['warehouse_transfer'] = $this->warehouse_transfer_model->get_warehousetransfer($id);
      $data['warehouse_transfer_item'] = $this->warehouse_transfer_model->get_warehousetransfer_item($id);
      $this->load->view('admin/warehouse_transfer/warehouse_transfer_preview_template', $data);
      
      

    }
}