<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Subcategories extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('subcategories_model');
    }

    public function index1() {

        if ($this->input->is_ajax_request()) {
           
            $aColumns = array('catid','subcategory_name', 'Description', 'subcategory_id','active');
            $sIndexColumn = "subcategory_id";
            $sTable = 'tblsubcategories';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, array(), array(), array('subcategory_name', 'subcategory_id',  'active'));
            $output = $result['output'];
            $rResult = $result['rResult'];
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                   if ($aColumns[$i] == 'active') {
                        if ($aRow['active'] == '0') {
                                $_data = '<input  class="ischeckbox" data-rowid="'.$aRow['subcategory_id'].'" value="' . $aRow['active'] . '" type="checkbox"/>';
                            } else {
                                $_data = '<input  class="ischeckbox" data-rowid="'.$aRow['subcategory_id'].'" checked="checked" value="' . $aRow['active'] . '" type="checkbox"/>';
                            }
                        }
                        else if ($aColumns[$i] == 'subcategory_id') {
                            $_data =0;
                        }
                        if($aColumns[$i] == 'catid'){
                            $_data = $this->subcategories_model->get_cat_name( $aRow['catid']);
                        }
                   
                      
                    $row[] = $_data;
                }
                
                $options = icon_btn('#','pencil-square-o','edit-category',array('data-id'=>$aRow['subcategory_id']));
                 $row[]  = $options .= icon_btn('admin/subcategories/delete/' . $aRow['subcategory_id'], 'remove', '', array('data-toggle' => 'tooltip', 'title' => _l('sub_category_delete_tooltip')));
                    
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }
        $this->load->model('invoice_items_model');
        $data['prev'] = $this->subcategories_model->get_prev_groups2();
        $data['ledgers'] = $this->subcategories_model->get_ledgers();
        $data['title'] = _l('sub_categories');
        $this->load->view('admin/subcategories/manage', $data);
    }

    public function index() {
       
        $data['subcategories'] = $this->subcategories_model->get();
  
        $this->load->model('invoice_items_model');
        $data['prev'] = $this->subcategories_model->get_prev_groups2();
        $data['ledgers'] = $this->subcategories_model->get_ledgers();
        $data['title'] = _l('sub_categories');
        $this->load->view('admin/subcategories/manage', $data);
    }

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('categories'));
        }
        $response = $this->subcategories_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('sub_category_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('sub_category_lowercase')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('sub_category_lowercase')));
        }
        
        redirect(admin_url('subcategories'));
    }

    public function change_category_status($id, $status) {
        if ($this->input->is_ajax_request()) {
            $this->subcategories_model->change_category_status($id, $status);
        }
    }
    
    public function get_category(){
        $id     = $this->input->post('id');
        $result = $this->subcategories_model->get_category_details($id);
        echo json_encode($result);
        
    }
    public function update_category(){
        $this->subcategories_model->update_category_details();  
         redirect(admin_url('subcategories'));
    }

    public function updatecategory(){
        $id = $this->subcategories_model->update_category_details();  
        echo $id;
    }
    public function add_category(){
        $this->subcategories_model->add_category_details(); 
        redirect(admin_url('subcategories'));
    }

    public function addcategory(){
        $id = $this->subcategories_model->add_category_details(); 
        echo $id;
    }
    public function changestatus(){
        echo $this->subcategories_model->changestatus();
    }

    public function changeeview(){
        echo $this->subcategories_model->changeeview();
    }
	

}
