<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Make extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('make_model');
    }

    /* List all available items */

    public function index() {
		
       

        $data['title'] = _l('make_mod');
        $this->load->view('admin/make/manage', $data);
    }
	
	
	 public function getallmakesdata() { 
		//$search = $this->input->get("search[value]");
		$total_makes = $this->make_model->getallmakesdatatotal();
	
		
          // Datatables Variables
          $draw = intval($this->input->get("draw"));
          $start = intval($this->input->get("start"));
		  $length = intval($this->input->get("length"));
		  $search = $this->input->get("search[value]");


        $order = $this->input->get("order");

        $col = 0;
        $dir = "";
        if(!empty($order)) {
            foreach($order as $o) {
                $col = $o['column'];
                $dir= $o['dir'];
            }
        }

        if($dir != "asc" && $dir != "desc") {
            $dir = "asc";
        }
		
		 $columns_valid = array(
            "vehiclemodelyear.make",
            "vehiclemodelyear.model",
            "vehiclemodelyear.year",
        );

        if(!isset($columns_valid[$col])) {
            $order = null;
        } else {
            $order = $columns_valid[$col];
        }
		//print_r($order);
          $engines = $this->make_model->getallmakesdata($start, $length, $order, $dir,$search);
          $data = array();

          foreach($engines->result() as $r) {
			
			
			
			
			if($r->image_make != '' && file_exists('uploads/make_img/'.$r->image_make))
					{
						$image = $r->image_make;
					}
					else
					{
						$image = 'noimage.png'; 
					}
					
			
			if($r->image_model != '' && file_exists('uploads/model_img/'.$r->image_model))
					{
						$model = $r->image_model;
					}
					else
					{
						$model = 'noimage.png'; 
					}		
			
			
			$fromyear = str_replace("(","",$r->year);
			$fromyear = str_replace(")","",$fromyear);
			$fromyear = str_replace("→...","",$fromyear);
			if (strpos($fromyear, '→') !== false) {
			$fromyear = substr($fromyear, 0, strpos($fromyear, "→"));
			}
			
			if($r->countengines == '0'){
				$color = '#FF0000';
				$font = 'bold';
				
			}else{
				$color = '';
				$font = '';
			}
			
               $data[] = array(
				'<img class="img-rounded"  src="'.site_url('uploads/make_img/' .$image).'"  title="'.$r->make.'" alt="Change Image"  style="cursor:pointer; height: 60px; width: 80px; margin-right: 5px; ">'.$r->make,
                '<img class="img-rounded"  src="'.site_url('uploads/model_img/' .$model).'"  title="'.$r->model.'" alt="Change Image"  style="cursor:pointer; height: 70px; width: 90px; margin-right: 5px; " onclick="showmodelimage(\''.$r->id.'\')"><input type="text" class="form-control" id="model_'.$r->id.'" name="model" value="'.$r->model.'" style="width: 70%;"/><input type="file" class="form-control" id="image_model_'.$r->id.'" name="image_model" style="display:none;"  />',
                   '<input type="text" class="form-control" id="year_'.$r->id.'" name="year" value="'.$fromyear.'" />',
					$r->category,
'<a href="engines/get_engine_list/'.$r->id.'" style="color:'.$color.'; font-weight:'.$font.';" target="_blank">'.$r->countengines.'</a>',
'<a class="btn edit-locations btn-icon" data-toggle="tooltip" title="Save Make" onclick="save_make_data(\''.$r->id.'\')"> <i class="fa fa-save" style="font-size: large !important;"></i></a><a href="make/make/'. $r->id.'" class="btn edit-locations btn-icon" data-toggle="tooltip" title="" data-original-title="Edit Make"> <i class="fa fa-pencil-square-o" style="font-size: large !important;"></i></a> <a href="make/delete/'.$r->id.'" class="btn edit-locations btn-icon" data-toggle="tooltip" title="" 
data-original-title="Delete Make"> <i class="fa fa-remove" style="font-size: large !important;"></i></a>'
               );
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $total_makes,
                 "recordsFiltered" => $total_makes,
                 "data" => $data
            );
          echo json_encode($output);
          exit();
		}
	
	
    public function make($id = '') {
        if ($this->input->post() && !$this->input->is_ajax_request()) {
			
			
			//print_r($this->input->post());
			//exit;
			
            if ($id == '') {
                    $id = $this->make_model->add($this->input->post());
                    if ($id) {
                        set_alert('success', _l('make_added_successfully', _l('make_added')));
                        if (trim($this->input->post('action')) == 'save') {
                           redirect(admin_url('make/make/'.$id));
							 //redirect(admin_url('make'));

                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
                            redirect(admin_url('make/make/'.$id));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('make'));
                              exit;
                        }
                        
                    }
            } else {
                
  				if (trim($this->input->post('action')) == 'save') {
                            $success = $this->make_model->update($this->input->post(), $id);
							
                           }
						   else if (trim($this->input->post('action')) == 'snew') {
                            $success = $this->make_model->add($this->input->post());
                        }
                if ($success) {
                  
                    set_alert('success', _l('make_updated_successfully', _l('make_updated')));
                    if (trim($this->input->post('action')) == 'save') {
                            redirect(admin_url('make/make/'.$id));
                            exit;
                           }
                        if (trim($this->input->post('action')) == 'snew') {
							$id = $success;
                            redirect(admin_url('make/make/'.$id));
                            exit;
                        }

                        if (trim($this->input->post('action')) == 'slist') {
                             redirect(admin_url('make'));
                              exit;
                        }
                }
                
            }
        }

        if ($id == '') {
            $title = _l('add_new', _l('warehouse_table_heading'));
        } else {     
           
            $make = $this->make_model->get_where_single_tbl('vehiclemodelyear','id',$id);
			$data['client'] = $this->make_model->get($id);
            $title = _l('edit', _l('warehouse_table_heading'));
        }
        $data['title'] = $title;
        $this->load->view('admin/make/make', $data);
    }

   public function save_makedata($id = '') {
      echo $success = $this->make_model->update($this->input->post(), $id);
	  //echo $this->db->last_query();
    }

    /* Delete item */

    public function delete($id) {
        if (!$id) {
            redirect(admin_url('make'));
        }

        $response = $this->make_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('make_lowercase')));
        } else if ($response == true) {
            set_alert('success', _l('deleted', _l('make')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('make_lowercase')));
        }
        redirect(admin_url('make'));
    }
    
    /*delete warehouse contact*/
    public function deletecontactwarehouse()
    {
        $id=  $this->input->post('id');
        $response = $this->make_model->deletecontact($id);
    }
    
    public function delete_items()
    {
        $id=  $this->input->post('id');
        $response = $this->make_model->deleteitems($id);
        echo $response;
    }

    



    public function get_warehouse_reminders($id){
		if($this->input->is_ajax_request()){

			$aColumns = array( 'description', 'date', 'staff', 'isnotified');
			$sIndexColumn = "id";
			$sTable = 'tbladminwarehousereminders';

			$where = array('AND ware_id='.$id);
			$join = array(
				'JOIN tblstaff ON tblstaff.staffid = tbladminwarehousereminders.staff'
				);
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,$join,$where,array('firstname','lastname','id','creator'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					if($aColumns[$i] == 'staff'){
						$_data = '<a href="'.admin_url('staff/profile/'.$aRow['staff']).'">'.staff_profile_image($aRow['staff'], array(
							'staff-profile-image-small'
							)) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] .'</a>';
					} else if($aColumns[$i] == 'staff'){
						$_data = _d($_data);
					} else if($aColumns[$i] == 'isnotified'){
						if($_data == 1){
							$_data = _l('client_reminder_is_notified_boolean_yes');
						} else {
							$_data = _l('client_reminder_is_notified_boolean_no');
						}
					}
					$row[] = $_data;
				}

				if($aRow['creator'] == get_staff_user_id()){
					//$row[] = icon_btn('admin/warehouse/delete_reminder/'.$id . '/'. $aRow['id'], 'remove', '');
				       $row[]  =  icon_btn('#', 'remove', ' delete-reminders', array('data-id'=>$aRow['id']));
                
                                        
                                } else {
					$row[] = '';
				}


				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}
	}
        
        /* Since version 1.0.2 add client reminder */
	public function add_warehouse_reminder($id){
		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->post()){
			$success = $this->make_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('warehouse_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('make/warehouse/'.$id));
	}

	/* Since version 1.0.2 delete client reminder */
	public function delete_reminders(){
		$id=  $this->input->post('id');
		$success = $this->make_model->delete_reminder($id);
                echo $success;
	}

    /* Get item by id / ajax */

    public function get_item_by_id($id) {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->make_model->get($id));
        }
    }

    /* Get all items */

    public function get_all_items_ajax() {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->make_model->get_all_items_ajax());
        }
    }
    
    /*Warehouse Id Exist or Not*/
    public function check_warehouse()
    {
        $warehouse_id=  $this->input->post('warehouse_id');
        $check_warehouse=  $this->make_model->get_where_single_tbl('tblwarehouse', 'warehouse_id', $warehouse_id);
        if(empty($check_warehouse))
        {
           echo '1';
        }
        else {
            echo '0';
        }
    }
          public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->make_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->make_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    public function getcontact(){
       echo json_encode($this->make_model->getcontact($this->input->post('id')));
    }
}
