<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Institutions extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('institutions_model');
    }

    public function index() 
    {    
      $data['institutions'] = $this->institutions_model->get_list();
      $data['title'] = _l('institutions');
      $this->load->view('admin/institutions/manage', $data);
    }

    public function institutions() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();

            if ($data['id'] == '') {
                $success = $this->institutions_model->add($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('institutions'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
				
                $success = $this->institutions_model->edit($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('institutions'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getinstitutions(){
		echo  json_encode($this->institutions_model->getinstitutions());
	}

	public function delete($id)
	{
		$response = $this->institutions_model->delete($id);
		
		if ($response == true) {
            set_alert('success', _l('deleted', _l('institutions')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('institutions')));
        }

        redirect(admin_url('institutions'));
	}
}