<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Holidays extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('holidays_model');
    }

    public function index() 
    {    
      $data['holidays'] = $this->holidays_model->get_list();
      $data['title'] = _l('holidays');
      $this->load->view('admin/holidays/manage', $data);
    }

    public function holiday() {
        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();
            
            if ($data['id'] == '') {
                $success = $this->holidays_model->add($data);
                $message = '';
                if ($success == true) {
                    $message = _l('added_successfuly', _l('holidays'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
				
                $success = $this->holidays_model->edit($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfuly', _l('holidays'));
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function getholiday(){
		echo  json_encode($this->holidays_model->getholiday());
	}

	public function delete($id)
	{
		$response = $this->holidays_model->delete($id);
		
		if ($response == true) {
            set_alert('success', _l('deleted', _l('holidays')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('holidays')));
        }

        redirect(admin_url('holidays'));
	}
}