<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Estimates extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('estimates_model');
    }

    /* Get all estimates in case user go on index page */
    public function index($id = false, $clientid = false)
    {
      
         $has_permission = check_access("child-quotes","",false);

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('child-quotes');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                  'date',
                'company',
                'total',
                'expirydate',
                
                'status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblestimates.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblestimates.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblestimates';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'firstname',
                'tblestimates.id',
                'lastname',
                'accountname',
                'company',
                'orderid',
                'invoiceid',
                 'hash',
                'clientid',
                'symbol',
                'total',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                $company = $aRow['company'];
                if ($company != '') {
                    $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                } else {
                    $company = $aRow['accountname'];
                }
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('estimates/list_estimates/' . $aRow['id']) . '">' . format_estimate_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_estimate(' . $aRow['id'] . '); return false;">' . format_estimate_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'company') {
                        $__data = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . $aRow['accountname'] . '</a><br />';
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else if($aColumns[$i] == 'status') {
                        $__data = format_estimate_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }
                $options='';
             if($aRow['orderid'] == NULL && $aRow['invoiceid'] == NULL && $aRow['status'] == 4){
                    if($aRow['orderid'] == NULL){
                if($aRow['status'] == 4){
					if(check_access("child-orders","add",false))
                    $options .= icon_btn('estimates/convert_to_order/' . $aRow['id'],'share','',array('data-toggle' => 'tooltip', 'title' =>_l('convert_order'),'status'=>$aRow['status']));
                    }else{
                        $options =icon_btn('#','ban','',array('data-toggle' => 'tooltip', 'title' =>_l('q_no_ready_o')));
                    }
                }else{
					if(check_access("child-orders","",false))
                   $options = icon_btn('admin/orders/list_orders/' . $aRow['orderid'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_order'))); 
                }
                
                   if($aRow['invoiceid'] == NULL){
                if($aRow['status'] == 4){
					if(check_access("child-invoices","add",false))
                    $options .= icon_btn('admin/estimates/convert_to_invoice/' . $aRow['id'],'share','',array('data-toggle' => 'tooltip', 'title' =>_l('convert_invoice'),'status'=>$aRow['status']));
                    }else{
                        $options .=icon_btn('#','ban','',array('data-toggle' => 'tooltip', 'title' =>_l('q_no_ready_i')));
                    }
                }else{
					if(check_access("child-invoices","",false))
                   $options .= icon_btn('admin/invoices/list_invoices/' . $aRow['invoiceid'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_invoice'))); 
                }
             }else{
             
                 if($aRow['orderid'] != NULL){
					 if(check_access("child-orders","",false))
                     $options .= icon_btn('admin/orders/list_orders/' . $aRow['orderid'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_order'). ' : ' .format_order_number($aRow['orderid'])));  
                 }
                 if($aRow['invoiceid'] != NULL){
					 if(check_access("child-invoices","",false))
                    $options .= icon_btn('admin/invoices/list_invoices/' . $aRow['invoiceid'], 'eye','',array('data-toggle' => 'tooltip', 'title' =>_l('view_invoice'). ' : ' .format_invoice_number($aRow['invoiceid']))); 
                 }
                 
             }
               
                 $options .= icon_btn('#','print','printquote',array('data-toggle' => 'tooltip', 'title' =>'Print Quote','data-id'=>$aRow['id'],'data-hash'=>$aRow['hash']));
                  $options .= icon_btn('admin/estimates/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Quote', 'download' =>'admin/estimates/pdf/' . $aRow['id']));
                $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Quote', 'onclick'=>'init_estimate('.$aRow['id'].'); return false;'));
                if($aRow['status'] !=4){
					if(check_access("child-quotes","delete",false))
                $options .= icon_btn('admin/estimates/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Quote'));
                }
                 $row[] = $options;
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['estimateid'] = '';
        if (is_numeric($id)) {
            $data['estimateid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('estimates');
        $this->load->view('admin/estimates/manage', $data);
    }

    /* List all estimates datatables */
    public function list_estimates($id = false, $clientid = false)
    {
        
        $has_permission = check_access("child-quotes","",false);

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageSales');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }
    
          if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                  'date',
                'company',
                'total',
              
//                'reference_no',
                'expirydate',
                
                'status'
            );

            $join = array(
                'LEFT JOIN tblclients ON tblclients.userid = tblestimates.clientid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblestimates.currency'
            );

            $where                    = array();

            if (is_numeric($clientid)) {
                $where                    = array(
                    'AND clientid=' . $clientid
                );
            }


            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "id";
            $sTable       = 'tblestimates';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'firstname',
                'tblestimates.id',
                'lastname',
                'accountname',
                'company',
                'clientid',
                'symbol',
                'total',
                'status'
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

          
            foreach ($rResult as $aRow) {
                $row = array();

                $company = $aRow['company'];
                if ($company != '') {
                    $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                } else {
                    $company = $aRow['accountname'];
                }
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'number') {
                        // If is from client area table
                    if (is_numeric($clientid)) {
                        $__data = '<a href="' . admin_url('estimates/list_estimates/' . $aRow['id']) . '">' . format_estimate_number($_data) . '</a><br />';
                    } else {
                           $__data = '<a href="#" onclick="init_estimate(' . $aRow['id'] . '); return false;">' . format_estimate_number($_data) . '</a><br />';
                    }
                    } else if ($aColumns[$i] == 'date') {
                        $__data = _d($_data);
                    }
                    else if ($aColumns[$i] == 'company') {
                        $__data = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . $aRow['accountname'] . '</a><br />';
                    } else if ($aColumns[$i] == 'expirydate') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = format_money($_data, $aRow['symbol']);
                    } else if($aColumns[$i] == 'status') {
                        $__data = format_estimate_status($aRow['status']);
                        // Status
                    }
                    $row[] = $__data;
                }
                 $options = icon_btn('admin/estimates/pdf/' . $aRow['id'],'download','',array('data-toggle' => 'tooltip', 'title' =>'Download Quote', 'download' =>'admin/estimates/pdf/' . $aRow['id']));
                $options .= icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Quote', 'onclick'=>'init_estimate('.$aRow['id'].'); return false;'));
				if(check_access("child-quotes","delete",false))
               $options .= icon_btn('admin/estimates/delete/' . $aRow['id'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' =>'Delete Quote'));
				$row[] = $options;
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['estimateid'] = '';
        if (is_numeric($id)) {
            $data['estimateid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('estimates');
        $this->load->view('admin/estimates/manage', $data);
    }

    /* Add new estimate or update existing */
    public function estimate($customerid = '',$id = '')
    {
          if ($id == '')
        	check_access("child-quotes","add");
		else
			check_access("child-quotes","edit");
                   $this->load->model('clients_model');
        if ($this->input->post()) {
            if ($id == '') {
                $id = $this->estimates_model->add($this->input->post());
                if ($id) {
                    $estimates = $this->estimates_model->get($id);
             
                    if ($estimates->number != $this->input->post('_number')) {
                        set_alert('warning', _l('estimate_number_changed'));
                    } else {
                       set_alert('success', _l('added_successfuly',_l('estimate')));
                    }
                    
                    if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('estimates/estimate/'.$this->input->post('clientid').'/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('estimates/estimate'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('estimates/list_estimates/' . $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
//                    redirect(admin_url('estimates/list_estimates/' . $id));
                }
            } else {
                $success = $this->estimates_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('estimate')));
                }
               if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('estimates/estimate/'.$this->input->post('clientid').'/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('estimates/estimate'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('estimates/list_estimates/' . $id));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }

        if ($id == '') {
            $title = _l('create_new_estimate');
        } else {
            $estimates = $this->estimates_model->get($id);
       
            if($estimates->invoiceid != NULL || $estimates->orderid != NULL){
                access_denied('manageSales');
                die();
            }
 
          
            $estimates->date    = _d($estimates->date);
            $estimates->expirydate = _d($estimates->expirydate);
            $this->load->model('emails_model');
            if ($estimates->sent == 0) {
                $data['template'] = $this->emails_model->parse_template('estimate-send-to-client', $estimates->clientid, false,false,false,$id);
            } else {
                $data['template'] = $this->emails_model->parse_template('estimate-already-send', $estimates->clientid, false,false,false,$id);
            }

             $data['estimates'] = $this->clients_model->get_where_record('tblestimates',$id);
           if(isset($data['estimates'])){
            $customerid = $data['estimates']->clientid;
         }
             
            $data['prev'] = $this->estimates_model->get_prev($id);
          $data['next'] = $this->estimates_model->get_next($id);
           
            $data['estimate']  = $estimates;
            $data['edit'] = true;
            $title           = _l('edit',_l('estimate_lowercase'));
        }
        

        $data['customerdetails'] = $this->clients_model->get_client($customerid);
        
        $this->load->model('taxes_model');
        $data['taxes'] = $this->taxes_model->get();

        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();

        $this->load->model('clients_model');
        $data['clients'] = $this->clients_model->get();

        $this->load->model('staff_model');
        $data['staff'] = $this->staff_model->get('',1);
          $data['copy'] ='';
   
        if($this->input->get('copyid')){
            $data['copy'] =$this->input->get('copyid');
           $data['estimates']['items'] =   $this->estimates_model->get_items($this->input->get('copyid'));
        }

        $this->load->model('discount_model');
        $data['discount'] = $this->discount_model->get_discounts();
        
        $data['title']     = $title;
        $this->load->view('admin/estimates/estimate', $data);
    }

    public function init_estimate_items_ajax($id){
        echo json_encode($this->estimates_model->get_estimate_items($id));
    }
    public function change_quote_status($status,$id){
          echo $this->estimates_model->change_quote_status($status,$id);
    }
    public function get_term() {
        $terms = $this->estimates_model->get_term($this->input->post('id'));
   
        $account_repy = $this->estimates_model->get_sales_agent($this->input->post('id'));

         echo json_encode(array('payment_term'=>$terms,'account_rep'=>$account_repy));
    }
    /* Get all estimate data used when user click on estimate number in a datatable left side*/
    public function get_estimate_data_ajax($id)
    {
        check_access("child-quotes","");

        if (!$id) {
            die('No estimate found');
        }

        $estimate = $this->estimates_model->get($id);
         $estimate->date    = _d($estimate->date);
        $estimate->expirydate = _d($estimate->expirydate);

        $data['invoice_number'] = $this->estimates_model->get_invoice($id);
        $data['order_number'] = $this->estimates_model->get_order($id);

        if($estimate->invoiceid !== NULL){
            $this->load->model('invoices_model');
            $estimate->invoice = $this->invoices_model->get($estimate->invoiceid);
        }
        if($estimate->orderid !== NULL){
            $this->load->model('orders_model');
            $estimate->order = $this->orders_model->get($estimate->orderid);
     
        }

        $this->load->model('emails_model');

        if ($estimate->sent == 0) {
            // $data['template'] = $this->emails_model->parse_template('estimate-send-to-client', $estimate->clientid, false,false,false,$id);
            $data['template'] = $this->emails_model->parse_template('quote-send-to-client', $estimate->clientid, false,false,false,$id);
        } else {
            // $data['template'] = $this->emails_model->parse_template('estimate-already-send', $estimate->clientid, false,false,false,$id);
            $data['template'] = $this->emails_model->parse_template('quote-already-send', $estimate->clientid, false,false,false,$id);
        }

        $data['activity'] = $this->estimates_model->get_estimate_activity($id);
        $data['estimate']  = $estimate;
     
        $this->load->view('admin/estimates/estimate_preview_template', $data);
    }

    public function get_estimates_total(){
        check_access("child-quotes","");
        if($this->input->post()){
            $data['totals'] = $this->estimates_model->get_estimates_total($this->input->post());
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
            if(is_using_multiple_currencies('tblestimates') || (total_rows('tblestimates',array('currency'=>$base_currency)) == 0) && total_rows('tblestimates') > 0){
                $this->load->model('currencies_model');
                $data['currencies'] = $this->currencies_model->get();
            }
            $this->load->view('admin/estimates/estimates_total_template',$data);
        }
    }

    /* Send estimate to email */
    public function send_to_email($id)
    {
         check_access("child-quotes","edit");
        $success = $this->estimates_model->sent_estimate_to_client($id,'',$this->input->post('attach_pdf'));
        if ($success) {
            set_alert('success', _l('estimate_sent_to_client_success'));

        } else {
            set_alert('danger', _l('estimate_sent_to_client_fail'));
        }
        redirect(admin_url('estimates/list_estimates/' . $id));
    }

    /* Convert estimate to invoice */
    public function convert_to_invoice($id,$clientid,$view){

        check_access("child-invoices","add");

        if(!$id){
            die('No estimate found');
        }

        $invoiceid = $this->estimates_model->convert_to_invoice($id);

       if($invoiceid && $view == 'edit'){
             set_alert('success',_l('estimate_convert_to_invoice_successfuly'));
             redirect(admin_url('invoices/invoice/'.$clientid.'/'.$invoiceid));
		}else if($invoiceid && $view == 'view'){
			 set_alert('success',_l('estimate_convert_to_invoice_successfuly'));
			 redirect(admin_url('invoices/list_invoices/'.$invoiceid));
		} else {
            redirect(admin_url('estimates/list_estimates/'.$id));
        }
		
		
		
    }
    /* Convert estimate to order */
    public function convert_to_order($id,$clientid,$view){

        check_access("child-orders","add");

        if(!$id){
            die('No estimate found');
        }

         $orderid= $this->estimates_model->convert_to_order($id);
  		 //$orderid= '2';
        if($orderid && $view == 'edit'){
            set_alert('success',_l('estimate_convert_to_order_successfuly'));
            redirect(admin_url('orders/order/'.$clientid.'/'.$orderid));
		}else if($orderid && $view == 'view'){
		    redirect(admin_url('orders/list_orders/'.$orderid));
		} else {
            redirect(admin_url('estimates/list_estimates/'.$id));
        }
    }

    /* Delete estimate */
    public function delete($id)
    {
         check_access("child-quotes","delete");

        if (!$id) {
            redirect(admin_url('estimates/list_estimates'));
        }

        $success = $this->estimates_model->delete($id);

        if ($success) {
           set_alert('success', _l('deleted',_l('estimate')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('estimate_lowercase')));
        }

        redirect(admin_url('estimates/list_estimates'));
    }

    /* Generates estimate PDF and senting to email of $send_to_email = true is passed */
    public function pdf($id, $send_to_email = false)
    {
        check_access("child-quotes","");

        if (!$id) {
            redirect(admin_url('estimates/list_estimates'));
        }

        $quote        = $this->estimates_model->get($id);
     
        $quote_number = format_estimate_number($quote->number);
        $pdf              =   estimate_pdf($quote);
        $pdf->Output($quote_number . '.pdf', 'D');
		
          //  redirect(admin_url('estimates/list_estimates'));
    }
}
