<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Discounts extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('discount_model');
    }

    /* List all Discounts */
    public function index()
    {
        if ($this->input->is_ajax_request()) {
            $aColumns     = array(
                'tbldiscounts.name',
                'discountrate',
                'tblledgergroups.name'
            );
            $sIndexColumn = "id";
            $sTable       = 'tbldiscounts';
            $join = array('LEFT JOIN tblledgergroups ON tblledgergroups.id = tbldiscounts.ledger');

            $result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), array(
                'tbldiscounts.id as id'
            ));
            $output  = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    $row[] = $_data;
                }

                $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default', array(
                    'data-toggle' => 'modal',
                    'data-target' => '#tax_modal',
                    'data-id' => $aRow['id']
                ));
                $row[]   = $options .= icon_btn('admin/discounts/delete/' . $aRow['id'], 'remove', '');

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();
        $data['default_options'] = $default_options;
        $data['prev'] = $this->discount_model->get_prev_groups2();
        $data['ledgers'] = $this->discount_model->getLedgers();
        $data['title'] = _l('discount');
        $this->load->view('admin/discounts/manage', $data);
    }
    public function discountrates($id='')
    {
    
        if ($this->input->is_ajax_request()) {
            $aColumns     = array(
                  'tbldiscounts.id',
                'tbldiscounts.name',
                'discountrate',
                'tblledgergroups.name',
              
            );
            $sIndexColumn = "id";
            $sTable       = 'tbldiscounts';
            $join = array('LEFT JOIN tblledgergroups ON tblledgergroups.id = tbldiscounts.ledger');

            $result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, array(), array(
                'tbldiscounts.id as id'
            ));
            $output  = $result['output'];
            $rResult = $result['rResult'];

            $res = $this->discount_model->get_invoice_item($id);
            $discount =  unserialize($res->discounts);

           
            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                     
                     if ($aColumns[$i] == 'tbldiscounts.id') {
                          $checked ='';
                         if(!empty($discount)){
                          if(in_array($aRow['tbldiscounts.id'],$discount)){
                             $checked = "checked";
                          }
                         }
                             $_data = '<input name="discounts[]"  class="ischeckbox" '.$checked.' data-rowid="'.$aRow['id'].'" value="' . $aRow['tbldiscounts.id'] . '" type="checkbox"/>';
                        }
              
                       $row[] = $_data;
                  }
             
                  $output['aaData'][] = $row;
            }
          
            
            echo json_encode($output);
            die();
        }
            $data['ledgers'] = $this->discount_model->get_ledgers();
        $data['title'] = _l('discount');
        $this->load->view('admin/discounts/manage', $data);
    }
    /* Add or edit discount / ajax */
    public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['discountid'] == '') {
                $success = $this->discount_model->add($data);
                $message = '';
                if($success == true){
                    $message =  _l('added_successfuly',_l('discount'));
                }
                echo json_encode(array('success'=>$success,'message'=>$message));
            } else {
                $success = $this->discount_model->edit($data);
                $message = '';
                if($success == true){
                    $message = _l('updated_successfuly',_l('currency'));
                }
                echo json_encode(array('success'=>$success,'message'=>$message));
            }
        }
    }
    /* Delete discount from database */
    public function delete($id)
    {
        if (!$id) {
            redirect(admin_url('discounts'));
        }

        $response = $this->discount_model->delete($id);
       if(is_array($response) && isset($response['referenced'])){
            set_alert('warning',_l('is_referenced',_l('discount_lowercase')));
        } else if($response == true){
            set_alert('success', _l('deleted',_l('discount')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('discount_lowercase')));
        }
        redirect(admin_url('discounts'));
    }
    public function get_details(){
       echo json_encode($this->discount_model->get($this->input->post('id')));
        
    }
}
