<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Banks extends Admin_controller {

	function __construct(){
		parent::__construct();
                $this->load->model('clients_model');
                $this->load->model('banks_model');
	}

	/* List all clients */
	public function index()
	{

		if($this->input->is_ajax_request()){
			$aColumns = array('bank');
			$sIndexColumn = "bankid";
			$sTable = 'tblbanks';
          
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,array(),array(),array('bank','bankid'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					  if ($aColumns[$i] == 'active') {
						$checked = '';
						if($aRow['active'] == 1){
							$checked = 'checked';
						}
						$_data = '<input type="checkbox" class="switch-box input-xs" data-size="mini" data-id="'.$aRow['userid'].'" data-switch-url="admin/banks/change_bank_status" '.$checked.'>';
						// For exporting
						$_data .=  '<span class="hide">' . ($checked == 'checked' ? _l('is_active_export') : _l('is_not_active_export')) .'</span>';
					} else if ($aColumns[$i] == 'bank'){
						$_data =  $aRow['bank'];
						
						$_data = '<a href="'.admin_url('banks/bank/'.$aRow['bankid']).'">'.$_data.'</a>';
                                        }
					$row[] = $_data;
				}

				$options = icon_btn('admin/banks/bank/'.$aRow['bankid'],'pencil-square-o');
				$row[]  = $options .= icon_btn('admin/banks/delete/'.$aRow['bankid'],'remove','',array('data-toggle'=>'tooltip','onClick' => 'return deleteconf();','title'=>_l('bank_delete_tooltip')));

				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}


		$data['title'] = _l('bank_lowercase');
		$this->load->view('admin/banks/manage',$data);
	}
        
    
	/* Edit client or add new client*/
	public function bank($id = ''){
		

		if($this->input->post() && !$this->input->is_ajax_request()){
			if(!has_permission('manageBanks')){
				access_denied('manageBanks');
			}

			if($id == ''){
			//echo $id;
				$id = $this->banks_model->add($this->input->post());
			
				if($id){
					set_alert('success', _l('added_successfuly',_l('bank')));
                                        if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('banks/bank/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('banks/bank'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'slist') {
                                            redirect(admin_url('banks'));

                                       }
                                       if (trim($this->input->post('action')) == 'cancel') {
                                           redirect(admin_url());
                                           exit;
                                       }
					
				}
			} else {
				
			
				$success = $this->banks_model->update($this->input->post(),$id);
				if($success){
					set_alert('success', _l('updated_successfuly',_l('bank')));
				}
				  if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('banks/bank/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('banks/bank'));
                                           exit;
                                       }

                                       if (trim($this->input->post('action')) == 'slist') {
                                            redirect(admin_url('banks'));

                                       }
                                       if (trim($this->input->post('action')) == 'cancel') {
                                           redirect(admin_url());
                                           exit;
                                       }
			}
		}

		if($id == ''){
			$title = _l('add_new',_l('bank_lowercase'));
		} else {
	
			$bank = $this->banks_model->get($id);
              
			$data['bank'] = $bank;
               
                        $data['prev'] = $this->banks_model->get_prev($id);
                         $data['next'] = $this->banks_model->get_next($id);
                         $title = $bank->bank;
            
		}

	
      		$data['title'] = $title;
			//var_dump( $this->input->post());
		$this->load->view('admin/banks/bank',$data);
	}
        
  

 
	

	/* Delete client */
	public function delete($id){

		if(!has_permission('manageBanks')){
			access_denied('manageBanks');
		}

		if(!$id){
			redirect(admin_url('banks'));
		}

		$response = $this->banks_model->delete($id);

		if(is_array($response) && isset($response['referenced'])){
			set_alert('warning',_l('is_referenced',_l('bank_lowercase')));
		} else if($response == true){
			set_alert('success', _l('deleted',_l('bank_lowercase')));
		} else {
			set_alert('warning', _l('problem_deleting',_l('bank_lowercase')));
		}

		redirect(admin_url('banks'));
	}

	/* Change client status / active / inactive */
	public function change_bank_status($id,$status){

		if(!has_permission('manageBanks')){
			access_denied('manageBanks');
		}

		if($this->input->is_ajax_request()){
			$this->banks_model->change_bank_status($id,$status);
		}
	}
	/* Get client by id - used in ajax request */
	public function get_client_by_id_ajax($id){

		if(!$id){
			redirect(admin_url('clients'));
		}

		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}
		if($this->input->is_ajax_request()){
			echo json_encode($this->clients_model->get($id));
		}
	}
	/* Since version 1.0.2 add client reminder */
	public function add_bank_reminder($id){
		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}

		if($this->input->post()){
			$success = $this->banks_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('bank_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('banks/bank/'.$id));
	}
	

}
