<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Bankingaccounttransfer extends Admin_controller {

    function __construct() {
        parent::__construct();
        $this->load->model('BankingAccountTransfer_model');
    }

    /* List all available items */

    public function index() {
        if ($this->input->is_ajax_request()) {
            $aColumns = array(                
                'date',
                'fromBank',
                'fromBranch',
                'toBank',
                'toBranch',
                'amountToTransfer',
                'fromCurrency',
              
            );
            $sIndexColumn = "id";
            $sTable = 'tblbanckaccounttransfer';
      
            
            $additionalSelect = array('id');
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable,array(), array(), $additionalSelect);
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                     $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'fromBank') {
                         $_data = $this->BankingAccountTransfer_model->getBankName($aRow['fromBank']);
                    }      
                    if ($aColumns[$i] == 'fromBranch') {
                         $_data = $this->BankingAccountTransfer_model->getBranchName($aRow['fromBranch']);
                    }      
                    if ($aColumns[$i] == 'toBank') {
                         $_data = $this->BankingAccountTransfer_model->getBankName($aRow['toBank']);
                    }      
                    if ($aColumns[$i] == 'toBranch') {
                         $_data = $this->BankingAccountTransfer_model->getBranchName($aRow['toBranch']);
                    }      
                    if ($aColumns[$i] == 'fromCurrency') {
                         $_data = $this->BankingAccountTransfer_model->getCurrency($aRow['fromCurrency']);
                    }      
                    if ($aColumns[$i] == 'amountToTransfer') {
                        $symbol = $this->BankingAccountTransfer_model->getCurrencySymbol($aRow['fromCurrency']);
                         $_data = format_money($aRow['amountToTransfer'],$symbol);
                    } 
                    if ($aColumns[$i] == 'date') {
                        $_data = _d($aRow['date']);
                    }
                   
                                     
                    $row[] = $_data;
                }
                    $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default editbanktransfer', array(
                            'data-toggle' => 'modal',
                            'data-target' => '#accounttransfer_model',
                            'title' =>'Edit Bank Account Transfer',
                            'data-id' => $aRow['id'],
                  
                        ));
//                $options = icon_btn('admin/banksaccounts/bankaccount/' . $aRow['id'], 'pencil-square-o', 'edit-locations', array('data-toggle' => 'tooltip', 'title' => 'Edit Bank Account'));
                
                
                $row[] = $options .= icon_btn('admin/Bankingaccounttransfer/delete/' . $aRow['id'], 'remove', '');

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
        $this->load->model('currencies_model');
        $this->load->model('banksaccounts_model');
        $data['currencies'] = $this->currencies_model->get();
         $data['banks'] = $this->banksaccounts_model->get_banks();
        $data['title'] = _l('account_transfer');
        $this->load->view('admin/bankingaccounttransfer/manage', $data);
        
    }
       public function getdetails(){
          $res = $this->BankingAccountTransfer_model->getdetails($this->input->post('id'));
    
          $fromBank = $this->BankingAccountTransfer_model->getBankName($res->fromBank);
          $fromBranch = $this->BankingAccountTransfer_model->getBranchName($res->fromBranch);
          $fromAccount = $this->BankingAccountTransfer_model->getBankAccount($res->fromAccount);
//          
          $toBank = $this->BankingAccountTransfer_model->getBankName($res->toBank);
          $toBranch = $this->BankingAccountTransfer_model->getBranchName($res->toBranch);
          $toAccount = $this->BankingAccountTransfer_model->getBankAccount($res->toAccount);
//          
          $json = array(
              'fromBank' => $res->fromBank,
              'fromBranch' => "<option value=''></option><option selected='selected' value='$res->fromBranch'>$fromBranch</option>",
              'fromAccount' => "<option value=''></option><option selected='selected' value='$res->fromAccount'>$fromAccount</option>",
              'toBank' => $res->toBank,
              'toBranch' => "<option value=''></option><option selected='selected' value='$res->toBranch'>$toBranch</option>",
              'toAccount' => "<option value=''></option><option selected='selected' value='$res->toAccount'>$toAccount</option>",
              'fromBalance' => number_format($res->fromBalance,2),
              'fromCurrency' => $res->fromCurrency,
              'amountToTransfer' => number_format($res->amountToTransfer,2),
              'fromBAT' => number_format($res->fromBAT,2),
              'toBalance' => number_format($res->toBalance,2),
              'toCurrency' => $res->toCurrency,
              'toBAT' => number_format($res->toBAT,2),
              'note' => $res->note,
              'date' => _d($res->date),
           
          );
          echo json_encode($json);
       }
     function delete($id) {
            $res = $this->BankingAccountTransfer_model->delete($id);
        if ($res == '1') {
            set_alert('success', 'Banck Account Transfer Record Deleted Successfully');
        } else {
            set_alert('warning', 'Sorry,Try Again..');
        }
        redirect(admin_url('Bankingaccounttransfer'));
    }

     public function get_branches(){
        if ($this->input->is_ajax_request()) {
          $res = $this->BankingAccountTransfer_model->get_branches();
          $options ='<option value=""></option>';
          if(isset($res)){
              foreach ($res as $value) {
               $options .='<option value="'.$value->bankbranchid.'">'.$value->branchname.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
        }
    }
 
     public function get_accounts(){
        if ($this->input->is_ajax_request()) {
          $res = $this->BankingAccountTransfer_model->get_accounts();
          $options ='<option value=""></option>';
          if(isset($res)){
              foreach ($res as $value) {
               $options .='<option value="'.$value->id.'">'.$value->account_number.'</option>';   
			   
			   
              }
          }
		  //echo $this->input->post('selectedaccount').'abc';

          echo json_encode(array('options'=>$options));
        }
    }
    public function get_accounts_details(){
       $result = $this->BankingAccountTransfer_model->get_accounts_details();
        $amountToTransfer = str_replace(',','',$this->input->post('amountToTransfer'));
       
       $toBAT = 0.00;
       if($result->balance){
                $toBAT = $amountToTransfer +$result->balance;  
       }

       $array = array(
           'balance'=>number_format($result->balance,2),
           'currency'=>$result->currency,
           'available'=>number_format($result->available,2),
           'toBAT'=>number_format($toBAT,2),
           
       );
       echo json_encode($array);
    }
    public function calculatetransfer(){
        
        $fromBalance = str_replace(',','',$this->input->post('frombalance'));
        $amountToTransfer = str_replace(',','',$this->input->post('amountToTransfer'));
        $toBalance = str_replace(',','',$this->input->post('toBalance'));
        if($amountToTransfer <= $fromBalance){
            $fromBAT = $fromBalance-$amountToTransfer;
            if($toBalance){
            $toBAT =$amountToTransfer+$toBalance;
            }
            $mssage = "success";
        }else{
            $mssage = "error";
        }
        echo json_encode(array('fromBAT'=>number_format($fromBAT,2),'toBAT'=>number_format($toBAT,2),'message'=>$mssage));
    }
        public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
             if ($data['tranferid'] == '') {
                $message = '';
                $success = $this->BankingAccountTransfer_model->add($data);
                if($success) {
                    $message = _l('added_successfuly',_l('bank_amount_transfer'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->BankingAccountTransfer_model->edit($data);
                if($success){
                    $message = _l('updated_successfuly',_l('payment_mode'));
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }

}
