<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bankbranches extends Admin_controller {

	function __construct(){
		parent::__construct();
                $this->load->model('bankbranches_model');
                $this->load->model('clients_model');
	}

	/* List all clients */
	public function index()
	{

		if($this->input->is_ajax_request()){
			$aColumns = array('bankid','branchname' ,'country', 'email','phonenumber','fax', 'active');
			$sIndexColumn = "bankbranchid";
			$sTable = 'tblbankbranches';
          
			$result = data_tables_init($aColumns,$sIndexColumn,$sTable,array(),array(),array('branchname','bankbranchid'));
			$output = $result['output'];
			$rResult = $result['rResult'];

			foreach ( $rResult as $aRow )
			{
				$row = array();
				for ( $i=0 ; $i<count($aColumns) ; $i++ )
				{
					$_data = $aRow[ $aColumns[$i] ];
					 if ($aColumns[$i] == 'last_login'){
						if($_data != NULL){
							$_data = time_ago($_data);
						} else {
							$_data = 'Never';
						}
					} else if ($aColumns[$i] == 'active') {
						$checked = '';
						if($aRow['active'] == 1){
							$checked = 'checked';
						}
						$_data = '<input type="checkbox" class="switch-box input-xs" data-size="mini" data-id="'.$aRow['bankbranchid'].'" data-switch-url="admin/bankbranches/change_bank_status" '.$checked.'>';
						// For exporting
						$_data .=  '<span class="hide">' . ($checked == 'checked' ? _l('is_active_export') : _l('is_not_active_export')) .'</span>';
					} else if ($aColumns[$i] == 'bankid'){
						$_data =  $this->bankbranches_model->get_bank($aRow['bankid']);
						
					}else if ($aColumns[$i] == 'branchname'){
						$_data =  $aRow['branchname'];
						
						$_data = '<a href="'.admin_url('bankbranches/bankbranche/'.$aRow['bankbranchid']).'">'.$_data.'</a>';
					}else if ($aColumns[$i] == 'country'){
                                             $res =$this->bankbranches_model->get_country($aRow['country']);
                                             if(isset($res)){
                                                $_data = $res->short_name;
                                             }else{
                                                  $_data ='';
                                             }
                                             
                                        }

					$row[] = $_data;
				}

				$options = icon_btn('admin/bankbranches/bankbranche/'.$aRow['bankbranchid'],'pencil-square-o');
				$row[]  = $options .= icon_btn('admin/bankbranches/delete/'.$aRow['bankbranchid'],'remove','',array('data-toggle'=>'tooltip','title'=>_l('bank_branche_delete_tooltip')));

				$output['aaData'][] = $row;
			}

			echo json_encode( $output );
			die();
		}


		$data['title'] = _l('Bank_branche_lowercase');
		$this->load->view('admin/bankbranches/manage',$data);
	}
        
  

    public function list_contacts($id = false, $bankbranchid = false) {
        $has_permission = has_permission('manageSales');

        if (!$has_permission && !$this->input->is_ajax_request()) {
            access_denied('manageSales');
        }


        if ($this->input->is_ajax_request()) {
            // From client profile
            if (is_numeric($bankbranchid)) {
                if (!$has_permission) {
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'firstname',
                'lastname',
                'email',
                'mobileno',
                'phoneno',
                'id'
            );

            $where = array();
            if (is_numeric($bankbranchid)) {
                $where = array(
                    'where bankbranchid=' . $bankbranchid
                        //'userid' => $bankbranchid
                );
            }
            //print_r($where);
            $sIndexColumn = "id";
            $sTable = 'tblbankbranchecontacts';
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $where,array(),array('bankbranchid'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                // $company .= '<small class="text-muted"> ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</small>';
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'firstname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'lastname') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'email') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'mobileno') {
                        $__data = ($aRow['mobileno']!= '0') ? $aRow['mobileno'] : '';
                    } else if ($aColumns[$i] == 'phoneno') {
                        $__data = ($aRow['phoneno']!= '0') ? $aRow['phoneno'] : '';
                    } else if ($aColumns[$i] == 'id') {
                        //$__data ='<a href="javascript:void(0);" class="editcontact" data-id="'.$aRow['id'].'">Edit</a> | <a href="' . admin_url('clients/deletecontact/' . $aRow['id']) . '" class="editcontact" data-id="'.$aRow['id'].'">Delete</a><br />';
                          $options = icon_btn('#' . $aRow['id'], 'pencil-square-o', 'btn-default editcontact', array(
                            'data-toggle' => 'modal',
                            'data-target' => '#branch_contact_modal',
                            'title' =>'Edit Contact',
                            'data-id' => $aRow['id'],
 
                        ));
//                        $options = icon_btn('admin/bankbranches/contact/'.$aRow['bankbranchid'].'/'.$aRow['id'], 'pencil-square-o', 'editcontact', array('data-id' => $aRow['id']));
                        $row[] = $options .= icon_btn('admin/bankbranches/deletecontact/' . $aRow['id'], 'remove', ' deletecontact', array('data-id' => $aRow['id']));
                    }


                    $row[] = $__data;
                }
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

     
    }
      /* Delete Contact */

    function deletecontact() {
        $id = $_REQUEST['id'];
        $res = $this->bankbranches_model->DeleteContacts($id);
        if ($res == '1') {
            set_alert('success', _l('client_contact_delete_success_action', _l('client')));
        } else {
            set_alert('success', _l('client_contact_delete_error_action', _l('client')));
        }
        echo $res;
    }

	/* Edit client or add new client*/
	public function bankbranche($id = ''){

		if($this->input->post() && !$this->input->is_ajax_request()){
			if(!has_permission('manageBanks')){
				access_denied('manageBanks');
			}

			if($id == ''){
				$id = $this->bankbranches_model->add($this->input->post());
				if($id){
					set_alert('success', _l('added_successfuly',_l('bank_branche_lowercase')));
                                        if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('bankbranches/bankbranche/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('bankbranches/bankbranche'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'slist') {
                                            redirect(admin_url('bankbranches'));

                                       }
                                       if (trim($this->input->post('action')) == 'cancel') {
                                           redirect(admin_url());
                                           exit;
                                       }
					
				}
			} else {
				$success = $this->bankbranches_model->update($this->input->post(),$id);
				if($success){
					set_alert('success', _l('updated_successfuly',_l('bank_branche_lowercase')));
				}
				  if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('bankbranches/bankbranche/'.$id));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('bankbranches/bankbranche'));
                                           exit;
                                       }

                                       if (trim($this->input->post('action')) == 'slist') {
                                            redirect(admin_url('bankbranches'));

                                       }
                                       if (trim($this->input->post('action')) == 'cancel') {
                                           redirect(admin_url());
                                           exit;
                                       }
			}
		}

		if($id == ''){
			$title = _l('add_new',_l('bank_branche_lowercase'));
		} else {
	
			$bank = $this->bankbranches_model->get($id);
                        $data['user_notes'] = $this->bankbranches_model->get_user_notes($id, 0);
              
			$data['bank'] = $bank;
                       
                        $data['prev'] = $this->bankbranches_model->get_prev($id);
                         $data['next'] = $this->bankbranches_model->get_next($id);
                           $data['members'] = $this->staff_model->get('', 1);
                         $title = $bank->bank.' ('.$bank->branchname.') ';
            
		}
                $data['department'] = $this->clients_model->get_departments();
	
      		$data['title'] = $title;
		$this->load->view('admin/bankbranches/bankbranches',$data);
	}
        
  

 
	

	/* Delete client */
	public function delete($id){

		if(!has_permission('manageBanks')){
			access_denied('manageBanks');
		}

		if(!$id){
			redirect(admin_url('bankbranches'));
		}

		$response = $this->bankbranches_model->delete($id);

		if(is_array($response) && isset($response['referenced'])){
			set_alert('warning',_l('is_referenced',_l('bank_branche_lowercase')));
		} else if($response == true){
			set_alert('success', _l('deleted',_l('bank_branche_lowercase')));
		} else {
			set_alert('warning', _l('problem_deleting',_l('bank__branchelowercase')));
		}

		redirect(admin_url('bankbranches'));
	}

	/* Change client status / active / inactive */
	public function change_bank_status($id,$status){

		if(!has_permission('manageBanks')){
			access_denied('manageBanks');
		}

		if($this->input->is_ajax_request()){
			$this->bankbranches_model->change_bank_status($id,$status);
		}
	}
	/* Get client by id - used in ajax request */
	public function get_client_by_id_ajax($id){

		if(!$id){
			redirect(admin_url('clients'));
		}

		if(!has_permission('manageClients')){
			access_denied('manageClients');
		}
		if($this->input->is_ajax_request()){
			echo json_encode($this->bankbranches_model->get($id));
		}
	}
	/* Since version 1.0.2 add client reminder */
	public function add_bank_reminder($id){
		if(!has_permission('manageBanks')){
			access_denied('manageBanks');
		}

		if($this->input->post()){
			$success = $this->bankbranches_model->add_reminder($this->input->post(),$id);
			if($success){
				set_alert('success',_l('bank_branche_reminder_added_successfuly'));
			}
		}

		redirect(admin_url('bankbranches/bankbranche/'.$id));
	}
       public function contact($customerid = '',$id = '') {

        $data['bankbranch'] = $this->bankbranches_model->get();
   
        if ($this->input->post()) {


            if ($id == '') {
                $id = $this->bankbranches_model->addcontact();
                if ($id) {
                    set_alert('success', _l('client_contact_insert_success_action', _l('client_lowercase')));
                    redirect(admin_url('bankbranches/contact/'.$this->input->post('bankbranchid') .'/'.$id));
                }
            } else {
                $success = $this->bankbranches_model->updateContacts($id);
                if ($success) {
                    set_alert('success', _l('updated_successfuly', _l('contact')));
                }

                redirect(admin_url('bankbranches/contact/'.$this->input->post('bankbranchid') .'/'.$id));
            }
        }
        
        if ($id == '') {
            $title = _l('add_new',_l('contact'));
        } else {
            $data['contact'] = $this->bankbranches_model->get_where_record('tblbankbranchecontacts',$id);
           $title = _l('edit',_l('contact'));
        }
        
        if(isset($data['contact'])){
            $customerid = $data['contact']->bankbranchid;
        }
             
        $data['customerdetails'] = $this->bankbranches_model->get($customerid);
  
        $data['department'] = $this->bankbranches_model->get_departments();
        $data['id']=$id;
        $data['customerid']=$customerid;
        
        $data['title'] = $title;
        $this->load->view('admin/bankbranches/contact', $data);
    }
      public function get_client_reminders($id) {
        if ($this->input->is_ajax_request()) {

            $aColumns = array('description', 'date', 'staff', 'isnotified');
            $sIndexColumn = "id";
            $sTable = 'tblbankbranchesreminders';

            $where = array('AND bankbranchid=' . $id);
            $join = array(
                'JOIN tblstaff ON tblstaff.staffid = tblbankbranchesreminders.staff'
            );
            $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('firstname', 'lastname', 'id', 'creator'));
            $output = $result['output'];
            $rResult = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();
                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'staff') {
                        $_data = '<a href="' . admin_url('staff/profile/' . $aRow['staff']) . '">' . staff_profile_image($aRow['staff'], array(
                                    'staff-profile-image-small'
                                )) . ' ' . $aRow['firstname'] . ' ' . $aRow['lastname'] . '</a>';
                    } else if ($aColumns[$i] == 'staff') {
                        $_data = _d($_data);
                    } else if ($aColumns[$i] == 'isnotified') {
                        if ($_data == 1) {
                            $_data = _l('client_reminder_is_notified_boolean_yes');
                        } else {
                            $_data = _l('client_reminder_is_notified_boolean_no');
                        }
                    }
                    $row[] = $_data;
                }

                if ($aRow['creator'] == get_staff_user_id()) {
                    $row[] = icon_btn('admin/bankbranches/delete_reminder/' . $id . '/' . $aRow['id'], 'remove', '');
                } else {
                    $row[] = '';
                }


                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }
    }

    /* Since version 1.0.2 delete client reminder */

    public function delete_reminder($clientid, $id) {
        if (!$id && !$clientid) {
            die('No reminder found');
        }
        $success = $this->bankbranches_model->delete_reminder($id);

        if ($success) {
            set_alert('success', _l('client_reminder_deleted'));
        } else {
            set_alert('warning', _l('client_reminder_failed_to_delete'));
        }

        redirect(admin_url('bankbranches/bankbranche/' . $clientid));
    }
    
    public function add_client_reminder($id) {
        if (!has_permission('manageBanks')) {
            access_denied('manageBanks');
        }

        if ($this->input->post()) {
            $success = $this->bankbranches_model->add_reminder($this->input->post(), $id);
            if ($success) {
                set_alert('success', _l('client_reminder_added_successfuly'));
            }
        }

        redirect(admin_url('bankbranches/bankbranche/' . $id));
    }
        /*Add new client /staff note from admin area */
    public function add_user_note($userid, $staff='')
    {

        if (!$userid) {
            die('No user id found');
        }

        $redirect_controller = 'bankbranches';
        $redirect_method     = 'bankbranche';
        if ($staff == 1) {
            $redirect_controller = 'staff';
            $redirect_method     = 'member';
        }

        if ($this->input->post()) {
            $success = $this->bankbranches_model->add_user_note($this->input->post(), $userid, $staff);
            if ($success) {
                set_alert('success', 'Branch note added successfuly');
            }
            redirect(admin_url('' . $redirect_controller . '/' . $redirect_method . '/' . $userid));
        }
    }
    /* Delete client /staff note from admin area */
    public function remove_user_note($noteid, $userid, $staff)
    {
        if (!$noteid) {
            die('No note id found');
        }

        $redirect_controller = 'bankbranches';
        $redirect_method     = 'bankbranche';
        if ($staff == 1) {
            $redirect_controller = 'staff';
            $redirect_method     = 'member';
        }

        $success = $this->bankbranches_model->delete_user_note($noteid);
        if ($success) {
            set_alert('success', 'Branch note deleted successfuly');
        }

        redirect(admin_url('' . $redirect_controller . '/' . $redirect_method . '/' . $userid));
    }
     public function get_attachments($id) {
       
        $data['clientid'] = $id;
        $data['attachments'] = $this->bankbranches_model->get_all_customer_attachments($id);
        $this->load->view('admin/bankbranches/attachments_template', $data);
    }
     public function upload_attachment($id) {
        handle_branch_attachments_upload($id);
    }
    
    public function delete_attachment($id) {
        echo json_encode(array('success' => $this->bankbranches_model->delete_attachment($id)));
    }
        public function manage()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            if ($data['contactid'] == '') {
                $message = '';
                $success = $this->bankbranches_model->addcontact($data);
                if($success) {
                    $message = _l('added_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            } else {
                $message = '';
                $success = $this->bankbranches_model->updateContacts($data);
                if($success){
                    $message = _l('updated_successfuly','Contact');
                }
                echo json_encode(array(
                    'success' => $success,
                    'message'=>$message
                ));
            }
        }
    }
    public function getcontact(){
        echo json_encode($this->bankbranches_model->getcontact($this->input->post('id')));
    }
    
	

}
