<?php

// Tag - used in BULK pdf exporter
if ($tag != '') {
    $pdf->SetFillColor(240, 240, 240);
    $pdf->SetDrawColor(245, 245, 245);
    $pdf->SetXY(0, 0);
    $pdf->SetFont('freesans', 'B', 15);
    $pdf->SetTextColor(0);
    $pdf->SetLineWidth(0.75);
    $pdf->StartTransform();
    $pdf->Rotate(-35, 109, 235);
    $pdf->Cell(100, 1, strtoupper($tag), 'TB', 0, 'C', '1');
    $pdf->StopTransform();
    $pdf->SetFont('freesans', '', 10);
    $pdf->setX(10);
    $pdf->setY(10);
}

// Top
$_status = '<div style="font-weight:bold;font-size:14px;color:red;">OVERDUE</div>';

$html = '';
$html .= '<span style="font-weight:bold;font-size:20px;color:red;">Statement</span><br />';


$pdf->writeHTMLCell(120, 0, 0, 12, $_status, 0, 1, false, true, 'R', false);
$pdf->writeHTMLCell(0, 0, 0, 10, $html, 0, 1, false, true, 'R', false);
$pdf->Ln(6);
$pdf->setJPEGQuality(100);
$custom_pdf_logo_image_url = get_option('custom_pdf_logo_image_url');

if ($custom_pdf_logo_image_url == '') {
    if (get_option('company_logo'))
        $pdf->writeHTMLCell(35, 0, 10, 10, '<a href="' . site_url() . '"><img src="' . site_url('uploads/company/' . get_option('company_logo')) . '"></a>', 0, 1, false, true, 'L', false);
} else {
    $pdf->writeHTMLCell(35, 0, 10, 10, '<a href="' . site_url() . '"><img src="' . $custom_pdf_logo_image_url . '"></a>', 0, 1, false, true, 'L', false);
}
// Get Y position for the separation
$y = $pdf->getY();
$invoice_info = '<b>' . get_option('invoice_company_name') . '</b><br />';
$invoice_info .= nl2br(get_option('invoice_company_address')) . '<br/>';
$invoice_info .= get_option('invoice_company_city') . ', ';
$invoice_info .= get_option('invoice_company_state') . ', ';
$invoice_info .= get_option('invoice_company_postal_code') . '<br/> ';
$invoice_info .= get_country_name(get_option('invoice_company_country_code')) . '<br/>';
if (get_option('invoice_company_phonenumber') != '') {
    $invoice_info .='<abbr title="Phone">P:</abbr>' . get_option('invoice_company_phonenumber');
}

// check for company custom fields
$custom_company_fields = get_company_custom_fields();
if (count($custom_company_fields) > 0) {
    $invoice_info .= '<br />';
}
foreach ($custom_company_fields as $field) {
    $invoice_info .= $field['label'] . ': ' . $field['value'] . '<br />';
}

$pdf->writeHTMLCell(91, '', '', $y, $invoice_info, 0, 0, false, true, 'J', true);

// Bill to

$client_details = $clientdetails->accountname . '<br />';
$client_details .= nl2br($clientdetails->address) . '<br />' . $clientdetails->city . ', ' . $clientdetails->state . ' , ' . $clientdetails->zip . '<br />' .
        get_country_name($clientdetails->country) . '<br />';

if (!empty($clientdetails->phonenumber)) {
    $client_details .='<abbr title="Phone">P:</abbr>' . $clientdetails->phonenumber . '<br/>';
}


$pdf->writeHTMLCell(99, '', '', '', $client_details, 0, 1, false, true, 'R', true);
$str = explode('|', get_option("dateformat"));
// Dates
$pdf->Cell(0, 0, 'Statement Date : ' . date($str[0]), 0, 1, 'R', 0, '', 0);
$pdf->Cell(0, 0, 'Account ID : ' . $clientdetails->account_number, 0, 1, 'R', 0, '', 0);
$pdf->Cell(0, 0, 'Account Manager : ' . $clientdetails->firstname . ' ' . $clientdetails->lastname, 0, 1, 'R', 0, '', 0);

// The Table
$pdf->Ln(5);
// Header
$tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
<tr height="30" bgcolor="#3A4656" style="color:#fff;text-align:left;">
	<th width="6%;">Line</th>
	<th width="12%" align="left">Date</th>
	<th width="20%">Transaction Type</th>
	<th width="16%">Reference</th>
	<th width="14%;" >Charge</th>
	<th width="14%">Payment</th>
	<th width="18%">Balance</th>
</tr>';

$j = 0;
$tblhtml .= '<tbody>';
$CI = & get_instance();
$i = 0;
$str = explode('|', get_option("dateformat"));
$range = array('30-60', '60-90', '90-120', '120-99999999');


$group_amount = array();
foreach ($range as $key => $rng) {
    $group_amount[$rng] = 0;
}

if($totaloutstanding){ 
         $tblhtml .='<tr>
                <td>'.++$j.'</td>
                <td>'._d($fromdate).'</td>
                <td>Brought Forward</td>
                <td></td>
                <td></td>
                <td></td>
                <td >'.format_money($totaloutstanding, $base_currency_symbol).'</td>
            </tr>';
            }else{
                $totaloutstanding=0;

           $tblhtml .='<tr>
                <td>'.++$j.'</td>
                <td>'._d($fromdate).'</td>
                <td>Brought Forward</td>
                <td></td>
                <td></td>
                <td></td>
                <td >$0.00</td>
            </tr>';
   }

foreach ($invoicesin as $key => $value) {

    $diffrent = $min = $max;
    foreach ($range as $key => $group) {
        $now = time(); // or your date as well
        $invoicedate = strtotime($value->date);
        $datediff = $now - $invoicedate;
        $diffrent = floor($datediff / (60 * 60 * 24));
        $res = explode('-', $group);

        $min = $res[0];
        if ($res[1] == '99999999') {
            $max = '999999999';
        } else {
            $max = $res[1];
        }

        if (($diffrent >= $min) && ($diffrent < $max)) {
            $group_amount[$group] = $group_amount[$group] + $value->total;
        }
    }

    if (!isset($invoicesin_balance)) {
        $invoicesin_balance = $totaloutstanding + $value->total;
    } else {
        $invoicesin_balance+=$value->total;
    }
    $tblhtml .="<tr>";
    $tblhtml .= "<td>" . ++$j . "</td>";
    $tblhtml .= "<td>" . _d($value->date) . "</td>";
    $tblhtml .= "<td>Invoice</td>";
    $tblhtml .= "<td>" . format_invoice_number($value->number) . "</td>";
    $tblhtml .= "<td align='right'>" . format_money($value->total, $base_currency_symbol) . "</td>";
    $tblhtml .= "<td></td>";
    $tblhtml .= "<td align='right'>" . format_money($invoicesin_balance, $base_currency_symbol) . "</td>";
    $tblhtml .= "</tr>";

    $paidinvoice = $CI->reports_model->get_paidinvoice($value->id,$fromdate_payment,$todate_payment);
    foreach ($paidinvoice as $paid) {
        $invoicesin_balance -= $paid->amount;
        $tblhtml .= "<tr>";
        $tblhtml .= "<td>" . ++$j . "</td>";
        $tblhtml .= "<td>" . _d($paid->date) . "</td>";
        $tblhtml .= "<td>Payment</td>";
        $tblhtml .= "<td>" . format_payment_number($paid->id) . "</td>";
        $tblhtml .= "<td></td>";
        $tblhtml .= "<td align='right'>" . format_money($paid->amount, $base_currency_symbol) . "</td>";

        $tblhtml .= "<td align='right'>" . format_money($invoicesin_balance, $base_currency_symbol) . "</td>";
        $tblhtml .= "</tr>";
    }
    $i++;
    
}


$tblhtml .= '</tbody>';
$tblhtml .= '</table>';
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$rangeHTML = '<table width="100%" bgcolor="#fff" rules="all" cellspacing="0" cellpadding="5" border="1">
<tr height="30" style="color:#000;text-align:center;">
	<th width="12%;">Current</th>
	<th width="13%">30 Days</th>
	<th width="13%">60 Days</th>
	<th width="13%">90 Days</th>
	<th width="13%;">120 Days</th>
	<th width="16%;">Amount Due</th>
	<th width="20%">Total Outstanding</th>
	
</tr>';

$rangeHTML .= '<tbody>';

$now = time(); 
    $invoicedate = strtotime($value->date);
    $datediff = $now - $invoicedate;
    $diffrent=  floor($datediff/(60*60*24));
   if($diffrent <= 30) {
       $currentinvoice =format_money($value->total, $base_currency_symbol);
   }else{
         $currentinvoice ='$0.00';
   }
   $rangeHTML .='<tr><td style="text-align: center">'.$currentinvoice.'</td>';
    $mountdue = array_sum($group_amount);
    
     foreach ($group_amount as $key => $value) {
        if($value != 0)
            $rangeHTML .='<td style="text-align: center">'.format_money($value, $base_currency_symbol).'</td>';                        
       else 
            $rangeHTML .='<td style="text-align: center">$0.00</td>';                         
        } 
        if($mountdue > 0 ){
   $rangeHTML .='<td style="text-align: center">'.format_money($mountdue, $base_currency_symbol).'</td>
                        <td style="text-align: center">'.format_money($invoicesin_balance, $base_currency_symbol).'</td>
                        </tr>
                        </tbody>
                    </table>';
        }else{
           $rangeHTML .='<td style="text-align: center">$0.00</td>
                        <td style="text-align: center">'.format_money($invoicesin_balance, $base_currency_symbol).'</td>
                        </tr>
                        </tbody>
                    </table>';   
        }
   $rangeHTML .='<br/><br/><b>Please detach and send with payment to :</b>   ____________________________________________________________<br/>';

    $pdf->writeHTML($rangeHTML, true, false, false, false, '');
//    $pdf->Cell(0, 0, 'Please detach and send with payment to :   _______________________________________________________________', 0, 1, 'L', 0, '', 0);
//    $pdf->Ln(1);
    
    
$invoice_info_html = '<table style="width:750px"><tr><td><b>' . get_option('invoice_company_name') . '</b><br />';
$invoice_info_html .= nl2br(get_option('invoice_company_address')) . '<br/>';
$invoice_info_html .= get_option('invoice_company_city') . ', ';
$invoice_info_html .= get_option('invoice_company_state') . ', ';
$invoice_info_html .= get_option('invoice_company_postal_code') . '<br/> ';
$invoice_info_html .= get_country_name(get_option('invoice_company_country_code')) . '<br/>';
if (get_option('invoice_company_phonenumber') != '') {
    $invoice_info_html .='<abbr title="Phone">P:</abbr>' . get_option('invoice_company_phonenumber');
}
$invoice_info_html .='</td><td>';

   // $pdf->writeHTML($invoice_info_html, true, false, false, false, '');
    $invoice_info_html .='<b>Remittance Advice</b><br/>';
    $invoice_info_html .='<table style="width:200px" cellpadding="1">'
            . '<tr><td style="width:30%">Customer : </td><td>'.$clientdetails->firstname.' '.$clientdetails->lastname.'</td></tr>'
            . '<tr><td style="width:30%">Date : </td><td>'.date('d-M-Y').'</td></tr>';
            if($mountdue > 0){
            $invoice_info_html  .='<tr><td style="width:30%">Total Due : </td><td>'.format_money($mountdue, $base_currency_symbol).'</td></tr>';   
            }else{
              $invoice_info_html.='<tr><td style="width:30%">Total Due : </td><td>$0.00</td></tr>' ;
            }
           
             $invoice_info_html.='<tr><td style="width:30%">Paid : </td><td><div style="border:1px solid gray">&nbsp;</div></td></tr>'
            . '</table></td></tr></table>';
    $pdf->writeHTML($invoice_info_html, true, false, false, false, '');

