<?php
if($tag != ''){
    $pdf->SetFillColor(240,240,240);
    $pdf->SetDrawColor(245,245,245);
    $pdf->SetXY(0,0);
    $pdf->SetFont('freesans','B',15);
    $pdf->SetTextColor(0);
    $pdf->SetLineWidth(0.75);
    $pdf->StartTransform();
    $pdf->Rotate(-35,109,235);
    $pdf->Cell(100,1,strtoupper($tag),'TB',0,'C','1');
    $pdf->StopTransform();
    $pdf->SetFont('freesans','',10);
    $pdf->setX(10);
    $pdf->setY(10);
}
if(get_option('show_status_on_pdf_ei') == 1){
    // Top
	   			
    if ($status == 1) {
        $status ='New';
        $pdf->SetFillColor(119, 119, 119);
    } else if ($status == 2) {
        $status = 'Under Review';
        $pdf->SetFillColor(3, 169, 244);
    } else if ($status == 3) {
        $status = 'Approved';
         $pdf->SetFillColor(252, 45, 66);
    } else if ($status == 4) {
        $status = 'Ordered';
        $pdf->SetFillColor(37, 155, 36);
    }
   

    $pdf->SetTextColor(255);
    $pdf->Cell(50, 10, strtoupper($status), 0, 1, 'C', '1');
    $pdf->SetTextColor(0);
}
$html = '<span style="font-weight:bold;font-size:18px;">Purchase Request</span><br />';
$html .= '<b style="color:#6a6c6f"># ' .format_rfqsquote_number($order->number) . '</b>';
$pdf->writeHTMLCell(0, 0, 0, 20, $html, 0, 1, false, true, 'R', false);
$pdf->Ln(6);
$custom_pdf_logo_image_url = get_option('custom_pdf_logo_image_url');
$pdf->setJPEGQuality(100);
if($custom_pdf_logo_image_url == ''){
     if(get_option('company_logo'))
    $pdf->writeHTMLCell(35, 0, 10, 25, '<a href="'.site_url().'"><img src="'.site_url('uploads/company/'.get_option('company_logo')).'"></a>', 0, 1, false, true, 'L', false);
} else {
    $pdf->writeHTMLCell(35, 0, 10, 25, '<a href="'.site_url().'"><img src="'.$custom_pdf_logo_image_url.'"></a>', 0, 1, false, true, 'L', false);
}
// Get Y position for the separation
$y            = $pdf->getY();
$order_info = '<b>' . get_option('invoice_company_name') . '</b><br />';
$order_info .= nl2br(get_option('invoice_company_address')) . '<br/>';
$order_info .= get_option('invoice_company_city') . ', ';
$order_info .= get_option('invoice_company_state') . ', ';
$order_info .= get_option('invoice_company_postal_code') . '<br/> ';
$order_info .= get_country_name(get_option('invoice_company_country_code')) . '<br/> ';
if(get_option('invoice_company_phonenumber') != ''){
    $order_info .='<abbr title="Phone">P:</abbr>'. get_option('invoice_company_phonenumber'); 
  } 
// check for company custom fields
$custom_company_fields = get_company_custom_fields();
if(count($custom_company_fields) > 0){
    $order_info .= '<br />';
}
foreach($custom_company_fields as $field){
    $order_info .= $field['label'] . ':' . $field['value'] . '<br />';
}

$pdf->writeHTMLCell(91, '', '', $y, $order_info, 0, 0, false, true, 'J', true);

$client_details="";
// Quote to
if(!empty($order->reference_no))
$client_details .= '<b>' ._l('reference_no') . ': '.$order->reference_no.'</b><br />';

$client_details .= '<b>Created On :' ._d($order->datecreated). '</b><br />';

$client_details .= '<b>Requested By :' .$order->createdby. '</b><br />';
$client_details .= '<b>Requested On :' ._d($order->requisitiondate). '</b><br />';
$client_details .= '<b>Required On :' ._d($order->requiredby). '</b><br />';
$client_details .= '<b>Warehouse :' .$order->warehouse. '</b><br />';


//$pdf->writeHTMLCell(200, '', '50', $y, $client_details, 0, 0, false, true, 'J', true);
$pdf->writeHTMLCell(0, 0, 0, $y, $client_details, 0, 1, false, true, 'R', false);
// The Table
$pdf->Ln(40);
// Header
$tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
<tr height="30" bgcolor="#3A4656" style="color:#fff;text-align:center;">
	<th width="5%;">#</th>
	<th width="20%" align="left">Supplier SKU</th>
	<th width="15%">Our SKU</th>
	<th width="25%">Description</th>
	<th width="15%">Qty</th>
	<th width="20%">Unit Of measure</th>
	
</tr>';
// Items
$taxes   = array();
$i       = 1;
$tblhtml .= '<tbody>';
 $CI =& get_instance();
foreach ($order->items as $item) {
    $tblhtml .= '<tr style="text-align:center;font-size:9px;">';
    $tblhtml .= '<td>' . $i . '</td>';
	$tblhtml .= '<td>' . $item['suppliersku'] . '</td>';
	$tblhtml .= '<td>' . $item['oursku'] . '</td>';
    $tblhtml .= '<td align="left">' . $item['description'] .'</td>';
    $tblhtml .= '<td>' . floatVal($item['qty']) . '</td>';
    $tblhtml .= '<td>' . $item['unit'] . '</td>';
    $tblhtml .= '</tr>';
    
    $i++;
}
$tblhtml .= '</tbody>';
$tblhtml .= '</table>';
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(8);


if (!empty($order->clientnote)) {
    $pdf->Ln(4);
    $pdf->MultiCell(190, 0, 'Warehouse note: ' . ' ' . clear_textarea_breaks($order->clientnote),0,'L');
}

