<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-heading">
                        <h2><?php echo $title; ?></h2>
                    </div>

                    <div class="panel-body">
                        <a href="javascript:void(0)" class="btn btn-info pull-left display-block addcategory" style="margin-bottom: -30px">
                            <?php echo _l('sub_new_category'); ?>
                        </a>
                        <div class="clearfix"></div>
                        
                        <div class="table-resposive">
                            <table id="example" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('category_name'); ?></th>
                                        <th><?php echo _l('sub_cat_name'); ?></th>
                                        <th><?php echo _l('sub_cat_description'); ?></th>
                                        <th><?php echo _l('sub_cat_item'); ?></th>
                                        <th>Eview Enabled</th>
                                        <th><?php echo _l('sub_cat_isactive'); ?></th>
                                        <th><?php echo _l('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($subcategories as $subcategory)
                                    {
                                    ?>
                                    <tr>
                                        <td><?php echo $subcategory->category_name; ?></td>
                                        <td><?php echo $subcategory->subcategory_name; ?></td>
                                        <td><?php echo $subcategory->description; ?></td>
                                        <td>
                                            <?php 
                                                $inv_subcate = $this->subcategories_model->count_invoice_subcategory($subcategory->subcategory_id);
                                                echo $inv_subcate;
                                            ?>
                                        </td>
                                        <td>
                                            <?php if ($subcategory->show_in_cart == '0') { ?>
                                                <input  class="showeview" data-rowid="<?php echo $subcategory->subcategory_id; ?>" value="<?php echo $subcategory->show_in_cart; ?>" type="checkbox"/>
                                            <?php } else { ?>
                                                <input  class="showeview" data-rowid="<?php echo $subcategory->subcategory_id; ?>" checked="checked" value="<?php echo $subcategory->show_in_cart; ?>" type="checkbox"/>
                                            <?php } ?>
                                             
                                        </td>
                                        <td>
                                            <?php if ($subcategory->active == '0') { ?>
                                                <input  class="ischeckbox" data-rowid="<?php echo $subcategory->subcategory_id; ?>" value="<?php echo $subcategory->active; ?>" type="checkbox"/>
                                            <?php } else { ?>
                                                <input  class="ischeckbox" data-rowid="<?php echo $subcategory->subcategory_id; ?>" checked="checked" value="<?php echo $subcategory->active; ?>" type="checkbox"/>
                                            <?php } ?>
                                             
                                        </td>
                                        <td>
                                            <a href="javascript:void(0)" class="btn edit-category btn-icon" data-id="<?php echo $subcategory->subcategory_id; ?>"><i class="fa fa-pencil-square-o"></i></a>

                                            <a onClick="return deleteconf();" href="<?php echo admin_url('subcategories/delete/'.$subcategory->subcategory_id) ?>"" class="btn  btn-icon" data-toggle="tooltip" title="" data-original-title="<?php echo _l('sub_category_delete_tooltip'); ?>"><i class="fa fa-remove"></i></a>
                                        </td>
                                    </tr>
                                    <?php
                                        }
                                         
                                    ?>
                                    
                                </tbody>
                            </table>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
init_tail();
include_once(APPPATH . 'views/admin/subcategories/modals/add_subcategory.php');
include_once(APPPATH . 'views/admin/subcategories/modals/update_subcategory.php');
?>
<script>
    $(document).ready(function () {
        $('.addcategory').on('click', function (e) {
            e.preventDefault();
            $('#add_subcategory_modal').modal('show');
        });

        $('#example').DataTable({
            "bLengthChange": false,
            "language": {
                "search": "Find"
            },
        });

    });

     $(document).ready(function(){

        $('.addsaveandnew').on('click', function (e) {
            if($('#show_in_cart').prop("checked") == true){
                var show_in_cart = 1;
            }
            else
            {
                var show_in_cart = 0;
            }

            if($('#cat_is_active').prop("checked") == true){
                var cat_is_active = 1;
            }
            else
            {
                var cat_is_active = 0;
            }

           
            $.ajax({
                type: "POST",
                url: admin_url + 'subcategories/addcategory',
                // data: {data: $('#add_category_form').serializeArray()},
                data: {
                    category: $('#category').val(),
                    categoryname: $('#categoryname').val(),
                    description: $('#description').val(),
                    show_in_cart: show_in_cart,
                    cat_is_active: cat_is_active,

                },
                dataType: 'json',
                success: function (response) {
                    // location.reload();
                    $('#category').val('');
                    $('#categoryname').val('');
                    $('#description').val('');
                    $('#cat_is_active').prop('checked', false);
                    $('#show_in_cart').prop('checked', false);
                    $('#add_subcategory_modal').modal('show');
                   
                }
                
            });
      
        });

        $('.updatesaveandnew').on('click', function (e) {
            if($('#edit_subcategory_form #show_in_cart').prop("checked") == true){
                var show_in_cart = 1;
            }
            else
            {
                var show_in_cart = 0;
            }

            if($('#edit_subcategory_form #cat_is_active').prop("checked") == true){
                var cat_is_active = 1;
            }
            else
            {
                var cat_is_active = 0;
            }

           
            $.ajax({
                type: "POST",
                url: admin_url + 'subcategories/updatecategory',
                // data: {data: $('#add_category_form').serializeArray()},
                data: {
                    category: $('#edit_subcategory_form #category').val(),
                    categoryname: $('#edit_subcategory_form #categoryname').val(),
                    description: $('#edit_subcategory_form #description').val(),
                    show_in_cart: show_in_cart,
                    cat_is_active: cat_is_active,
                    cat_id: $('#edit_subcategory_form #cat_id').val(),

                },
                dataType: 'json',
                success: function (response) {
                    // location.reload();
                    $('#category').val('');
                    $('#categoryname').val('');
                    $('#description').val('');
                    $('#cat_is_active').prop('checked', false);
                    $('#show_in_cart').prop('checked', false);

                    $('#edit_subcategory_modal').modal('hide');
                    $('#add_subcategory_modal').modal('show');
                }
                
            });
      
        });
    });

    $(document).on('click', '.edit-category', function () {

        var id = $(this).attr('data-id');
        $.ajax({
            type: "POST",
            url: admin_url + 'subcategories/get_category',
            data: {id: id},
            dataType: 'json',
            success: function (response) {
                $('#edit_subcategory_modal').modal('show');
                $('#edit_subcategory_form #category').selectpicker('deselectAll');
                $('#edit_subcategory_form #sales,#inventory,#cogs').selectpicker('deselectAll');
                $('#edit_subcategory_form #category').selectpicker('val', response.catid);
                $('#edit_subcategory_form #category').selectpicker('refresh');
                $('#edit_subcategory_form #sales').selectpicker('val', response.sales);
                $('#edit_subcategory_form #sales').selectpicker('refresh');
                $('#edit_subcategory_form #inventory').selectpicker('val', response.inventory);
                $('#edit_subcategory_form #inventory').selectpicker('refresh');
                $('#edit_subcategory_form #cogs').selectpicker('val', response.cogs);
                $('#edit_subcategory_form #cogs').selectpicker('refresh');
                $('#edit_subcategory_form #categoryname').val(response.subcategory_name);
                $('#edit_subcategory_form #description').val(response.description);
                $('#edit_subcategory_form #cat_id').val(response.subcategory_id);
                if (response.active == '1') {
                    $('#edit_subcategory_form input[name="cat_is_active"]').prop('checked', true);
                }
                else {
                    $('#edit_subcategory_form input[name="cat_is_active"]').prop('checked', false);
                }

                 if (response.show_in_cart == '1') {
                    $('#edit_subcategory_form input[name="show_in_cart"]').prop('checked', true);
                }
                else {
                    $('#edit_subcategory_form input[name="show_in_cart"]').prop('checked', false);
                }


            }
        });
    });

    $(document).on('click', '.ischeckbox', function () {
        var current = $(this);
        $.ajax({
            url: admin_url + "subcategories/changestatus",
            data: {id: $(this).data('rowid'), rowtype: $(this).data('rowtype')},
            dataType: 'json',
            type: 'post',
            success: function (response)
            {

            }
        });
    });

    $(document).on('click', '.showeview', function () {
        var current = $(this);
        $.ajax({
            url: admin_url + "subcategories/changeeview",
            data: {id: $(this).data('rowid'), rowtype: $(this).data('rowtype')},
            dataType: 'json',
            type: 'post',
            success: function (response)
            {

            }
        });
    });
</script>
</body>
</html>
