<!-- Client add reminder modal -->
<style>
    .modal-dialog {
  width: 60%;
}
</style>
<div class="modal animated fadeIn" id="contact_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <?php echo form_open(admin_url('employee/contact'), array('class' => 'contact-form', 'id' => 'contactform')); ?>    
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title add-title" ><i class="fa" data-toggle="tooltip" title="Add new Contact" data-placement="bottom"></i> Add New Contact</h4>
                <h4 class="modal-title edit-title" ><i class="fa" data-toggle="tooltip" title="Edit new Contact" data-placement="bottom"></i> Edit Contact</h4>
            </div>
            <div class="modal-body">
                <div class="row">


                    <div class="clearfix"></div>
                    
                    <div class="clearfix"></div>
                    <div class="col-md-6">

                        <div class="form-group">
                            <?php echo form_hidden('id'); ?>
                            <input type="hidden" name="empid" value="<?php echo $employee->empid ?>"/>
                            <label for="salutation" class="control-label"><?php echo _l('client_salutation'); ?></label>
                            <select name="salutation" class="form-control selectpicker" id="salutation" data-live-search="true">
                                <option value=""></option>
                                <?php
                                    foreach ($salutation as $value) {
                                        if ($value->id == $employee->salutation) {
                                ?>
                                            <option selected="selected" value="<?php echo $value->id; ?>"><?php echo $value->description; ?></option>
                                <?php   }  ?>
                                    <option value="<?php echo $value->id; ?>"><?php echo $value->description; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <?php $value = (isset($employee) ? $employee->firstname : ''); ?>
                        <?php echo render_input('firstname', 'Firstname', $value); ?>

                        <?php $value = (isset($employee) ? $employee->lastname : ''); ?>
                        <?php echo render_input('lastname', 'Lastname', $value); ?>                                        

                        <div class="form-group">
                            <label for="country" class="control-label">Country</label>
                            <select name="country" class="form-control selectpicker" id="country" data-live-search="true">
                                <option value="">Nothing Selected</option>
                                <?php
                                foreach (get_all_countries() as $country) {
                                    $selected = '';
                                    if (isset($employee)) {
                                        if ($employee->country == $country['country_id']) {
                                            $selected = 'selected';
                                        }
                                    // } else {
                                    //     if ($client->country == $country['country_id']) {
                                    //         $selected = 'selected';
                                    //     }
                                    }                                               
                                    ?>
                                    <option value="<?php echo $country['country_id']; ?>" <?php echo $selected; ?>><?php echo $country['short_name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="address" class="control-label">Address</label>
                            <textarea name="address" rows="2" cols="15" class="form-control selectpicker" id="address" data-live-search="true"><?php echo (isset($employee) ? $employee->address : ""); ?></textarea>
                        </div>

                        <?php $value = (isset($employee) ? $employee->city : ""); ?>
                        <?php echo render_input('city', 'City', $value); ?>

                        <?php $value = (isset($employee) ? $employee->state : ""); ?>
                        <?php echo render_input('state', 'State', $value); ?>

                        <?php $value = (isset($employee) ? $employee->postal_code : ""); ?>
                        <?php echo render_input('postal_code', 'Postal Code', $value); ?>
                    </div>

                    <div class="col-md-6">

                        <div class="form-group">
                            <label class="control-label">Relationship</label>
                            <select name="relationship" class="form-control selectpicker" id="relationship" data-live-search="true">
                                <option value="">Nothing Selected</option>
                                <option value="husband">Husband</option>
                                <option value="wife">Wife</option>
                                <option value="son">Son</option>
                                <option value="daughter">Daughter</option>
                                <option value="uncle">Uncle</option>
                                <option value="aunt">Aunt</option>
                                <option value="cousin">Cousin</option>
                                <option value="grand_mother">Grand Mother</option>
                                <option value="grand_father">Grand Father</option>
                                <option value="step_mother">Grand Mother</option>
                                <option value="step_father">Grand Father</option>
                                
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="control-label">Priority</label>
                            <select name="priority" class="form-control selectpicker" id="priority" data-live-search="true">
                                <option value="first">First</option>
                                <option value="second">Second</option>
                                <option value="third">Third</option>
                                <option value="forth">Forth</option>
                                <option value="fifth">Fifth</option>
                            </select>
                        </div>

                        <?php $value = (isset($employee) ? $employee->phone : ''); ?>
                        <?php echo render_input('phone_home', 'Phone (Home)', $value); ?>

                        <?php $value = (isset($employee) ? $employee->phone : ''); ?>
                        <?php echo render_input('phone_work', 'Phone (Work)', $value); ?>

                        <?php $value = (isset($employee) ? $employee->mobile : ''); ?>
                        <?php echo render_input('mobile', 'Mobile', $value); ?>

                        <?php $value = (isset($employee) ? $employee->email : ''); ?>
                        <?php echo render_input('email', 'Email', $value, 'email'); ?>


                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
<script>
 $(document).ready(function () {
            
        var form = _validate_form($('#contactform'), {firstname: 'required', lastname: 'required', salutation: 'required', country: 'required',address: 'required',relationship: 'required',priority: 'required'},manage_contact_form);
 
   function manage_contact_form(form) {
 
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).success(function (response) {
            response = $.parseJSON(response);
            if (response.success != '0') {
                // $('.table-contacts-single-client').DataTable().ajax.reload();
                alert_float('success', response.message);
                location.reload();
            }
            $('#contact_modal').modal('hide');
        });
        return false;
    }
      $('#contact_modal').on('show.bs.modal', function (event) {
           $('#contactform .add-title').addClass('hide');
         $('#contactform .edit-title').removeClass('hide');  
        var button = $(event.relatedTarget)
        var id = button.data('id');
        var data = {id: id};
        var url = '<?php echo base_url('admin/employee/getcontact') ?>';
        if(id){
              $('#contactform input').val('');
           $('#contactform select').selectpicker('val', "");
            $('#contactform select').selectpicker('refresh');
            $('#contactform textarea').val('');
        $.post(url, data, function (response) {
        
       
        if (typeof (id) !== 'undefined') {
            $('input[name="id"]').val(id);
            $('input[name="empid"]').val(response.empid);
            $('#contactform input[name="firstname"]').val(response.firstname);
            $('#contactform input[name="lastname"]').val(response.lastname);
            $('#contactform textarea[name="address"]').val(response.address);
            $('#contactform #salutation').selectpicker('val', response.salutation);
            $('#contactform #salutation').selectpicker('refresh');
            $('#contactform #country').selectpicker('val', response.country);
            $('#contactform #country').selectpicker('refresh');
            $('#contactform input[name="city"]').val(response.city);
            $('#contactform input[name="state"]').val(response.state);
            $('#contactform input[name="postal_code"]').val(response.postal_code);
            $('#contactform #relationship').selectpicker('val', response.relationship);
            $('#contactform #relationship').selectpicker('refresh');
            $('#contactform #priority').selectpicker('val', response.priority);
            $('#contactform #priority').selectpicker('refresh');

            $('#contactform input[name="phone_home"]').val(response.phone_home);
            $('#contactform input[name="phone_work"]').val(response.phone_work);
            $('#contactform input[name="mobile"]').val(response.mobile);
            $('#contactform input[name="email"]').val(response.email);
        }
    }, 'json');
    }
    });
    });</script>

