<style media="print" type="text/css">
.navbar-fixed-bottom{display:none}

@media print 
{
    .table-items
    {
        border: 0px;
        background: #fff;
        width: 100%
        /*-webkit-print-color-adjust: exact; */
    }
}
@media print {
    .thead-item
    {
        background-color: #3A4656 !important;
        /*height: 30px;*/
        -webkit-print-color-adjust: exact; 

    }
    .th-item
    {
        color: #fff !important;
        text-align: center !important;
        /*height: 30px !important;*/
    }
    .main-total
    {
        background-color:#f0f0f0 !important;
        -webkit-print-color-adjust: exact; 
    }
    .fulfilled
    {
        color: #249A23 !important;
    }
    .new
    {
        color: #323A45 !important;
    }
    .completed
    {
        color: #03a9f4 !important;
    }
    .inprogress
    {
        color: #03a9f4 !important;
    }
    .planning
    {
        color: #03a9f4 !important;
    }
    .expired
    {
        color: #C9302C !important;
    }
}
</style>

<?php 
    
function format_invoicestatus($status, $classes = '', $label = true)
{
    $invoicestatus ="";

    if ($status == 1) {
        $invoicestatus      = _l('invoice_status_unpaid');
    } else if ($status == 2) {
        $invoicestatus      = _l('invoice_status_paid');
        // $label_class = 'success';
    } else if ($status == 3) {
        $invoicestatus      = _l('invoice_status_not_paid_completely');
        // $label_class = 'warning';
    } else {
        // status 4
        $invoicestatus      = _l('invoice_status_overdue');
        // $label_class = 'warning';
    }

    return $invoicestatus;
}

?>

<div class="clearfix"></div>
<div class="panel_s mtop20 animated fadeIn">
    <div class="panel-body" style="border:none;">
        <div class="col-md-10 col-md-offset-1">
            <div class="row">
                <div style="width: 50%; float: left;" class="col-md-6">
                    
                    <address>
                        <span class="bold"><?php echo get_option('invoice_company_name'); ?></span><br>
                        <?php echo nl2br(get_option('invoice_company_address')); ?><br>
                        <?php echo get_option('invoice_company_city'); ?>, <?php echo get_option('invoice_company_state'); ?> , <?php echo get_option('invoice_company_postal_code'); ?><br>
                        <?php echo get_country_name(get_option('invoice_company_country_code')); ?><br/>
                        <?php if(get_option('invoice_company_phonenumber') != ''){ ?>
                        <abbr title="Phone">P:</abbr> <?php echo get_option('invoice_company_phonenumber'); ?>
                        <?php } ?>
                        <?php
                                    // check for company custom fields
                        $custom_company_fields = get_company_custom_fields();
                        foreach($custom_company_fields as $field){
                                echo $field['label'] . ':' . $field['value'] . '<br />';
                        }
                        ?>
                    </address>
                </div>
                <div style="width: 50%; float: left;" class="col-sm-6 text-right">
                    
                    <span class="bold"><?php echo _l('invoices_report'); ?></span>
                    
                    <p>
                        <span><span class="text-muted"><?php echo _l('run_date').': '; ?></span> <?php echo _d(date('Y-m-d')); ?></span><br />
                        <?php if (!empty($from_date)) { ?>

                       		<span class="mtop20"><span class="text-muted"><?php echo _l('invoices_from_date').': '; ?></span> <?php echo _d($from_date); ?></span><br>
                        <?php } ?>

                        <?php if (!empty($to_date)) { ?>

                       		<span class="mtop20"><span class="text-muted"><?php echo _l('invoices_to_date').': '; ?></span> <?php echo _d($to_date); ?></span><br>
                        <?php } ?>
                        <?php
                            if($invoices == "")
                            {
                                $count_invoices = 0;
                            }
                            else
                            {
                                $count_invoices = count($invoices);
                            }
                        ?>
                        <span class="mtop20"><span class="text-muted"><?php echo _l('invoices_count').': '; ?></span> <?php echo $count_invoices; ?></span><br>
                   
            		</p>
        		</div>
    		</div>

		    <div class="row">
		        <div class="col-md-12">
		        <table class="table-items">
	                <thead>
	                    <tr class="thead-item">
	                        <th class="th-item"><?php echo _l('invoice_dt_table_heading_number'); ?></th>

	                        <th class="description th-item"><?php echo _l('invoice_dt_table_heading_date'); ?></th>

	                        <th class="th-item"><?php echo _l('invoice_dt_table_heading_client'); ?></th>

	                        <th class="th-item"><?php echo _l('invoice_dt_table_heading_amount'); ?></th>

	                        <th class="th-item"><?php echo _l('invoice_dt_table_heading_duedate'); ?></th>

	                        <th class="th-item"><?php echo _l('invoice_dt_table_heading_status'); ?></th>
	                    </tr>
	                </thead>
	                <tbody>
	                   <?php 
				        if($invoices != "")
				        {
				        	foreach($invoices as $invoice)
				        	{
				        ?>
			        	<tr>
			                <td>
			                	<?php echo format_invoice_number($invoice->number); ?>
			                </td>

                            <td>
                                <?php echo date('d/m/Y',strtotime($invoice->date)); ?>
                            </td>

			                 <td>
			                	<?php echo $invoice->accountname; ?>
			               	</td>

                            <td>
                                <?php echo format_money($invoice->total,$invoice->symbol); ?>
                            </td>
			                
			                <td>
			                	<?php echo date('d/m/Y',strtotime($invoice->duedate)); ?>
			                </td>
			               
			                
			                
			                <td>
			                	<?php echo format_invoicestatus($invoice->status); ?>
			               	</td>
			            </tr>
				        <?php
				        	}
				       	}
				        ?>
	                </tbody>
		            </table>
		        </div>
		        
		    </div>
		</div>
	</div>
</div>
