<div class="col-md-12 page-pdf-html-logo">
    <?php get_company_logo(); ?>
    <?php if(is_staff_logged_in()){ ?>
    <a href="<?php echo admin_url(); ?>estimates/list_estimates/<?php echo $order->id; ?>" class="btn btn-info pull-right"><?php echo _l('goto_admin_area'); ?>
    </a>
    <?php } ?>
</div>
<div class="clearfix"></div>
<div class="panel_s mtop20 animated fadeIn">
    <div class="panel-body">
        <div class="col-md-10 col-md-offset-1">
            <div class="row">
                <div class="col-md-6">
                    <div class="mtop10 display-block">
                        <?php echo format_order_status($order->status,'',true,true); ?>
                    </div>
                </div>
                <div class="col-md-6 text-right">
                    <?php echo form_open($this->uri->uri_string(),array('class'=>'pull-right')); ?>
                    <input type="submit" name="quotepdf" class="btn btn-primary" value="<?php echo _l('clients_invoice_html_btn_download'); ?>">
                    <?php echo form_close(); ?>
                    <?php
                    if ($order->status != 4 && $order->status != 3) {
                            echo form_open($this->uri->uri_string(),array('class'=>'pull-right mright10'));
                            echo form_hidden('quote_action',3);
                            echo '<button type="submit" class="btn btn-danger">'._l('clients_decline_quote').'</button>';
                            echo form_close();
                            echo form_open($this->uri->uri_string(),array('class'=>'pull-right mright10'));
                            echo form_hidden('quote_action',4);
                            echo '<button type="submit" class="btn btn-success">'._l('clients_accept_quote').'</button>';
                            echo form_close();
                    } else if($order->status == 3){
                        if ($order->expirydate >= date('Y-m-d') && $order->status != 5) {
                            echo form_open($this->uri->uri_string(),array('class'=>'pull-right mright10'));
                            echo form_hidden('quote_action',4);
                            echo '<button type="submit" class="btn btn-success">'._l('clients_accept_quote').'</button>';
                            echo form_close();
                        }
                    }
                    ?>
                </div>
            </div>
            <div class="row mtop40">
                <div class="col-md-6">
                    <h4 class="bold"><?php echo format_order_number($order->number); ?></h4>
                  <address>
                                <span class="bold"><?php echo get_option('invoice_company_name'); ?></span><br>
                                <?php echo nl2br(get_option('invoice_company_address')); ?><br>
                                <?php echo get_option('invoice_company_city'); ?>, <?php echo get_option('invoice_company_state'); ?> , <?php echo get_option('invoice_company_postal_code'); ?><br>
                                <?php echo get_country_name(get_option('invoice_company_country_code')); ?><br/>
                                <?php if(get_option('invoice_company_phonenumber') != ''){ ?>
                                <abbr title="Phone">P:</abbr> <?php echo get_option('invoice_company_phonenumber'); ?>
                                <?php } ?>
                                <?php
                                // check for company custom fields
                                $custom_company_fields = get_company_custom_fields();
                                foreach($custom_company_fields as $field){
                                        echo $field['label'] . ':' . $field['value'] . '<br />';
                                }
                                ?>
                        </address>
                </div>
                <div class="col-sm-6 text-right">
                    <span class="bold"><?php echo _l('quote_to'); ?>:</span>
                    <address>
                            <span class="bold"><?php echo $order->client->accountname; ?></span><br>
                            <?php echo nl2br($order->client->address); ?><br>
                            <?php echo $order->client->city; ?>, <?php echo $order->client->state; ?> , <?php echo $order->client->zip; ?><br>
                            <?php echo get_country_name($order->client->country); ?><br/>
                            <?php if($order->client->phonenumber != ''){ ?>
                            <abbr title="Phone">P:</abbr> <?php echo $order->client->phonenumber; ?><br/>
                            <?php } ?>
                            <?php if(!empty($order->client->vat)){ ?>
                            <?php echo _l('quote_vat'); ?>: <?php echo $order->client->vat; ?><br />
                            <?php } ?>
                            <?php
                                    // check for customer custom fields which is checked show on pdf
                            $pdf_custom_fields = get_custom_fields('customers',array('show_on_pdf'=>1));
                            foreach($pdf_custom_fields as $field){
                                    $value = get_custom_field_value($order->clientid,$field['id'],'customers');
                                    if($value == ''){continue;}
                                    echo $field['name'] . ': ' . $value . '<br />';
                            }
                            ?>
                    </address>
                    <!-- shipping details -->
                    <?php if($order->include_shipping == 1 && $order->show_shipping_on_quote == 1){ ?>
                    <span class="bold"><?php echo _l('ship_to'); ?>:</span>
                    <address>
                        <?php echo $order->shipping_street; ?><br>
                        <?php echo $order->shipping_city; ?>, <?php echo $order->shipping_state; ?><br/><?php echo get_country_short_name($order->shipping_country); ?>,<?php echo $order->shipping_zip; ?>
                    </address>
                    <?php } ?>
                    <p>
                        <span><span class="text-muted"><?php echo _l('quote_data_date'); ?></span> <?php echo $order->date; ?></span>
                        <?php if(!empty($order->expirydate)){ ?>
                       <br /><span class="mtop20"><span class="text-muted"><?php echo _l('quote_data_expiry_date'); ?></span> <?php echo $order->expirydate; ?></span>
                        <?php } ?>
                        <?php if(!empty($order->reference_no)){ ?>
                        <br /><span class="mtop20"><span class="text-muted"><?php echo _l('reference_no'); ?>:</span> <?php echo $order->reference_no; ?></span>
                        <?php } ?>
                        <?php if($order->sale_agent != 0){
                            if(get_option('show_sale_agent_on_orders') == 1){ ?>
                            <br /><span class="mtop20">
                            <span class="text-muted"><?php echo _l('sale_agent_string'); ?>:</span>
                            <?php echo get_staff_full_name($order->sale_agent); ?>
                        </span>
                        <?php }
                    }
                    ?>
                    <?php
                        // check for quote custom fields which is checked show on pdf
                    $pdf_custom_fields = get_custom_fields('order',array('show_on_pdf'=>1));
                    foreach($pdf_custom_fields as $field){
                        $value = get_custom_field_value($order->id,$field['id'],'order');
                        if($value == ''){continue;} ?>
                        <br /><span class="mtop20">
                        <span class="text-muted"><?php echo $field['name']; ?>: </span>
                        <?php echo $value; ?>
                    </span>
                    <?php
                }
                ?>
            </p>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table class="table items">
                <thead>
                    <tr>
                        <th>#</th>
                        <th class="description"><?php echo _l('quote_table_item_heading'); ?></th>
                        <th><?php echo _l('quote_table_quantity_heading'); ?></th>
                        <th><?php echo _l('quote_table_rate_heading'); ?></th>
                        <th><?php echo _l('discount'); ?></th>
                        <th><?php echo _l('quote_table_tax_heading'); ?></th>
                        <th><?php echo _l('quote_table_amount_heading'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($order)){
                        $_tax_tr = '';
                        $taxes = array();
                        $i = 1;
                         $CI =& get_instance();
                        foreach($order->items as $item){
                            $_item = '';
                            $_item .= '<tr>';
                            $_item .= '<td>' .$i. '</td>';
                            $_item .= '<td class="bold description">'.$item['description'].'<br /><span class="text-muted">'.$item['long_description'].'</span></td>';
                            $_item .= '<td>'.floatVal($item['qty']).'</td>';
                            $_item .= '<td>'._format_number($item['rate']).'</td>';
                             $disc = $CI->orders_model->get_discount($item['disc']);
                            $disc = ($disc !== null ? $disc : 0);
                            $_item .= '<td>'.$disc.'%</td>';
                            $taxrate = ($item['taxrate'] !== null ? $item['taxrate'] : 0);
                            $_item .= '<td>'.$taxrate.'%</td>';
                            $_item .= '<td class="amount">'._format_number(($item['qty'] * $item['rate'])).'</td>';
                            $_item .= '</tr>';
                            echo $_item;
                            if($item['taxid']){
                                if(!array_key_exists($item['taxid'],$taxes)) {
                                    if($item['taxrate'] != null){
                                       $discamount = ($disc / 100) * ($item['qty']*$item['rate']);
                                        $calculated_tax = ((($item['qty'] * $item['rate'])-$discamount) / 100 * $item['taxrate']);
                                        $taxes[$item['taxid']] = $calculated_tax;
                                    }
                                } else {
                                   $discamount = ($disc / 100) * ($item['qty']*$item['rate']);
				$taxes[$item['taxid']] += $calculated_tax = ((($item['qty'] * $item['rate'])-$discamount) / 100 * $item['taxrate']);
                                }
                            }
                            $i++;
                        }
                    } ?>
                </tbody>
            </table>
        </div>

        <div class="col-md-6 col-md-offset-6">
            <table class="table text-right">
                <tbody>
                    <tr id="subtotal">
                        <td><span class="bold"><?php echo _l('quote_subtotal'); ?></span>
                        </td>
                        <td class="subtotal">
                            <?php
                            if(isset($quote)){
                                echo _format_number($order->subtotal,$order->symbol);
                            }
                            ?>
                        </td>
                    </tr>
                    <?php if($order->discount_total != 0){ ?>
                    <tr>
                        <td>
                            <span class="bold"><?php echo _l('quote_discount'); ?> (<?php echo get_discount_percent($order->discount_percent); ?>%)</span>
                        </td>
                        <td class="discount">
                            <?php echo '-' . _format_number($order->discount_total); ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php
                    if(isset($order)){
                        foreach($taxes as $taxid => $total){
                            $_tax = get_tax_by_id($taxid);
                            if($order->discount_percent != 0 && $order->discount_type == 'before_tax'){
                                $total_tax_calculated = ($total * get_discount_percent($order->discount_percent)) / 100;
                                $total = ($total - $total_tax_calculated);
                            }
                            echo '<tr class="tax-area"><td>'.$_tax->name.'('._format_number($_tax->taxrate).'%)</td><td>'._format_number($total,$order->symbol).'</td></tr>';
                        }
                    }
                    ?>
                    <?php if($order->adjustment != '0.00'){ ?>
                    <tr>
                        <td>
                            <span class="bold"><?php echo _l('quote_adjustment'); ?></span>
                        </td>
                        <td class="adjustment">
                            <?php echo _format_number($order->adjustment); ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td><span class="bold"><?php echo _l('quote_total'); ?></span>
                        </td>
                        <td class="total">
                            <?php
                            if(isset($order)){
                                echo format_money($order->total,$order->symbol);
                                echo form_hidden('subtotal',$order->total);
                            }
                            ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <?php if(!empty($order->clientnote)){ ?>
        <div class="col-md-12">
            <?php echo _l('order_note'); ?><br /><?php echo $order->clientnote; ?>
        </div>
        <?php } ?>
        <?php if(!empty($order->terms)){ ?>
        <div class="col-md-12">
            <hr />
            <?php echo _l('terms_and_conditions'); ?><br /><?php echo $order->terms; ?>
        </div>
        <?php } ?>
    </div>
</div>
</div>
</div>
