<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
			<?php include_once(APPPATH . 'views/admin/quotes/quotes_top_stats.php'); ?>
			<div class="col-md-5" id="small-table">
				<div class="panel_s">
					<div class="panel-body">
						<?php if(has_permission('manageSales')){ ?>
						<a href="<?php echo admin_url('quotes/quote'); ?>" class="btn btn-info pull-left new"><?php echo _l('create_new_quote'); ?></a>
						<?php } ?>
						<div class="display-block text-right option-buttons">
							<div class="btn-group pull-right mleft4" data-toggle="tooltip" title="<?php echo _l('quotes_list_tooltip'); ?>">
								<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<i class="fa fa-list"></i>
								</button>
								<ul class="dropdown-menu">
									<li>
										<a href="#" onclick="dt_custom_view('','.table-quotes'); return false;">
											<?php echo _l('quotes_list_all'); ?>
										</a>
									</li>
									<li>
										<a href="#" onclick="show_quotes_by_status(1); return false;">
											<?php echo _l('quote_status_draft'); ?> (<?php echo total_rows('tblquotes',array('status'=>0)); ?>)
										</a>
									</li>
									<li>
										<a href="#" onclick="show_quotes_by_status(2); return false;">
											<?php echo _l('quote_status_sent'); ?> (<?php echo total_rows('tblquotes',array('status'=>2)); ?>)
										</a>
									</li>
									<li>
										<a href="#" onclick="show_quotes_by_status(3); return false;">
											<?php echo _l('quote_status_declined'); ?> (<?php echo total_rows('tblquotes',array('status'=>3)); ?>)
										</a>
									</li>
									<li>
										<a href="#" onclick="show_quotes_by_status(4); return false;">
											<?php echo _l('quote_status_accepted'); ?> (<?php echo total_rows('tblquotes',array('status'=>4)); ?>)
										</a>
									</li>
									<li>
										<a href="#" onclick="show_quotes_by_status(5); return false;">
											<?php echo _l('quote_status_expired'); ?> (<?php echo total_rows('tblquotes',array('status'=>5)); ?>)
										</a>
									</li>

								</ul>
							</div>
							<a href="#" class="btn btn-default" onclick="slideToggle('#stats-top'); return false;" data-toggle="tooltip" title="<?php echo _l('view_stats_tooltip'); ?>"><i class="fa fa-bar-chart"></i></a>
							<a href="#" class="btn btn-default" onclick="toggle_small_view('.table-quotes','#quote'); return false;" data-toggle="tooltip" title="<?php echo _l('quotes_toggle_table_tooltip'); ?>"><i class="fa fa-bars"></i></a>
						</div>
					</div>
				</div>
				<div class="panel_s animated fadeIn">
					<div class="panel-body">
						<!-- if quoteid found in url -->
						<?php echo form_hidden('quoteid',$quoteid); ?>
						<?php
						$table_data = array(
							_l('quote_dt_table_heading_number'),
							_l('quote_dt_table_heading_date'),
							_l('reference_no'),
							_l('quote_dt_table_heading_client'),
							_l('quote_dt_table_heading_expirydate'),
							_l('quote_dt_table_heading_amount'),
							_l('quote_dt_table_heading_status'),
							);
						$custom_fields = get_custom_fields('quote',array('show_on_table'=>1));
						foreach($custom_fields as $field){
							array_push($table_data,$field['name']);
						}
						render_datatable($table_data,'quotes'); ?>
					</div>
				</div>
			</div>
			<div class="col-md-7">
				<div id="quote">

				</div>
			</div>
		</div>
	</div>
</div>
<script>var hidden_columns = [2,3,4];</script>
<?php init_tail(); ?>
<script>
	$(document).ready(function(){
		$.each(hidden_columns,function(i,val){
			var column_quotes = $('.table-quotes').DataTable().column( val );
			column_quotes.visible( false );
		});

		init_quote();
		init_quotes_total();
	});
	function init_quotes_total(){
		var currency = $('select[name="quote_total_currency"]').val();
		$.post(admin_url + 'quotes/get_quotes_total',{currency:currency,init_total:true}).success(function(response){
			$('#quotes_total').html(response);
		});
	}
</script>
</body>
</html>


