<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
                <?php echo form_open($this->uri->uri_string(), array('class' => 'client-form')); ?>
                
                <div class="col-md-6">
                    <div class="panel-heading">
                        <?php echo $title; ?>
                    </div>
                </div>

                
                <div class="col-md-6" style="height:40px; text-align: right;" >
                    
                    <input type="button" onclick="window.location.href='<?php echo admin_url('manufacturers/manufacturer')?>'" class="btn btn-primary" value="Cancel"/>

                    <input type="button" onclick="window.location.href='<?php echo admin_url('manufacturers')?>'" class="btn btn-primary" value="Exit"/>

                    <input type="button" onclick="window.location.href='<?php echo admin_url('manufacturers/manufacturer')?>'" class="btn btn-primary" value="New"/>

                    <input type="submit" data-name="save" class="btn btn-primary actionbtn" value="Save"/>

                    <input type="submit" data-name="snew" class="btn btn-primary actionbtn" value="Save & New"/>

                    <input type="submit" data-name="slist" class="btn btn-primary actionbtn" value="Save & List"/>

                    <input type="hidden" name="action" id="action"/>
                             
                </div>
               

                <div class="col-md-12">
                    <div class="panel_s">
                        <div class="panel-body">
                            <?php if (isset($mfr)) { ?>
                                <?php echo form_hidden('isedit'); ?>
                                <?php echo form_hidden('userid', $mfr->mfid); ?>
                            <?php } ?>

                            <div>
                                <!-- Nav tabs -->
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">
                                            <?php echo _l('client_add_edit_profile'); ?></a>
                                    </li>
                                    <?php if (isset($mfr)) { ?>
                                        <li role="presentation"><a href="#product" aria-controls="product" role="tab" data-toggle="tab">
                                                <?php echo _l('manufacturer_product_tab'); ?></a>
                                        </li>
                                        <li role="presentation"><a href="#documents" aria-controls="documents" role="tab" data-toggle="tab">
                                                <?php echo _l('manufacturer_documents_tab'); ?></a>
                                        </li>
                                        <li role="presentation"><a href="#notes" aria-controls="notes" role="tab" data-toggle="tab">
                                                <?php echo _l('manufacturer_notes_tab'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                                <!-- Tab panes -->
                                <div class="tab-content">
                                    <div role="tabpanel" class="tab-pane ptop10 active" id="profile">
                                        <div class="row">
                                            

                                            <div class="col-md-6">

                                                <?php $value = (isset($mfr) ? $mfr->name : ''); ?>
                                                <?php echo render_input('name', 'mf_name', $value);
                                                ?>

                                                <div class="form-group">
                                                    <label for="country" class="control-label">Country</label>
                                                    <select name="country" class="form-control selectpicker" id="country" data-live-search="true">
                                                        <?php
                                                        foreach (get_all_countries() as $country) {
                                                            $selected = '';
                                                            if (isset($mfr)) {
                                                                if ($mfr->country == $country['country_id']) {
                                                                    $selected = 'selected';
                                                                }
                                                            } else {
                                                                if (get_option('invoice_company_country_code') == $country['country_id']) {
                                                                    $selected = 'selected';
                                                                }
                                                            }
                                                            ?>
                                                            <option value="<?php echo $country['country_id']; ?>" <?php echo $selected; ?>><?php echo $country['short_name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label for="address" class="control-label"><?php echo _l('supplier_address'); ?></label>
                                                    <textarea name="address" rows="2" cols="15" class="form-control selectpicker" id="address" data-live-search="true"><?php echo (isset($mfr->address) ? $mfr->address : '' ); ?></textarea>
                                                </div>



                                                <?php $value = (isset($mfr) ? $mfr->city : ''); ?>
                                                <?php echo render_input('city', 'supplier_city', $value); ?>

                                                <?php $value = (isset($mfr) ? $mfr->state : ''); ?>
                                                <?php echo render_input('state', 'supplier_state', $value); ?>

                                                <?php $value = (isset($mfr) ? $mfr->zip : ''); ?>
                                                <?php echo render_input('zip', 'supplier_postal_code', $value); ?>


                                            </div>
                                            <div class="col-md-6">

                                                <?php $value = (isset($mfr) ? $mfr->phonenumber : ''); ?>
                                                <?php echo render_input('phonenumber', 'suppliers_list_phone', $value); ?>

                                                <?php $value = (isset($mfr) ? $mfr->fax : ''); ?>
                                                <?php echo render_input('fax', 'supplier_fax', $value); ?>

                                                <?php $value = (isset($mfr) ? $mfr->website : ''); ?>
                                                <?php echo render_input('website', 'supplier_website', $value); ?>

                                                <?php $value = (isset($mfr) ? $mfr->email : ''); ?>
                                                <?php echo render_input('email', 'supplier_email', $value, 'email'); ?>
                                                <?php $value = (isset($mfr) ? $mfr->email : ''); ?>
                                                 <div class="form-group">
                                                    <label for="active" class="control-label">Status</label>
                                                    <select name="active" class="form-control selectpicker" id="status" data-live-search="true">
                                                  
                                                        <option <?php if(isset($mfr)){ if($mfr->active=='1') echo "selected"; }?> value="1">Active</option>
                                                        <option <?php if(isset($mfr)){ if($mfr->active=='0') echo "selected"; }?> value="0">In Active</option>
                                                    </select>
                                                </div>
                                               <!--  <button type="submit" class="btn btn-primary pull-right mtop20"><?php echo _l('submit'); ?></button> -->

                                            </div><?php echo form_close(); ?>
                                        </div>
                                    </div>
                                    <?php if (isset($mfr)) { ?>
                         
                                        <div role="tabpanel" class="tab-pane ptop10" id="product"><p>Coming Soon...</p></div>
                                        <div role="tabpanel" class="tab-pane ptop10" id="documents"><p>Coming Soon...</p></div>
                                        <div role="tabpanel" class="tab-pane ptop10" id="notes">
                                            <a href="#" class="btn btn-success btn-icon pull-right" onclick="slideToggle('.usernote');
                                                    return false;"><i class="fa fa-plus"></i>
                                            </a>
                                            <div class="clearfix"></div>
                                            <div class="row usernote" style="display:none;">
                                                <div class="col-md-12">
                                                    <?php echo form_open(admin_url('misc/add_manufacturer_note/' . $mfr->mfid . '/0')); ?>
                                                    <?php echo render_textarea('description', 'note_description', '', array('rows' => 5)); ?>
                                                    <button class="btn btn-primary pull-right"><?php echo _l('submit'); ?></button>
                                                    <?php echo form_close(); ?>
                                                </div>
                                            </div>
                                            <?php if (count($user_notes) > 0) { ?>
                                                <table class="table mtop10 animated fadeIn">
                                                    <thead>
                                                        <tr>
                                                            <th><?php echo _l('clients_notes_table_description_heading'); ?></th>
                                                            <th><?php echo _l('clients_notes_table_addedfrom_heading'); ?></th>
                                                            <th><?php echo _l('clients_notes_table_dateadded_heading'); ?></th>
                                                            <th><?php echo _l('options'); ?></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($user_notes as $note) { ?>
                                                            <tr>
                                                                <td><?php echo $note['description']; ?></td>
                                                                <td><?php echo '<a href="' . admin_url('profile/' . $note['addedfrom']) . '">' . $note['firstname'] . ' ' . $note['lastname'] . '</a>' ?></td>
                                                                <td><?php echo _dt($note['dateadded']); ?></td>
                                                                <td><a href="<?php echo admin_url('misc/remove_manufacturer_note/' . $note['usernoteid'] . '/' . $mfr->mfid . '/0'); ?>" class="btn btn-danger btn-icon"><i class="fa fa-remove"></i></a></td>
                                                            </tr>
                                                        <?php } ?>
                                                    </tbody>
                                                </table>
                                            <?php } else { ?>
                                                <p class="no-margin"><?php echo _l('no_user_notes'); ?></p>
                                            <?php } ?>
                                        </div>
                            <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

        </div>
    </div>
</div>

<?php init_tail(); ?>
<!-- Modals for zip -->
<?php
if (isset($mfr)) {

//    include_once(APPPATH . 'views/admin/supplier/modals/zip_payments.php');
//    include_once(APPPATH . 'views/admin/supplier/modals/add_reminder.php');
//    include_once(APPPATH . 'views/admin/supplier/modals/zip_invoices.php');
//    include_once(APPPATH . 'views/admin/supplier/modals/zip_estimates.php');
//    /* contact */
//    include_once(APPPATH . 'views/admin/supplier/modals/zip_contacts.php');
}
?>
<script>



    $(function () {


        $('body').on('click', '.deletecontact ', function (event) {
            event.preventDefault();
            var id = $(this).attr('data-id');
            var url_update = admin_url + "clients/deletecontact";
            $.ajax({
                url: url_update,
                data: {id: id},
                type: 'POST',
                success: function (response)
                {
                    $(".table-contacts-single-supplier").dataTable().fnDestroy();
                    initDataTable('.table-contacts-single-supplier', admin_url + 'suppliers/list_contacts/false/' + $('input[name="userid"]').val(), 'contactstable');

                }
            });
        });


    });

    $(document).ready(function () {


        initDataTable('.table-reminders-single-client', admin_url + 'suppliers/get_client_reminders/' + $('input[name="userid"]').val(), 'reminders', [4], [4]);
        initDataTable('.table-contacts-single-supplier', admin_url + 'suppliers/list_contacts/false/' + $('input[name="userid"]').val(), 'contactstable');

        _validate_form($('.client-form'), {
            name: 'required',
        });

        $('.actionbtn').click(function(){
            $('#action').val($(this).data('name') );
        });

    });


</script>
</body>
</html>
