<?php echo form_hidden('_at_invoice_id',$invoice->id); ?>
<div class="col-md-12 no-padding animated fadeIn">
	<div class="panel_s">
		<div class="panel-body">
			<?php if($invoice->recurring > 0){
				echo '<div class="ribbon warning"><span>'._l('invoice_recurring_indicator').'</span></div>';
			} ?>
			<div class="row">
				<div class="col-md-5">
					<?php echo format_invoice_status($invoice->status,'mtop10'); ?>
					<?php if(isset($estimates_number->number) && $estimates_number->number != ""){ ?>
						<a href="<?php echo admin_url('estimates/list_estimates/'.$estimates_number->id); ?>" class="label label-info  inline-block"><?php echo format_estimate_number($estimates_number->number); ?></a>
					<?php } ?>
					<?php if(isset($order_number) && $order_number != ""){ ?>
					<a href="<?php echo admin_url('orders/list_orders/'.$order_number->id); ?>" class="label label-info  inline-block"><?php echo format_order_number($order_number->number); ?></a>
					<?php } ?>

				</div>
				<div class="col-md-7">
					<div class="pull-right">
                    <?php if(check_access("child-invoices","edit",false)){ ?>
                                                  <div class="btn-group pull-left mright5" data-toggle="tooltip" data-placement="bottom" title="Change Status">
                                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-list"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-left" style="width:200px"><li>
                                    <a href="#" onclick="change_invoice_status(1,<?php echo $invoice->id; ?>); return false;">Unpaid</a>
                                    <a href="#" onclick="change_invoice_status(2,<?php echo $invoice->id; ?>); return false;">Paid</a>
                                    <a href="#" onclick="change_invoice_status(3,<?php echo $invoice->id; ?>); return false;">Partially Paid</a>
                                    <a href="#" onclick="change_invoice_status(4,<?php echo $invoice->id; ?>); return false;">Overdue</a>
                            
                                    </li>
                                </ul>
                                </div> 
                                <?php } ?>
                                 <?php if(check_access("child-invoices","add",false)){ ?>
                                            <a href="<?php echo admin_url('invoices/invoice/?copyid='.$invoice->id); ?>" data-toggle="tooltip" title="<?php echo _l('copy_data_in_new_invoice'); ?>" data-placement="bottom"  class="btn btn-default pull-left mright5"><i class="fa fa-files-o"></i></a>
                                            <?php } ?>
                               <?php if(check_access("child-invoices","edit",false)){ ?>
						<?php if($invoice->sent == 0){ ?>
						<a id="markassent" href="<?php echo admin_url('invoices/mark_as_sent/'.$invoice->id); ?>" class="btn btn-default pull-left mright5"><?php echo _l('invoice_mark_as_sent'); ?></a>
						<?php } 
							   
						
						$_tooltip = _l('invoice_sent_to_email_tooltip');
						if($invoice->sent == 1){
							$_tooltip = _l('invoice_already_send_to_client_tooltip',time_ago($invoice->datesend));
						}
                                                
                                                if($invoice->createstatus !="0"){
						?><a href="<?php echo admin_url('invoices/invoice/'.$invoice->clientid.'/'.$invoice->id); ?>" data-toggle="tooltip" title="<?php echo _l('edit_invoice_tooltip'); ?>" class="btn btn-default pull-left mright5" data-placement="bottom"><i class="fa fa-pencil-square-o"></i></a>
                                                <?php } } ?>
                                               
                                                <a data-hash="<?php echo $invoice->hash ?>" data-id="<?php echo $invoice->id ?>" title="" data-toggle="tooltip" class="btn printonvoice btn btn-default pull-left mright5" href="javascript:void(0)" data-original-title="Print Invoice"><i class="fa fa-print"></i></a>
						<a href="<?php echo admin_url('invoices/pdf/'.$invoice->id); ?>" class="btn btn-default pull-left mright5" target="_blank" data-toggle="tooltip" title="View PDF" data-placement="bottom"><i class="fa fa-file-pdf-o"></i></a>

						<?php if(check_access("child-invoices","edit",false)){ ?>
						<a href="#" class="invoice-send-to-client btn pull-left btn-default mright5" data-toggle="tooltip" title="<?php echo $_tooltip; ?>" data-placement="bottom"><i class="fa fa-envelope"></i></a>
						<?php } ?>
                        <?php if(check_access("child-invoices","edit",false)){ ?>
						<div id="settingsicon" class="btn-toolbar pull-left btn-default mright5" data-toggle="tooltip" title="<?php echo _l('Settings'); ?>" class="btn btn-default pull-left mright5" data-placement="bottom"><i class="fa fa-cog"></i></div>
                       
<a  href="<?php echo admin_url('vouchers/voucher/'.$invoice->vchid); ?>" data-toggle="tooltip" title="View Journal" data-placement="bottom" class="btn btn-default pull-left mright5"><i class="fa fa-newspaper-o"></i></a>  
		<?php if(check_access("child-invoices","edit",false)){ ?>                                              
    <?php if($invoice->status != 2){ ?>
                                                
						<a href="#" onclick="record_payment(<?php echo $invoice->id; ?>); return false;" data-toggle="tooltip" title="Record Payment" data-placement="bottom"  class="btn btn-default pull-left <?php if($invoice->status == 2){echo ' disabled';} ?>"><i class="fa fa-money"></i></a>
                                                    <?php } ?>
                                                      <?php } ?>
                                                        <div id="toolbar-options" class="hidden">
							<a href="<?php echo site_url('viewinvoice/' . $invoice->id . '/' .  $invoice->hash) ?>" target="_blank" data-toggle="tooltip" title="<?php echo _l('view_invoice_as_customer_tooltip'); ?>" data-placement="bottom"><i class="fa fa-eye"></i></a>

							<?php if($invoice->status == 4){ ?>
							<a href="<?php echo admin_url('invoices/send_overdue_notice/'.$invoice->id); ?>" data-toggle="tooltip" title="<?php echo _l('send_overdue_notice_tooltip'); ?>" data-placement="bottom"><i class="fa fa-clock-o"></i></a>
							<?php } ?>

							<a href="#" data-toggle="tooltip" title="<?php echo _l('invoice_view_activity_tooltip'); ?>" data-placement="bottom" class="invoice-activity"><i class="fa fa-list-ul"></i></a>

							<a href="#" data-toggle="modal" data-target="#invoice_attach"><i class="fa fa-paperclip" data-toggle="tooltip" title="<?php echo _l('invoice_attach_file'); ?>" data-placement="bottom"></i></a>

							<?php
							 if(check_access("child-invoices","delete",false)){  
							if((get_option('delete_only_on_last_invoice') == 1 && is_last_invoice($invoice->id)) || (get_option('delete_only_on_last_invoice') == 0)){ ?>

							<a href="<?php echo admin_url('invoices/delete/'.$invoice->id); ?>" data-toggle="tooltip" title="<?php echo _l('delete_invoice_tooltip'); ?>" data-placement="bottom"><i class="fa fa-remove"></i></a>
							<?php
						}
						}
						?>
                         <?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
		<hr />
		<div id="invoice-preview" class="mtop30">
			<div class="col-md-12">
				<div class="row">
					<div class="col-md-6">
						<h4 class="bold"><?php echo format_invoice_number($invoice->number); ?></h4>
						<address>
							<span class="bold"><?php echo get_option('invoice_company_name'); ?></span><br>
							<?php echo nl2br(get_option('invoice_company_address')); ?><br>
							<?php echo get_option('invoice_company_city'); ?>, <?php echo get_option('invoice_company_state'); ?> , <?php echo get_option('invoice_company_postal_code'); ?><br>
							<?php echo get_country_name(get_option('invoice_company_country_code')); ?><br/>
                                                        <?php if(get_option('invoice_company_phonenumber') != ''){ ?>
							<abbr title="Phone">P:</abbr> <?php echo get_option('invoice_company_phonenumber'); ?>
							<?php } ?>
							<?php
							// check for company custom fields
							$custom_company_fields = get_company_custom_fields();
							foreach($custom_company_fields as $field){
								echo $field['label'] . ':' . $field['value'] . '<br />';
							}
							?>
						</address>

					</div>

					<div class="col-sm-6 text-right">
						<span><?php echo _l('invoice_bill_to'); ?>:</span>
						<address>
							<span class="bold"><?php echo $invoice->client->accountname; ?></span><br>
							<?php echo nl2br($invoice->client->address); ?><br>
							<?php echo $invoice->client->city; ?>, <?php echo $invoice->client->state; ?> , <?php echo $invoice->client->zip; ?><br>
                                                        <?php echo get_country_name($invoice->client->country); ?><br/>
                                                          <?php if($invoice->client->phonenumber != ''){ ?>
							<abbr title="Phone">P:</abbr> <?php echo $invoice->client->phonenumber; ?><br/>
							<?php } ?>
							<?php if(!empty($invoice->client->vat)){ ?>
							<?php echo _l('invoice_vat'); ?>: <?php echo $invoice->client->vat; ?><br />
							<?php } ?>
							<?php
								// check for customer custom fields which is checked show on pdf
							$pdf_custom_fields = get_custom_fields('customers',array('show_on_pdf'=>1));
							foreach($pdf_custom_fields as $field){
								$value = get_custom_field_value($invoice->clientid,$field['id'],'customers');
								if($value == ''){continue;}
								echo $field['name'] . ': ' . $value . '<br />';
							}
							?>
						</address>
						<p>
							<span><span class="text-muted"><?php echo _l('invoice_data_date'); ?></span> <?php echo $invoice->date; ?></span><br>
							<?php if(!empty($invoice->duedate)){ ?>
							<span class="mtop20"><span class="text-muted"><?php echo _l('invoice_data_duedate'); ?></span> <?php echo $invoice->duedate; ?></span>
							<?php } ?>
							<?php if($invoice->sale_agent != 0){
								if(get_option('show_sale_agent_on_invoices') == 1){ ?>
								<br /><span class="mtop20">
								<span class="text-muted"><?php echo _l('sale_agent_string'); ?>: </span>
								<?php echo get_staff_full_name($invoice->sale_agent); ?>
							</span>
							<?php }
						}
						?>
						<?php
						// check for invoice custom fields which is checked show on pdf
						$pdf_custom_fields = get_custom_fields('invoice',array('show_on_pdf'=>1));
						foreach($pdf_custom_fields as $field){
							$value = get_custom_field_value($invoice->id,$field['id'],'invoice');
							if($value == ''){continue;} ?>
							<br /><span class="mtop20">
							<span class="text-muted"><?php echo $field['name']; ?>: </span>
							<?php echo $value; ?>
						</span>
						<?php
					}
					?>
				</p>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="table-responsive">
					<table class="table items">
						<thead>
							<tr>
								<th>#</th>
								<th class="description">SKU</th>
								<th class="description"><?php echo _l('invoice_table_item_description'); ?></th>
								<th><?php echo _l('invoice_table_quantity_heading'); ?></th>
								<th><?php echo _l('invoice_table_rate_heading'); ?></th>
								<th><?php echo _l('discount'); ?></th>
								<th><?php echo _l('invoice_table_tax_heading'); ?></th>
								<th><?php echo _l('invoice_table_amount_heading'); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php 
                                                        
                                                 
                                                        if(isset($invoice)){
								$_tax_tr = '';
								$taxes = array();
								$i = 1;
                                                                    $CI =& get_instance();
                       
								foreach($invoice->items as $item){
                                                                  
									$_item = '';
									$_item .= '<tr>';
									$_item .= '<td>' .$i. '</td>';
									$_item .= '<td>' .$item['sku']. '</td>';
									$_item .= '<td class="bold description">'.$item['description'].'<span class="text-muted">'.$item['long_description'].'</span></td>';
									$_item .= '<td>'.$item['qty'].'</td>';
									$_item .= '<td>'._format_number($item['rate']).'</td>';
									$taxrate = ($item['taxrate'] !== null ? $item['taxrate'] : 0);
                                                                         $disc = $CI->invoices_model->get_discount($item['disc']);
									$disc = ($disc !== null ? $disc : 0);
                                                                      	$_item .= '<td>'.$disc.'%</td>';
									$_item .= '<td>'.$taxrate.'%</td>';
									$_item .= '<td class="amount">'._format_number(($item['qty'] * $item['rate'])).'</td>';
									$_item .= '</tr>';
									echo $_item;
									if($item['taxid']){
										if(!array_key_exists($item['taxid'],$taxes)) {
											if($item['taxrate'] != null){
                                                                                           
                                                                                              $discamount = ($disc / 100) * ($item['qty']*$item['rate']);
												$calculated_tax = ((($item['qty'] * $item['rate'])-$discamount) / 100 * $item['taxrate']);
												$taxes[$item['taxid']] = $calculated_tax;
											}
										} else {
                                                                                     $discamount = ($disc / 100) * ($item['qty']*$item['rate']);
											$taxes[$item['taxid']] += $calculated_tax = ((($item['qty'] * $item['rate'])-$discamount) / 100 * $item['taxrate']);
										}
									}
									$i++;
								}
							} ?>
						</tbody>
					</table>
				</div>
			</div>
			<div class="col-md-4 col-md-offset-8">
				<table class="table text-right">
					<tbody>
						<tr id="subtotal">
							<td><span class="bold"><?php echo _l('invoice_subtotal'); ?></span>
							</td>
							<td class="subtotal">
								<?php
								if(isset($invoice)){
									echo _format_number($invoice->subtotal,$invoice->symbol);
									echo form_hidden('subtotal',$invoice->subtotal);
								}
								?>
							</td>
						</tr>
						<?php if($invoice->discount_total != 0){ 
                                                    
                                 
                                                    ?>
						<tr>
							<td>
								<span class="bold"><?php echo _l('invoice_discount'); ?> (<?php echo get_discount_percent($invoice->discount_percent); ?>%)</span>
							</td>
							<td class="discount">
								<?php echo '-' . _format_number($invoice->discount_total); ?>
							</td>
						</tr>
						<?php } ?>
						<?php
                                        
						if(isset($invoice)){
							foreach($taxes as $taxid => $total){
								$_tax = get_tax_by_id($taxid);
								if($invoice->discount_type == 'before_tax'){
									$total_tax_calculated = ($total * $invoice->discount_percent) / 100;
									$total = ($total - $total_tax_calculated);
								}
								echo '<tr class="tax-area"><td>'.$_tax->name.'('.$_tax->taxrate.'%)</td><td>'._format_number($total,$invoice->symbol).'</td></tr>';
							}
						}
						?>
						<?php if($invoice->adjustment != '0.00'){ ?>
						<tr>
							<td>
								<span class="bold"><?php echo _l('invoice_adjustment'); ?></span>
							</td>
							<td class="adjustment">
								<?php echo _format_number($invoice->adjustment); ?>
							</td>
						</tr>
						<?php } ?>
						<tr>
							<td><span class="bold"><?php echo _l('invoice_total'); ?></span>
							</td>
							<td class="total">
								<?php
								if(isset($invoice)){
									echo format_money($invoice->total,$invoice->symbol);
									echo form_hidden('subtotal',$invoice->total);
								}
								?>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
		<?php if(count($attachments) > 0){ ?>
		<?php foreach($attachments as $attachment){ ?>
		<div class="invoice-attachment-wrapper row mbot15">
			<div class="col-md-8">
				<div class="pull-left"><i class="<?php echo get_mime_class($attachment['filetype']); ?>"></i></div>
				<a href="<?php echo site_url('download/file/invoice_attachment/'.$attachment['id']); ?>"><?php echo $attachment['original_file_name']; ?></a>
				<br />
				<small class="text-muted"> <?php echo $attachment['filetype']; ?></small>
			</div>
			<div class="col-md-4 text-right">
				<a href="#" class="text-danger" onclick="delete_invoice_attachment(this,<?php echo $attachment['id']; ?>); return false;"><i class="fa fa-trash-o"></i></a>
			</div>
		</div>
		<?php } ?>
		<?php } ?>
		<hr />
		<?php if($invoice->clientnote != ''){ ?>
		<div class="col-md-12 row mtop15">
			<p class="bold text-muted"><?php echo _l('invoice_note'); ?></p>
			<p><?php echo $invoice->clientnote; ?></p>
		</div>
		<?php } ?>
		<?php if($invoice->terms != ''){ ?>
		<div class="col-md-12 row mtop15">
			<p class="bold text-muted"><?php echo _l('terms_and_conditions'); ?></p>
			<p><?php echo $invoice->terms; ?></p>
		</div>
		<?php } ?>
		<div class="col-md-12 no-padding animated fadeIn">
			<?php
			$total_payments = count($invoice->payments);
			if($total_payments > 0){ ?>
			<h4 class="bold"><?php echo _l('invoice_received_payments'); ?></h4>
			<div class="row col-md-12">
				<?php include_once(APPPATH . 'views/admin/invoices/invoice_payments_table.php'); ?>
			</div>
			<?php } else { ?>
			<h5 class="bold mtop15 pull-left text-center"><?php echo _l('invoice_no_payments_found'); ?></h5>
			<?php } ?>
		</div>
	</div>
</div>
</div>
</div>
</div>

<script>
	init_btn_toolbar();
        
           function change_invoice_status(status,id) {
        $.get(admin_url + 'invoices/change_invoice_status/' + status+'/'+id, function(response) {
         document.location.href=admin_url+"invoices/list_invoices/"+id;
     }, 'json');
   }

</script>
<?php $this->load->view('admin/invoices/invoice_activity_log'); ?>
<?php $this->load->view('admin/invoices/invoice_send_to_client'); ?>
