<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php include_once(APPPATH . 'views/admin/includes/alerts.php'); ?>
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-heading">
                        <?php echo $title; ?>
                    </div>
                    <?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'bankaccounts-form', 'id' => 'submitbankaccounts')); ?>
                    <div class="panel-body">
                        <div class="col-md-5"  align="center"></div>
                        <div class="col-md-7" style="height:40px; text-align:right; padding:0px 6px;" >
                            <input type="submit" onclick="location.reload()" class="btn btn-primary actionbtn" value="Cancel"/>
                            <input type="button" onclick="window.location.href = '<?php echo admin_url('banksaccounts') ?>'" class="btn btn-primary" value="Exit"/>
                            <input type="button" onclick="window.location.href = '<?php echo admin_url('banksaccounts/bankaccount') ?>'" class="btn btn-primary" value="New"/>
                            <input type="submit" data-name="save" class="btn btn-primary actionbtn" value="Save"/>
                            <input type="submit" data-name="snew" class="btn btn-primary actionbtn" value="Save & New"/>
                            <input type="submit" data-name="slist" class="btn btn-primary actionbtn" value="Save & List"/>
                            <input type="hidden" name="action" id="action"/>
                        </div>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane ptop10 active" id="profile">
                                <div class="row">

                                    <?php
                                    $value = (isset($baksaccount) ? $baksaccount->id : '');
                                    ?>
                                    <input type="hidden" name="id" value="<?php echo $value; ?>" id="id" />
                                    <div class="col-md-6">

                                        <div class="form-group">
                                            <label for="bank" class="control-label"><?php echo _l('bbank'); ?></label>
                                            <select name="bank" class="form-control selectpicker" id="bank" data-live-search="true">
                                                <option value=""></option>
                                                <?php
                                                foreach ($banks as $val) {
                                                    $selected = '';
                                                    if ($baksaccount):
                                                        if ($val->bankid == $baksaccount->bank):
                                                            $selected = "selected=selected";
                                                        endif;
                                                    endif;
                                                    ?>                                                        
                                                    <option value="<?php echo $val->bankid; ?>" <?php echo $selected; ?>><?php echo $val->bank; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
               
                                        <div class="form-group">
                                            <label for="branch" class="control-label"><?php echo _l('Branch'); ?></label>
                                            <select name="branch" class="form-control selectpicker" id="branch" data-live-search="true">
                                                <option value=""></option>
                                                <?php
                                                foreach ($branches as $value) {
                                                    $selected = '';
                                                    if ($baksaccount):
                                                        if ($value->bankbranchid == $baksaccount->branch):
                                                            $selected = "selected=selected";
                                                        endif;
                                                    endif;
                                                    ?>                                                        
                                                    <option value="<?php echo $value->bankbranchid; ?>" <?php echo $selected; ?>><?php echo $value->branchname; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                            <?php $value = (isset($baksaccount->account_number) ? $baksaccount->account_number : ''); ?>
                                        <?php echo render_input('account_number', 'Account Number', $value); ?>
                                        <div class="form-group">
                                            <label for="account_type" class="control-label"><?php echo _l('account_type'); ?></label>
                                            <select name="account_type" class="form-control selectpicker" id="account_type" data-live-search="true">
                                                <option value=""></option>
                                                <option <?php echo ($baksaccount->account_type == "Checking Account") ? "selected=selected" : ''; ?> value="Checking Account">Checking Account</option>
                                                <option <?php echo ($baksaccount->account_type == "Current Account") ? "selected=selected" : ''; ?>  value="Current Account">Current Account</option>
                                                <option  <?php echo ($baksaccount->account_type == "Saving Account") ? "selected=selected" : ''; ?> value="Saving Account">Saving Account</option>


                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="ledger" class="control-label"><?php echo _l('Ledger'); ?></label>
                                            <select name="ledger" class="form-control selectpicker" id="ledger" data-live-search="true">
                                                <option value=""></option>
                                                <?php
                                                foreach ($ledgers as $led) {
                                                    $selected = '';
                                                    if ($baksaccount):
                                                        if ($led->id == $baksaccount->ledger):
                                                            $selected = "selected=selected";
                                                        endif;
                                                    endif;
                                                    ?>                                                        
                                                    <option value="<?php echo $led->id; ?>" <?php echo $selected; ?>><?php echo $led->name; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="description" class="control-label"><?php echo _l('description'); ?></label>
                                            <textarea name="description" rows="2" cols="15" class="form-control selectpicker" id="description" data-live-search="true"><?php echo (isset($baksaccount->description) ? $baksaccount->description : '' ); ?></textarea>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <?php
                                        $str = explode('|', get_option("dateformat"));
                                        $value = (isset($baksaccount) ? _d($baksaccount->dateOpened) : date($str[0]));
                                        ?>
                                        <?php echo render_date_input('dateOpened', 'Date Opened', $value); ?>
                                        <?php
                                        foreach ($currencies as $currency) {
                                            if (isset($baksaccount)) {
                                                if ($currency['id'] == $baksaccount->currency) {
                                                    $selected = $currency['id'];
                                                }
                                            } else {
                                                if ($currency['isdefault'] == 1) {
                                                    $selected = $currency['id'];
                                                }
                                            }
                                        }
                                        ?>
                                        <?php echo render_select('currency', $currencies, array('id', 'symbol', 'name'), 'estimate_add_edit_currency', $selected); ?>

                                        <?php $value = (isset($baksaccount->balance) ? $baksaccount->balance : ''); ?>
                                        <?php echo render_input('balance', 'Balance', $value); ?>
                                        <?php $value = (isset($baksaccount->overdraft) ? $baksaccount->overdraft : ''); ?>
                                        <?php echo render_input('overdraft', 'Overdraft', $value); ?>
                                        <?php $value = (isset($baksaccount->available) ? $baksaccount->available : ''); ?>
<?php echo render_input('available', 'Available', $value,'',array('readonly'=>'readonly')); ?>



                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>

                </div>
            </div>
<?php echo form_close(); ?>
        </div>
    </div>
</div>

<?php init_tail(); ?>
<?php
if (isset($baksaccount)) {
    //include_once(APPPATH . 'views/admin/warehouse/modals/add_reminder.php');
    /* contact */
    //include_once(APPPATH . 'views/admin/clients/modals/zip_contacts.php');
}
?>
<script>

    $(document).ready(function () {

        _validate_form($('#submitbankaccounts'), {
            bank: 'required',
            branch: 'required',
            account_number: 'required',
            account_type: 'required',
            dateOpened: 'required',
            ledger: 'required',
            balance: 'required'
        });

    });

  $('.actionbtn').click(function(){
    $('#action').val($(this).data('name') );
  });

$('#bank').change(function() {
    $.ajax({
        url: admin_url + '/banksaccounts/get_branches',
        data: {id: $(this).val()},
        type: 'POST',
        dataType: 'json',
        success: function(response)
        {
            $('#branch').html(response.options);
            $('#branch').selectpicker('refresh');
        }
    });
    });
    
   $('#balance,#overdraft').change(function(){
       if($('#balance').val() && !$('#overdraft').val()){
        $('#available').val(parseFloat($('#balance').val())); 
       }else{
            $('#available').val((parseFloat($('#balance').val())+ parseFloat($('#overdraft').val())));
       }
   });


</script>
</body>
</html>
