<?php

ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Vouchers_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get estimate by id
     * @param  mixed $id
     * @return array
     */
    public function get_voucher_list($bill_id)
    {
        $this->db->select('*');
        $this->db->from('tblvoucher');

        if($bill_id != "")
        {
            $this->db->like('voucher', 'BL');
            $this->db->where('invoiceid',$bill_id);
        }
        $query = $this->db->get()->result();
        return $query;

        // echo "<pre>";
        // print_r($query);
        // die;
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            // if(($gr->type =="Group")||($gr->exists))
            // {

            //     $ta->exists=true;
            //     break;
                
            // }
            // if(($ta->type !="Group")||($ta->exists))
            // {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            // }
            
            
        }
        
        return $subgoups;
    }




    public function get_types() {
        $this->db->order_by('name', 'asc');
        return $this->db->get('tblvouchertypes')->result();
    }

    public function get_ledgers() {
        $this->db->where('type', 'Ledger');
        $this->db->order_by('name', 'asc');
        return $this->db->get('tblledgergroups')->result();
    }

    public function get($id = '') {
        $this->db->select('*,tblcurrencies.id as currencyid, tblvoucher.vchid as id, tblcurrencies.name as currency_name');
        $this->db->from('tblvoucher');
        $this->db->join('tblcurrencies', 'tblcurrencies.id = tblvoucher.currency', 'left');

        if (is_numeric($id)) {
            $this->db->where('vchid', $id);
            $voucher = $this->db->get()->row();

            if ($voucher) {
                $voucher->items = $this->get_voucher_items($id);
            }
            return $voucher;
        }

        $this->db->get()->result_array();
    }

    public function get_voucher($id = '') {
        $this->db->from('tblvouchertypes');
        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $voucher = $this->db->get()->row();

            return $voucher;
        }

        $this->db->get()->result_array();
    }

    public function get_items($id) {
        return $this->get_voucher_items($id);
    }

    /**
     * Convert estimate to invoice
     * @param  mixed $id estimate id
     * @return mixed     New invoice ID
     */
    public function convert_to_invoice($id, $client = false) {
        // Recurring invoice date is okey lets convert it to new invoice
        $_estimate = $this->get($id);

        $new_invoice_data = array();
        $new_invoice_data['clientid'] = $_estimate->clientid;
        $new_invoice_data['_number'] = get_option('next_invoice_number');
        $new_invoice_data['date'] = _d(date('Y-m-d'));
        $new_invoice_data['duedate'] = _d(date('Y-m-d'));

        if ($_estimate->expirydate < date('Y-m-d')) {
            $new_invoice_data['duedate'] = _d($_estimate->expirydate);
        }

        $new_invoice_data['currency'] = $_estimate->currency;
        $new_invoice_data['subtotal'] = $_estimate->subtotal;
        $new_invoice_data['total'] = $_estimate->total;
        $new_invoice_data['adjustment'] = $_estimate->adjustment;
        $new_invoice_data['discount_percent'] = $_estimate->discount_percent;
        $new_invoice_data['discount_total'] = $_estimate->discount_total;
        $new_invoice_data['discount_type'] = $_estimate->discount_type;
        $new_invoice_data['sale_agent'] = $_estimate->sale_agent;

        $new_invoice_data['terms'] = get_option('predefined_terms_invoice');
        $new_invoice_data['clientnote'] = get_option('predefined_clientnote_invoice');

        // Set to unpaid status automatically
        $new_invoice_data['status'] = 1;
        $new_invoice_data['clientnote'] = '';
        $new_invoice_data['adminnote'] = 'Converted from estimate #' . format_estimate_number($_estimate->number);
        $this->load->model('payment_modes_model');

        $modes = $this->payment_modes_model->get();
        $temp_modes = array();

        foreach ($modes as $mode) {
            $temp_modes[] = $mode['id'];
        }

        $new_invoice_data['allowed_payment_modes'] = $temp_modes;
        $new_invoice_data['newitems'] = array();

        $key = 1;
        foreach ($_estimate->items as $item) {
            $new_invoice_data['newitems'][$key]['description'] = $item['description'];
            $new_invoice_data['newitems'][$key]['long_description'] = $item['long_description'];
            $new_invoice_data['newitems'][$key]['qty'] = $item['qty'];
            $new_invoice_data['newitems'][$key]['taxid'] = $item['taxid'];
            $new_invoice_data['newitems'][$key]['rate'] = $item['rate'];
            $new_invoice_data['newitems'][$key]['order'] = $item['item_order'];
            $key++;
        }

        $this->load->model('invoices_model');
        $id = $this->invoices_model->add($new_invoice_data);

        if ($id) {
            // Update estimate with the new invoice data and set to status accepted
            $this->db->where('id', $_estimate->id);
            $this->db->update('tblestimates', array(
                'invoiced_date' => date('Y-m-d H:i:s'),
                'invoiceid' => $id,
                'status' => 4
            ));
            if ($client == false) {
                $this->log_estimate_activity($_estimate->id, 'converted this estimate to invoice.<br /><a href="' . admin_url('invoices/list_invoices/' . $id) . '">' . format_invoice_number($new_invoice_data['_number']) . '</a>');
            }
        }

        return $id;
    }

    function change_quote_status($status, $id) {
        $this->db->where('id', $id);
        return $this->db->update('tblestimates', array('status' => $status));
    }

    /**
     * Convert estimate to order
     * @param  mixed $id estimate id
     * @return mixed     New order ID
     */
    public function convert_to_order($id, $client = false) {
        // Recurring invoice date is okey lets convert it to new invoice
        $_estimate = $this->get($id);

        $new_order_data = array();
        $new_order_data['clientid'] = $_estimate->clientid;
        $new_order_data['_number'] = get_option('next_order_number');
        $new_order_data['date'] = _d(date('Y-m-d'));
        $new_order_data['expirydate'] = _d(date('Y-m-d'));

        if ($_estimate->expirydate < date('Y-m-d')) {
            $new_order_data['expirydate'] = _d($_estimate->expirydate);
        }

        $new_order_data['currency'] = $_estimate->currency;
        $new_order_data['subtotal'] = $_estimate->subtotal;
        $new_order_data['total'] = $_estimate->total;
        $new_order_data['adjustment'] = $_estimate->adjustment;
        $new_order_data['discount_percent'] = $_estimate->discount_percent;
        $new_order_data['discount_total'] = $_estimate->discount_total;
        $new_order_data['discount_type'] = $_estimate->discount_type;
        $new_order_data['sale_agent'] = $_estimate->sale_agent;

        $new_order_data['terms'] = get_option('predefined_terms_order');
        $new_order_data['clientnote'] = get_option('predefined_clientnote_order');

        // Set to unpaid status automatically
        $new_order_data['status'] = 1;
        $new_order_data['clientnote'] = '';
        $new_order_data['adminnote'] = 'Converted from estimate #' . format_estimate_number($_estimate->number);
        $this->load->model('payment_modes_model');

//        $modes      = $this->payment_modes_model->get();
//        $temp_modes = array();
//
//        foreach ($modes as $mode) {
//            $temp_modes[] = $mode['id'];
//        }
//
//        $new_order_data['allowed_payment_modes'] = $temp_modes;
        $new_order_data['newitems'] = array();

        $key = 1;
        foreach ($_estimate->items as $item) {
            $new_order_data['newitems'][$key]['sku'] = $item['sku'];
            $new_order_data['newitems'][$key]['description'] = $item['description'];
            $new_order_data['newitems'][$key]['long_description'] = $item['long_description'];
            $new_order_data['newitems'][$key]['qty'] = $item['qty'];
            $new_order_data['newitems'][$key]['taxid'] = $item['taxid'];
            $new_order_data['newitems'][$key]['rate'] = $item['rate'];
            $new_order_data['newitems'][$key]['order'] = $item['item_order'];
            $key++;
        }

        $this->load->model('orders_model');
        $id = $this->orders_model->add($new_order_data);

        if ($id) {
            // Update estimate with the new invoice data and set to status accepted
            $this->db->where('id', $_estimate->id);
            $this->db->update('tblestimates', array(
                'order_date' => date('Y-m-d H:i:s'),
                'orderid' => $id,
//                'status' => 1
            ));
            if ($client == false) {
                $this->log_estimate_activity($_estimate->id, 'converted this estimate to invoice.<br /><a href="' . admin_url('invoices/list_invoices/' . $id) . '">' . format_invoice_number($new_invoice_data['_number']) . '</a>');
            }
        }

        return $id;
    }

    public function get_estimates_total($data) {

        $statuses = array(
            1,
            2,
            3,
            4,
            5
        );
        $this->load->model('currencies_model');

        if ((is_using_multiple_currencies('tblestimates') && !isset($data['currency'])) || !isset($data['currency'])) {
            $currencyid = $this->currencies_model->get_base_currency()->id;
        } else if (isset($data['currency'])) {
            $currencyid = $data['currency'];
        }

        $symbol = $this->currencies_model->get_currency_symbol($currencyid);
        $sql = 'SELECT';
        foreach ($statuses as $estimate_status) {
            $sql .= '(SELECT SUM(total) FROM tblestimates WHERE status=' . $estimate_status;
            $sql .= ' AND currency =' . $currencyid;
            $sql .= ') as "' . $estimate_status . '",';
        }

        $sql = substr($sql, 0, -1);
        $result = $this->db->query($sql)->result_array();
        $_result = array();
        $i = 0;
        foreach ($result as $key => $val) {
            foreach ($val as $total) {
                $_result[$i]['total'] = $total;
                $_result[$i]['symbol'] = $symbol;
                $i++;
            }
        }

        return $_result;
    }

    /**
     * Get all estimate items
     * @param  mixed $id estimateid
     * @return array
     */
    public function get_voucher_items($id) {

        $this->load->model('settings_model');
        $default_options = $this->settings_model->getOptions();

        $this->db->select('*');
        $this->db->from('tblvoucherlines');
        $this->db->where('tblvoucherlines.vchid', $id);
        // $this->db->where('tblvoucherlines.ledger !=', $default_options['customer_discounts_ledger']);
        // $this->db->where('tblvoucherlines.ledger !=', $default_options['account_receivable']);
        $this->db->where('tblvoucherlines.ledger !=', $default_options['cost_of_goods_sold']);
        $this->db->where('tblvoucherlines.ledger !=', $default_options['inventory_ledger']);
        $this->db->order_by('item_order', 'asc');
        return $this->db->get()->result_array();
    }

    /**
     * Insert new estimate to database
     * @param array $data invoiec data
     * @return mixed - false if not insert, estimate ID if succes
     */
    public function add($data) {

        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        $unsetters = array(
            'ledger',
            'amount',
	    'amount_type',
            'description',
            'refrence',
            'invoiceid',
            'poid',
        );

        foreach ($unsetters as $unseter) {
            if (isset($data[$unseter])) {
                unset($data[$unseter]);
            }
        }



        $data['docdate'] = to_sql_date($data['docdate']);
        if (!empty($data['trxdate'])) {
            $data['trxdate'] = to_sql_date($data['trxdate']);
        } else {
            unset($data['trxdate']);
        }


        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['posteddate'] = date('Y-m-d H:i:s');
        $data['created_by'] = get_staff_user_id();


        $items = array();
        if (isset($data['newitems'])) {
            $items = $data['newitems'];
            unset($data['newitems']);
        }

        $_data = do_action('before_voucher_added', array(
            'data' => $data,
            'items' => $items
        ));

        $data = $_data['data'];
        $items = $_data['items'];


        $this->db->select_max('voucher');
        $this->db->where('vchtype', $this->input->post('vchtype'));
        $voucher = $this->db->get('tblvoucher')->row()->voucher;
        if ($voucher) {
            $voucher = ++$voucher;
        } else {
            $voucher = $data['code'] . '0001';
        }
        unset($data['code']);
        $data['voucher'] = $voucher;

        $this->db->insert('tblvoucher', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {


            if (count($items) > 0) {
                foreach ($items as $key => $item) {
                    $this->db->insert('tblvoucherlines', array(
                        'ledger' => $item['ledger'],
                        'vchid' => $insert_id,
                        'amount' => str_replace(array(','), '', $item['amount']),
			  'amount_type' =>  $item['amount_type'],
                        'description' => $item['description'],
                        'refrence' => $item['refrence'],
                        'invoiceid' => $item['invoiceid'],
                        'poid' => $item['poid'],
                        'item_order' => $item['order'],
                    ));
                }
            }

            // $this->log_estimate_activity($insert_id, 'created the estimate');
            do_action('after_voucher_added', $insert_id);
            return $insert_id;
        }

        return false;
    }

    public function add_vouchertype($data) {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        $led = $data['ledgers'];
        unset($data['ledgers']);
        $_data = do_action('before_vouchertype_added', $data);

        
            $this->db->insert('tblvouchertypes', $_data);
            $insert_id = $this->db->insert_id();
if ($insert_id) {
            foreach ($led as $value) {
                $leddata = array('vouchertype_id' => $insert_id, 'ledgerorgroupid' => $value);
                $this->db->insert('tblallowedledgers', $leddata);
            }
            return $insert_id;
        } else {
            return false;
        }
    }

    public function update_vouchertype($data,$id) {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
        $led = $data['ledgers'];
        unset($data['ledgers']);

        $_data = do_action('before_vouchertype_update', $data);
        $this->db->where('id', $id);
        $this->db->update('tblvouchertypes', $_data);
      
        $this->db->where('vouchertype_id', $id);
        $this->db->delete('tblallowedledgers');

        foreach ($led as $value) {
            $leddata = array('vouchertype_id' => $id, 'ledgerorgroupid' => $value);
            $this->db->insert('tblallowedledgers', $leddata);
        }

        return true;
    }

    public function get_voucher_item($id) {
        $this->db->where('id', $id);
        return $this->db->get('tblvoucherlines')->row();
    }

    public function get_term($id) {
        $this->db->select('payment_term');
        $this->db->where('userid', $id);
        return $this->db->get('tblclients')->row();
    }

    /**
     * Update estimate data
     * @param  array $data estimate data
     * @param  mixed $id   estimateid
     * @return boolean
     */
    public function update($data, $id) {
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        $affectedRows = 0;

        $original_estimate = $this->get($id);
        $original_status = $original_estimate->status;
        $original_number = $original_estimate->number;

        unset($data['ledger']);
        unset($data['amount']);
	unset($data['amount_type']);
        unset($data['description']);
        unset($data['refrence']);
        unset($data['isedit']);
        unset($data['invoiceid']);
        unset($data['poid']);


        $items = array();
        if (isset($data['items'])) {
            $items = $data['items'];
            unset($data['items']);
        }

        $newitems = array();
        if (isset($data['newitems'])) {
            $newitems = $data['newitems'];
            unset($data['newitems']);
        }

        if ($data['adjustment'] == 'NaN') {
            $data['adjustment'] = 0;
        }

        $data['terms'] = nl2br($data['terms']);
        $data['docdate'] = to_sql_date($data['docdate']);
        $data['trxdate'] = to_sql_date($data['trxdate']);





        $action_data = array(
            'data' => $data,
            'newitems' => $newitems,
            'items' => $items,
            'id' => $id,
            'removed_items' => array()
        );

        if (isset($data['removed_items'])) {
            $action_data['removed_items'] = $data['removed_items'];
        }

        $_data = do_action('before_voucher_updated', $action_data);
        $data['removed_items'] = $_data['removed_items'];
        $newitems = $_data['newitems'];
        $items = $_data['items'];
        $data = $_data['data'];

        // Delete items checked to be removed from database
        if (isset($data['removed_items'])) {
            foreach ($data['removed_items'] as $remove_item_id) {
                foreach ($data['removed_items'] as $remove_item_id) {
                    $original_item = $this->get_voucher_item($remove_item_id);
                    $this->db->where('vchid', $id);
                    $this->db->where('id', $remove_item_id);
                    $this->db->delete('tblvoucherlines');
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
                }
            }
            unset($data['removed_items']);
        }
		unset($data['code']);
		unset($data['terms']);
        $this->db->where('vchid', $id);
        $this->db->update('tblvoucher', $data);
        $this->load->model('taxes_model');

        if (count($items) > 0) {
            $i = 0;
            foreach ($items as $key => $item) {
                $voucher_item_id = $item['itemid'];

                $original_item = $this->get_voucher_item($voucher_item_id);

                $this->db->where('vchid', $voucher_item_id);
                $this->db->update('tblvoucherlines', array(
                    'ledger' => $item['ledger'],
			
                    'amount' => str_replace(array(','), '', $item['amount']),
		     'amount_type' =>  $item['amount_type'],
                    'description' => $item['description'],
                    'refrence' => $item['refrence'],
                    'invoiceid' => $item['invoiceid'],
                    'poid' => $item['poid'],
                    'item_order' => $item['order'],
                ));
            }
        }

        if (count($newitems) > 0) {
            foreach ($newitems as $key => $item) {
                $this->db->insert('tblvoucherlines', array(
                    'ledger' => $item['ledger'],
                    'vchid' => $id,
                    'amount' => str_replace(array(','), '', $item['amount']),
		      'amount_type' =>  $item['amount_type'],
                    'description' => $item['description'],
                    'refrence' => $item['refrence'],
                    'poid' => $item['poid'],
                    'item_order' => $item['order'],
                ));

                $new_item_added = $this->db->insert_id();
            }
        }

        if ($affectedRows > 0) {
            do_action('after_voucher_updated', $id);
            return true;
        }

        return false;
    }

    public function client_estimate_action($action, $id) {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {
            $this->load->model('staff_model');
            $staff = $this->staff_model->get('', 1);
            $estimate = $this->get($id);
            $invoiceid = false;
            $invoiced = false;
            if ($action == 4) {
                if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                    $invoiceid = $this->convert_to_invoice($id, true);
                    $this->load->model('invoices_model');
                    if ($invoiceid) {
                        $invoiced = true;
                        $invoice = $this->invoices_model->get($invoiceid);
                        $this->log_estimate_activity($id, 'Client accepted this estimate. Estimate is converted to invoice with number <a href="' . admin_url('invoices/list_invoices/' . $invoiceid) . '">' . format_invoice_number($invoice->number) . '</a>', false, true);
                    }
                } else {
                    $this->log_estimate_activity($id, 'Client accepted this estimate.', false, true);
                }

                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffid'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Congratiolations! Client accepted estimate with number ' . format_estimate_number($estimate->number),
                            'link' => 'estimates/list_estimates/' . $id
                        ));
                    }
                }

                return array(
                    'invoiced' => $invoiced,
                    'invoiceid' => $invoiceid
                );
            } else if ($action == 3) {
                // add notifications for all users which have permissions manageSales
                foreach ($staff as $member) {
                    if (has_permission('manageSales', $member['staffod'])) {
                        add_notification(array(
                            'fromcompany' => true,
                            'touserid' => $member['staffid'],
                            'description' => 'Client declined estimate with number ' . format_estimate_number($estimate->number),
                            'link' => 'estimates/list_estimates/' . $id
                        ));
                    }
                }
                $this->log_estimate_activity($id, 'Client declined this estimate.', false, true);
                return true;
            }
        }

        return false;
    }

    public function set_estimate_sent($id) {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'sent' => 1,
            'datesend' => date('Y-m-d H:i:s')
        ));

        $description = 'sent estimate to client';
        $this->log_estimate_activity($id, $description);

        // Update estimate status to sent
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => 2
        ));
    }

    /**
     * Sent estimate to client
     * @param  mixed  $id        estimateid
     * @param  string  $template  email template to sent
     * @param  boolean $attachpdf attach estimate pdf or not
     * @return boolean
     */
    public function sent_estimate_to_client($id, $template = '', $attachpdf = true) {

        $this->load->model('emails_model');
        $estimate = $this->get($id);
        if ($template == '') {
            if ($estimate->sent == 0) {
                $template = 'estimate-send-to-client';
            } else {
                $template = 'estimate-already-send';
            }
        }

        $estimate_number = format_estimate_number($estimate->number);
        $pdf = estimate_pdf($estimate);

        if ($attachpdf) {
            $attach = $pdf->Output($estimate_number . '.pdf', 'S');
            $this->emails_model->add_attachment($attach, $estimate_number . '.pdf', 'application/pdf');
        }

        $send = $this->emails_model->send_email_template($template, $estimate->client->email, $estimate->clientid, false, false, false, $id);
        if ($send) {
            $this->set_estimate_sent($id);
            return true;
        }

        return false;
    }

    /**
     * All estimate activity
     * @param  mixed $id estimateid
     * @return array
     */
    public function get_estimate_activity($id) {
        $this->db->where('estimateid', $id);
        $this->db->order_by('date', 'asc');
        return $this->db->get('tblestimateactivity')->result_array();
    }

    /**
     * Log estimate activity to database
     * @param  mixed $id   estimateid
     * @param  string $description activity description
     */
    public function log_estimate_activity($id, $description = '', $cron = false, $client = false) {
        $staffid = get_staff_user_id();

        if ($cron == true) {
            $staffid = 'Cron Job';
        } else if ($client == true) {
            $staffid = NULL;
        }

        $this->db->insert('tblestimateactivity', array(
            'description' => $description,
            'date' => date('Y-m-d H:i:s'),
            'estimateid' => $id,
            'staffid' => $staffid
        ));
    }

    function get_prev($id) {
        return $this->db->query("select id,clientid from tblestimates where id = (select max(id) from tblestimates where id < $id)")->row();
    }

    function get_next($id) {
        return $this->db->query("select id,clientid from tblestimates where id = (select min(id) from tblestimates where id > $id)")->row();
    }

    public function mark_action_status($action, $id, $client = false) {
        $this->db->where('id', $id);
        $this->db->update('tblquotes', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {

            $quote = $this->get($id);

            if ($client == true) {
                $this->db->where('staffid', $quote->addedfrom);
                $this->db->or_where('staffid', $quote->sale_agent);
                $staff_quote = $this->db->get('tblstaff')->result_array();


                $orderid = false;
                $orderd = false;
                if ($action == 4) {
                    if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                        $orderid = $this->convert_to_order($id, true);
                        $this->load->model('orders_model');
                        if ($orderid) {
                            $orderd = true;
                            $invoice = $this->orders_model->get($orderid);
                            $this->log_estimate_activity($id, 'Client accepted this quote. Quote is converted to order with number <a href="' . admin_url('orders/list_orders/' . $orderid) . '">' . format_order_number($orderid->id) . '</a>', false, true);
                        }
                    } else {
                        $this->log_estimate_activity($id, 'Client accepted this quote.', false, true);
                    }

                    // Send thank you email
                    $this->emails_model->send_email_template('quote-thank-you-to-customer', $quote->client->email, $quote->clientid, false, false, false, $id);

                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {
                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Congratiolations! Client accepted quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));
                            // Send staff email notification that customer accepted quote
                            $this->emails_model->send_email_template('quote-accepted-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }

                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );
                } else if ($action == 3) {
                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {

                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Client declined quote with number ' . format_quote_number($quote->id),
                                'link' => 'quotes/list_quotes/' . $id
                            ));

                            // Send staff email notification that customer declined quote
                            $this->emails_model->send_email_template('quote-declined-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }
                    $this->log_estimate_activity($id, 'Client declined this quote.', false, true);
                    return array(
                        'invoiced' => $invoiced,
                        'invoiceid' => $invoiceid
                    );
                }
            } else {
                // Admin marked quote
                $this->log_estimate_activity($id, 'marked quote as ' . format_quote_status($status, '', false));
                return true;
            }
        }
        return false;
    }

    public function mark_action_status_order($action, $id, $client = false) {
        $this->db->where('id', $id);
        $this->db->update('tblestimates', array(
            'status' => $action
        ));

        if ($this->db->affected_rows() > 0) {

            $quote = $this->get($id);

            if ($client == true) {
                $this->db->where('staffid', $quote->addedfrom);
                $this->db->or_where('staffid', $quote->sale_agent);
                $staff_quote = $this->db->get('tblstaff')->result_array();

                $orderid = false;
                $orderd = false;
                if ($action == 4) {
                    if (get_option('estimate_auto_convert_to_invoice_on_client_accept') == 1) {
                        $orderid = $this->convert_to_order($id, true);
                        $this->load->model('orders_model');
                        if ($orderid) {
                            $orderd = true;
                            $invoice = $this->orders_model->get($orderid);
                            $this->log_estimate_activity($id, 'Client accepted this quote. Quote is converted to order with number <a href="' . admin_url('orders/list_orders/' . $orderid) . '">' . format_order_number($orderid->id) . '</a>', false, true);
                        }
                    } else {
                        $this->log_estimate_activity($id, 'Client accepted this quote.', false, true);
                    }

                    // Send thank you email
                    $this->emails_model->send_email_template('quote-thank-you-to-customer', $quote->client->email, $quote->clientid, false, false, false, $id);

                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {
                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Congratiolations! Client accepted quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));
                            // Send staff email notification that customer accepted quote
                            $this->emails_model->send_email_template('quote-accepted-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }

                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );
                } else if ($action == 3) {
                    // add notifications for all users which have permissions manageSales
                    foreach ($staff_quote as $member) {
                        if (has_permission('manageSales', $member['staffid'])) {

                            add_notification(array(
                                'fromcompany' => true,
                                'touserid' => $member['staffid'],
                                'description' => 'Client declined quote with number ' . format_estimate_number($quote->id),
                                'link' => 'estimates/list_estimates/' . $id
                            ));

                            // Send staff email notification that customer declined quote
                            $this->emails_model->send_email_template('quote-declined-to-staff', $member['email'], $quote->clientid, false, false, false, $id);
                        }
                    }
                    $this->log_estimate_activity($id, 'Client declined this quote.', false, true);
                    return array(
                        'orderd' => $orderd,
                        'orderid' => $orderid
                    );
                }
            } else {
                // Admin marked quote
                $this->log_estimate_activity($id, 'marked quote as ' . format_quote_status($status, '', false));
                return true;
            }
        }
        return false;
    }

    public function delete($id) {
        do_action('before_vouchers_deleted', $id);
        $this->db->where('vchid', $id);
        $this->db->delete('tblvoucher');

        $this->db->where('vchid', $id);
        $this->db->delete('tblvoucherlines');
        return true;
    }
    public function typedelete($id) {
        do_action('before_voucherstype_deleted', $id);
        $this->db->where('id', $id);
        $this->db->delete('tblvouchertypes');

        $this->db->where('vouchertype_id', $id);
        $this->db->delete('tblallowedledgers');
        return true;
    }

    public function createcode() {

        $this->db->select_max('voucher');
        $this->db->where('vchtype', $this->input->post('id'));
        $voucher = $this->db->get('tblvoucher')->row()->voucher;
        if ($voucher) {
            $voucher = ++$voucher;
        } else {
            $voucher = $this->input->post('code') . '0001';
        }
        return $voucher;
    }

    public function getall_ledgers() {
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblledgergroups')->result();
    }
    public function get_where_allowedvouchertype($id) {
     return  $this->db->where('vouchertype_id', $id)->get('tblallowedledgers')->result();
    }
function get_prev_type($id){
   return $this->db->query("select id from tblvouchertypes where id = (select max(id) from tblvouchertypes where id < $id)")->row();
}
function get_next_type($id){
  return  $this->db->query("select id from tblvouchertypes where id = (select min(id) from tblvouchertypes where id > $id)")->row();
}
}
