<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Taxes_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * Get tax by id
     * @param  mixed $id tax id
     * @return mixed     if id passed return object else array
     */
    public function get($id = '')
    {

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            return $this->db->get('tbltaxes')->row();
        }

        return $this->db->get('tbltaxes')->result_array();
    }

    public function get_ledgers(){
        return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }
    /**
     * Add new tax
     * @param array $data tax data
     * @return boolean
     */
    public function add($data)
    {
        unset($data['taxid']);
        $this->db->insert('tbltaxes', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Tax Added [ID: '.$insert_id.', ' . $data['name'] . ']');
            return true;
        }

        return false;
    }

    /**
     * Edit tax
     * @param  array $data tax data
     * @return boolean
     */
    public function edit($data)
    {

        $taxid = $data['taxid'];
        unset($data['taxid']);
        $this->db->where('id', $taxid);
        $this->db->update('tbltaxes', $data);

        if ($this->db->affected_rows() > 0) {
            logActivity('Tax Updated [ID: '.$taxid.', ' . $data['name'] . ']');
            return true;
        }

        return false;
    }
    /**
     * Delete tax from database
     * @param  mixed $id tax id
     * @return boolean
     */
    public function delete($id)
    {
        if (is_reference_in_table('tax', 'tblinvoiceitemslist', $id)) {
            return array(
                'referenced' => true
            );
        }

        $this->db->where('id', $id);
        $this->db->delete('tbltaxes');

        if ($this->db->affected_rows() > 0) {
            logActivity('Tax Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
}
