<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Suppliers_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  mixed $id client id (optional)
     * @param  integer $active (optional) get all active or inactive
     * @return mixed
     * Get client object based on passed clientid if not passed clientid return array of all clients
     */
    
    public function get($id = false, $active = '')
    {


        $this->db->join('tblcountries','tblcountries.country_id = tblsuppliers.country', 'left');

        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('userid', $id);
            $client = $this->db->get('tblsuppliers')->row();

            return $client;
        }

        $this->db->order_by('datecreated', 'desc');
        return $this->db->get('tblsuppliers')->result_array();
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }


    function get_prev_groups($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        // $this->db->where('id', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            // if(($gr->type!="Group")||($gr->exists))
            // {
            //     $ta->exists=true;
            //     break;
                
            // }
            // if(($ta->type!="Group")||($ta->exists))
            // {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            // }
            
            
        }
        
        return $subgoups;
    }

    public function add_group($data){
        if($this->input->post('class_is_active')){
              $active = $this->input->post('class_is_active');
         }else{
              $active = 0;  
         }
         $data['class_is_active'] = $active;
        $this->db->insert('tblsuppliersgroups',$data);
        $insert_id = $this->db->insert_id();

        if($insert_id){
            logActivity('New Suppliers Group Created [ID:'.$insert_id.', Name:'.$data['name'].']');
            return true;
        }

        return false;
    }

    public function edit_group($data){
        $this->db->where('id',$data['id']);
   
          if($this->input->post('class_is_active')){
              $active = $this->input->post('class_is_active');
         }else{
              $active = 0;  
         }
         $data['creditlimit']=str_replace(",","",$data['creditlimit']);
         $array=array(
             'name' => $data['name'],
             'discription' => $data['discription'],
             'default_language' => $data['default_language'],
             'account_payable_ledger' => $data['account_payable_ledger'],
             'expense_ledger' => $data['expense_ledger'],
             'payment_term' => $data['payment_term'],
             'default_currency' => $data['default_currency'],
             'class_is_active' => $active,
             
             // 'account_req' => $data['account_req'],
             'creditlimit' => $data['creditlimit'],          
         );
     
         
        $this->db->update('tblsuppliersgroups',$array);
        if($this->db->affected_rows() > 0){
            logActivity('Suppliers Group Updated [ID:'.$data['id'].']');
            return true;
        }
        return false;
    }

    public function changestatus(){
          
      $row = $this->db->where('id',$this->input->post('id'))->get('tblsuppliersgroups')->row();
      if($row->class_is_active == '0'){
        $data =array('class_is_active'=>1);
        $this->db->where('id', $this->input->post('id'));
        $this->db->update('tblsuppliersgroups', $data);
      }
      if($row->class_is_active == '1'){
        $data =array('class_is_active'=>0);
        $this->db->where('id', $this->input->post('id'));
        $this->db->update('tblsuppliersgroups', $data);
      }
    }

    public function getclass(){
      return $this->db->where('id', $this->input->post('id'))->get('tblsuppliersgroups')->row();  
    }

    public function delete_group($id){

        // if(is_reference_in_table('groupid','tblsuppliersgroups',$id)){
        //     return array('referenced'=>true);
        // }

        $this->db->where('id',$id);
        $this->db->delete('tblsuppliersgroups');

        if($this->db->affected_rows() > 0){
            logActivity('Supplier Group Delete [ID:'.$id.']');
            return true;
        }

        return false;

    }


    public function get_groups($id = ''){
         $this->db->where('class_is_active','1');
        if(is_numeric($id)){
            $this->db->where('id',$id);
            return $this->db->get('tblsuppliersgroups')->row();
        }

        return $this->db->get('tblsuppliersgroups')->result_array();
    }

    public function filldata($id){
      return $this->db->where('id', $id)->get('tblsuppliersgroups')->row();    
    }


   /*get last client account number*/

public function get_last_user(){
 return $this->db->order_by('userid','DESC')->get('tblclients')->row();
}

public function get_country($id){
   return $this->db->where('country_id',$id)->get('tblcountries')->row();  
}
public function get_pai_balance($id){
   $result = $this->db->select_sum('amount')->where('invoiceid',$id)->get('tblinvoicepaymentrecords')->row();
   if($result){
       return $result->amount;
   }else{
       return 0;
   }
}
public function get_balance($id){
    $result = $this->db->where('clientid',$id)->get('tblinvoices')->result();

    if(!empty($result)){
        $total=$paidamount=0;
        foreach ($result as $value) {
            $paidamount +=$this->get_pai_balance($value->id);
            $total +=$value->total;
        }
        
        return $total-$paidamount;
    }
}
public function get_ledgers(){
        return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    }
public function get_contact($id){
 return $this->db->where('userid',$id)->get('tblclientcontacts')->result();
}

 function getSingleRecord($table, $where) {
        return $this->db->get_where($table, $where)->row();
    }
    
 function getDataByOrder($table, $where ) {
        $this->db->order_by('sort_order', 'asc');
        return $this->db->get_where($table, $where)->result_array();
 }

public function addcontact($customerid){
    $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'userid'   => $this->input->post('supplier_id'));
    $res=$this->db->insert('tblsuppliercontacts', $data);  
    return $this->db->insert_id();
    
}

public function getRecords($tbl)
{
  return $this->db->get($tbl)->result_array();  
}
public function get_where_record($tbl,$id)
{
    
  return $this->db->where('id', $id)->get($tbl)->row();  
}
public function getcontact($id)
{
  return $this->db->where('id', $id)->get('tblsuppliercontacts')->row();  
}

public function DeleteContacts($id)
{
        $this->db->where('id', $id);
        $res=$this->db->delete('tblsuppliercontacts');
        return $res;
}
public function get_client($id){
      return $this->db->where('userid', $id)->get('tblsuppliers')->row(); 
}

public function updateContacts($contactid)
{
     $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        );
        
        $this->db->where('id', $this->input->post('contactid'));
        $res=$this->db->update('tblsuppliercontacts',$data);
        return $res;
}



    /**
     * @param array $_POST data
     * @return integer Insert ID
     * Add new client to database
     */
    public function add($data)
    {
		
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);
		    unset($data['isedit']);

        

        if($data['duedays'] < 2){
          unset($data['credit_limit']);
        }else{
          $data['credit_limit'] = str_replace(',','',$data['credit_limit']);
          
        }
        unset($data['duedays']);

        //first check account number is exist or not
       
      //  $accountno = $this->db->get('tblsuppliers')->row();
        
        // First check for all cases if the email exists.
      /*  $this->db->where('email', $data['email']);
        $email = $this->db->get('tblsuppliers')->row();
        if ($email) {
            die('Email already exists');
        }*/

        if (isset($data['passwordr'])) {
            unset($data['passwordr']);
        }

        if(isset($data['groups_in'])){
            $groups_in = $data['groups_in'];
            unset($data['groups_in']);
        }
        
    

        $this->load->helper('phpass');
        $hasher              = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
        $data['password']    = $hasher->HashPassword($data['password']);
        $data['datecreated'] = date('Y-m-d H:i:s');

        $data['amount'] = str_replace(',','',$data['amount']);
        
        if($data['opening_balance'] == ""){
            $data['type_of_balance'] = "";
            $data['amount'] = "";
            $data['note'] = "";
        }
        $data['active'] = 1;
        // echo "<pre>";
        // print_r($data);
        // die;

        $data['ledger'] = $data['account_payable_ledger'];
        
        $data = do_action('before_client_added', $data);
         $this->db->insert('tblsuppliers', $data);
         
        $userid = $this->db->insert_id();
        
//            $data1=array(
//        'firstname' => $this->input->post('supplier'),
//        'userid'   => $userid);
//        $this->db->insert('tblsuppliercontacts', $data1);
        
        if ($userid) {
          $data['groups_in']=$groups_in;

          unset($data['groups_in']);
            
          $this->load->model('ledgers_model');
              $ledgerdata=array(
                  'name'=>ucfirst($data['supplier']),
                  'description'=>$data['supplier'],
                  'type'=>'Ledger',
                  'parent'=>61,
                  'accountid'=>$userid,
              );
              // $ledgerid = $this->ledgers_model->add($ledgerdata);
           
              //  if($ledgerid){
              //       // $this->db->where('userid', $userid);
              //       // $this->db->update('tblsuppliers', array('ledger'=>$ledgerid));
              //       $this->createpath2($userid, $ledgerid, $data['supplier']);
              //  } 

              if (isset($groups_in)) 
              {
               // foreach ($groups_in as $group) {
                $this->db->where('supplier_id', $userid);
                // $this->db->where('groupid', $groups_in);
                $_exists = $this->db->get('tblsuppliergroups_in')->row();
                // print_r($_exists);
                // die;
                if (!$_exists) {
                    $this->db->insert('tblsuppliergroups_in', array(
                        'supplier_id' => $userid,
                        'groupid' => $groups_in
                    ));
                }
                else
                {
                    $this->db->where('supplier_id', $userid);
                    $this->db->update('tblsuppliergroups_in', array(
                        // 'supplier_id' => $userid,
                        'groupid' => $groups_in
                    ));
                }
               // }
            }

             // Get all announcements and set it to read.
            $this->db->select('announcementid');
            $this->db->from('tblannouncements');
            $this->db->where('showtousers',1);
            $announcements = $this->db->get()->result_array();

            foreach($announcements as $announcement){
                $this->db->insert('tbldismissedannouncements',array(
                    'announcementid'=>$announcement['announcementid'],
                    'staff'=>1,
                    'userid'=>$userid
                    ));
            }

      

        }

        if($data['opening_balance'] != "")
        {
          $this->db->select_max('voucher');
          $this->db->where('vchtype', '9');
          $voucher = $this->db->get('tblvoucher')->row()->voucher;

          if($voucher){
              $voucher = ++$voucher;
          }else{
           $voucher ='OB-0001';
          }

          $voucherdate = date('Y-m-d H:i:s');

          $this->db->insert('tblvoucher',array(
                         
                    'voucher'=>$voucher,
                    'vchtype'=>'9',
                    'invoiceid'=>0,
                    'docdate'=>$voucherdate,
                    'trxdate'=>$voucherdate,
                    'created_by'=> get_staff_user_id(),
                    'currency'=>'3',
               
                    ));
          $voucherid = $this->db->insert_id();

          $this->load->model('settings_model');
          $default_options = $this->settings_model->getOptions();

          if($data['type_of_balance'] == 'debit')
          {
            $opening_balance_ledger =  array(
                                'ledger'=>$default_options['opening_balance'],
                                'vchid'=>$voucherid,
                                'amount'=>$data['amount'],
                                'description'=>$data['supplier'],
                                'refrence'=>$voucher,
                               // 'invoiceid'=>$invoicenumber,
                               'poid'=>'',
                                'item_order'=> 0,
                                'amount_type'=>0
                                );
            $this->db->insert('tblvoucherlines',$opening_balance_ledger);

            $account_payable_ledger =  array(
                                'ledger'=>$default_options['accounts_payable'],
                                'vchid'=>$voucherid,
                                'amount'=>$data['amount'],
                                'description'=>$data['supplier'],
                                'refrence'=>$voucher,
                               // 'invoiceid'=>$invoicenumber,
                               'poid'=>'',
                                'item_order'=> 0,
                                'amount_type'=>1
                                );
            $this->db->insert('tblvoucherlines',$account_payable_ledger);
          }

          if($data['type_of_balance'] == 'credit')
          {
            $opening_balance_ledger =  array(
                                'ledger'=>$default_options['opening_balance'],
                                'vchid'=>$voucherid,
                                'amount'=>$data['amount'],
                                'description'=>$data['supplier'],
                                'refrence'=>$voucher,
                               // 'invoiceid'=>$invoicenumber,
                               'poid'=>'',
                                'item_order'=> 0,
                                'amount_type'=>1
                                );
            $this->db->insert('tblvoucherlines',$opening_balance_ledger);

            $account_payable_ledger =  array(
                                'ledger'=>$default_options['accounts_payable'],
                                'vchid'=>$voucherid,
                                'amount'=>$data['amount'],
                                'description'=>$data['supplier'],
                                'refrence'=>$voucher,
                               // 'invoiceid'=>$invoicenumber,
                               'poid'=>'',
                                'item_order'=> 0,
                                'amount_type'=>0
                                );
            $this->db->insert('tblvoucherlines',$account_payable_ledger);
          }
        }


        return $userid;
    }

    public function get_supplier_groups($id){

        $this->db->where('supplier_id',$id);
        return $this->db->get('tblsuppliergroups_in')->result_array();
    }

    /* Edit ledger or add new ledger */
    public function createpath(){
    
        $array = $this->db->query("SELECT * from tblledgergroups")->result_array();
        $array2 = array();
        foreach ($array as $key => $value) {
            $array2[$value['id']] = $value;
        }
        foreach ($array2 as $key => $a) {

            if ($a['parent'] == 0) {
                $data['path']= $a['name'];
                 $this->db->where('id', $a['id']);
                 $this->db->update('tblledgergroups', $data);
                 } else {
                $b = $a;
                $_a = array($b['name']);
                while ($b['parent'] != 0) {
                    $b = $array2[$b['parent']];
                    $_a[] = $b['name'];
                }
                
               
                $data['path']= implode('/', array_reverse($_a));
                 $this->db->where('id', $a['id']);
                 $this->db->update('tblledgergroups', $data);
            }
        }
    }

    public function createpath2($parent, $ledger_id, $accountname) {
        $clientid = $this->db->where('userid', $parent)->get('tblsuppliers')->row()->ledger;
        $ledgerPath = $this->db->where('id', $clientid)->get('tblledgergroups')->row()->path;
		/*echo "cliedid=".$clientid."<br>";
		echo "ledgerpath=".$ledgerPath;exit;*/
        $array2 = array($ledgerPath, ucfirst($accountname));
        $slash = implode('/', $array2);
        $data['path']= $slash;
	     
		$data['parent']	= $clientid;
        $this->db->where('id', $ledger_id);
        $this->db->update('tblledgergroups', $data);
    }
    /**
     * @param  array $_POST data
     * @param  integer ID
     * @return boolean
     * Update client informations
     */
    public function update($data, $id)
    {
	
        unset($data['action']);
        unset($data['save']);
        unset($data['cancel']);
        unset($data['snew']);
        unset($data['slist']);

        if($data['duedays'] < 2){
          unset($data['credit_limit']);
        }else{
          $data['credit_limit'] = str_replace(',','',$data['credit_limit']);
        }

        if(isset($data['groups_in'])){
          $groups_in = $data['groups_in'];
          unset($data['groups_in']);
        }
	
        unset($data['duedays']);

		    unset($data['isedit']);
        
        if (empty($data['password'])) {
            unset($data['password']);
        } else {
            $this->load->helper('phpass');
            $hasher                       = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
            $data['password']             = $hasher->HashPassword($data['password']);
            $data['last_password_change'] = date('Y-m-d H:i:s');
        }

       $affectedRows = 0;
//         if(isset($data['custom_fields'])){
//            $custom_fields = $data['custom_fields'];
//            if(handle_custom_fields_post($id,$custom_fields)){
//                $affectedRows++;
//            }
//            unset($data['custom_fields']);
//         }
//
//        if (@$data['company'] == '') {
//            $data['company'] = NULL;
//        }
//
//        $_data = do_action('before_client_updated', array(
//            'userid' => $id,
//            'data' => $data
//        ));



//        $data = $_data['data'];

        $this->db->where('userid', $id);
        $this->db->update('tblsuppliers', $data);




        $supplier_groups = $this->get_supplier_groups($id);

        if (sizeof($supplier_groups) > 0) {
            foreach ($supplier_groups as $supplier_group) {
                if (isset($groups_in)&&(is_array($groups_in))) {
                    if (!in_array($supplier_group['id'], $groups_in)) {
                        $this->db->where('supplier_id', $id);
                        $this->db->where('id', $supplier_group['id']);
                        $this->db->delete('tblsuppliergroups_in');
                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                    }
                } else {
                     $this->db->where('supplier_id', $id);
                     $this->db->delete('tblsuppliergroups_in');
                       if ($this->db->affected_rows() > 0) {
                            $affectedRows++;
                        }
                }
            }
            if (isset($groups_in)) {
//                foreach ($groups_in as $groups_in) {
                    $this->db->where('supplier_id', $id);
                    $this->db->where('groupid', $groups_in);
                    $_exists = $this->db->get('tblsuppliergroups_in')->row();
                    if (!$_exists) {
                        if(empty($groups_in)){return;}
                        $this->db->insert('tblsuppliergroups_in', array(
                            'supplier_id' => $id,
                            'groupid' => $groups_in 
                       ));

                        if ($this->db->affected_rows() > 0) {
                            $affectedRows++; 
                       }
                    }
//                }
            }
        } else {
            if (isset($groups_in)) {
//                foreach ($groups_in as $group) {
                    if(empty($groups_in)){return;}
                    $this->db->insert('tblsuppliergroups_in', array(
                        'supplier_id' => $id,
                        'groupid' => $groups_in
                    ));
                    if ($this->db->affected_rows() > 0) {
                        $affectedRows++;
                    }
//                }
            }
        }



        return true;
    }

    /**
     * @param  integer ID
     * @return boolean
     * Delete client, also deleting rows from, dismissed client announcements, ticket replies, tickets, autologin, user notes
     */
    public function deletebill($id){
        $this->db->where('billid', $id);
       $res= $this->db->delete('tblbills');
        return $res;
    }
    public function delete($id)
    {

        $affectedRows = 0;
        do_action('before_client_deleted', $id);

//        if (is_reference_in_table('clientid', 'tblinvoices', $id)) {
//            set_alert('warning', _l('client_delete_invoices_warning'));
//            redirect(admin_url('clients/client/' . $id),'refresh');
//        }

        $this->db->where('userid', $id);
        $this->db->delete('tblsuppliers');

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;

            $this->db->where('userid', $id);
            $this->db->where('staff', 0);
            $this->db->delete('tbldismissedannouncements');



            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }

            // Delete all tickets start here
            $this->db->where('userid', $id);
            $tickets = $this->db->get('tbltickets')->result_array();
            $this->load->model('tickets_model');
            foreach ($tickets as $ticket) {
                $deleted = $this->tickets_model->delete($ticket['ticketid']);
                if ($deleted) {
                    $affectedRows++;
                }
            }

            // Delete autologin if found
            $this->db->where('user_id', $id);
            $this->db->where('staff', 0);
            $this->db->delete('tbluserautologin');

            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }

            // Delete client admin notes
            $this->db->where('userid', $id);
            $this->db->where('staff', 0);
            $this->db->delete('tbluseradminnotes');

            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }

          
        }



        if ($affectedRows > 0) {
            do_action('after_client_deleted');
            logActivity('Supplier Deleted [' . $id . ']');
            return true;
        }
        return false;
    }


    /**
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     * Update client status Active/Inactive
     */
    public function change_supplier_status($id, $status)
    {
        $this->db->where('userid', $id);
        $this->db->update('tblsuppliers', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Supplier Status Changed [ClientID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }
    /**
     * Add client personal reminder
     * @since  Version 1.0.2
     * @param mixed $data All $_POST data for the reminder
     * @param mixed $id   client id
     * @return boolean
     */
    public function add_reminder($data,$id){

        if(isset($data['notify_by_email'])){
            $data['notify_by_email'] = 1;
        } else {
             $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tbladminsupplierreminders',$data);

        $insert_id = $this->db->insert_id();
        if($insert_id){
            logActivity('New Supplier Reminder Added [SupplierID: ' . $data['clientid'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }

    /**
     * Get all reminders or 1 reminder if id is passed
     * @since Version 1.0.2
     * @param  mixed $id reminder id OPTIONAL
     * @return array or object
     */
    public function get_reminders($id = ''){

        $this->db->join('tblstaff','tblstaff.staffid = tbladminsupplierreminders.staff');

        if (is_numeric($id)) {
            $this->db->where('tbladminsupplierreminders.id', $id);
            return $this->db->get('tbladminsupplierreminders')->row();
        }

        $this->db->order_by('date', 'desc');
        return $this->db->get('tbladminsupplierreminders')->result_array();
    }

    /**
     * Remove client reminder from database
     * @since Version 1.0.2
     * @param  mixed $id reminder id
     * @return boolean
     */
    public function delete_reminder($id){
        $reminder = $this->get_reminders($id);
           if($reminder->creator == get_staff_user_id()){
                $this->db->where('id',$id);
                $this->db->delete('tbladminsupplierreminders');
                if($this->db->affected_rows() > 0){
                    logActivity('Supplier Reminder Deleted [ClientID: ' . $id . ' Description: ' . $reminder->description . ']');
                    return true;
                }
                return false;
           }

       return false;
    }
    /**
     * @param  mixed $_POST data
     * @return mixed
     * Change client password, used from client area
     */
    public function change_client_password($data)
    {
        // Get current password
        $this->db->where('userid', get_client_user_id());
        $client = $this->db->get('tblclients')->row();

        $this->load->helper('phpass');
        $hasher = new PasswordHash(PHPASS_HASH_STRENGTH, PHPASS_HASH_PORTABLE);
        if (!$hasher->CheckPassword($data['oldpassword'], $client->password)) {
            logActivity('Client Password Not Match [ClientID: ' . get_client_user_id() . ']');
            return array(
                'old_password_not_match' => true
            );
        }

        $update_data['password']             = $hasher->HashPassword($data['password']);
        $update_data['last_password_change'] = date('Y-m-d H:i:s');
        $this->db->where('userid', get_client_user_id());
        $this->db->update('tblclients', $update_data);

        if ($this->db->affected_rows() > 0) {
            logActivity('Client Password Changed [ClientID: ' . get_client_user_id() . ']');
            return true;
        }

        return false;
    }
function get_prev($id){
   return $this->db->query("select userid from tblsuppliers where userid = (select max(userid) from tblsuppliers where userid < $id)")->row();
}
function get_next($id){
  return  $this->db->query("select userid from tblsuppliers where userid = (select min(userid) from tblsuppliers where userid > $id)")->row();
}
}
