<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reconcile_model extends CRM_Model
{
    
    function __construct()
    {
        parent::__construct();
    }

    

    public function get_banks(){
        return $this->db->order_by('bank', 'ASC')->get('tblbanks')->result();  
    }

    public function get_branch()
    {
        $branch = $this->db->get('tblbankbranches')->result();
        return $branch;
    }

    public function get_accounts($branch_id)
    {
        return $this->db->where('branch',$branch_id)->order_by('id','ASC')->get('tblbanksaccount')->result(); 
    }

    public function get_deopsits($account_id)
    {
        $this->db->select('tblclients.accountname,tblinvoicepaymentsmodes.name as payment_type,tbldeopsits.amount,tbldeopsits.date,tbldeopsits.id as deopsitsid');
        $this->db->from('tbldeopsits');
        $this->db->join('tblclients', 'tblclients.userid = tbldeopsits.customer');
        $this->db->join('tblinvoicepaymentsmodes', 'tblinvoicepaymentsmodes.id = tbldeopsits.payment_type');
        $this->db->where('tbldeopsits.account_id',$account_id);
        $this->db->where('tbldeopsits.reconciled',0);
        $records = $this->db->get()->result();

        // echo "<pre>";
        // print_r($records);
        // die;
         return $records;
    }
	   public function get_payments($account_id)
    {
        $this->db->select('tblsuppliers.supplier, tblpaidbills.bill_date,tblbillpaymentrecords.amount,tblbillpaymentrecords.date,tblbillpaymentrecords.id as paymentid');
        $this->db->from('tblbillpaymentrecords');
		$this->db->join('tblpaidbills', 'tblpaidbills.id = tblbillpaymentrecords.	paidbillid');
        $this->db->join('tblsuppliers', 'tblsuppliers.userid = tblpaidbills.supplierid');
        $this->db->where('tblbillpaymentrecords.account_number',$account_id);
        $this->db->where('tblbillpaymentrecords.reconciled',0);
        $records = $this->db->get()->result();

        // echo "<pre>";
        // print_r($records);
        // die;
         return $records;
    }

    public function get_last_reconcile($id)
    {
        return $last_reconcile = $this->db->select('tblreconcilations.*')->where('account_id',$id)->order_by('id','desc')->limit(1)->get('tblreconcilations')->row();
    }

    public function add($data)
    {
        $var = $data['date'];
        $date = str_replace('/', '-', $var);
        // echo date('Y-m-d', strtotime($date));
        // echo "<pre>";
        // print_r(date("m-d-y", strtotime($data['date'])));
        // die;

        $data['startbalance'] = str_replace(',','',$data['startbalance']);
        $data['endbalance'] = str_replace(',','',$data['endbalance']);
        $data['servicecharge'] = str_replace(',','',$data['servicecharge']);
        $data['interestreceived'] = str_replace(',','',$data['interestreceived']);


        $addreconcile = array(
                            'bank_id' => $data['bank_id'],
                            'branch_id' => $data['branch_id'],
                            'account_id' => $data['account_id'],
                            'note' => $data['note'],
                            'date' => date('Y-m-d', strtotime($date)),
                            'startbalance' => $data['startbalance'],
                            'endbalance' => $data['endbalance'],
                            'servicecharge' => $data['servicecharge'],
                            'interestreceived' => $data['interestreceived'],
                        );
        $this->db->insert('tblreconcilations',$addreconcile);
        $reconciled_id = $this->db->insert_id();

        foreach ($data['deopsits'] as $key => $deopsit) 
        {
            // $this->db->select('tbldeopsits.*');
            // $this->db->from('tbldeopsits');
            // $this->db->where('tbldeopsits.id',$deopsit);
            // $deopsit_row = $this->db->get()->row();

            $updatedeopsits =array(
                                        'reconciled' => 1,
                                        'date_reconciled'=> date('Y-m-d', strtotime($date)),
                                    );
            $this->db->where('id', $deopsit);
            $this->db->update('tbldeopsits', $updatedeopsits);
        }
		 foreach ($data['payments'] as $key => $payment) 
        {
            // $this->db->select('tbldeopsits.*');
            // $this->db->from('tbldeopsits');
            // $this->db->where('tbldeopsits.id',$deopsit);
            // $deopsit_row = $this->db->get()->row();

            $updatedeopsits =array(
                                        'reconciled' => 1,
                                        'date_reconciled'=> date('Y-m-d', strtotime($date)),
                                    );
            $this->db->where('id', $payment);
            $this->db->update('tblbillpaymentrecords', $updatedeopsits);
        }

        return true;
    }

}
