<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Locations_model extends CRM_Model {

    function __construct() {
        parent::__construct();
         $this->load->model('locations_model');
    }

    public function change_category_status($id, $status) {
        $this->db->where('category_id', $id);
        $this->db->update('tblcategories', array(
            'active' => $status
        ));

        if ($this->db->affected_rows() > 0) {
            logActivity('Category Status Changed [CategoryID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');
            return true;
        }

        return false;
    }

    public function update($data, $id) {
        $data = $_data['data'];

        $this->db->where('category_id', $id);
        $this->db->update('tblcategories', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
            do_action('after_category_updated', $id);
            $_update_client_log = $data['firstname'] . ' ' . $data['lastname'];
            $_is_staff = NULL;

            if (is_staff_logged_in()) {
                $_update_client_log .= ' From Staff: ' . get_staff_user_id();
                $_is_staff = get_staff_user_id();
            }

            logActivity('Client Info Updated [' . $_update_client_log . ']', $_is_staff);
            return true;
        }

        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }

    public function delete($id) {
        $affectedRows = 0;
        do_action('before_location_deleted', $id);
        $this->db->where('location_id', $id);
        $affectedRows =$this->db->delete('tbllocations');

        if ($affectedRows > 0) {
            do_action('after_location_deleted');
            logActivity('Location Deleted [' . $id . ']');
            return true;
        }
       
    }

    public function get_location_details($id) {
        return $this->db->where('location_id', $id)->get('tbllocations')->first_row();
    }
    
    public function get_warehouse() {
        return $this->db->get('tblwarehouse')->result();
    }

    public function update_location_details() {
		if($this->input->post('editlocation_name'))
			return $this->update_location_details2();
        $id   = $this->input->post('location_id');
        $active = $this->input->post('loc_is_active')?$this->input->post('loc_is_active'):0;
        $data = array(
            'location_name' => $this->input->post('location_name'),
            'stock_type'   => $this->input->post('stock_type'),
            'length'   => $this->input->post('length'),
            'width'   => $this->input->post('width'),
            'height'   => $this->input->post('height'),
            'volume'   => $this->input->post('volume'),
            'remarks'   => $this->input->post('loc_remarks'),
            'ware_id'  => $this->input->post('ware_id'),
            'active'        => $active
        );
        
        $this->db->where('location_id', $id)->update('tbllocations',$data);

        return $id;
    }
     public function update_location_details2() {
        $id   = $this->input->post('id');
        $active = $this->input->post('active')?$this->input->post('active'):0;
        $data = array(
            'location_name' => $this->input->post('editlocation_name'),
            'stock_type'   => $this->input->post('editstock_type'),
            'length'   => $this->input->post('editlength'),
            'width'   => $this->input->post('editwidth'),
            'height'   => $this->input->post('editheight'),
            'volume'   => $this->input->post('editvolume'),
            'remarks'   => $this->input->post('editremark'),
            'ware_id'  => $this->input->post('editware_id'),
            'active'        => $active
        );
        
        $this->db->where('location_id', $id)->update('tbllocations',$data);

        return $id;
    }
    public function add_location_details(){
        $active = $this->input->post('loc_is_active')?$this->input->post('loc_is_active'):0;
        $data = array(
            'location_name' => $this->input->post('location_name'),
            'stock_type'   => $this->input->post('stock_type'),
            'length'   => $this->input->post('length'),
            'width'   => $this->input->post('width'),
            'height'   => $this->input->post('height'),
            'volume'   => $this->input->post('volume'),
            'remarks'   => $this->input->post('loc_remarks'),
            'ware_id'  => $this->input->post('ware_id'),
            'active'        => $active
        );
        
        $this->db->insert('tbllocations',$data);
        $id = $this->db->insert_id();
        return $id;
    }
    
    public function changestatus(){
       
            $row = $this->db->where('location_id',$this->input->post('id'))->get('tbllocations')->row();
           if($row->active == '0'){
                $data =array('active'=>1);
                $this->db->where('location_id', $this->input->post('id'));
                $this->db->update('tbllocations', $data);
           }
           if($row->active == '1'){
                $data =array('active'=>0);
                $this->db->where('location_id', $this->input->post('id'));
                $this->db->update('tbllocations', $data);
           }

            }
            
   
}
