<?php
error_reporting(0);
defined('BASEPATH') OR exit('No direct script access allowed');

class Engines_model extends CRM_Model {

    function __construct() {
        parent::__construct();
    }

    /**
     * Get invoice item by ID
     * @param  mixed $id
     * @return mixed - array if not passed id, object if id passed
     */
    public function get($id = false, $active = '')
    {
		
        $this->db->select('engines.*,vehiclemodelyear.make,vehiclemodelyear.model,vehiclemodelyear.year');
        $this->db->join('vehiclemodelyear','vehiclemodelyear.id = engines.vehiclemodelyear', 'left');

       //$this->db->limit(100);

        if ($id) {
            $this->db->where('engines.id', $id);
            $client = $this->db->get('engines')->row();
        //echo $this->db->last_query();

            return $client;
        }

       // $this->db->order_by('engines.fuel', 'desc');
        return $this->db->get('engines')->result_array();
    }
	
	public function get_engines($search)
    {
		
        $this->db->select('engines.id as engines_id,engines.*,vehiclemodelyear.make,vehiclemodelyear.model,vehiclemodelyear.year');
        $this->db->join('vehiclemodelyear','vehiclemodelyear.id = engines.vehiclemodelyear', 'left');
		$this->db->where("CONCAT(vehiclemodelyear.make, ' ', vehiclemodelyear.model) LIKE '%".$search."%'", NULL, FALSE);
		$this->db->or_like("vehiclemodelyear.year ",$search);
		$this->db->or_like("engines.engine_code ",$search);
		$this->db->or_like("engines.type ",$search);

       //$this->db->limit(100);

        if ($id) {
            $this->db->where('engines.id', $id);
            $client = $this->db->get('engines')->row();
        //echo $this->db->last_query();

            return $client;
        }
		
		
       	$this->db->order_by('vehiclemodelyear.make asc, vehiclemodelyear.model asc,vehiclemodelyear.year asc,
 FIELD(fuel, "Petrol", "diesel", "hybrid") asc,engines.type asc,engines.kw asc');
        return $this->db->get('engines')->result_array();
    }
	
	
	  public function getallenginesdata($start, $length, $order, $dir,$search,$makeid)
    {
		//print_r($makeid);
		//exit;
		 if($order !=null) {
           // $this->db->order_by($order, $dir);
		   
        }
$this->db->order_by('vehiclemodelyear.make asc, vehiclemodelyear.model asc,vehiclemodelyear.year asc,
 FIELD(fuel, "Petrol", "diesel") asc,engines.type asc,engines.kw asc');
		$this->db->limit($length,$start);
        $this->db->select('engines.type,engines.id,engines.cc,engines.kw,engines.ps,engines.hp,engines.nm,engines.engine_code,engines.ecu_type,engines.fuel,engines.stage1_hp,engines.cylinders,engines.stage1_nm,engines.stage2_hp,engines.stage2_nm,vehiclemodelyear.make,vehiclemodelyear.model,vehiclemodelyear.year,vehiclemodelyear.image_make');
        $this->db->join('vehiclemodelyear','vehiclemodelyear.id = engines.vehiclemodelyear', 'left');
      // echo $makeid;
		if($makeid){
			$this->db->where('engines.vehiclemodelyear', $makeid);
		}
     	$this->db->where_not_in('vehiclemodelyear.make', '');
		if($search){
		$this->db->where("CONCAT(vehiclemodelyear.make, ' ', vehiclemodelyear.model) LIKE '%".$search."%'", NULL, FALSE);
		$this->db->or_like("vehiclemodelyear.year ",$search);
		$this->db->or_like("engines.type ",$search);
		}
		//$query  = $this->db->get('engines');
		//echo $this->db->last_query();
       // $this->db->order_by('engines.fuel', 'desc');
       return $this->db->get('engines');
    }
	
	
	  public function getallenginesdatatotal($makeid)
    {
	 
	 
	if($makeid){
			$this->db->where('engines.vehiclemodelyear', $makeid);
		}
	  $query = $this->db->select("COUNT(*) as num")->get("engines");
	
	 

      $result = $query->row();
      if(isset($result)) return $result->num;
      return 0;
    }
	
	
	
	
	
	
	public function getmakemodelyears($limit, $start) {
		$this->db->limit($limit, $start);
		//$this->db->where('id', $id);
        $this->db->order_by('make', 'ASC');
       // return $this->db->get('vehiclemodelyear')->result_array();
		$query = $this->db->get("vehiclemodelyear");
		if ($query->num_rows() > 0) {
		foreach ($query->result() as $row) {
		$data[] = $row;
		}
		
		return $data;
		}
		
    }
	
		
	public function record_count() {
		return $this->db->count_all("vehiclemodelyear");
		}
	
	public function getmakemodelyears_search($limit, $start , $searchterm) {
		$this->db->limit($limit, $start);
		$this->db->where("CONCAT(make, ' ', model) LIKE '%".$searchterm."%'", NULL, FALSE);
        $this->db->order_by('make', 'ASC');
       // return $this->db->get('vehiclemodelyear')->result_array();
		$query = $this->db->get("vehiclemodelyear");
		//echo $this->db->last_query();
		//exit;
		if ($query->num_rows() > 0) {
		foreach ($query->result() as $row) {
		$data[] = $row;
		}
		
		return $data;
		}
		
    }
	

		
	public function record_count_search($searchterm) {
		$this->db->where("CONCAT(make, ' ', model) LIKE '%".$searchterm."%'", NULL, FALSE);

	/*	$this->db->where_in('make', $searchterm);
		$this->db->where_in('model', $searchterm);*/
		$query = $this->db->get("vehiclemodelyear");
		//echo $this->db->last_query();
		//echo $query->num_rows();
		return $query->num_rows();
		}	
		
		
 public function getcontact($id){
     return $this->db->where('contact_id', $id)->get('tblwarehousecontacts')->row();  
}
 
public function get_num_row($engineid){
	$this->db->select('vehicles.*');

        $this->db->from('vehicles');


		$this->db->where('vehicles.engines_id',$engineid);

 		$vehicles = $this->db->get()->num_rows();

        return $vehicles;

	}    
public function addcontact(){
    $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
        'ware_id'   => $this->input->post('ware_id'));
    $res=$this->db->insert('tblwarehousecontacts', $data);  
    return $this->db->insert_id();
    
}

public function updateContacts($contactid)
{
     $data=array('salutation' => $this->input->post('salutation'),
        'firstname' => $this->input->post('firstname'),
        'lastname'  => $this->input->post('lastname'),
        'country'  => $this->input->post('country'),
        'address'  => $this->input->post('address'),
        'city'     => $this->input->post('city'),
        'state'    => $this->input->post('state'),
        'zip'      => $this->input->post('zip'),
        'phoneno'  => $this->input->post('phoneno'),
        'mobileno' => $this->input->post('mobileno'),
        'fax'      => $this->input->post('fax'),
        'email'    => $this->input->post('email'),
        'skypeid'  => $this->input->post('skypeid'),
        'position' => $this->input->post('position'),
        'status'   => $this->input->post('status'),
        'department_id'   => $this->input->post('department'),
        'ware_id'   => $this->input->post('ware_id'));
        $this->db->where('contact_id',$this->input->post('contactid'));
        $res=$this->db->update('tblwarehousecontacts',$data);
        return $res;
}

public function get_where_record($tbl,$id)
{
    
  return $this->db->where('contact_id', $id)->get($tbl)->row();  
}

public function get_client($id){
      return $this->db->where('ware_id', $id)->get('tblwarehouse')->row(); 
}

public function get_departments(){
   return $this->db->where('is_active','1')->order_by('sort_order','ASC')->get('tbldepartments')->result();  
}

    /**
     * Add new invoice item
     * @param array $data Invoice item data
     * @return boolean
     */
    public function add($data) {
        unset($data['action']);
		unset($data['vehiclemodelyear_old']);
		
         
        $this->db->select('UUID() AS id');
        $idrow = $this->db->get('engines')->row();
		$data['id']= $idrow->id;
		
		
	
		
		$vehiclemodelyeardata = $this->db->where('id', $data['vehiclemodelyear'])->get('vehiclemodelyear')->row(); 
		
		$data['make']  = $vehiclemodelyeardata->make;
		$data['model'] = $vehiclemodelyeardata->model;
		$data['year']  = $vehiclemodelyeardata->year;
		
        $this->db->insert('engines', $data);
		
        $insert_id = $this->db->insert_id();
		
		$this->db->set('countengines', 'countengines+1', FALSE);
 		$this->db->where('id', $vehiclemodelyeardata->id);
    	$this->db->update('vehiclemodelyear');
      
		
        if ($data['id']) { return $data['id'];}
       
    }

    /**
     * Delete invoice item
     * @param  mixed $id
     * @return boolean
     */
    public function delete($id) {
		
		$this->db->select('engines.vehiclemodelyear');
		$this->db->where('id', $id);
        $vehiclemodelyearid = $this->db->get('engines')->row();
		//print_r($vehiclemodelyearid->vehiclemodelyear);
		//exit;
        $this->db->where('id', $id);
        $this->db->delete('engines');
		
		if ($this->db->affected_rows() > 0) {
            logActivity('engines/Engine Deleted [ID: ' . $id . ']');
            return true;
        }
		
		$this->db->set('countengines', 'countengines-1', FALSE);
 		$this->db->where('id',$vehiclemodelyearid->vehiclemodelyear);
    	$this->db->update('vehiclemodelyear');
		
        return false;
    }
    
     public function deletecontact($id) {
        $this->db->where('contact_id', $id);
        $this->db->delete('tblwarehousecontacts');

        if ($this->db->affected_rows() > 0) {
            logActivity('Warehouse Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
    
    public function deleteitems($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblinvoiceitemslist');

        if ($this->db->affected_rows() > 0) {
            logActivity('Items Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }

        public function get_countries() {
        return $this->db->get('tblcountries')->result();
    }
    
   

    public function get_where_tbl($tbl, $col) {
        return $this->db->where($col, 1)->get($tbl)->result();
    }
    public function get_locations(){
         return $this->db->where('active','1')->get('tbllocations')->result();
    }

    public function get_where_single_tbl($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->row();
    }
    
    public function get_where_single_tbl_result($tbl, $col, $val) {
        return $this->db->where($col, $val)->get($tbl)->result();
    }

    public function get_receiving_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 1)->get('tbllocations')->row();
    }

    public function get_available_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 2)->get('tbllocations')->row();
    }

    public function get_customer_rma_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 3)->get('tbllocations')->row();
    }

    public function get_supplier_rtv_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 4)->get('tbllocations')->row();
    }

    public function get_scrapt_warehouse($ware_id)
    {
      return $this->db->where('ware_id', $ware_id)->where('default_location', 5)->get('tbllocations')->row();
    }

    public function update($data, $id) {
       
         unset($data['action']);
         unset($data['isedit']);
		 $oldvehmakemodelyear = $data['vehiclemodelyear_old'];
         unset($data['vehiclemodelyear_old']);
           $engines = $this->db->where('id',$id)->get('engines')->row()->make;
		   
		$vehiclemodelyeardataold = $this->db->where('id', $oldvehmakemodelyear)->get('vehiclemodelyear')->row(); 
		$vehiclemodelyeardata = $this->db->where('id', $data['vehiclemodelyear'])->get('vehiclemodelyear')->row(); 

		$data['make']  = $vehiclemodelyeardata->make;
		$data['model'] = $vehiclemodelyeardata->model;
		$data['year']  = $vehiclemodelyeardata->year;
		$this->db->where('id', $id)->update('engines', $data);
		
		
		$this->db->set('countengines', 'countengines-1', FALSE);
 		$this->db->where('id', $vehiclemodelyeardataold->id);
    	$this->db->update('vehiclemodelyear');
		   
		$this->db->set('countengines', 'countengines+1', FALSE);
 		$this->db->where('id', $vehiclemodelyeardata->id);
    	$this->db->update('vehiclemodelyear');
        return true;

    }
    
    public function get_contact_warehouse($id){
        return $this->db->where('ware_id',$id)->get('tblwarehousecontacts')->result();
    }

    public function add_reminder($data,$id){

        if(isset($data['notify_by_email'])){
            $data['notify_by_email'] = 1;
        } else {
             $data['notify_by_email'] = 0;
        }

        $data['date'] = to_sql_date($data['date']);
        $data['description'] = nl2br($data['description']);
        $data['creator'] = get_staff_user_id();
        $this->db->insert('tbladminwarehousereminders',$data);

        $insert_id = $this->db->insert_id();
        if($insert_id){
            logActivity('New Warehouse Reminder Added [Warehouse_id: ' . $data['ware_id'] . ' Description: ' . $data['description'] . ']');
            return true;
        }

        return false;
    }
    
    public function get_reminders($id = ''){

        $this->db->join('tblstaff','tblstaff.staffid = tbladminwarehousereminders.staff');

        if (is_numeric($id)) {
            $this->db->where('tbladminwarehousereminders.id', $id);
            return $this->db->get('tbladminwarehousereminders')->row();
        }

        $this->db->order_by('date', 'desc');
        return $this->db->get('tbladminwarehousereminders')->result_array();
    }
    
    public function delete_reminder($id){
        $reminder = $this->get_reminders($id);
           if($reminder->creator == get_staff_user_id()){
                $this->db->where('id',$id);
                $this->db->delete('tbladminwarehousereminders');
                if($this->db->affected_rows() > 0){
                    return true;
                }
                return false;
           }

       return false;
    }
    
}
