<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Discount_model extends CRM_Model
{
    function __construct()
    {
        parent::__construct();
    }

    /**
     * Get discount by id
     * @param  mixed $id discount id
     * @return mixed     if id passed return object else array
     */
    public function get($id = '')
    {

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            return $this->db->get('tbldiscounts')->row();
        }

        return $this->db->get('tbldiscounts')->result_array();
    }

    //    public function get_ledgers(){
    //     return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    // }
    /**
     * Add new tax
     * @param $id data
     * @return array
     */
    public function get_ledgers($id = false, $active = '')
    {
        if (is_int($active)) {
            $this->db->where('active', $active);
        }

        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $client = $this->db->get('tblledgergroups')->row();
            echo($client);

            return $client;
        }


        return $this->db->get('tblledgergroups')->result_array();
    }

    function get_prev_ledgers(){
        return $this->get_prev_groups(0);
        $this->db->order_by('name', 'ASC');
        return $this->db->get('tblledgergroups')->result();   
    }

    function get_prev_groups($id=0) {
     //  $this->db->where('type', 'Group');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups($ta->id);
            $subgoups[]=$ta;
            
        }
        
        return $subgoups;
    }
    public function getLedgers(){
        return $this->db->where('type', 'Ledger')->order_by('name','ASC')->get('tblledgergroups')->result();
    }

    function get_prev_groups2($id=0) {
       
        //$this->db->where('type', 'Ledger');
        $this->db->where('parent', $id);
        $this->db->order_by('name', 'ASC');
        $tabl= $this->db->get('tblledgergroups')->result();
        $subgoups=array();
        foreach($tabl as $ta)
        {           
            
            $ta->subgroups= $this->get_prev_groups2($ta->id);
            $ta->exists=false;
            foreach($ta->subgroups as $gr )         
            if(($gr->type!="Group")||($gr->exists))
            {
                $ta->exists=true;
                break;
                
            }
            if(($ta->type!="Group")||($ta->exists))
            {
                $ta->exists=true;
                $subgoups[]=$ta;
                
            }
            
            
        }
        
        return $subgoups;
    }
    public function get_discounts($itemid=''){
                 $res = $this->db->where('id', $itemid)->get('tblinvoiceitemslist')->row();
               $disc = unserialize($res->discounts);
      if($res->allow_discount == 1){
          if($disc){
        if(!empty($itemid)){
      
             return $this->db->where_in('id', $disc)->get('tbldiscounts')->result();   
        }else{
             return $this->db->get('tbldiscounts')->result();   
          }
          
        }else{
              return array();
        }
          }else{
                     return array();
           }
     
    }
    public function get_invoice_item($id){
         return $this->db->where('id', $id)->get('tblinvoiceitemslist')->row();
    }
    /**
     * Add new discount
     * @param array $data discount data
     * @return boolean
     */
    public function add($data)
    {
        unset($data['discountid']);
        $this->db->insert('tbldiscounts', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Discount Added [ID: '.$insert_id.', ' . $data['name'] . ']');
            return true;
        }

        return false;
    }

    /**
     * Edit discount
     * @param  array $data discount data
     * @return boolean
     */
    public function edit($data)
    {

        $discountid = $data['discountid'];
        unset($data['discountid']);
        $this->db->where('id', $discountid);
        $this->db->update('tbldiscounts', $data);

        if ($this->db->affected_rows() > 0) {
            logActivity('Discount Updated [ID: '.$discountid.', ' . $data['name'] . ']');
            return true;
        }

        return false;
    }
    /**
     * Delete discount from database
     * @param  mixed $id discount id
     * @return boolean
     */
    public function delete($id)
    {
//        if (is_reference_in_table('discount', 'tblinvoiceitemslist', $id)) {
//            return array(
//                'referenced' => true
//            );
//        }

        $this->db->where('id', $id);
        $this->db->delete('tbldiscounts');

        if ($this->db->affected_rows() > 0) {
            logActivity('Discount Deleted [ID: ' . $id . ']');
            return true;
        }

        return false;
    }
}
